/*
 * Decompiled with CFR 0.152.
 */
package decoder.FoxBPSK;

import filter.CosOscillator;
import filter.DotProduct;
import filter.SinOscillator;

public class PskSearcher
implements Runnable {
    double energy;
    double[] samples;
    double cphase_inc_start;
    double cphase_inc_step;
    int nfreq;
    double cphase_inc;
    int symphase;
    int Ntaps;
    int BUFFER_SIZE;
    int bucketSize;
    double frequency;
    DotProduct matchedFilter;
    CosOscillator cos;
    SinOscillator sin;
    boolean running = true;
    public boolean done = false;

    public PskSearcher(double[] samples, double cphase_inc_start, double cphase_inc_step, int nfreq, int BUFFER_SIZE, int bucketSize, int sampleRate) {
        this.samples = samples;
        this.cphase_inc_start = cphase_inc_start;
        this.cphase_inc_step = cphase_inc_step;
        this.nfreq = nfreq;
        this.BUFFER_SIZE = BUFFER_SIZE;
        this.bucketSize = bucketSize;
        this.matchedFilter = new DotProduct();
        this.Ntaps = this.matchedFilter.getNumOfTaps();
        this.cos = new CosOscillator(sampleRate, cphase_inc_start);
        this.sin = new SinOscillator(sampleRate, cphase_inc_start);
    }

    public synchronized double getEnergy() {
        return this.energy;
    }

    public synchronized int getNfreq() {
        return this.nfreq;
    }

    public synchronized double getCphaseInc() {
        return this.cphase_inc;
    }

    public synchronized int getSymphase() {
        return this.symphase;
    }

    public synchronized double getFrequency() {
        return this.frequency;
    }

    public void stop() {
        this.running = false;
    }

    @Override
    public void run() {
        double[] baseband_i = new double[this.BUFFER_SIZE];
        double[] baseband_q = new double[this.BUFFER_SIZE];
        this.energy = 0.0;
        this.symphase = -1;
        int j = 0;
        double cphase_inc = this.cphase_inc_start;
        while (j < this.nfreq) {
            this.cos.setPhaseIncrement(cphase_inc);
            this.sin.setPhaseIncrement(cphase_inc);
            this.cos.setPhase(0.0);
            this.sin.setPhase(0.0);
            int i = 0;
            while (i < this.BUFFER_SIZE) {
                baseband_i[i] = this.samples[i] * this.cos.nextSample();
                baseband_q[i] = this.samples[i] * this.sin.nextSample();
                ++i;
            }
            int offset = 0;
            while (offset < this.bucketSize) {
                double offsetEnergy = 0.0;
                double tlast_i = 0.0;
                double tlast_q = 0.0;
                int bb_p = offset;
                while (bb_p + this.Ntaps < this.BUFFER_SIZE) {
                    double fi = this.matchedFilter.dotprod(baseband_i, bb_p);
                    double fq = this.matchedFilter.dotprod(baseband_q, bb_p);
                    double symbol = fi * tlast_i + fq * tlast_q;
                    offsetEnergy += symbol * symbol;
                    tlast_i = fi;
                    tlast_q = fq;
                    bb_p += this.bucketSize;
                }
                if (offsetEnergy >= this.energy) {
                    this.cphase_inc = cphase_inc;
                    this.energy = offsetEnergy;
                    this.symphase = offset;
                    this.frequency = this.cos.getFrequency();
                }
                ++offset;
            }
            ++j;
            cphase_inc += this.cphase_inc_step;
        }
        this.done = true;
        this.running = false;
        while (this.running) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

