/*
 * Decompiled with CFR 0.152.
 */
package decoder;

import common.Config;
import common.Log;
import decoder.Decoder;
import decoder.SourceAudio;
import gui.MainWindow;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;

public class SourceSoundCardAudio
extends SourceAudio
implements Runnable {
    static Mixer[] mixerList;
    public static final int DEFAULT_READ_BUFFER_SIZE = 2048;
    TargetDataLine targetDataLine = null;
    int errorCount = 0;
    byte[] readBuffer;
    double a;
    double b;
    boolean skippedOneByte = false;
    int channels = 0;

    public SourceSoundCardAudio(int circularBufferSize, int rate, int device, int chan, boolean storeStereo) throws IllegalArgumentException, LineUnavailableException {
        super("SoundCard", circularBufferSize, chan, storeStereo);
        this.channels = chan;
        this.sampleRate = rate;
        this.setDevice(device);
        this.readBuffer = new byte[2048];
    }

    private void init() throws LineUnavailableException {
        if (this.targetDataLine != null) {
            this.targetDataLine.stop();
            this.targetDataLine.drain();
            this.targetDataLine.close();
        }
        this.audioFormat = SourceSoundCardAudio.makeAudioFormat(this.sampleRate);
        this.targetDataLine.open(this.audioFormat);
        Log.println("Soundcard Line opened with buffer: " + this.targetDataLine.getBufferSize());
        this.targetDataLine.start();
    }

    @Override
    public void stop(String caller) {
        Log.println("** STOP CALLED by " + caller + " for " + this.getClass().getName() + "\n");
        this.running = false;
        if (this.targetDataLine != null) {
            this.targetDataLine.stop();
            this.targetDataLine.drain();
            this.targetDataLine.close();
        }
        this.done = true;
    }

    public static String[] getAudioSources() {
        int device = 2;
        AudioFormat audioFmt = SourceSoundCardAudio.makeAudioFormat(48000);
        Mixer.Info[] mixers = AudioSystem.getMixerInfo();
        String[] devices = new String[mixers.length + 2];
        mixerList = new Mixer[mixers.length + 2];
        Mixer.Info[] infoArray = mixers;
        int n = mixers.length;
        int n2 = 0;
        while (n2 < n) {
            Mixer.Info info = infoArray[n2];
            Mixer mixer = AudioSystem.getMixer(info);
            try {
                Log.println("Found audio Device: " + info.getName() + " Desc:" + info.getDescription());
                DataLine.Info dataLineInfo = new DataLine.Info(TargetDataLine.class, audioFmt);
                String name = info.getName();
                String desc = info.getDescription();
                if (Config.isMacOs() && (desc.indexOf("FUNcube Dongle") >= 0 || name.indexOf("FUNcube Dongle") >= 0)) {
                    Log.println("Detected FCD");
                } else {
                    TargetDataLine targetDataLine = (TargetDataLine)mixer.getLine(dataLineInfo);
                    targetDataLine.close();
                }
                SourceSoundCardAudio.mixerList[device] = mixer;
                if (Config.isLinuxOs()) {
                    name = desc.length() > 50 ? desc.substring(0, 50) : desc;
                } else if (name.length() > 50) {
                    name = name.substring(0, 50);
                }
                devices[device++] = name;
            }
            catch (LineUnavailableException lineUnavailableException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n2;
        }
        String[] result = new String[device];
        result[0] = "Select audio source here then press start";
        result[1] = "Load Wav File";
        int i = 2;
        while (i < device) {
            result[i] = devices[i];
            ++i;
        }
        return result;
    }

    private static String getMixerIdString(Mixer appMixer) {
        Mixer.Info info = appMixer.getMixerInfo();
        return String.valueOf(info.getName()) + info.getDescription() + info.getVendor() + info.getVersion();
    }

    public static String getDeviceName(int position) {
        Mixer appMixer = mixerList[position];
        return SourceSoundCardAudio.getMixerIdString(appMixer);
    }

    public static int getDeviceIdByName(String name) {
        int i = 1;
        while (i < mixerList.length) {
            if (mixerList[i] != null && name.equalsIgnoreCase(SourceSoundCardAudio.getMixerIdString(mixerList[i]))) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private void setDevice(int position) throws LineUnavailableException, IllegalArgumentException {
        Mixer appMixer = mixerList[position];
        DataLine.Info sdlLineInfo = new DataLine.Info(TargetDataLine.class, SourceSoundCardAudio.makeAudioFormat(this.sampleRate));
        this.stop("setDevice");
        this.targetDataLine = (TargetDataLine)appMixer.getLine(sdlLineInfo);
        this.init();
    }

    public static AudioFormat makeAudioFormat(int sampleRate) {
        int sampleSizeInBits = 16;
        int channels = 2;
        boolean signed = true;
        boolean bigEndian = false;
        AudioFormat af = new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
        Log.println("SC Format " + af);
        return af;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("SourceSoundCard");
        this.done = false;
        this.running = true;
        try {
            this.init();
        }
        catch (LineUnavailableException e1) {
            Log.errorDialog("ERROR", "Can't start the decoder.  Your Operating System says the device or soundcard is not available.  Error message:\n" + e1.getMessage());
            e1.printStackTrace(Log.getWriter());
            this.running = false;
        }
        int lastErrorCount = 0;
        int audioBufferPeriodCounter = 0;
        int audioBufferPeriod = 1000;
        Log.println("Audio Source START");
        while (this.running) {
            if (++audioBufferPeriodCounter == audioBufferPeriod) {
                audioBufferPeriodCounter = 0;
                MainWindow.setAudioMissed((this.errorCount + lastErrorCount) / 2);
                lastErrorCount = this.errorCount;
                this.errorCount = 0;
            }
            if (this.targetDataLine == null) continue;
            while (this.running && (double)this.targetDataLine.available() < (double)this.targetDataLine.getBufferSize() * 0.5) {
                try {
                    Thread.sleep(0L, 1);
                }
                catch (InterruptedException e) {
                    e.printStackTrace(Log.getWriter());
                }
            }
            int nBytesRead = this.targetDataLine.read(this.readBuffer, 0, this.readBuffer.length);
            try {
                int i = 0;
                while (i < nBytesRead) {
                    byte[] ia = new byte[]{this.readBuffer[i], this.readBuffer[i + 1]};
                    this.a = this.audioFormat.isBigEndian() ? (double)Decoder.bigEndian2(ia, this.audioFormat.getSampleSizeInBits()) / 32768.0 : (double)Decoder.littleEndian2(ia, this.audioFormat.getSampleSizeInBits()) / 32768.0;
                    if (this.audioFormat.getFrameSize() == 4) {
                        byte[] ib = new byte[]{this.readBuffer[i + 2], this.readBuffer[i + 3]};
                        this.b = this.audioFormat.isBigEndian() ? (double)Decoder.bigEndian2(ib, this.audioFormat.getSampleSizeInBits()) / 32768.0 : (double)Decoder.littleEndian2(ib, this.audioFormat.getSampleSizeInBits()) / 32768.0;
                    }
                    if (this.audioFormat.getFrameSize() == 4 && this.storeStereo) {
                        if (this.channels == 0) {
                            this.circularDoubleBuffer[0].add(this.a, this.b);
                        } else {
                            int chan = 0;
                            while (chan < this.channels) {
                                this.circularDoubleBuffer[chan].add(this.a, this.b);
                                ++chan;
                            }
                        }
                    } else {
                        if (!Config.useLeftStereoChannel) {
                            this.a = this.b;
                        }
                        if (this.channels == 0) {
                            this.circularDoubleBuffer[0].add(this.a);
                        } else {
                            int chan = 0;
                            while (chan < this.channels) {
                                this.circularDoubleBuffer[chan].add(this.a);
                                ++chan;
                            }
                        }
                    }
                    i += this.audioFormat.getFrameSize();
                }
            }
            catch (IndexOutOfBoundsException e) {
                ++this.errorCount;
                if (!Config.debugAudioGlitches || this.errorCount % 10 != 0) continue;
                Log.println("Missed audio from the sound card, Buffers missed: " + this.errorCount + " with capacity: " + this.getAudioBufferCapacity());
                if (this.errorCount % 100 != 0) continue;
                Log.println("Cant keep up with audio from soundcard: " + e.getMessage());
            }
        }
        Log.println("Audio Source EXIT, channels:" + this.channels);
    }
}

