/*
 * Decompiled with CFR 0.152.
 */
package decoder;

import common.Config;
import common.Log;
import decoder.Listener;
import decoder.SourceAudio;
import gui.MainWindow;
import javax.sound.sampled.AudioFormat;

public class SourceUSB
extends SourceAudio
implements Listener<float[]>,
Runnable {
    int errorCount = 0;
    float a;
    float b;
    float c;
    float d;
    int lastErrorCount = 0;
    int audioBufferPeriodCounter = 0;
    int audioBufferPeriod = 100;

    public SourceUSB(String n, int sampleRate, int circularBufferSize, int channels) {
        super(n, circularBufferSize, channels, true);
        this.sampleRate = sampleRate;
        this.audioFormat = SourceUSB.makeAudioFormat(sampleRate);
    }

    @Override
    public void receive(float[] realSamples) {
        block7: {
            try {
                int bytesPerSample = 2;
                int i = 0;
                while (i < realSamples.length) {
                    this.a = realSamples[i];
                    this.b = realSamples[i + 1];
                    if (this.channels == 0) {
                        this.circularDoubleBuffer[0].add(this.a, this.b);
                    } else {
                        int chan = 0;
                        while (chan < this.channels) {
                            this.circularDoubleBuffer[chan].add(this.a, this.b);
                            ++chan;
                        }
                    }
                    i += bytesPerSample;
                }
            }
            catch (IndexOutOfBoundsException e) {
                ++this.errorCount;
                if (!Config.debugAudioGlitches || this.errorCount % 10 != 0 || this.errorCount % 100 != 0) break block7;
                Log.println("Cant keep up with audio from soundcard: " + e.getMessage());
            }
        }
        ++this.audioBufferPeriodCounter;
        if (this.audioBufferPeriodCounter == this.audioBufferPeriod) {
            this.audioBufferPeriodCounter = 0;
            MainWindow.setAudioMissed(10 * (this.errorCount + this.lastErrorCount) / 2);
            this.lastErrorCount = this.errorCount;
            this.errorCount = 0;
        }
    }

    public static AudioFormat makeAudioFormat(int sampleRate) {
        int sampleSizeInBits = 16;
        int channels = 2;
        boolean signed = true;
        boolean bigEndian = false;
        AudioFormat af = new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
        Log.println("SC Format " + af);
        return af;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("SourceUSB");
        this.done = false;
        this.running = false;
    }

    @Override
    public void stop(String caller) {
        this.running = false;
        this.done = true;
    }
}

