/*
 * Decompiled with CFR 0.152.
 */
package decoder;

import common.Config;
import common.Log;
import decoder.Decoder;
import decoder.SourceAudio;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SourceWav
extends SourceAudio
implements Runnable {
    String fileName;
    long totalFrames = 0L;
    int frameSize = 0;
    long bytesRead = 0L;
    long framesProcessed = 0L;
    double a;
    double b;
    byte[] readBuffer;
    public static final int DEFAULT_READ_BUFFER_SIZE = 65536;
    AudioInputStream audioStream = null;

    public SourceWav(String f, boolean IQ) throws UnsupportedAudioFileException, IOException {
        super("WavFile", 201600, 0, IQ);
        this.fileName = f;
        this.initWav();
    }

    private void initWav() throws UnsupportedAudioFileException, IOException {
        this.readBuffer = new byte[65536];
        Log.println("Wavefile: " + this.fileName);
        File soundFile = null;
        soundFile = new File(this.fileName);
        this.audioStream = AudioSystem.getAudioInputStream(soundFile);
        this.audioFormat = this.audioStream.getFormat();
        Config.wavSampleRate = (int)this.audioFormat.getSampleRate();
        Log.println("Format: " + this.audioFormat);
        this.totalFrames = this.audioStream.getFrameLength();
        this.frameSize = this.audioFormat.getFrameSize();
        Log.println("Length (frames): " + this.totalFrames);
        this.bytesRead = 0L;
        this.framesProcessed = 0L;
    }

    @Override
    public void stop(String caller) {
        this.running = false;
        this.cleanup();
    }

    public void cleanup() {
        try {
            if (this.audioStream != null) {
                this.audioStream.close();
            }
            this.audioStream = null;
        }
        catch (IOException e) {
            e.printStackTrace(Log.getWriter());
        }
        if (this.circularDoubleBuffer[0].size() > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        this.done = true;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("SourceWav");
        this.running = true;
        this.done = false;
        Log.println("WAV Source START");
        if (this.audioStream == null) {
            try {
                this.initWav();
            }
            catch (UnsupportedAudioFileException e1) {
                Log.errorDialog("ERROR", "Unsupported File Format\n" + e1.getMessage());
                e1.printStackTrace(Log.getWriter());
                this.running = false;
            }
            catch (IOException e1) {
                Log.errorDialog("ERROR", "There was a problem opening the wav file\n" + e1.getMessage());
                e1.printStackTrace(Log.getWriter());
                this.running = false;
            }
        }
        long lastLoopTime = System.nanoTime();
        long OPTIMAL_TIME_FOR_1_SAMPLE = 1000000000 / (int)this.audioFormat.getSampleRate();
        while (this.running) {
            if (this.audioStream == null) continue;
            int nBytesRead = 0;
            if (this.circularDoubleBuffer[0].getCapacity() > this.readBuffer.length) {
                try {
                    nBytesRead = this.audioStream.read(this.readBuffer, 0, this.readBuffer.length);
                    this.bytesRead += (long)nBytesRead;
                    this.framesProcessed += (long)(nBytesRead / this.frameSize);
                    if (this.audioStream == null) {
                        this.running = false;
                    } else if (this.audioStream.available() <= 0) {
                        this.running = false;
                    }
                }
                catch (IOException e) {
                    Log.errorDialog("ERROR", "Failed to read from file " + this.fileName);
                    e.printStackTrace(Log.getWriter());
                }
            } else {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            lastLoopTime = System.nanoTime();
            int i = 0;
            while (i < nBytesRead) {
                int chan;
                if (this.audioFormat.getFrameSize() == 4) {
                    byte[] ib = new byte[]{this.readBuffer[i + 2], this.readBuffer[i + 3]};
                    this.b = this.audioFormat.isBigEndian() ? (double)Decoder.bigEndian2(ib, this.audioFormat.getSampleSizeInBits()) / 32768.0 : (double)Decoder.littleEndian2(ib, this.audioFormat.getSampleSizeInBits()) / 32768.0;
                }
                byte[] ia = new byte[]{this.readBuffer[i], this.readBuffer[i + 1]};
                this.a = this.audioFormat.isBigEndian() ? (double)Decoder.bigEndian2(ia, this.audioFormat.getSampleSizeInBits()) / 32768.0 : (double)Decoder.littleEndian2(ia, this.audioFormat.getSampleSizeInBits()) / 32768.0;
                if (this.audioFormat.getFrameSize() == 4 && this.storeStereo) {
                    if (this.channels == 0) {
                        this.circularDoubleBuffer[0].add(this.a, this.b);
                    } else {
                        chan = 0;
                        while (chan < this.channels) {
                            this.circularDoubleBuffer[chan].add(this.a, this.b);
                            ++chan;
                        }
                    }
                } else {
                    if (!Config.useLeftStereoChannel) {
                        this.a = this.b;
                    }
                    if (this.channels == 0) {
                        this.circularDoubleBuffer[0].add(this.a);
                    } else {
                        chan = 0;
                        while (chan < this.channels) {
                            this.circularDoubleBuffer[chan].add(this.a);
                            ++chan;
                        }
                    }
                }
                i += this.audioFormat.getFrameSize();
            }
            if (Config.turboWavFilePlayback) continue;
            long loopTime = System.nanoTime() - lastLoopTime;
            long sleepTime_ms = (OPTIMAL_TIME_FOR_1_SAMPLE * (long)(nBytesRead / this.audioFormat.getFrameSize()) - loopTime) / 1000000L;
            if (sleepTime_ms > 0L) {
                try {
                    Thread.sleep(sleepTime_ms);
                }
                catch (InterruptedException e) {
                    System.err.println("Mainloop Sleep Interrupted!");
                }
                continue;
            }
            Thread.yield();
        }
        this.framesProcessed = this.totalFrames;
        this.cleanup();
        this.running = false;
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Log.println("WAV Source EXIT");
    }

    public int getLengthInSeconds() {
        int seconds = (int)(this.totalFrames / (long)Config.wavSampleRate);
        return seconds;
    }

    public int getPercentProgress() {
        int percent = 0;
        try {
            percent = (int)(100L * this.framesProcessed / this.totalFrames);
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return percent;
    }
}

