/*
 * Decompiled with CFR 0.152.
 */
package device;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamingThreadFactory
implements ThreadFactory {
    static final AtomicInteger poolNumber = new AtomicInteger(1);
    final ThreadGroup mThreadGroup;
    final AtomicInteger mThreadNumber = new AtomicInteger(1);
    final String mNamePrefix;

    public NamingThreadFactory(String prefix) {
        SecurityManager s = System.getSecurityManager();
        this.mThreadGroup = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.mNamePrefix = String.valueOf(prefix) + " pool-" + poolNumber.getAndIncrement() + "-thread-";
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(this.mThreadGroup, runnable, String.valueOf(this.mNamePrefix) + this.mThreadNumber.getAndIncrement(), 0L);
        if (thread.isDaemon()) {
            thread.setDaemon(false);
        }
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        return thread;
    }
}

