/*
 * Decompiled with CFR 0.152.
 */
package device.airspy;

import common.Log;
import device.airspy.AirspyDevice;
import java.util.Arrays;

public class AirspyDeviceInformation {
    private AirspyDevice.BoardID mBoardID = AirspyDevice.BoardID.UNKNOWN;
    private String mFirmwareVersion = "Unknown";
    private String mPartNumber = "Unknown";
    private String mSerialNumber = "Unknown";

    public void setBoardID(int boardID) {
        this.mBoardID = AirspyDevice.BoardID.fromValue(boardID);
    }

    public AirspyDevice.BoardID getBoardID() {
        return this.mBoardID;
    }

    public void setVersion(byte[] data) {
        if (data != null && data.length > 0) {
            int x = 0;
            while (x < data.length) {
                if (data[x] == 10) {
                    this.mFirmwareVersion = new String(Arrays.copyOf(data, x));
                    this.mFirmwareVersion = this.mFirmwareVersion.replace("AirSpy NOS ", "");
                    return;
                }
                ++x;
            }
            this.mFirmwareVersion = new String(data);
            this.mFirmwareVersion = this.mFirmwareVersion.replace("AirSpy NOS ", "");
        } else {
            Log.errorDialog("ERROR", "Error setting airspy version byte data - null:" + (data == null ? " TRUE" : " FALSE length:" + data.length));
        }
    }

    public String getVersion() {
        return this.mFirmwareVersion;
    }

    public void setPartAndSerialNumber(byte[] data) {
        if (data != null && data.length == 24) {
            StringBuilder part = new StringBuilder();
            part.append(this.format(data[3]));
            part.append(this.format(data[2]));
            part.append(this.format(data[1]));
            part.append(this.format(data[0]));
            part.append(this.format(data[7]));
            part.append(this.format(data[6]));
            part.append(this.format(data[5]));
            part.append(this.format(data[4]));
            this.mPartNumber = part.toString();
            StringBuilder serial = new StringBuilder();
            if (data[8] != 0 || data[9] != 0 || data[10] != 0 || data[11] != 0) {
                serial.append(this.format(data[11]));
                serial.append(this.format(data[10]));
                serial.append(this.format(data[9]));
                serial.append(this.format(data[8]));
                serial.append("-");
            }
            if (data[12] != 0 || data[13] != 0 || data[14] != 0 || data[15] != 0) {
                serial.append(this.format(data[15]));
                serial.append(this.format(data[14]));
                serial.append(this.format(data[13]));
                serial.append(this.format(data[12]));
                serial.append("-");
            }
            serial.append(this.format(data[19]));
            serial.append(this.format(data[18]));
            serial.append(this.format(data[17]));
            serial.append(this.format(data[16]));
            serial.append("-");
            serial.append(this.format(data[23]));
            serial.append(this.format(data[22]));
            serial.append(this.format(data[21]));
            serial.append(this.format(data[20]));
            this.mSerialNumber = serial.toString();
        } else {
            Log.errorDialog("ERROR", "Error setting airspy part and serial byte data - null:" + (data == null ? " TRUE" : " FALSE length:" + data.length));
        }
    }

    private String format(byte value) {
        return String.format("%02X", value);
    }

    public String getSerialNumber() {
        return this.mSerialNumber;
    }

    public String getPartNumber() {
        return this.mPartNumber;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Airspy Device Information\n");
        sb.append("Board: ");
        sb.append(this.getBoardID().getLabel());
        sb.append("\nPart Number: ");
        sb.append(this.getPartNumber());
        sb.append("\nSerial Number: ");
        sb.append(this.getSerialNumber());
        sb.append("\nFirmware: ");
        sb.append(this.getVersion());
        return sb.toString();
    }
}

