/*
 * Decompiled with CFR 0.152.
 */
package device.airspy;

import device.TunerConfiguration;
import device.TunerType;
import device.airspy.AirspyDevice;

public class AirspyTunerConfiguration
extends TunerConfiguration {
    private int mSampleRate = AirspyDevice.DEFAULT_SAMPLE_RATE.getRate();
    private AirspyDevice.Gain mGain = AirspyDevice.LINEARITY_GAIN_DEFAULT;
    private int mIFGain = 9;
    private int mMixerGain = 9;
    private int mLNAGain = 7;
    private double mFrequencyCorrection = 0.0;
    private boolean mMixerAGC = false;
    private boolean mLNAAGC = false;

    public AirspyTunerConfiguration() {
    }

    public AirspyTunerConfiguration(String uniqueID, String name) {
        super(uniqueID, name);
    }

    @Override
    public TunerType getTunerType() {
        return TunerType.AIRSPY_R820T;
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public void setSampleRate(int sampleRate) {
        this.mSampleRate = sampleRate;
    }

    public AirspyDevice.Gain getGain() {
        return this.mGain;
    }

    public void setGain(AirspyDevice.Gain gain) {
        this.mGain = gain;
    }

    public int getIFGain() {
        return this.mIFGain;
    }

    public void setIFGain(int gain) {
        this.mIFGain = gain;
    }

    public int getMixerGain() {
        return this.mMixerGain;
    }

    public void setMixerGain(int gain) {
        this.mMixerGain = gain;
    }

    public int getLNAGain() {
        return this.mLNAGain;
    }

    public void setLNAGain(int gain) {
        this.mLNAGain = gain;
    }

    public boolean isMixerAGC() {
        return this.mMixerAGC;
    }

    public void setMixerAGC(boolean enabled) {
        this.mMixerAGC = enabled;
    }

    public boolean isLNAAGC() {
        return this.mLNAAGC;
    }

    public void setLNAAGC(boolean enabled) {
        this.mLNAAGC = enabled;
    }

    public double getFrequencyCorrection() {
        return this.mFrequencyCorrection;
    }

    public void setFrequencyCorrection(double value) {
        this.mFrequencyCorrection = value;
    }
}

