/*
 * Decompiled with CFR 0.152.
 */
package device.rtl;

import common.Log;
import device.DeviceException;
import device.ThreadPoolManager;
import device.TunerType;
import device.rtl.RTL2832TunerController;
import java.nio.ByteBuffer;
import javax.usb.UsbException;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.LibUsbException;

public class R820TTunerController
extends RTL2832TunerController {
    public static final long MIN_FREQUENCY = 31800L;
    public static final long MAX_FREQUENCY = 1782030L;
    public static final double USABLE_BANDWIDTH_PERCENT = 1.0;
    public static final int DC_SPIKE_AVOID_BUFFER = 5000;
    public static final int R820T_IF_FREQUENCY = 3570000;
    public static final byte VERSION = 49;
    public static final byte[] BIT_REV_LOOKUP_TABLE;
    private byte mI2CAddress = (byte)52;
    private int[] mShadowRegister;
    int err;

    static {
        byte[] byArray = new byte[16];
        byArray[1] = 8;
        byArray[2] = 4;
        byArray[3] = 12;
        byArray[4] = 2;
        byArray[5] = 10;
        byArray[6] = 6;
        byArray[7] = 14;
        byArray[8] = 1;
        byArray[9] = 9;
        byArray[10] = 5;
        byArray[11] = 13;
        byArray[12] = 3;
        byArray[13] = 11;
        byArray[14] = 7;
        byArray[15] = 15;
        BIT_REV_LOOKUP_TABLE = byArray;
    }

    public R820TTunerController(Device device, DeviceDescriptor deviceDescriptor, ThreadPoolManager threadPoolManager) throws DeviceException {
        super(device, deviceDescriptor, threadPoolManager, 31800L, 1782030L, 5000, 1.0);
        int[] nArray = new int[32];
        nArray[5] = 131;
        nArray[6] = 50;
        nArray[7] = 117;
        nArray[8] = 192;
        nArray[9] = 64;
        nArray[10] = 214;
        nArray[11] = 108;
        nArray[12] = 245;
        nArray[13] = 99;
        nArray[14] = 117;
        nArray[15] = 104;
        nArray[16] = 108;
        nArray[17] = 131;
        nArray[18] = 128;
        nArray[20] = 15;
        nArray[22] = 192;
        nArray[23] = 48;
        nArray[24] = 72;
        nArray[25] = 204;
        nArray[26] = 96;
        nArray[28] = 84;
        nArray[29] = 174;
        nArray[30] = 74;
        nArray[31] = 192;
        this.mShadowRegister = nArray;
        this.err = 0;
    }

    @Override
    public TunerType getTunerType() {
        return TunerType.RAFAELMICRO_R820T;
    }

    @Override
    public void setSampleRateFilters(int sampleRate) throws LibUsbException {
    }

    public long getTunedFrequency() throws DeviceException {
        return 0L;
    }

    public void setTunedFrequency(long frequency) throws UsbException {
        try {
            R820TTunerController.enableI2CRepeater(this.mDeviceHandle, true);
            boolean controlI2C = false;
            long offsetFrequency = frequency + 3570000L;
            this.setMux(offsetFrequency, controlI2C);
            this.setPLL(offsetFrequency, controlI2C);
            R820TTunerController.enableI2CRepeater(this.mDeviceHandle, false);
        }
        catch (Exception e) {
            Log.println("R820TTunerController - exception while setting frequency [" + frequency + "] - " + e.getLocalizedMessage());
            throw e;
        }
    }

    @Override
    public void setSamplingMode(RTL2832TunerController.SampleMode mode) throws LibUsbException {
        switch (mode) {
            case QUADRATURE: {
                this.setIFFrequency(3570000);
                R820TTunerController.writeDemodRegister(this.mDeviceHandle, RTL2832TunerController.Page.ONE, (short)21, 1, 1);
                R820TTunerController.writeDemodRegister(this.mDeviceHandle, RTL2832TunerController.Page.ZERO, (short)6, 128, 1);
                break;
            }
        }
    }

    private void setMux(long frequency, boolean controlI2C) throws UsbException {
        FrequencyRange range = FrequencyRange.getRangeForFrequency(frequency);
        this.writeR820TRegister(Register.DRAIN, range.getOpenDrain(), controlI2C);
        this.writeR820TRegister(Register.RF_POLY_MUX, range.getRFMuxPolyMux(), controlI2C);
        this.writeR820TRegister(Register.TF_BAND, range.getTFC(), controlI2C);
        this.writeR820TRegister(Register.PLL_XTAL_CAPACITOR_AND_DRIVE, range.getXTALHighCap0P(), controlI2C);
        this.writeR820TRegister(Register.UNKNOWN_REGISTER_8, (byte)0, controlI2C);
        this.writeR820TRegister(Register.UNKNOWN_REGISTER_9, (byte)0, controlI2C);
    }

    @Override
    public void init(RTL2832TunerController.SampleRate sampleRate) throws DeviceException {
        super.init(sampleRate);
        try {
            R820TTunerController.initBaseband(this.mDeviceHandle);
            R820TTunerController.enableI2CRepeater(this.mDeviceHandle, true);
            boolean i2CRepeaterControl = false;
            this.initTuner(i2CRepeaterControl);
            R820TTunerController.enableI2CRepeater(this.mDeviceHandle, false);
        }
        catch (UsbException e) {
            throw new DeviceException("error during init():" + e);
        }
    }

    @Override
    public void initTuner(boolean controlI2C) throws UsbException {
        R820TTunerController.writeDemodRegister(this.mDeviceHandle, RTL2832TunerController.Page.ONE, (short)177, 26, 1);
        R820TTunerController.writeDemodRegister(this.mDeviceHandle, RTL2832TunerController.Page.ZERO, (short)8, 77, 1);
        this.setIFFrequency(3570000);
        R820TTunerController.writeDemodRegister(this.mDeviceHandle, RTL2832TunerController.Page.ONE, (short)21, 1, 1);
        this.initializeRegisters(controlI2C);
        this.setTVStandard(controlI2C);
        this.systemFrequencySelect(0L, controlI2C);
    }

    private void setTVStandard(boolean controlI2C) throws UsbException {
        this.writeR820TRegister(Register.XTAL_CHECK, (byte)0, controlI2C);
        this.writeR820TRegister(Register.VERSION, (byte)49, controlI2C);
        this.writeR820TRegister(Register.LNA_TOP, (byte)0, controlI2C);
        int calibrationCode = 0;
        int x = 0;
        while (x < 2) {
            this.writeR820TRegister(Register.FILTER_CAPACITOR, (byte)107, controlI2C);
            this.writeR820TRegister(Register.CALIBRATION_CLOCK, (byte)4, controlI2C);
            this.writeR820TRegister(Register.PLL_XTAL_CAPACITOR, (byte)0, controlI2C);
            this.setPLL(56000000L, controlI2C);
            this.writeR820TRegister(Register.CALIBRATION_TRIGGER, (byte)16, controlI2C);
            this.writeR820TRegister(Register.CALIBRATION_TRIGGER, (byte)0, controlI2C);
            this.writeR820TRegister(Register.CALIBRATION_CLOCK, (byte)0, controlI2C);
            calibrationCode = this.getCalibrationCode(controlI2C);
            if (!this.calibrationSuccessful(calibrationCode)) {
                Log.println("Calibration NOT successful - code: " + calibrationCode);
            }
            ++x;
        }
        if (calibrationCode == 15) {
            calibrationCode = 0;
        }
        int filt_q = 16;
        this.writeR820TRegister(Register.FILTER_CALIBRATION_CODE, (byte)(calibrationCode | filt_q), controlI2C);
        this.writeR820TRegister(Register.BANDWIDTH_FILTER_GAIN_HIGHPASS_FILTER_CORNER, (byte)107, controlI2C);
        this.writeR820TRegister(Register.IMAGE_REVERSE, (byte)0, controlI2C);
        this.writeR820TRegister(Register.FILTER_GAIN, (byte)16, controlI2C);
        this.writeR820TRegister(Register.CHANNEL_FILTER_EXTENSION, (byte)96, controlI2C);
        this.writeR820TRegister(Register.LOOP_THROUGH, (byte)0, controlI2C);
        this.writeR820TRegister(Register.LOOP_THROUGH_ATTENUATION, (byte)0, controlI2C);
        this.writeR820TRegister(Register.FILTER_EXTENSION_WIDEST, (byte)0, controlI2C);
        this.writeR820TRegister(Register.RF_POLY_FILTER_CURRENT, (byte)96, controlI2C);
    }

    private boolean calibrationSuccessful(int calibrationCode) {
        return calibrationCode != 0 && calibrationCode != 15;
    }

    private int getCalibrationCode(boolean controlI2C) throws UsbException {
        return this.getStatusRegister(4, controlI2C) & 0xF;
    }

    private void systemFrequencySelect(long frequency, boolean controlI2C) throws UsbException {
        byte div_buf_cur;
        byte cp_cur;
        byte mixer_top;
        this.writeR820TRegister(Register.LNA_TOP2, (byte)-27, controlI2C);
        if (frequency == 506000000L || frequency == 666000000L || frequency == 818000000L) {
            mixer_top = 20;
            cp_cur = 40;
            div_buf_cur = 32;
        } else {
            mixer_top = 36;
            cp_cur = 56;
            div_buf_cur = 48;
        }
        this.writeR820TRegister(Register.MIXER_TOP, mixer_top, controlI2C);
        this.writeR820TRegister(Register.LNA_VTH_L, (byte)83, controlI2C);
        this.writeR820TRegister(Register.MIXER_VTH_L, (byte)117, controlI2C);
        this.writeR820TRegister(Register.AIR_CABLE1_INPUT_SELECTOR, (byte)0, controlI2C);
        this.writeR820TRegister(Register.CABLE2_INPUT_SELECTOR, (byte)0, controlI2C);
        this.writeR820TRegister(Register.CP_CUR, cp_cur, controlI2C);
        this.writeR820TRegister(Register.DIVIDER_BUFFER_CURRENT, div_buf_cur, controlI2C);
        this.writeR820TRegister(Register.FILTER_CURRENT, (byte)64, controlI2C);
        this.writeR820TRegister(Register.LNA_TOP, (byte)0, controlI2C);
        this.writeR820TRegister(Register.MIXER_TOP2, (byte)0, controlI2C);
        this.writeR820TRegister(Register.PRE_DETECT, (byte)0, controlI2C);
        this.writeR820TRegister(Register.AGC_CLOCK, (byte)48, controlI2C);
        this.writeR820TRegister(Register.LNA_TOP, (byte)24, controlI2C);
        this.writeR820TRegister(Register.MIXER_TOP2, mixer_top, controlI2C);
        this.writeR820TRegister(Register.LNA_DISCHARGE_CURRENT, (byte)20, controlI2C);
        this.writeR820TRegister(Register.AGC_CLOCK, (byte)32, controlI2C);
    }

    private void setPLL(long frequency, boolean controlI2C) throws UsbException {
        this.writeR820TRegister(Register.REFERENCE_DIVIDER_2, (byte)0, controlI2C);
        this.writeR820TRegister(Register.PLL_AUTOTUNE, (byte)0, controlI2C);
        this.writeR820TRegister(Register.VCO_CURRENT, (byte)-128, controlI2C);
        FrequencyDivider divider = FrequencyDivider.fromFrequency(frequency);
        int statusRegister4 = this.getStatusRegister(4, controlI2C);
        int vco_fine_tune = (statusRegister4 & 0x30) >> 4;
        int div_num = divider.getDividerNumber(vco_fine_tune);
        this.writeR820TRegister(Register.DIVIDER, (byte)(div_num << 5), controlI2C);
        Integral integral = divider.getIntegral(frequency);
        this.writeR820TRegister(Register.PLL, integral.getRegisterValue(), controlI2C);
        int sdm = divider.getSDM(integral, frequency);
        if (sdm != 0) {
            this.writeR820TRegister(Register.SIGMA_DELTA_MODULATOR_POWER, (byte)0, controlI2C);
            this.writeR820TRegister(Register.SIGMA_DELTA_MODULATOR_MSB, (byte)(sdm >> 8 & 0xFF), controlI2C);
            this.writeR820TRegister(Register.SIGMA_DELTA_MODULATOR_LSB, (byte)(sdm & 0xFF), controlI2C);
        } else {
            this.writeR820TRegister(Register.SIGMA_DELTA_MODULATOR_POWER, (byte)8, controlI2C);
        }
        if (!this.isPLLLocked(controlI2C)) {
            this.writeR820TRegister(Register.VCO_CURRENT, (byte)96, controlI2C);
            if (!this.isPLLLocked(controlI2C)) {
                throw new UsbException("R820T Tuner Controller - couldn't achieve PLL lock on frequency [" + frequency + "]");
            }
        }
        this.writeR820TRegister(Register.PLL_AUTOTUNE_VARIANT, (byte)8, controlI2C);
    }

    private boolean isPLLLocked(boolean controlI2C) throws UsbException {
        int register = this.getStatusRegister(2, controlI2C);
        return (register & 0x40) == 64;
    }

    private void initializeRegisters(boolean controlI2C) throws UsbException {
        int x = 5;
        while (x < this.mShadowRegister.length) {
            this.writeI2CRegister(this.mDeviceHandle, this.mI2CAddress, (byte)x, (byte)this.mShadowRegister[x], controlI2C);
            ++x;
        }
    }

    private int getStatusRegister(int register, boolean controlI2C) throws UsbException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(5);
        R820TTunerController.read(this.mDeviceHandle, (short)this.mI2CAddress, RTL2832TunerController.Block.I2C, buffer);
        return R820TTunerController.bitReverse(buffer.get(register) & 0xFF);
    }

    private static int bitReverse(int value) {
        return BIT_REV_LOOKUP_TABLE[value & 0xF] << 4 | BIT_REV_LOOKUP_TABLE[(value & 0xF0) >> 4];
    }

    public void writeR820TRegister(Register register, byte value, boolean controlI2C) throws UsbException {
        if (register.isMasked()) {
            int current = this.mShadowRegister[register.getRegister()];
            value = (byte)(current & ~register.getMask() | value & register.getMask());
        }
        this.writeI2CRegister(this.mDeviceHandle, this.mI2CAddress, (byte)register.getRegister(), value, controlI2C);
        this.mShadowRegister[register.getRegister()] = value;
    }

    public int readR820TRegister(Register register, boolean controlI2C) throws UsbException {
        int value = R820TTunerController.readI2CRegister(this.mDeviceHandle, this.mI2CAddress, (byte)register.getRegister(), controlI2C);
        return value;
    }

    public int setBiasTee(boolean on) {
        R820TTunerController.setGPIOOutput(this.mDeviceHandle, (byte)0);
        R820TTunerController.setGPIOBit(this.mDeviceHandle, (byte)1, on);
        return 0;
    }

    public void setGain(R820TGain gain, boolean controlI2C) throws UsbException {
        this.setLNAGain(gain.getLNAGain(), controlI2C);
        this.setMixerGain(gain.getMixerGain(), controlI2C);
        this.setVGAGain(gain.getVGAGain(), controlI2C);
    }

    public void setLNAGain(R820TLNAGain gain, boolean controlI2C) throws UsbException {
        this.writeR820TRegister(Register.LNA_GAIN, gain.getSetting(), controlI2C);
    }

    public void setMixerGain(R820TMixerGain gain, boolean controlI2C) throws UsbException {
        this.writeR820TRegister(Register.MIXER_GAIN, gain.getSetting(), controlI2C);
    }

    public void setVGAGain(R820TVGAGain gain, boolean controlI2C) throws UsbException {
        this.writeR820TRegister(Register.VGA_GAIN, gain.getSetting(), controlI2C);
    }

    @Override
    public int setFrequency(long freq) throws DeviceException, UsbException {
        this.setTunedFrequency(freq);
        return 0;
    }

    @Override
    public boolean isConnected() {
        return false;
    }

    public static enum FrequencyDivider {
        DIVIDER_0(0, 2, 864000000L, 1785600000L, 0, 28800000),
        DIVIDER_1(1, 4, 432000000L, 892800000L, 32, 14400000),
        DIVIDER_2(2, 8, 216000000L, 460800000L, 64, 0x6DDD00),
        DIVIDER_3(3, 16, 108000000L, 223200000L, 96, 3600000),
        DIVIDER_4(4, 32, 54000000L, 111600000L, 128, 1800000),
        DIVIDER_5(5, 64, 27000000L, 55800000L, 160, 900000),
        DIVIDER_6(6, 128, 13500000L, 27900000L, 192, 450000),
        DIVIDER_7(7, 256, 6750000L, 13950000L, 224, 225000);

        private int mDividerNumber;
        private int mMixerDivider;
        private long mMinimumFrequency;
        private long mMaximumFrequency;
        private int mRegisterSetting;
        private int mIntegralValue;
        private static final int mVCOPowerReference = 2;

        private FrequencyDivider(int dividerNumber, int mixerDivider, long minimumFrequency, long maximumFrequency, int registerSetting, int integralValue) {
            this.mDividerNumber = dividerNumber;
            this.mMixerDivider = mixerDivider;
            this.mMinimumFrequency = minimumFrequency;
            this.mMaximumFrequency = maximumFrequency;
            this.mRegisterSetting = registerSetting;
            this.mIntegralValue = integralValue;
        }

        public int getDividerNumber(int vcoFineTune) {
            if (vcoFineTune == 2) {
                return this.mDividerNumber;
            }
            if (vcoFineTune < 2) {
                return this.mDividerNumber - 1;
            }
            if (vcoFineTune > 2) {
                return this.mDividerNumber + 1;
            }
            return this.mDividerNumber;
        }

        public int getMixerDivider() {
            return this.mMixerDivider;
        }

        public long getMinimumFrequency() {
            return this.mMinimumFrequency;
        }

        public long getMaximumFrequency() {
            return this.mMaximumFrequency;
        }

        public byte getDividerRegisterSetting() {
            return (byte)this.mRegisterSetting;
        }

        public boolean contains(long frequency) {
            return this.mMinimumFrequency <= frequency && frequency <= this.mMaximumFrequency;
        }

        public static FrequencyDivider fromFrequency(long frequency) {
            FrequencyDivider[] frequencyDividerArray = FrequencyDivider.values();
            int n = frequencyDividerArray.length;
            int n2 = 0;
            while (n2 < n) {
                FrequencyDivider divider = frequencyDividerArray[n2];
                if (divider.contains(frequency)) {
                    return divider;
                }
                ++n2;
            }
            return DIVIDER_5;
        }

        public Integral getIntegral(long frequency) {
            if (this.contains(frequency)) {
                int delta = (int)(frequency - this.mMinimumFrequency);
                int integral = (int)((double)delta / (double)this.mIntegralValue);
                return Integral.fromValue(integral);
            }
            throw new IllegalArgumentException("PLL frequency [" + frequency + "] is not valid for this frequency divider " + this.toString());
        }

        public int getSDM(Integral integral, long frequency) {
            if (this.contains(frequency)) {
                int delta = (int)(frequency - this.mMinimumFrequency - (long)(integral.getNumber() * this.mIntegralValue));
                double fractional = (double)delta / (double)this.mIntegralValue;
                return (int)(fractional * 65536.0) & 0xFFFF;
            }
            return 0;
        }
    }

    public static enum FrequencyRange {
        RANGE_024(24000000L, 49999999L, 8, 2, 223, 2, 1),
        RANGE_050(50000000L, 54999999L, 8, 2, 190, 2, 1),
        RANGE_055(55000000L, 59999999L, 8, 2, 139, 2, 1),
        RANGE_060(60000000L, 64999999L, 8, 2, 123, 2, 1),
        RANGE_065(65000000L, 69999999L, 8, 2, 105, 2, 1),
        RANGE_070(70000000L, 74999999L, 8, 2, 88, 2, 1),
        RANGE_075(75000000L, 79999999L, 0, 2, 68, 2, 1),
        RANGE_080(80000000L, 89999999L, 0, 2, 68, 2, 1),
        RANGE_090(90000000L, 99999999L, 0, 2, 52, 1, 1),
        RANGE_100(100000000L, 109999999L, 0, 2, 52, 1, 1),
        RANGE_110(110000000L, 119999999L, 0, 2, 36, 1, 1),
        RANGE_120(120000000L, 139999999L, 0, 2, 36, 1, 1),
        RANGE_140(140000000L, 179999999L, 0, 2, 20, 1, 1),
        RANGE_180(180000000L, 219999999L, 0, 2, 19, 0, 0),
        RANGE_220(220000000L, 249999999L, 0, 2, 19, 0, 0),
        RANGE_250(250000000L, 279999999L, 0, 2, 17, 0, 0),
        RANGE_280(280000000L, 309999999L, 0, 2, 0, 0, 0),
        RANGE_310(310000000L, 449999999L, 0, 65, 0, 0, 0),
        RANGE_450(450000000L, 587999999L, 0, 65, 0, 0, 0),
        RANGE_588(588000000L, 649999999L, 0, 64, 0, 0, 0),
        RANGE_650(650000000L, 1766000000L, 0, 64, 0, 0, 0),
        RANGE_UNK(0L, 0L, 0, 0, 0, 0, 0);

        private long mMinFrequency;
        private long mMaxFrequency;
        private int mOpenDrain;
        private int mRFMux_PolyMux;
        private int mTF_c;
        private int mXtalCap20p;
        private int mXtalCap10p;

        private FrequencyRange(long minFrequency, long maxFrequency, int openDrain, int rfMuxPloy, int tf_c, int xtalCap20p, int xtalCap10p) {
            this.mMinFrequency = minFrequency;
            this.mMaxFrequency = maxFrequency;
            this.mOpenDrain = openDrain;
            this.mRFMux_PolyMux = rfMuxPloy;
            this.mTF_c = tf_c;
            this.mXtalCap20p = xtalCap20p;
            this.mXtalCap10p = xtalCap10p;
        }

        public boolean contains(long frequency) {
            return this.mMinFrequency <= frequency && frequency <= this.mMaxFrequency;
        }

        public static FrequencyRange getRangeForFrequency(long frequency) {
            FrequencyRange[] frequencyRangeArray = FrequencyRange.values();
            int n = frequencyRangeArray.length;
            int n2 = 0;
            while (n2 < n) {
                FrequencyRange range = frequencyRangeArray[n2];
                if (range.contains(frequency)) {
                    return range;
                }
                ++n2;
            }
            return RANGE_UNK;
        }

        public long getMinFrequency() {
            return this.mMinFrequency;
        }

        public long getMaxFrequency() {
            return this.mMaxFrequency;
        }

        public byte getOpenDrain() {
            return (byte)this.mOpenDrain;
        }

        public byte getRFMuxPolyMux() {
            return (byte)this.mRFMux_PolyMux;
        }

        public byte getTFC() {
            return (byte)this.mTF_c;
        }

        public byte getXTALCap20P() {
            return (byte)this.mXtalCap20p;
        }

        public byte getXTALCap10P() {
            return (byte)this.mXtalCap10p;
        }

        public byte getXTALLowCap0P() {
            return 8;
        }

        public byte getXTALHighCap0P() {
            return 0;
        }
    }

    public static enum Integral {
        I00(0, 68),
        I01(1, 132),
        I02(2, 196),
        I03(3, 5),
        I04(4, 69),
        I05(5, 133),
        I06(6, 197),
        I07(7, 6),
        I08(8, 70),
        I09(9, 134),
        I10(10, 198),
        I11(11, 7),
        I12(12, 71),
        I13(13, 135),
        I14(14, 199),
        I15(15, 8),
        I16(16, 72),
        I17(17, 136),
        I18(18, 200),
        I19(19, 9),
        I20(20, 73),
        I21(21, 137),
        I22(22, 201),
        I23(23, 10),
        I24(24, 74),
        I25(25, 138),
        I26(26, 202),
        I27(27, 11),
        I28(28, 75),
        I29(29, 139),
        I30(30, 203),
        I31(31, 12);

        private int mNumber;
        private int mRegister;

        private Integral(int number, int register) {
            this.mNumber = number;
            this.mRegister = register;
        }

        public int getNumber() {
            return this.mNumber;
        }

        public byte getRegisterValue() {
            return (byte)this.mRegister;
        }

        public static Integral fromValue(int value) {
            if (value >= 0 && value <= 31) {
                return Integral.values()[value];
            }
            throw new IllegalArgumentException("PLL integral value [" + value + "] must be in the range 0 - 31");
        }
    }

    public static enum R820TGain {
        AUTOMATIC("Automatic", R820TVGAGain.GAIN_312, R820TLNAGain.AUTOMATIC, R820TMixerGain.AUTOMATIC),
        MANUAL("Manual", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_248, R820TMixerGain.GAIN_123),
        GAIN_0("0", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_0, R820TMixerGain.GAIN_0),
        GAIN_9("9", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_9, R820TMixerGain.GAIN_0),
        GAIN_14("14", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_9, R820TMixerGain.GAIN_5),
        GAIN_26("26", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_21, R820TMixerGain.GAIN_5),
        GAIN_36("36", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_21, R820TMixerGain.GAIN_15),
        GAIN_76("76", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_61, R820TMixerGain.GAIN_15),
        GAIN_86("86", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_61, R820TMixerGain.GAIN_25),
        GAIN_124("124", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_99, R820TMixerGain.GAIN_25),
        GAIN_143("143", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_99, R820TMixerGain.GAIN_44),
        GAIN_156("156", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_112, R820TMixerGain.GAIN_44),
        GAIN_165("165", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_112, R820TMixerGain.GAIN_53),
        GAIN_196("196", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_143, R820TMixerGain.GAIN_53),
        GAIN_208("208", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_143, R820TMixerGain.GAIN_63),
        GAIN_228("228", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_165, R820TMixerGain.GAIN_63),
        GAIN_253("253", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_165, R820TMixerGain.GAIN_88),
        GAIN_279("279", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_191, R820TMixerGain.GAIN_88),
        GAIN_296("296", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_191, R820TMixerGain.GAIN_105),
        GAIN_327("327", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_222, R820TMixerGain.GAIN_105),
        GAIN_337("337", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_222, R820TMixerGain.GAIN_115),
        GAIN_363("363", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_248, R820TMixerGain.GAIN_115),
        GAIN_371("371", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_248, R820TMixerGain.GAIN_123),
        GAIN_385("385", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_262, R820TMixerGain.GAIN_123),
        GAIN_401("401", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_262, R820TMixerGain.GAIN_139),
        GAIN_420("420", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_281, R820TMixerGain.GAIN_139),
        GAIN_433("433", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_281, R820TMixerGain.GAIN_152),
        GAIN_438("438", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_286, R820TMixerGain.GAIN_152),
        GAIN_444("444", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_286, R820TMixerGain.GAIN_158),
        GAIN_479("479", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_321, R820TMixerGain.GAIN_158),
        GAIN_482("482", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_321, R820TMixerGain.GAIN_161),
        GAIN_495("495", R820TVGAGain.GAIN_210, R820TLNAGain.GAIN_334, R820TMixerGain.GAIN_161);

        private String mLabel;
        private R820TVGAGain mVGAGain;
        private R820TLNAGain mLNAGain;
        private R820TMixerGain mMixerGain;

        private R820TGain(String label, R820TVGAGain vga, R820TLNAGain lna, R820TMixerGain mixer) {
            this.mLabel = label;
            this.mVGAGain = vga;
            this.mLNAGain = lna;
            this.mMixerGain = mixer;
        }

        public String toString() {
            return this.mLabel;
        }

        public R820TVGAGain getVGAGain() {
            return this.mVGAGain;
        }

        public R820TLNAGain getLNAGain() {
            return this.mLNAGain;
        }

        public R820TMixerGain getMixerGain() {
            return this.mMixerGain;
        }
    }

    public static enum R820TLNAGain {
        AUTOMATIC("Automatic", 0),
        GAIN_0("0", 16),
        GAIN_9("9", 17),
        GAIN_21("21", 18),
        GAIN_61("61", 19),
        GAIN_99("99", 20),
        GAIN_112("112", 21),
        GAIN_143("143", 22),
        GAIN_165("165", 23),
        GAIN_191("191", 24),
        GAIN_222("222", 25),
        GAIN_248("248", 26),
        GAIN_262("262", 27),
        GAIN_281("281", 28),
        GAIN_286("286", 29),
        GAIN_321("321", 30),
        GAIN_334("334", 31);

        private String mLabel;
        private int mSetting;

        private R820TLNAGain(String label, int setting) {
            this.mLabel = label;
            this.mSetting = setting;
        }

        public String toString() {
            return this.mLabel;
        }

        public byte getSetting() {
            return (byte)this.mSetting;
        }
    }

    public static enum R820TMixerGain {
        AUTOMATIC("Automatic", 16),
        GAIN_0("0", 0),
        GAIN_5("5", 1),
        GAIN_15("15", 2),
        GAIN_25("25", 3),
        GAIN_44("44", 4),
        GAIN_53("53", 5),
        GAIN_63("63", 6),
        GAIN_88("88", 7),
        GAIN_105("105", 8),
        GAIN_115("115", 9),
        GAIN_123("123", 10),
        GAIN_139("139", 11),
        GAIN_152("152", 12),
        GAIN_158("158", 13),
        GAIN_161("161", 14),
        GAIN_153("153", 15);

        private String mLabel;
        private int mSetting;

        private R820TMixerGain(String label, int setting) {
            this.mLabel = label;
            this.mSetting = setting;
        }

        public String toString() {
            return this.mLabel;
        }

        public byte getSetting() {
            return (byte)this.mSetting;
        }
    }

    public static enum R820TVGAGain {
        GAIN_0("0", 0),
        GAIN_26("26", 1),
        GAIN_52("52", 2),
        GAIN_82("82", 3),
        GAIN_124("124", 4),
        GAIN_159("159", 5),
        GAIN_183("183", 6),
        GAIN_196("196", 7),
        GAIN_210("210", 8),
        GAIN_242("242", 9),
        GAIN_278("278", 10),
        GAIN_312("312", 11),
        GAIN_347("347", 12),
        GAIN_384("384", 13),
        GAIN_419("419", 14),
        GAIN_455("455", 15);

        private String mLabel;
        private int mSetting;

        private R820TVGAGain(String label, int setting) {
            this.mLabel = label;
            this.mSetting = setting;
        }

        public String toString() {
            return this.mLabel;
        }

        public byte getSetting() {
            return (byte)this.mSetting;
        }
    }

    public static enum Register {
        LNA_GAIN(5, 31),
        AIR_CABLE1_INPUT_SELECTOR(5, 96),
        LOOP_THROUGH(5, 128),
        CABLE2_INPUT_SELECTOR(6, 8),
        FILTER_GAIN(6, 48),
        PRE_DETECT(6, 64),
        MIXER_GAIN(7, 31),
        IMAGE_REVERSE(7, 128),
        UNKNOWN_REGISTER_8(8, 63),
        UNKNOWN_REGISTER_9(9, 63),
        FILTER_CALIBRATION_CODE(10, 31),
        FILTER_CURRENT(10, 96),
        CALIBRATION_TRIGGER(11, 16),
        FILTER_CAPACITOR(11, 96),
        BANDWIDTH_FILTER_GAIN_HIGHPASS_FILTER_CORNER(11, 239),
        XTAL_CHECK(12, 15),
        VGA_GAIN(12, 159),
        LNA_VTH_L(13, 0),
        MIXER_VTH_L(14, 0),
        CALIBRATION_CLOCK(15, 4),
        FILTER_EXTENSION_WIDEST(15, 128),
        PLL_XTAL_CAPACITOR(16, 3),
        UNKNOWN_REGISTER_10(16, 4),
        PLL_XTAL_CAPACITOR_AND_DRIVE(16, 11),
        REFERENCE_DIVIDER_2(16, 16),
        CAPACITOR_SELECTOR(16, 27),
        DIVIDER(16, 224),
        CP_CUR(17, 56),
        SIGMA_DELTA_MODULATOR_POWER(18, 8),
        VCO_CURRENT(18, 224),
        VERSION(19, 63),
        PLL(20, 0),
        SIGMA_DELTA_MODULATOR_LSB(21, 0),
        SIGMA_DELTA_MODULATOR_MSB(22, 0),
        DRAIN(23, 8),
        DIVIDER_BUFFER_CURRENT(23, 48),
        RF_POLY_FILTER_CURRENT(25, 96),
        PLL_AUTOTUNE(26, 12),
        PLL_AUTOTUNE_VARIANT(26, 8),
        AGC_CLOCK(26, 48),
        RF_POLY_MUX(26, 195),
        TF_BAND(27, 0),
        MIXER_TOP(28, 248),
        MIXER_TOP2(28, 4),
        LNA_TOP(29, 56),
        LNA_TOP2(29, 199),
        CHANNEL_FILTER_EXTENSION(30, 96),
        LNA_DISCHARGE_CURRENT(30, 31),
        LOOP_THROUGH_ATTENUATION(31, 128);

        private int mRegister;
        private int mMask;

        private Register(int register, int mask) {
            this.mRegister = register;
            this.mMask = mask;
        }

        public int getRegister() {
            return this.mRegister;
        }

        public byte getMask() {
            return (byte)this.mMask;
        }

        public boolean isMasked() {
            return this.mMask != 0;
        }
    }
}

