/*
 * Decompiled with CFR 0.152.
 */
package filter;

import filter.Filter;
import javax.sound.sampled.AudioFormat;

public class CICDecimationFilter
extends Filter {
    protected double[] xv;
    double GAIN = 1.0;
    double[] previousOutput;
    int M = 127;
    double[] xcoeffs = new double[]{8.593779E-6, 5.697627E-6, -1.75055E-5, -1.93578E-5, 2.490024E-5, 4.45096E-5, -2.421413E-5, -8.184734E-5, 6.330681E-6, 1.277673E-4, 3.897493E-5, -1.726743E-4, -1.204248E-4, 2.001757E-4, 2.416643E-4, -1.877985E-4, -3.972685E-4, 1.097069E-4, 5.691903E-4, 5.842869E-5, -7.247108E-4, -3.327294E-4, 8.169643E-4, 7.134259E-4, -7.88877E-4, -0.001177538, 5.808677E-4, 0.001673587, -1.419772E-4, -0.002120056, -5.566946E-4, 0.002409036, 0.001508089, -0.00241584, -0.002657183, 0.002014441, 0.003893361, -0.001097525, -0.005049328, -4.010691E-4, 0.005907848, 0.002484479, -0.006216324, -0.005074727, 0.005707522, 0.008001118, -0.004122839, -0.01099652, 0.001232179, 0.01370046, 0.003158929, -0.01566334, -0.009231583, 0.01633741, 0.01724286, -0.01501631, -0.02779653, 0.01060636, 0.04276591, -7.540386E-4, -0.06984689, -0.02265479, 0.1813897, 0.382278, 0.382278, 0.1813897, -0.02265479, -0.06984689, -7.540386E-4, 0.04276591, 0.01060636, -0.02779653, -0.01501631, 0.01724286, 0.01633741, -0.009231583, -0.01566334, 0.003158929, 0.01370046, 0.001232179, -0.01099652, -0.004122839, 0.008001118, 0.005707522, -0.005074727, -0.006216324, 0.002484479, 0.005907848, -4.010691E-4, -0.005049328, -0.001097525, 0.003893361, 0.002014441, -0.002657183, -0.00241584, 0.001508089, 0.002409036, -5.566946E-4, -0.002120056, -1.419772E-4, 0.001673587, 5.808677E-4, -0.001177538, -7.88877E-4, 7.134259E-4, 8.169643E-4, -3.327294E-4, -7.247108E-4, 5.842869E-5, 5.691903E-4, 1.097069E-4, -3.972685E-4, -1.877985E-4, 2.416643E-4, 2.001757E-4, -1.204248E-4, -1.726743E-4, 3.897493E-5, 1.277673E-4, 6.330681E-6, -8.184734E-5, -2.421413E-5, 4.45096E-5, 2.490024E-5, -1.93578E-5, -1.75055E-5, 5.697627E-6, 8.593779E-6};
    int R = 5;
    int D = 10;
    int Q = 1;
    double[][] delayLine;
    int sampleNumber = 0;

    public CICDecimationFilter(AudioFormat af, int size) {
        super(af, size);
    }

    @Override
    public void init(double sampleRate, double freq, int len) {
        this.Q = 10;
        this.previousOutput = new double[this.Q];
        this.R = 4;
        this.D = this.R * 10;
        this.delayLine = new double[this.Q][];
        int i = 0;
        while (i < this.Q) {
            this.delayLine = new double[i][this.D / this.R];
            ++i;
        }
        this.xv = new double[this.M + 1];
        this.setDecimationFactor(this.R);
    }

    private double integrate(double currentInput, int stage) {
        double currentOutput;
        this.previousOutput[stage] = currentOutput = currentInput + this.previousOutput[stage];
        return currentOutput;
    }

    private double comb(double currentOutput, int stage) {
        this.delayLine[stage][0] = currentOutput;
        currentOutput += this.delayLine[stage][this.delayLine[0].length - 1];
        int i = 0;
        while (i < this.delayLine[0].length - 1) {
            this.delayLine[stage][i + 1] = this.delayLine[stage][i];
            ++i;
        }
        return currentOutput;
    }

    public double filter(double currentInput) {
        double currentOutput = 0.0;
        int q = 0;
        currentOutput = currentInput;
        q = 0;
        while (q < this.Q) {
            currentOutput = this.integrate(currentOutput, q);
            ++q;
        }
        if (this.calculateNow()) {
            q = 0;
            while (q < this.Q) {
                currentOutput = this.comb(currentOutput, q);
                ++q;
            }
            currentOutput = this.filterDouble(currentOutput);
            return currentOutput;
        }
        return 0.0;
    }

    @Override
    public double filterDouble(double in) {
        int i = 0;
        while (i < this.M) {
            this.xv[i] = this.xv[i + 1];
            ++i;
        }
        this.xv[this.M] = in * this.GAIN;
        double sum = 0.0;
        i = 0;
        while (i <= this.M) {
            sum += this.xcoeffs[i] * this.xv[i];
            ++i;
        }
        return sum;
    }

    @Override
    protected int getFilterLength() {
        return 0;
    }

    @Override
    public double[] getKernal() {
        return null;
    }
}

