/*
 * Decompiled with CFR 0.152.
 */
package filter;

import common.Log;
import filter.Filter;
import javax.sound.sampled.AudioFormat;

public class MatchedSincFilter
extends Filter {
    protected double[] xv;
    int M = 0;
    double GAIN = 1.0;
    double[] xcoeffs;

    public MatchedSincFilter(AudioFormat af, int size) {
        super(af, size);
    }

    @Override
    public void init(double sampleRate, double freq, int len) {
        int pulseLength = (int)(sampleRate / freq);
        this.M = len;
        this.xcoeffs = new double[this.M + 1];
        this.xv = new double[this.M + 1];
        double sumofsquares = 0.0;
        int j = 0;
        int i = 0;
        while (i <= this.M) {
            if (i >= (this.M + 1 - pulseLength) / 2 && i < this.M + 1 - (this.M + 1 - pulseLength) / 2) {
                double sinc = this.GAIN * Math.sin(j - pulseLength / 2) / (double)(j - pulseLength / 2);
                double blackman = 0.42 - 0.5 * Math.cos(Math.PI * 2 * (double)j / (double)pulseLength) + 0.08 * Math.cos(Math.PI * 4 * (double)j / (double)pulseLength);
                this.xcoeffs[i] = j == pulseLength / 2 ? Math.PI * 2 * blackman : sinc * blackman;
                ++j;
            } else {
                this.xcoeffs[i] = 0.0;
            }
            sumofsquares += this.xcoeffs[i] * this.xcoeffs[i];
            ++i;
        }
        this.GAIN = Math.sqrt(sumofsquares) / (double)this.xcoeffs.length;
        Log.println("Matched Filter GAIN: " + this.GAIN);
        super.init(sampleRate, freq, len);
        this.name = "MatchedFilter (" + this.cutoffFreq + " " + this.xcoeffs.length + " stereo:" + this.stereo + " Rate: " + this.SAMPLERATE + ")";
    }

    @Override
    public double filterDouble(double in) {
        int i = 0;
        while (i < this.M) {
            this.xv[i] = this.xv[i + 1];
            ++i;
        }
        this.xv[this.M] = in * this.GAIN;
        double sum = 0.0;
        i = 0;
        while (i <= this.M) {
            sum += this.xcoeffs[i] * this.xv[i];
            ++i;
        }
        return sum;
    }

    @Override
    protected int getFilterLength() {
        return this.xcoeffs.length;
    }

    @Override
    public double[] getKernal() {
        return this.xcoeffs;
    }
}

