/*
 * Decompiled with CFR 0.152.
 */
package filter;

import common.Log;
import filter.Filter;
import javax.sound.sampled.AudioFormat;

public class WindowedSincFilter
extends Filter {
    protected double[] xv;
    int M = 0;
    double GAIN = 1.0;
    double Fc = 0.0;
    double[] xcoeffs = null;

    public WindowedSincFilter(AudioFormat af, int size) {
        super(af, size);
    }

    @Override
    public void init(double sampleRate, double freq, int len) {
        this.M = len;
        this.xcoeffs = new double[this.M + 1];
        this.Fc = freq / sampleRate;
        double sumofsquares = 0.0;
        int i = 0;
        while (i <= this.M) {
            double sinc = this.GAIN * Math.sin(Math.PI * 2 * this.Fc * (double)(i - this.M / 2)) / (double)(i - this.M / 2);
            double blackman = 0.42 - 0.5 * Math.cos(Math.PI * 2 * (double)i / (double)this.M) + 0.08 * Math.cos(Math.PI * 4 * (double)i / (double)this.M);
            this.xcoeffs[i] = i == this.M / 2 ? Math.PI * 2 * this.Fc * this.GAIN * blackman : sinc * blackman;
            sumofsquares += this.xcoeffs[i] * this.xcoeffs[i];
            ++i;
        }
        this.xv = new double[this.M + 1];
        this.GAIN = Math.sqrt(sumofsquares) / (double)this.xcoeffs.length;
        Log.println("Windowed Sinc Filter GAIN: " + this.GAIN);
        super.init(sampleRate, freq, len);
        this.name = "WindowedSinc Cutoff:" + this.cutoffFreq + " Taps:" + this.xcoeffs.length + " stereo:" + this.stereo + " Rate: " + sampleRate;
    }

    @Override
    public double filterDouble(double in) {
        int i = 0;
        while (i < this.M) {
            this.xv[i] = this.xv[i + 1];
            ++i;
        }
        this.xv[this.M] = in * this.GAIN;
        if (this.calculateNow()) {
            double sum = 0.0;
            i = 0;
            while (i <= this.M) {
                sum += this.xcoeffs[i] * this.xv[i];
                ++i;
            }
            return sum;
        }
        return 0.0;
    }

    @Override
    protected int getFilterLength() {
        return this.xcoeffs.length;
    }

    @Override
    public double[] getKernal() {
        return this.xcoeffs;
    }
}

