/*
 * Decompiled with CFR 0.152.
 */
package gui;

import common.Config;
import common.Log;
import common.Spacecraft;
import decoder.RfData;
import decoder.SourceIQ;
import gui.graph.LinePlotPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class FFTPanel
extends JPanel
implements Runnable,
MouseListener {
    Spacecraft fox;
    int fftSamples = 0;
    private double[] psd = null;
    boolean running = true;
    boolean done = false;
    double centerFreqX = 145950.0;
    int selection = 0;
    boolean showFilteredAudio = false;
    int sideBorder = 2 * Config.graphAxisFontSize;
    int topBorder = Config.graphAxisFontSize;
    int labelWidth = 4 * Config.graphAxisFontSize;
    int zoomFactor = 1;
    public static final int MAX_ZOOM_FACTOR = 10;
    public static final int MIN_ZOOM_FACTOR = 1;
    int graphWidth;
    int graphHeight;
    Color graphColor = Config.AMSAT_RED;
    Color graphAxisColor = Color.BLACK;
    Color graphTextColor = Color.DARK_GRAY;
    SourceIQ iqSource;
    RfData rfData;
    boolean liveData = false;
    int tuneDelay = 0;
    int TUNE_THRESHOLD = 100;
    JLabel title = new JLabel();
    int avgBin = 0;
    int avgNum = 0;

    FFTPanel() {
        this.add(this.title);
        this.addMouseListener(this);
        String TUNE_LEFT = "left";
        String TUNE_RIGHT = "right";
        InputMap inMap = this.getInputMap(2);
        inMap.put(KeyStroke.getKeyStroke("LEFT"), TUNE_LEFT);
        inMap.put(KeyStroke.getKeyStroke("RIGHT"), TUNE_RIGHT);
        ActionMap actMap = this.getActionMap();
        actMap.put(TUNE_LEFT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FFTPanel.this.iqSource.decSelectedFrequency();
            }
        });
        actMap.put(TUNE_RIGHT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FFTPanel.this.iqSource.incSelectedFrequency();
            }
        });
    }

    public void zoomIn() {
        ++this.zoomFactor;
        if (this.zoomFactor > 10) {
            this.zoomFactor = 10;
        }
        System.err.println(this.zoomFactor);
    }

    public void zoomOut() {
        --this.zoomFactor;
        if (this.zoomFactor < 1) {
            this.zoomFactor = 1;
        }
        System.err.println(this.zoomFactor);
    }

    private void printBin() {
        int freq = 0;
        int selectedBin = this.iqSource.getSelectedBin();
        freq = selectedBin < SourceIQ.FFT_SAMPLES / 2 ? 192000 * selectedBin / SourceIQ.FFT_SAMPLES : 96000 - 192000 * (selectedBin - SourceIQ.FFT_SAMPLES / 2) / SourceIQ.FFT_SAMPLES;
        double cycles = this.getCycles();
        System.out.println("fft bin " + selectedBin + " freq: " + freq + " cyc: " + cycles);
    }

    public void stopProcessing() {
        this.running = false;
    }

    private void init() {
        this.fftSamples = SourceIQ.FFT_SAMPLES;
        this.done = false;
        this.running = true;
        this.psd = new double[this.fftSamples + 1];
        this.title.setText("FFT: " + this.fftSamples);
    }

    @Override
    public void run() {
        Thread.currentThread().setName("FFTPanel");
        double[] buffer = null;
        while (this.running) {
            if (this.iqSource != null) {
                if (this.fftSamples != SourceIQ.FFT_SAMPLES) {
                    this.fftSamples = SourceIQ.FFT_SAMPLES;
                    this.psd = new double[this.fftSamples + 1];
                    this.title.setText("FFT: " + this.fftSamples);
                }
                buffer = this.iqSource.getPowerSpectralDensity();
                this.centerFreqX = this.iqSource.getCenterFreqkHz();
                this.rfData = this.iqSource.getRfData();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (buffer != null) {
                this.psd = buffer;
                this.liveData = true;
                this.repaint();
            } else {
                this.liveData = false;
            }
            if (this.rfData == null || Config.foxTelemCalcsDoppler) continue;
            this.retune();
        }
        this.done = true;
    }

    private void retune() {
        if (this.iqSource == null) {
            return;
        }
        int selectedBin = this.iqSource.getSelectedBin();
        int targetBin = 0;
        if (Config.findSignal && this.liveData && this.rfData.rfSNRInFilterWidth > Config.ANALYZE_SNR_THRESHOLD) {
            targetBin = this.rfData.getBinOfPeakSignalInFilterWidth();
            this.avgBin += targetBin;
            ++this.avgNum;
            if (this.iqSource.getFormat().isBPSK()) {
                this.TUNE_THRESHOLD = 10;
                ++this.tuneDelay;
            } else {
                this.TUNE_THRESHOLD = 100;
                this.tuneDelay = Config.passManager.getState() == 4 ? ++this.tuneDelay : (Config.passManager.getState() == 2 ? (this.tuneDelay += 20) : (Config.passManager.getState() == 5 ? 0 : this.TUNE_THRESHOLD));
            }
            if (this.tuneDelay >= this.TUNE_THRESHOLD) {
                targetBin = this.avgBin / this.avgNum;
                this.avgNum = 0;
                this.avgBin = 0;
                this.tuneDelay = 0;
                int move = targetBin - selectedBin;
                if (targetBin < selectedBin) {
                    selectedBin = move < -100 ? (selectedBin -= 50) : (move < -25 ? (selectedBin -= 12) : (move < -5 ? (selectedBin -= 5) : (move < -2 ? (selectedBin -= 2) : --selectedBin)));
                }
                if (targetBin > selectedBin) {
                    selectedBin = move > 100 ? (selectedBin += 50) : (move > 25 ? (selectedBin += 12) : (move > 5 ? (selectedBin += 5) : (move > 2 ? (selectedBin += 2) : ++selectedBin)));
                }
                if (targetBin != 0) {
                    if (Config.findSignal) {
                        if (selectedBin > Config.fromBin && selectedBin < Config.toBin && targetBin > Config.fromBin && targetBin < Config.toBin) {
                            this.iqSource.setSelectedBin(targetBin);
                        }
                    } else {
                        this.iqSource.setSelectedBin(selectedBin);
                    }
                }
            }
        }
    }

    public static int littleEndian2(byte[] b) {
        byte b2 = b[1];
        byte b1 = b[0];
        int value = (b2 & 0xFF) << 8 | (b1 & 0xFF) << 0;
        if (value > Short.MAX_VALUE) {
            value += -65536;
        }
        return value;
    }

    private int getSelectionFromBin(int bin) {
        int selection = bin < this.fftSamples / 2 ? bin + this.fftSamples / 2 : bin - this.fftSamples / 2;
        return selection;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.iqSource == null) {
            return;
        }
        this.sideBorder = 3 * Config.graphAxisFontSize;
        this.topBorder = Config.graphAxisFontSize;
        this.labelWidth = 4 * Config.graphAxisFontSize;
        if (!this.running) {
            return;
        }
        if (this.psd == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.graphAxisColor);
        this.graphHeight = this.getHeight() - this.topBorder * 2;
        this.graphWidth = this.getWidth() - this.sideBorder * 2;
        int minTimeValue = (int)(this.centerFreqX - (double)(this.iqSource.IQ_SAMPLE_RATE / 2000));
        int maxTimeValue = (int)(this.centerFreqX + (double)(this.iqSource.IQ_SAMPLE_RATE / 2000));
        int numberOfTimeLabels = this.graphWidth / this.labelWidth;
        int zeroPoint = this.graphHeight;
        float maxValue = 10.0f;
        float minValue = -120.0f;
        int labelHeight = 14;
        int sideLabel = 3;
        int numberOfLabels = this.graphHeight / labelHeight;
        double[] labels = LinePlotPanel.calcAxisInterval(minValue, maxValue, numberOfLabels, false);
        numberOfLabels = labels.length;
        DecimalFormat f1 = new DecimalFormat("0.0");
        DecimalFormat f2 = new DecimalFormat("0");
        g2.drawLine(this.sideBorder, this.getHeight() - this.topBorder, this.sideBorder, 0);
        g.setFont(new Font("SansSerif", 0, Config.graphAxisFontSize));
        int v = 0;
        while (v < numberOfLabels) {
            int pos = this.getRatioPosition(minValue, maxValue, labels[v], this.graphHeight);
            pos = this.graphHeight - pos;
            String s = null;
            s = labels[v] == (double)Math.round(labels[v]) ? f2.format(labels[v]) : f1.format(labels[v]);
            if (v < numberOfLabels - 1 && (v != 0 || pos <= this.graphHeight)) {
                g2.setColor(this.graphTextColor);
                g.drawString(s, sideLabel, pos + this.topBorder + 4);
                g2.setColor(this.graphAxisColor);
                g.drawLine(this.sideBorder - 5, pos + this.topBorder, this.sideBorder + 5, pos + this.topBorder);
            }
            ++v;
        }
        if (this.iqSource != null) {
            this.selection = this.getSelectionFromBin(this.iqSource.getSelectedBin());
            int c = this.getRatioPosition(0.0, this.fftSamples, this.selection, this.graphWidth);
            int lower = this.getRatioPosition(0.0, this.fftSamples, this.selection - this.iqSource.getFilterWidth() / 2, this.graphWidth);
            int upper = this.getRatioPosition(0.0, this.fftSamples, this.selection + this.iqSource.getFilterWidth() / 2, this.graphWidth);
            g2.setColor(this.graphAxisColor);
            g2.drawLine(c + this.sideBorder, this.topBorder, c + this.sideBorder, zeroPoint);
            g2.setColor(Color.gray);
            g2.drawLine(lower + this.sideBorder, this.topBorder, lower + this.sideBorder, zeroPoint);
            g2.drawLine(upper + this.sideBorder, this.topBorder, upper + this.sideBorder, zeroPoint);
            if (Config.findSignal || Config.foxTelemCalcsDoppler) {
                if (Config.findSignal) {
                    if (this.fox != null) {
                        g.drawString(String.valueOf(Config.passManager.getStateName()) + ": " + this.fox.user_display_name, this.graphWidth - 5 * Config.graphAxisFontSize, 4 * Config.graphAxisFontSize);
                    } else {
                        g.drawString("Scanning..", this.graphWidth - 5 * Config.graphAxisFontSize, 4 * Config.graphAxisFontSize);
                    }
                }
                int s = 0;
                while (s < Config.satManager.spacecraftList.size()) {
                    Spacecraft sat = Config.satManager.spacecraftList.get(s);
                    if (sat.user_track) {
                        int fromSatBin = this.iqSource.getBinFromFreqHz((long)(sat.user_minFreqBoundkHz * 1000.0));
                        int toSatBin = this.iqSource.getBinFromFreqHz((long)(sat.user_maxFreqBoundkHz * 1000.0));
                        if (fromSatBin > SourceIQ.FFT_SAMPLES / 2 && toSatBin < SourceIQ.FFT_SAMPLES / 2) {
                            toSatBin = 0;
                        }
                        g2.setColor(Config.PURPLE);
                        int upperSelection = this.getSelectionFromBin(toSatBin);
                        int lowerSelection = this.getSelectionFromBin(fromSatBin);
                        if (upperSelection != lowerSelection) {
                            int c1 = this.getRatioPosition(0.0, this.fftSamples, upperSelection, this.graphWidth);
                            g2.drawLine(c1 + this.sideBorder, this.topBorder + 5, c1 + this.sideBorder, zeroPoint);
                            int c2 = this.getRatioPosition(0.0, this.fftSamples, lowerSelection, this.graphWidth);
                            g2.drawLine(c2 + this.sideBorder, this.topBorder + 5, c2 + this.sideBorder, zeroPoint);
                            int c3 = (c1 + c2) / 2;
                            g.drawString(sat.user_display_name, (c3 -= sat.user_display_name.length() / 3 * Config.graphAxisFontSize) + this.sideBorder, this.topBorder + 15);
                        }
                    }
                    ++s;
                }
            }
            if (this.rfData != null) {
                g2.setColor(Config.AMSAT_BLUE);
                int posPeakSignalInFilterWidth = this.getRatioPosition(maxValue, minValue, this.rfData.getAvg(3) + (double)this.topBorder, this.graphHeight);
                int binOfPeakSignalInFilterWidth = 0;
                if (this.rfData.getBinOfPeakSignalInFilterWidth() < this.fftSamples / 2) {
                    binOfPeakSignalInFilterWidth = this.getRatioPosition(0.0, this.fftSamples / 2, this.rfData.getBinOfPeakSignalInFilterWidth(), this.graphWidth / 2);
                    binOfPeakSignalInFilterWidth = binOfPeakSignalInFilterWidth + this.sideBorder + this.graphWidth / 2;
                } else {
                    binOfPeakSignalInFilterWidth = this.getRatioPosition(0.0, this.fftSamples / 2, this.rfData.getBinOfPeakSignalInFilterWidth() - this.fftSamples / 2, this.graphWidth / 2);
                    binOfPeakSignalInFilterWidth += this.sideBorder;
                }
                double snrStrongestSigInSatBand = LinePlotPanel.roundToSignificantFigures(this.rfData.rfStrongestSigSNRInSatBand, 3);
                double snr = LinePlotPanel.roundToSignificantFigures(this.rfData.rfSNRInFilterWidth, 3);
                String s = String.valueOf(Double.toString(snr));
                String ss = String.valueOf(Double.toString(snrStrongestSigInSatBand));
                double f = this.iqSource.getCenterFreqkHz() * 1000.0 + this.iqSource.getSelectedFrequency();
                DecimalFormat d3 = new DecimalFormat("0.000");
                g.drawString("| ", binOfPeakSignalInFilterWidth, posPeakSignalInFilterWidth);
                g2.drawLine(binOfPeakSignalInFilterWidth - 5, posPeakSignalInFilterWidth - 3, binOfPeakSignalInFilterWidth + 5, posPeakSignalInFilterWidth - 3);
                if (Config.showSNR) {
                    g.drawString("snr: " + s + "dB", binOfPeakSignalInFilterWidth + 10, posPeakSignalInFilterWidth);
                } else {
                    g.drawString(ss + "dB", binOfPeakSignalInFilterWidth + 10, posPeakSignalInFilterWidth);
                }
                g.drawString("Freq:" + d3.format(f / 1000.0), this.graphWidth - 5 * Config.graphAxisFontSize, 2 * Config.graphAxisFontSize);
                if (Config.findSignal && Config.debugSignalFinder) {
                    int strongestSigInSatBand = this.getRatioPosition(minValue, maxValue, this.rfData.getAvg(4), this.graphHeight);
                    strongestSigInSatBand = this.graphHeight - strongestSigInSatBand - this.topBorder;
                    int binOfStrongestSigInSatBand = 0;
                    if (this.rfData.getBinOfStrongestSignalInSatBand() < this.fftSamples / 2) {
                        binOfStrongestSigInSatBand = this.getRatioPosition(0.0, this.fftSamples / 2, this.rfData.getBinOfStrongestSignalInSatBand(), this.graphWidth / 2);
                        binOfStrongestSigInSatBand = binOfStrongestSigInSatBand + this.sideBorder + this.graphWidth / 2;
                    } else {
                        binOfStrongestSigInSatBand = this.getRatioPosition(0.0, this.fftSamples / 2, this.rfData.getBinOfStrongestSignalInSatBand() - this.fftSamples / 2, this.graphWidth / 2);
                        binOfStrongestSigInSatBand += this.sideBorder;
                    }
                    g.drawString("^ ", binOfStrongestSigInSatBand, strongestSigInSatBand - 5);
                }
            } else {
                Log.println("RF DATA NULL");
            }
        }
        int lastx = this.sideBorder + 1;
        int lasty = this.graphHeight;
        int x = 0;
        int y = 0;
        g2.setColor(this.graphColor);
        int stepSize = Math.round((this.fftSamples - 1) / this.graphWidth);
        int i = this.fftSamples / 2;
        while (i < this.fftSamples) {
            x = this.getRatioPosition(0.0, this.fftSamples / 2, i - this.fftSamples / 2, this.graphWidth / 2);
            x += this.sideBorder;
            if (i >= this.psd.length) {
                return;
            }
            y = this.getRatioPosition(minValue, maxValue, this.psd[i], this.graphHeight);
            y = this.graphHeight - y + this.topBorder;
            if (i == 1) {
                lastx = x;
                lasty = y;
            }
            g2.drawLine(lastx, lasty, x, y);
            lastx = x;
            lasty = y;
            i += stepSize;
        }
        i = 1;
        while (i < this.fftSamples / 2) {
            x = this.getRatioPosition(0.0, this.fftSamples / 2, i, this.graphWidth / 2);
            x = x + this.sideBorder + this.graphWidth / 2;
            if (i >= this.psd.length) {
                return;
            }
            y = this.getRatioPosition(minValue, maxValue, this.psd[i], this.graphHeight);
            y = this.graphHeight - y + this.topBorder;
            if (i == 1) {
                lastx = x;
                lasty = y;
            }
            g2.drawLine(lastx, lasty, x, y);
            lastx = x;
            lasty = y;
            i += stepSize;
        }
        double[] freqlabels = LinePlotPanel.calcAxisInterval(minTimeValue, maxTimeValue, numberOfTimeLabels, false);
        DecimalFormat d = new DecimalFormat("0");
        int v2 = 0;
        while (v2 < freqlabels.length) {
            int timepos = this.getRatioPosition(minTimeValue, maxTimeValue, freqlabels[v2], this.graphWidth);
            if (timepos > 2 && this.graphWidth - timepos > this.labelWidth / 6) {
                String s = d.format(freqlabels[v2]);
                g2.setColor(this.graphTextColor);
                g.drawString(s, timepos + this.sideBorder + 2 - this.labelWidth / 2, zeroPoint + Config.graphAxisFontSize);
                g2.setColor(this.graphAxisColor);
                g.drawLine(timepos + this.sideBorder, zeroPoint, timepos + this.sideBorder, zeroPoint + 5);
            }
            ++v2;
        }
        g2.setColor(this.graphAxisColor);
        g2.drawLine(0, zeroPoint, this.getWidth(), zeroPoint);
    }

    public void setFox(Spacecraft spacecraft) {
        this.fox = spacecraft;
    }

    public void startProcessing(SourceIQ d) {
        this.iqSource = d;
        this.init();
        this.running = true;
    }

    private int getRatioPosition(double min, double max, double value, int dimension) {
        double ratio = (max - value) / (max - min);
        int position = (int)Math.round((double)dimension * ratio);
        return dimension - position;
    }

    private double getCycles() {
        int selectedBin = this.iqSource.getSelectedBin();
        double binBW = 96000.0f / (float)SourceIQ.FFT_SAMPLES;
        double freq = (double)selectedBin * binBW;
        double samples = 192000.0 / freq;
        double cycles = (double)SourceIQ.FFT_SAMPLES / samples;
        return cycles;
    }

    private int getRequiredBin(int bin) {
        double binBW = 96000.0f / (float)SourceIQ.FFT_SAMPLES;
        double freq = (double)bin * binBW;
        int dc = 0;
        dc = bin < SourceIQ.FFT_SAMPLES / 2 ? 2 : -1;
        int actBin = Math.round(bin / 30) * 30 + dc;
        return actBin;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.iqSource == null) {
            return;
        }
        int selectedBin = this.iqSource.getSelectedBin();
        int x = e.getX();
        this.selection = this.getRatioPosition(0.0, this.graphWidth, x -= this.sideBorder, this.fftSamples);
        selectedBin = this.selection >= this.fftSamples / 2 ? this.selection - this.fftSamples / 2 : this.selection + this.fftSamples / 2;
        this.iqSource.setSelectedBin(selectedBin);
        if (this.rfData != null) {
            this.rfData.reset();
        }
        Config.passManager.setState(2);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

