/*
 * Decompiled with CFR 0.152.
 */
package gui;

import common.Config;
import common.DesktopApi;
import common.Log;
import gui.MainWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class HelpAbout
extends JDialog
implements ActionListener {
    private JPanel contentPane;
    private final String AMSAT = "https://www.amsat.org";
    private final String FOX = "https://www.g0kla.com/foxtelem/";
    public static final String MANUAL = "foxtelem_manual.pdf";
    public static final String LEADERBOARD = "https://www.amsat.org/tlm/";
    public static final String SOFTWARE = "https://www.g0kla.com/foxtelem/";
    JButton btnClose;

    public HelpAbout(JFrame owner, boolean modal) {
        super((Frame)owner, modal);
        this.setDefaultCloseOperation(2);
        this.setBounds(MainWindow.frame.getBounds().x + 25, MainWindow.frame.getBounds().y + 25, 800, 750);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        this.contentPane.add((Component)panel, "Center");
        panel.setLayout(new BorderLayout(0, 0));
        JPanel northPanel = new JPanel();
        panel.add((Component)northPanel, "North");
        northPanel.setLayout(new BoxLayout(northPanel, 0));
        JPanel northApanel = new JPanel();
        JPanel northBpanel = new JPanel();
        northPanel.add(northApanel);
        northPanel.add(northBpanel);
        northApanel.setLayout(new BoxLayout(northApanel, 1));
        JPanel eastPanel = new JPanel();
        panel.add((Component)eastPanel, "East");
        eastPanel.setLayout(new BoxLayout(eastPanel, 1));
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        JPanel southPanel = new JPanel();
        panel.add((Component)southPanel, "South");
        JLabel lblAmsatFoxaTelemetry = new JLabel("<html><h2>AMSAT Telemetry Decoder and Analysis</h2></html>");
        lblAmsatFoxaTelemetry.setForeground(Color.BLUE);
        northApanel.add(lblAmsatFoxaTelemetry);
        this.addLine("Version " + Config.VERSION, northApanel);
        this.addUrl("Written by ", "https://www.g0kla.com", "<b>Chris Thompson</b>", " AC2CZ", northApanel);
        this.addUrl("You can browse ", MANUAL, "the manual", " for help", northApanel);
        this.addUrl("Visit the ", SOFTWARE, "FoxTelem", " pages to learn more about Fox-1 and the Radio Amateur Satellite Corporation.", northApanel);
        this.addUrl("Please consider ", "https://www.amsat.org", "donating", " to this and future AMSAT missions", northApanel);
        this.addLine(" ", northApanel);
        this.addUrl("\nThis program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the ", "http://www.gnu.org/licenses/gpl-3.0.en.html", "<b>GNU General Public License</b>", " for more details. ", northApanel);
        this.addLine(" ", northApanel);
        this.addLine("This software also includes:", northApanel);
        this.addUrl("- Phil Karn (KA9Q) RS Decoder, ported to Java by ", "https://github.com/phlash", "<b>Phil Ashby M6IPX</b>", ", (part of the FUNcube team) released under the CC Non-Commercial Share Alike license", northApanel);
        this.addUrl("- Portions of SdrTrunk DSP code for AirSpy and RTL USB by ", "https://github.com/DSheirer/sdrtrunk", "<b>DSheirer</b>", ", released underGPL", northApanel);
        this.addUrl("- Purejavahid library developed by ", "https://github.com/nyholku/purejavahidapi", "<b>Kustaa Nyholm / SpareTimeLabs</b>", ", released under the BSD license", northApanel);
        this.addUrl("- JTransforms FFT library developed by ", "https://sites.google.com/site/piotrwendykier/software/jtransforms", "<b>Piotr Wendykier</b>", ", released under the BSD license", northApanel);
        this.addUrl("- Java DDE developed by ", "http://jdde.pretty-tools.com/", "<b>Pretty Tools</b>", ", released as free and opensource", northApanel);
        this.addUrl("- Java Predict Port by ", "https://github.com/g4dpz/predict4java", "<b>G4DPZ</b>", ", released under GPL", northApanel);
        this.addUrl("- Predict is by", "http://www.qsl.net/kd2bd/predict.html", "<b>KD2BD</b>", ", released under GPL", northApanel);
        this.addUrl("- Equidistant Map by ", "https://commons.wikimedia.org/wiki/File:World_V2.0.svg", "<b>Myvolcano</b>", ", released under CC0 1.0", northApanel);
        this.addUrl("- Color Equidistant Map by ", "https://commons.wikimedia.org/wiki/File:Equirectangular_projection_SW.jpg", "<b>Strebe</b>", ", released under CC BY-SA 3.0", northApanel);
        this.addUrl("- Icons by ", "https://icons8.com/license", "<b>ICONS8</b>", ", released under UML", northApanel);
        JScrollPane scrollPane = new JScrollPane(centerPanel, 22, 31);
        panel.add((Component)scrollPane, "Center");
        this.addLine("<html><br><b><u>The original Fox1 Engineering Team</b></u></html>", centerPanel);
        this.addLine("<html><table style='mso-cellspacing: 0in' cellspacing='0' cellpadding='2' ><tr><tbody><td><b>Jerry Buxton N0JY</b></td><td>Program Manager</td>\t\t<td><b>Tony Monteiro AA2TX (SK)</b></td><td>Original driving force</td></tr><tr> \t<td><b>Burns Fisher W2BFJ</b></td><td>Software team co-lead</td>  \t\t<td><b>Cory Abate K8SPN</b></td><td>Solar panel design</td> </tr> <tr> \t<td><b>Andrew Abken KN6ZA</b></td><td>Structure machining</td> \t\t<td><b>Bryan Baker N4DTV</b></td><td>Command and Control RF Uplink</td> </tr> <tr> <td><b>Jonathan Brandenburg KF5IDY</b></td><td>Experiment Control</td> \t\t<td><b>Arlen Cordoba</b></td><td>Flight unit structure machining</td></tr> <tr> <td><b>Don Corrington AK2S</b></td><td>Power supply</td> \t\t<td><b>Bob Davis KF4KSS</b></td><td>Mechanical, Environmental</td></tr> <tr> <td><b>Paul Finch WD5IDM</b></td><td>RF Testing</td> \t\t<td><b>Joe Fitzgerald KM1P</b></td><td>IT Support and Management</td></tr> <tr> <td><b>Bob Fitzpatrick KB5SQG</b></td><td>Transponder Testing</td> \t\t<td><b>Bdale Garbee KB0G</b></td><td>IHU and Command & Control Hardware</td></tr> <tr> <td><b>Dan Habecker W9EQ</b></td><td>RF Design and Test</td> \t\t<td><b>Bryan Hoyer K7UDR</b></td><td>Battery and EXP4</td></tr> <tr> <td><b>Dick Jansson KD1K</b></td><td>Thermal Design</td> \t\t<td><b>Mark Kanawati N4TPY</b></td><td>Solar Cells</td></tr> <tr> <td><b>Phil Karn KA9Q</b></td><td>Downlink FEC</td> \t\t<td><b>John Klingelhoeffer WB4LNM</b></td><td>RF, Command and Control</td></tr> <tr> <td><b>Taylor Klotz K4OTZ</b></td><td>Command and Control RF</td> \t\t<td><b>Dino Lorenzini KC4YMG</b></td><td>Solar Cells</td></tr> <tr> <td><b>Steve Lubbers KE8FP</b></td><td>IHU Software</td> \t\t<td><b>Mike McCann KB2GHZ</b></td><td>IHU Software</td></tr> <tr> <td><b>Brian McCarthy N1ZZD</b></td><td>Spin Detection</td> \t\t<td><b>Lou McFadin W5DID</b></td><td>Conformal coating</td></tr> <tr> <td><b>Larry Phelps K4OZS</b></td><td>Satellite construction</td> \t\t<td><b>Fred Piering WD9HNU</b></td><td>RF System Design</td></tr> <tr> <td><b>David Ping WB6DP</b></td><td>Antennae</td> \t\t<td><b>Douglas Quagliana KA2UPW</b></td><td>Telemetry and Ground station architecture</td></tr> <tr> <td><b>Bill Reed NX5R</b></td><td>Software team co-lead, DSP</td> \t\t<td><b>Brenton Salmi KB1LQD</b></td><td>Maximum Power Point Tracker</td></tr> <tr> <td><b>Bryce Salmi KB1LQC</b></td><td>Maximum Power Point Tracker</td> \t\t<td><b>Kelly Shaddrick W0RK</b></td><td>Battery Testing, Inventory control software</td></tr> <tr> <td><b>Ron Tassi N3AEA</b></td><td>Power Supply, RF</td> \t\t<td><b>Damon Wascom KC5CQW</b></td><td>PCB Construction</td></tr> <tr> <td><b>Melanie Wascom KF5TNK</b></td><td>PCB Construction</td> \t\t<td><b>Everett Yost KB9XI</b></td><td>Batteries</td></tr> <tr> <td><b>Bruce Herrick WW1M</b></td><td>L Band Uplink</td> \t\t<td><b>Dan Hubert VE9DAN</b></td><td>L Band Uplink</td></tr> <tr> <td><b>Elizabeth Schenk KC1AXX</b></td><td>L Band Uplink</td> \t\t<td><b>Dave Smith W6TE</b></td><td>L Band Uplink</td></tr> <tr> <td><b>Alfred Watts AF5VH</b></td><td>L Band Uplink</td> \t\t<td><b>Bronson Crothers N1ZAQ (SK)</b></td><td>Power Systems</td></tr> </tbody></table></html>", centerPanel);
        BufferedImage wPic = null;
        try {
            wPic = ImageIO.read(this.getClass().getResource("/images/fox.jpg"));
        }
        catch (IOException e) {
            e.printStackTrace(Log.getWriter());
        }
        if (wPic != null) {
            JLabel wIcon = new JLabel(new ImageIcon(wPic));
            northBpanel.add(wIcon);
        }
        this.btnClose = new JButton("Close");
        this.btnClose.addActionListener(this);
        southPanel.add(this.btnClose);
    }

    private void addUrl(String pre, final String url, String text, String post, JPanel panel) {
        JLabel website = new JLabel();
        website.setForeground(Color.BLACK);
        panel.add(website);
        website.setText("<html>" + pre + "<a href=\"\">" + text + "</a>" + post + "</html>");
        website.setCursor(new Cursor(12));
        website.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    DesktopApi.browse(new URI(url));
                }
                catch (URISyntaxException ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private void addLine(String text, JPanel panel) {
        JLabel lblVersion = new JLabel(text);
        lblVersion.setForeground(Color.BLACK);
        panel.add(lblVersion);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnClose) {
            this.dispose();
        }
    }
}

