/*
 * Decompiled with CFR 0.152.
 */
package gui;

import common.Config;
import common.Log;
import decoder.HighSpeedBitStream;
import decoder.SlowSpeedBitStream;
import gui.MainWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class OptionsPanel
extends JPanel
implements ItemListener {
    JCheckBox cbFtpFiles;
    JCheckBox cbFlipBits;
    JCheckBox debugFrames;
    JCheckBox debugFieldValues;
    JCheckBox debugCameraFrames;
    JCheckBox debugBits;
    JCheckBox debugBytes;
    JCheckBox debugValues;
    JCheckBox debugClock;
    JCheckBox debugRS;
    JCheckBox debugGlitches;
    JCheckBox debugAudioLevels;
    JCheckBox debugSignalFinder;
    JCheckBox debugCalcDopplerContinually;
    JCheckBox filterData;
    JCheckBox useRSfec;
    JCheckBox useRSerasures;
    JCheckBox squelchAudio;
    JCheckBox useAGC;
    JCheckBox recoverClock;
    JCheckBox realTimePlayback;
    JCheckBox useNativeFileChooser;
    JCheckBox logging;
    JLabel hsFrameLength;
    JLabel ssFrameLength;
    JLabel debugWavFile;
    JLabel debugCount;
    JCheckBox calculateBPSKCrc;

    OptionsPanel() {
        TitledBorder title = new TitledBorder(null, "Debug Options", 4, 2, null, null);
        title.setTitleFont(new Font("SansSerif", 1, 14));
        this.setBorder(title);
        this.initializeGui();
    }

    public void initializeGui() {
        this.setLayout(new BoxLayout(this, 1));
        this.logging = this.addCheckBox("Enable Logging", "Write debug information to a log file in the same folder as the decoded payloads", Log.getLogging());
        this.debugFrames = this.addCheckBox("Debug Frames", "Print information about the decoded frames into the debug log", Config.debugFrames);
        this.debugFieldValues = this.addCheckBox("Debug Fields", "Write all of the decoded fields in the payloads to the debug log", Config.debugFieldValues);
        this.debugCameraFrames = this.addCheckBox("Debug Camera Frames", "Write debug info for camera frames", Config.debugCameraFrames);
        this.debugBits = this.addCheckBox("Debug Bits", "Write very verbose debug information at the bit level", Config.debugBits);
        this.debugBytes = this.addCheckBox("Debug Bytes", "Write the hex bytes in a frame when it is decoded", Config.debugBytes);
        this.debugValues = this.addCheckBox("Debug Values", "Display Debug information for bit values on the audio screen", Config.debugValues);
        this.useRSfec = this.addCheckBox("Use RS FEC", "Use the RS Decoder", Config.useRSfec);
        this.useRSfec.setEnabled(false);
        this.useRSerasures = this.addCheckBox("Use RS Erasures", "Use erasurs in the calculation of the RS decode", Config.useRSerasures);
        this.useRSerasures.setEnabled(false);
        this.calculateBPSKCrc = this.addCheckBox("Calculate BPSK Crc", "Calculate a CRC Checksum on BPSK GOLF frames and reject if they fail", Config.calculateBPSKCrc);
        this.debugRS = this.addCheckBox("Debug RS", "Print verbose debugging info for the RS Decoder", Config.debugRS);
        this.debugGlitches = this.addCheckBox("Debug missed audio", "Write to debug log when significant audio is being missed from the soundcard", Config.debugAudioGlitches);
        this.debugAudioLevels = this.addCheckBox("Debug audio levels", "Allow more accurate measurement of the received audio levels", Config.debugAudioLevels);
        this.debugSignalFinder = this.addCheckBox("Debug Find Signal", "Write debug to show the workings of the signal finder and the pass measurements", Config.debugSignalFinder);
        this.debugCalcDopplerContinually = this.addCheckBox("Debug (Calc) Doppler Continually", "Calculate doppler continually for debugging.  Calculates first sat in the priority order.", Config.debugCalcDopplerContinually);
        this.useNativeFileChooser = this.addCheckBox("Use Native File Chooser", "Use the OS native file chooser", Config.useNativeFileChooser);
        this.ssFrameLength = new JLabel("DUV Frame Length: " + (SlowSpeedBitStream.SLOW_SPEED_SYNC_WORD_DISTANCE - 10) + " bits");
        this.hsFrameLength = new JLabel("HS Frame Length: " + (HighSpeedBitStream.FOX_HIGH_SPEED_SYNC_WORD_DISTANCE - 10) + " bits");
        this.add(this.ssFrameLength);
        this.add(this.hsFrameLength);
        if (Config.writeDebugWavFile) {
            this.debugWavFile = new JLabel("Writing to Debug Wav File");
            this.debugWavFile.setForeground(Color.RED);
            this.add(this.debugWavFile);
        }
        if (Config.DEBUG_COUNT != -1) {
            this.debugCount = new JLabel("Processing only: " + Config.DEBUG_COUNT + " windows");
            this.debugCount.setForeground(Color.RED);
            this.add(this.debugCount);
        }
        this.add(new Box.Filler(new Dimension(0, 0), new Dimension(100, 0), new Dimension(1000, 0)));
    }

    private JCheckBox addCheckBox(String name, String tip, boolean value) {
        JCheckBox checkBox = new JCheckBox(name);
        checkBox.setEnabled(true);
        checkBox.addItemListener(this);
        checkBox.setToolTipText(tip);
        this.add(checkBox);
        if (value) {
            checkBox.setSelected(true);
        } else {
            checkBox.setSelected(false);
        }
        return checkBox;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.cbFtpFiles) {
            if (e.getStateChange() == 2) {
                Config.uploadToServer = false;
            } else {
                Config.uploadToServer = true;
                if (Config.callsign.equalsIgnoreCase("NONE") || Config.callsign.length() < 3) {
                    String call;
                    Config.callsign = call = JOptionPane.showInputDialog(MainWindow.frame, "Please enter your callsign", "CALLSIGN", 3);
                    this.cbFtpFiles.setSelected(true);
                }
            }
            Config.save();
        }
        if (source == this.cbFlipBits) {
            e.getStateChange();
        }
        if (source == this.filterData) {
            Config.filterData = e.getStateChange() != 2;
            Config.save();
        }
        if (source == this.useRSfec) {
            Config.useRSfec = e.getStateChange() != 2;
            Config.save();
        }
        if (source == this.useRSerasures) {
            Config.useRSerasures = e.getStateChange() != 2;
            Config.save();
        }
        if (source == this.logging) {
            if (e.getStateChange() == 2) {
                Log.setLogging(false);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(OptionsPanel.this.getTopLevelAncestor(), "You have enabled logging, which will write debug information and erros to the log file.\nOver time the log file can grow large, especially if other debugOptions are set.  You\nshould have a manual or automatic method to rotate the log files if you intend to leave\nlogging enabled permanently.", "Logging Selected", 2);
                    }
                });
                Log.setLogging(true);
            }
            Config.save();
        }
        if (source == this.recoverClock) {
            Config.recoverClock = e.getStateChange() != 2;
            Config.save();
        }
        if (source == this.useAGC) {
            Config.useAGC = e.getStateChange() != 2;
            Config.save();
        }
        if (source == this.debugGlitches) {
            Config.debugAudioGlitches = e.getStateChange() != 2;
            Config.save();
        }
        if (source == this.debugAudioLevels) {
            Config.debugAudioLevels = e.getStateChange() != 2;
            Config.save();
        }
        if (source == this.debugSignalFinder) {
            Config.debugSignalFinder = e.getStateChange() != 2;
            Config.save();
        }
        if (source == this.debugCalcDopplerContinually) {
            Config.debugCalcDopplerContinually = e.getStateChange() != 2;
            Config.save();
        }
        if (source == this.debugRS) {
            Config.debugRS = e.getStateChange() != 2;
            Config.save();
        }
        if (source == this.useNativeFileChooser) {
            Config.useNativeFileChooser = e.getStateChange() != 2;
            Config.save();
        }
        if (source == this.debugFrames) {
            Config.debugFrames = e.getStateChange() != 2;
            Config.save();
        }
        if (source == this.debugFieldValues) {
            Config.debugFieldValues = e.getStateChange() != 2;
            Config.save();
        }
        if (source == this.debugCameraFrames) {
            Config.debugCameraFrames = e.getStateChange() != 2;
            Config.save();
        }
        if (source == this.debugClock) {
            Config.debugClock = e.getStateChange() != 2;
            Config.save();
        }
        if (source == this.debugBits) {
            if (e.getStateChange() == 2) {
                Config.debugBits = false;
            } else {
                Config.debugBits = true;
                this.debugBits.setSelected(true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(OptionsPanel.this.getTopLevelAncestor(), "Bit level debugging causes significant quantities of information to be written\nto the disk.  The decoder typically can not keep up, especially in High Speed Mode.\nUse this setting only if it's critial that you see the bit level information to troubleshoot\nan issue.", "Bit Level Debugging Selected", 2);
                    }
                });
            }
            Config.save();
        }
        if (source == this.debugBytes) {
            Config.debugBytes = e.getStateChange() != 2;
        }
        if (source == this.debugValues) {
            Config.debugValues = e.getStateChange() != 2;
            Config.save();
        }
        if (source == this.squelchAudio) {
            Config.squelchAudio = e.getStateChange() != 2;
            Config.save();
        }
        if (source == this.realTimePlayback) {
            Config.realTimePlaybackOfFile = e.getStateChange() != 2;
            Config.save();
        }
        if (source == this.calculateBPSKCrc) {
            Config.calculateBPSKCrc = e.getStateChange() != 2;
            Config.save();
        }
    }
}

