/*
 * Decompiled with CFR 0.152.
 */
package gui;

import common.Config;
import common.Log;
import decoder.Decoder;
import decoder.EyeData;
import decoder.FoxBPSK.FoxBPSKCostasDecoder;
import decoder.FoxBPSK.FoxBPSKDotProdDecoder;
import gui.graph.GraphCanvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PhasorPanel
extends JPanel
implements Runnable {
    boolean done = false;
    boolean running = true;
    Decoder decoder;
    int zeroValue;
    int[][] buffer;
    public double avgHigh;
    public double avgLow;
    public double sdHigh;
    public double sdLow;
    private int errors;
    private int erasures;
    private int clockOffset;
    double[] phasorData;
    JLabel title = new JLabel("Phasor");
    Color GRAPH_COLOR;
    int border = 5;
    public static int NUMBER_OF_BITS = 50;
    public static int SAMPLES = 120;

    public PhasorPanel() {
        this.title.setFont(new Font("SansSerif", 0, Config.graphAxisFontSize));
        this.add(this.title);
        this.GRAPH_COLOR = Color.BLUE;
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
    }

    @Override
    public void run() {
        Thread.currentThread().setName("PhasorPanel");
        this.done = false;
        this.running = true;
        Log.println("STARTING PHASOR PANEL THREAD");
        while (this.running) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: Phasor Diagram thread interrupted");
            }
            if (this.decoder != null) {
                this.phasorData = this.decoder instanceof FoxBPSKCostasDecoder ? ((FoxBPSKCostasDecoder)this.decoder).getPhasorData() : ((FoxBPSKDotProdDecoder)this.decoder).getPhasorData();
                EyeData eyeData = this.decoder.getEyeData();
                if (eyeData != null) {
                    this.errors = eyeData.lastErrorsCount;
                    this.erasures = eyeData.lastErasureCount;
                }
            }
            this.repaint();
        }
        Log.println("ENDING PHASOR PANEL THREAD");
    }

    public void updateFont() {
        this.title.setFont(new Font("SansSerif", 0, Config.graphAxisFontSize));
    }

    public void startProcessing(Decoder decoder1) {
        this.decoder = decoder1;
        this.running = true;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        int graphHeight = this.getHeight() - this.border;
        int graphWidth = this.getWidth() - this.border * 2;
        g2.drawLine(0, graphHeight - this.border, graphWidth + this.border * 2, graphHeight - this.border);
        g2.drawLine(this.border * 2, this.getHeight() - this.border, this.border * 2, this.border * 4);
        g2.drawLine(graphWidth, this.getHeight() - this.border, graphWidth, this.border * 4);
        int lastx = this.border * 2 + 1;
        int lasty = graphHeight / 2;
        int y = 0;
        int x = this.border * 2 + 1;
        g2.setColor(this.GRAPH_COLOR);
        try {
            if (this.phasorData != null) {
                int j = 0;
                while (j < this.phasorData.length / 2) {
                    x = GraphCanvas.getRatioPosition(-1.0, 1.0, this.phasorData[2 * j] * 0.4, graphWidth);
                    y = GraphCanvas.getRatioPosition(-1.0, 1.0, this.phasorData[2 * j + 1] * 0.4, graphHeight);
                    if (j == 0) {
                        lastx = x;
                        lasty = y;
                    }
                    g2.drawLine(x, y, x, y);
                    lastx = x;
                    lasty = y;
                    j += 2;
                }
            }
            g2.setColor(Color.GRAY);
            double h = graphHeight / 2 + graphHeight / 3 * this.zeroValue / 32000 + this.border;
            g2.drawLine(0, (int)h, graphWidth, (int)h);
            g2.setColor(Config.AMSAT_RED);
            g2.setColor(Color.GRAY);
            if (Config.debugValues) {
                g.drawString("Clk Offset  " + this.clockOffset, 10 + this.border, 40);
            }
            g.drawString("Errors  " + this.errors, graphWidth / 2 - 70 + this.border, graphHeight - 10);
            g.drawString("Erasures  " + this.erasures, graphWidth / 2 - 0 + this.border, graphHeight - 10);
        }
        catch (NullPointerException e) {
            Log.println("NullPointer plotting phasor:" + e);
        }
    }
}

