/*
 * Decompiled with CFR 0.152.
 */
package gui.graph;

import common.Config;
import common.Spacecraft;
import gui.graph.GraphCanvas;
import gui.graph.GraphFrame;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.text.DecimalFormat;

public class DensityPlotPanel
extends GraphCanvas {
    int[][] timePeriod = null;

    DensityPlotPanel(String t, GraphFrame gf, Spacecraft sat) {
        super(t, gf, sat);
        this.updateGraphData(gf.layout, "DensityPlotPanel.new");
    }

    private void drawLegend(int graphHeight, int graphWidth, double minValue, double maxValue, String units) {
        int verticalOffset = 60;
        int leftOffset = 15;
        int legendHeight = graphHeight - verticalOffset * 2;
        int font = 9 * Config.graphAxisFontSize / 11;
        int fonth = 12 * font / 9;
        int legendWidth = font * 4;
        int numberOfLabels = legendHeight / labelHeight;
        double[] labels = DensityPlotPanel.calcAxisInterval(minValue, maxValue, numberOfLabels, false);
        if (labels.length > 0) {
            int rows = labels.length;
            int boxHeight = legendHeight / rows;
            legendHeight = boxHeight * rows;
            this.g.setFont(new Font("SansSerif", 0, Config.graphAxisFontSize));
            this.g2.drawString("Key", this.sideBorder + graphWidth + leftOffset + 5, verticalOffset - fonth * 2);
            this.g2.drawString("(" + units + ")", this.sideBorder + graphWidth + leftOffset + 5, verticalOffset - fonth);
            this.g.setFont(new Font("SansSerif", 0, font));
            int i = 0;
            while (i < rows) {
                int shade = DensityPlotPanel.getRatioPosition(minValue, maxValue, labels[i], 255);
                if (shade > 255) {
                    shade = 255;
                }
                if (shade < 0) {
                    shade = 0;
                }
                shade = 255 - shade;
                this.g2.setColor(new Color(shade, shade, shade));
                this.g2.fillRect(this.sideBorder + graphWidth + leftOffset, verticalOffset + i * boxHeight, legendWidth, boxHeight);
                if (shade > 127) {
                    this.g2.setColor(Color.BLACK);
                } else {
                    this.g2.setColor(Color.WHITE);
                }
                this.g2.drawString("" + labels[i], this.sideBorder + graphWidth + leftOffset + 5, verticalOffset + i * boxHeight + (int)((double)boxHeight * 0.8));
                ++i;
            }
        }
    }

    @Override
    public void paintComponent(Graphics gr) {
        super.paintComponent(gr);
        if (!this.checkDataExists()) {
            return;
        }
        boolean noAzElReadings = true;
        int graphHeight = this.getHeight() - this.topBorder - this.bottomBorder;
        int graphWidth = this.getWidth() - this.sideBorder * 2;
        this.g.setFont(new Font("SansSerif", 0, Config.graphAxisFontSize));
        double maxVert = 90.0;
        double maxHor = 360.0;
        int maxVertBoxes = 45;
        int maxHorBoxes = 90;
        int boxHeight = graphHeight / maxVertBoxes;
        graphHeight = boxHeight * maxVertBoxes;
        int boxWidth = graphWidth / maxHorBoxes;
        graphWidth = boxWidth * maxHorBoxes;
        double[][] dataGrid = new double[maxVertBoxes][maxHorBoxes];
        int[][] dataGridCount = new int[maxVertBoxes][maxHorBoxes];
        double vertStep = maxVert / (double)maxVertBoxes;
        double horStep = maxHor / (double)maxHorBoxes;
        int i = 1;
        while (i < this.graphData[0][0].length) {
            double value;
            double hor;
            double vert = this.graphData2[0][0][i];
            if (vert > 0.0) {
                noAzElReadings = false;
            }
            if ((hor = this.graphData2[1][0][i]) > 0.0) {
                noAzElReadings = false;
            }
            if (Double.isNaN(value = this.graphData[0][0][i])) {
                value = 0.0;
            }
            if (this.graphData[0][1][i] != this.graphData2[1][1][i]) {
                System.err.println("ERROR!!!!!!!!!");
            }
            if (hor > maxHor) {
                hor %= maxHor;
            }
            if (vert > maxVert) {
                vert = maxVert - (vert - maxVert);
            }
            int vertBox = (int)Math.round(vert / vertStep);
            int horBox = (int)Math.round(hor / horStep);
            if (vertBox < 0) {
                vertBox = 0;
            }
            if (horBox < 0) {
                horBox = 0;
            }
            if (vertBox >= maxVertBoxes) {
                vertBox = maxVertBoxes - 1;
            }
            if (horBox >= maxHorBoxes) {
                horBox = maxHorBoxes - 1;
            }
            double[] dArray = dataGrid[vertBox];
            int n = horBox;
            dArray[n] = dArray[n] + value;
            int[] nArray = dataGridCount[vertBox];
            int n2 = horBox;
            nArray[n2] = nArray[n2] + 1;
            ++i;
        }
        double maxValue = -9.99999999E8;
        double minValue = 9.99999999E8;
        int h = 0;
        while (h < maxHorBoxes) {
            int v = 0;
            while (v < maxVertBoxes) {
                dataGrid[v][h] = dataGridCount[v][h] == 0 ? 0.0 : dataGrid[v][h] / (double)dataGridCount[v][h];
                if (dataGrid[v][h] != 0.0) {
                    if (dataGrid[v][h] > maxValue) {
                        maxValue = dataGrid[v][h];
                    }
                    if (dataGrid[v][h] < minValue) {
                        minValue = dataGrid[v][h];
                    }
                }
                ++v;
            }
            ++h;
        }
        this.drawLegend(graphHeight, graphWidth, minValue, maxValue, this.graphFrame.fieldUnits);
        this.g.setFont(new Font("SansSerif", 0, Config.graphAxisFontSize));
        this.g2.setColor(this.graphAxisColor);
        this.g2.drawLine(this.sideBorder, this.getHeight() - this.bottomBorder, this.sideBorder, this.topBorder);
        int numberOfLabels = graphHeight / labelHeight;
        double[] labels = DensityPlotPanel.calcAxisInterval(0.0, maxVert, numberOfLabels, false);
        numberOfLabels = labels.length;
        this.g2.setColor(this.graphTextColor);
        this.g2.drawString("Elevation", this.sideLabelOffset, this.topBorder - Config.graphAxisFontSize / 2);
        DecimalFormat f2 = new DecimalFormat("0");
        int v = 1;
        while (v < numberOfLabels) {
            int pos = DensityPlotPanel.getRatioPosition(0.0, maxVert, labels[v], graphHeight);
            pos = graphHeight - pos;
            String s = f2.format(labels[v]);
            this.g2.drawString(s, this.sideLabelOffset, pos + this.topBorder + Config.graphAxisFontSize / 2);
            ++v;
        }
        this.g2.setColor(this.graphAxisColor);
        int zeroPoint = graphHeight + this.topBorder;
        this.g.setFont(new Font("SansSerif", 0, Config.graphAxisFontSize));
        int titleHeight = Config.graphAxisFontSize + 10;
        if (zeroPoint < Config.graphAxisFontSize * 3) {
            titleHeight = graphHeight + this.topBorder;
        }
        this.g2.setColor(Color.BLACK);
        this.g.setFont(new Font("SansSerif", 1, Config.graphAxisFontSize + 3));
        String title = String.valueOf(this.graphFrame.displayTitle) + " vs Az El";
        this.g2.drawString(title, this.sideBorder / 2 + graphWidth / 2 - this.graphFrame.displayTitle.length() / 2 * Config.graphAxisFontSize / 2, titleHeight - Config.graphAxisFontSize / 2);
        this.g.setFont(new Font("SansSerif", 0, Config.graphAxisFontSize));
        this.g2.setColor(this.graphAxisColor);
        this.g2.drawLine(this.sideLabelOffset, zeroPoint, graphWidth + this.sideBorder, zeroPoint);
        this.g2.setColor(this.graphTextColor);
        int offset = 0;
        this.g2.drawString("Azimuth", this.sideLabelOffset, zeroPoint + 1 * Config.graphAxisFontSize + offset);
        int numberOfTimeLabels = graphWidth / (labelWidth / 2);
        double[] timelabels = DensityPlotPanel.calcAxisInterval(0.0, maxHor, numberOfTimeLabels, true);
        numberOfTimeLabels = timelabels.length;
        int h2 = 0;
        while (h2 < numberOfTimeLabels) {
            int timepos = DensityPlotPanel.getRatioPosition(0.0, maxHor, timelabels[h2], graphWidth);
            this.g2.setColor(this.graphTextColor);
            this.g2.drawString("" + (long)timelabels[h2], timepos + this.sideBorder + 2, zeroPoint + 1 * Config.graphAxisFontSize + offset);
            ++h2;
        }
        if (noAzElReadings) {
            this.g2.setColor(Color.BLACK);
            this.g2.drawString("No Azimuth and Elevation Data Available for plot", graphWidth / 2 - 50, graphHeight / 2);
            return;
        }
        int v2 = 0;
        while (v2 < maxVertBoxes) {
            int h3 = 0;
            while (h3 < maxHorBoxes) {
                int shade;
                int x = DensityPlotPanel.getRatioPosition(0.0, maxHorBoxes, h3, graphWidth) + this.sideBorder + 1;
                int y = DensityPlotPanel.getRatioPosition(0.0, maxVertBoxes, v2, graphHeight);
                double val = dataGrid[v2][h3];
                if (val == 0.0) {
                    val = -100.0;
                }
                if ((shade = DensityPlotPanel.getRatioPosition(minValue, maxValue, val, 255)) > 255) {
                    shade = 255;
                }
                if (shade < 0) {
                    shade = 0;
                }
                shade = 255 - shade;
                this.g2.setColor(new Color(shade, shade, shade));
                this.g2.fillRect(x, graphHeight - y + this.topBorder - boxHeight, boxWidth, boxHeight);
                ++h3;
            }
            ++v2;
        }
    }
}

