/*
 * Decompiled with CFR 0.152.
 */
package gui.tabs;

import common.Config;
import common.Spacecraft;
import gui.tabs.DisplayModule;
import gui.tabs.HealthTableModel;
import gui.tabs.ModuleTab;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import telemetry.BitArrayLayout;
import telemetry.FramePart;
import telemetry.LayoutLoadException;
import telemetry.payloads.PayloadMaxValues;
import telemetry.payloads.PayloadMinValues;
import telemetry.payloads.PayloadRtValues;

public abstract class HealthTab
extends ModuleTab
implements PropertyChangeListener,
MouseListener,
ItemListener,
ActionListener,
Runnable {
    public final int DEFAULT_DIVIDER_LOCATION = 5000;
    public static final String HEALTHTAB = "HEALTHTAB";
    private static final String LIVE = "Latest ";
    private static final String DISPLAY = "Historical ";
    protected String TAB_TYPE = "health";
    JPanel centerPanel;
    JLabel lblId;
    JLabel lblIdValue;
    JLabel lblMode;
    JLabel lblModeValue;
    JLabel lblLive;
    JLabel lblResets;
    JLabel lblResetsValue;
    JLabel lblMaxResets;
    JLabel lblMaxResetsValue;
    JLabel lblMinResets;
    JLabel lblMinResetsValue;
    JLabel lblUptime;
    JLabel lblUptimeValue;
    JLabel lblMaxUptime;
    JLabel lblMaxUptimeValue;
    JLabel lblMinUptime;
    JLabel lblMinUptimeValue;
    JLabel lblFramesDecoded;
    JLabel lblFramesDecodedValue;
    JLabel lblCaptureDate;
    JLabel lblCaptureDateValue;
    FramePart realTime;
    FramePart maxPayload;
    FramePart minPayload;
    BitArrayLayout rt;
    BitArrayLayout max;
    BitArrayLayout min;
    protected static final String ID = "Satellite ";
    protected static final String MODE = "  Mode: ";
    private static final String UPTIME = "  Uptime: ";
    private static final String RESETS = "  Epoch: ";
    protected static final String DECODED = "Telemetry Payloads Decoded: ";
    protected static final String CAPTURE_DATE = "Captured: ";
    public static final int DISPLAY_CURRENT = 0;
    public static final int DISPLAY_RT = 1;
    public static final int DISPLAY_MAX = 2;
    public static final int DISPLAY_MIN = 3;
    protected JPanel topPanel;
    protected JPanel topPanel1;
    protected JPanel topPanel2;
    int splitPaneHeight = 0;
    JSplitPane splitPane;
    HealthTableModel rtTableModel;
    HealthTableModel minTableModel;
    HealthTableModel maxTableModel;
    JTable rtTable;
    JTable maxTable;
    JTable minTable;
    JScrollPane rtScrollPane;
    JScrollPane maxScrollPane;
    JScrollPane minScrollPane;
    JRadioButton currentBut;
    JRadioButton rtBut;
    JRadioButton maxBut;
    JRadioButton minBut;
    protected int healthTableToDisplay;
    int total;
    public static final int NO_ROW_SELECTED = -1;

    public HealthTab(Spacecraft spacecraft, int displayType) throws LayoutLoadException {
        this.fox = spacecraft;
        this.foxId = this.fox.foxId;
        this.setLayout(new BorderLayout(0, 0));
        this.topPanel = new JPanel();
        this.topPanel1 = new JPanel();
        this.topPanel2 = new JPanel();
        this.topPanel.setMinimumSize(new Dimension(Config.displayModuleFontSize * 10 / 11, 50));
        this.add((Component)this.topPanel, "North");
        this.topPanel.setLayout(new BorderLayout(0, 0));
        this.topPanel.add((Component)this.topPanel1, "North");
        this.topPanel.add((Component)this.topPanel2, "South");
        this.topPanel1.setLayout(new BoxLayout(this.topPanel1, 0));
        this.topPanel2.setLayout(new BoxLayout(this.topPanel2, 0));
        this.lblId = new JLabel(ID);
        this.lblId.setFont(new Font("SansSerif", 1, Config.displayModuleFontSize * 14 / 11));
        this.lblId.setForeground(this.textLblColor);
        this.topPanel1.add(this.lblId);
        this.lblIdValue = new JLabel();
        this.lblIdValue.setFont(new Font("SansSerif", 1, Config.displayModuleFontSize * 14 / 11));
        this.lblIdValue.setForeground(this.textColor);
        this.topPanel1.add(this.lblIdValue);
        this.lblLive = new JLabel(LIVE);
        this.lblLive.setFont(new Font("SansSerif", 1, Config.displayModuleFontSize * 14 / 11));
        this.lblLive.setForeground(Config.AMSAT_RED);
        this.topPanel2.add(this.lblLive);
        this.centerPanel = new JPanel();
        this.add((Component)this.centerPanel, "Center");
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 1));
        this.centerPanel.setBorder(new SoftBevelBorder(1, null, null, null, null));
        this.centerPanel.setBackground(Color.DARK_GRAY);
        JPanel healthPanel = new JPanel();
        healthPanel.setLayout(new BoxLayout(healthPanel, 0));
        this.initDisplayHalves(this.centerPanel);
        this.splitPane = new JSplitPane(0, this.centerPanel, healthPanel);
        this.splitPane.setOneTouchExpandable(false);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.addPropertyChangeListener("dividerLocation", this);
        Dimension minimumSize = new Dimension(100, 50);
        healthPanel.setMinimumSize(minimumSize);
        this.centerPanel.setMinimumSize(minimumSize);
        this.add((Component)this.splitPane, "Center");
        this.bottomPanel = new JPanel();
        this.add((Component)this.bottomPanel, "South");
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 0));
        this.addBottomFilter();
        this.lblCaptureDate = new JLabel(CAPTURE_DATE);
        this.lblCaptureDate.setFont(new Font("SansSerif", 1, Config.displayModuleFontSize * 10 / 11));
        this.lblCaptureDate.setBorder(new EmptyBorder(5, 2, 5, 10));
        this.lblCaptureDate.setForeground(this.textLblColor);
        this.bottomPanel.add(this.lblCaptureDate);
        this.rt = null;
        if (this.fox.hasFOXDB_V3) {
            this.rt = displayType == 16 ? this.fox.getLayoutByType("WOD") : this.fox.getLayoutByType("RT");
            this.max = this.fox.getLayoutByType("MAX");
            this.min = this.fox.getLayoutByType("MIN");
        } else {
            this.rt = displayType == 16 ? this.fox.getLayoutByName("wodtelemetry") : this.fox.getLayoutByName("rttelemetry");
            this.max = this.fox.getLayoutByName("maxtelemetry");
            this.min = this.fox.getLayoutByName("mintelemetry");
        }
        if (this.rt == null) {
            throw new LayoutLoadException("MISSING PAYLOAD DEFINITION: The spacecraft file for satellite " + this.fox.user_display_name + " is missing the payload definition for " + "realtime\n  Remove this satellite or add/fix the payload file");
        }
        if (this.max == null) {
            throw new LayoutLoadException("MISSING PAYLOAD DEFINITION: The spacecraft file for satellite " + this.fox.user_display_name + " is missing the payload definition for " + "max\n  Remove this satellite or add/fix the payload file");
        }
        if (this.min == null) {
            throw new LayoutLoadException("MISSING PAYLOAD DEFINITION: The spacecraft file for satellite " + this.fox.user_display_name + " is missing the payload definition for " + "min\n  Remove this satellite or add/fix the payload file");
        }
        this.analyzeModules(this.rt, this.max, this.min, displayType);
        this.rtTableModel = new HealthTableModel(this.rt);
        this.rtTable = new JTable(this.rtTableModel);
        this.rtScrollPane = this.addTable(this.rtTable, this.rtTableModel, healthPanel, this.rt);
        this.maxTableModel = new HealthTableModel(this.max);
        this.maxTable = new JTable(this.maxTableModel);
        this.maxScrollPane = this.addTable(this.maxTable, this.maxTableModel, healthPanel, this.max);
        this.minTableModel = new HealthTableModel(this.min);
        this.minTable = new JTable(this.minTableModel);
        this.minScrollPane = this.addTable(this.minTable, this.minTableModel, healthPanel, this.min);
        this.displayTable();
        String PREV = "prev";
        String NEXT = "next";
        InputMap inMap = this.rtTable.getInputMap(1);
        inMap.put(KeyStroke.getKeyStroke("UP"), PREV);
        inMap.put(KeyStroke.getKeyStroke("DOWN"), NEXT);
        ActionMap actMap = this.rtTable.getActionMap();
        actMap.put(PREV, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = HealthTab.this.rtTable.getSelectedRow();
                if (row > 0) {
                    HealthTab.this.displayRow(HealthTab.this.rtTable, -1, row - 1);
                    HealthTab.this.scrollToRow(HealthTab.this.rtTable, row - 1);
                }
            }
        });
        actMap.put(NEXT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = HealthTab.this.rtTable.getSelectedRow();
                if (row < HealthTab.this.rtTable.getRowCount() - 1) {
                    HealthTab.this.displayRow(HealthTab.this.rtTable, -1, row + 1);
                    HealthTab.this.scrollToRow(HealthTab.this.rtTable, row + 1);
                }
            }
        });
        InputMap inMapMax = this.maxTable.getInputMap(1);
        inMapMax.put(KeyStroke.getKeyStroke("UP"), PREV);
        inMapMax.put(KeyStroke.getKeyStroke("DOWN"), NEXT);
        ActionMap actMapMax = this.maxTable.getActionMap();
        actMapMax.put(PREV, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = HealthTab.this.maxTable.getSelectedRow();
                if (row > 0) {
                    HealthTab.this.displayRow(HealthTab.this.maxTable, -1, row - 1);
                    HealthTab.this.scrollToRow(HealthTab.this.maxTable, row - 1);
                }
            }
        });
        actMapMax.put(NEXT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = HealthTab.this.maxTable.getSelectedRow();
                if (row < HealthTab.this.maxTable.getRowCount() - 1) {
                    HealthTab.this.displayRow(HealthTab.this.maxTable, -1, row + 1);
                    HealthTab.this.scrollToRow(HealthTab.this.maxTable, row + 1);
                }
            }
        });
        InputMap inMapMin = this.minTable.getInputMap(1);
        inMapMin.put(KeyStroke.getKeyStroke("UP"), PREV);
        inMapMin.put(KeyStroke.getKeyStroke("DOWN"), NEXT);
        ActionMap actMapMin = this.minTable.getActionMap();
        actMapMin.put(PREV, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = HealthTab.this.minTable.getSelectedRow();
                if (row > 0) {
                    HealthTab.this.displayRow(HealthTab.this.minTable, -1, row - 1);
                    HealthTab.this.scrollToRow(HealthTab.this.minTable, row - 1);
                }
            }
        });
        actMapMin.put(NEXT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = HealthTab.this.minTable.getSelectedRow();
                if (row < HealthTab.this.minTable.getRowCount() - 1) {
                    HealthTab.this.displayRow(HealthTab.this.minTable, -1, row + 1);
                    HealthTab.this.scrollToRow(HealthTab.this.minTable, row + 1);
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this.healthTableToDisplay == 0) {
            this.hideTables(true);
        }
        this.showLiveOrHistorical();
        this.splitPaneHeight = this.splitPane.getDividerLocation();
        Config.saveGraphIntParam(this.fox.getIdString(), 99, 1, HEALTHTAB, String.valueOf(this.TAB_TYPE) + "splitPaneHeight", this.splitPaneHeight);
    }

    protected void hideTables(boolean hide) {
        if (hide) {
            this.splitPane.setDividerLocation(5000);
        } else {
            this.splitPaneHeight = Config.loadGraphIntValue(this.fox.getIdString(), 99, 1, HEALTHTAB, String.valueOf(this.TAB_TYPE) + "splitPaneHeight");
            if (this.splitPaneHeight == 0) {
                this.splitPaneHeight = this.splitPane.getMaximumDividerLocation() / 2;
            }
            if (this.splitPaneHeight >= this.splitPane.getMaximumDividerLocation()) {
                this.splitPaneHeight = this.splitPane.getMaximumDividerLocation() / 2;
            }
            this.splitPane.setDividerLocation(this.splitPaneHeight);
        }
    }

    private void scrollToRow(JTable table, int row) {
        Rectangle cellRect = table.getCellRect(row, 0, false);
        if (cellRect != null) {
            table.scrollRectToVisible(cellRect);
        }
    }

    protected void displayTable() {
        if (this.healthTableToDisplay == 0) {
            this.rtScrollPane.setVisible(false);
            this.maxScrollPane.setVisible(false);
            this.minScrollPane.setVisible(false);
        } else if (this.healthTableToDisplay == 1) {
            this.rtScrollPane.setVisible(true);
            this.maxScrollPane.setVisible(false);
            this.minScrollPane.setVisible(false);
        } else if (this.healthTableToDisplay == 2) {
            this.rtScrollPane.setVisible(false);
            this.maxScrollPane.setVisible(true);
            this.minScrollPane.setVisible(false);
        } else {
            this.rtScrollPane.setVisible(false);
            this.maxScrollPane.setVisible(false);
            this.minScrollPane.setVisible(true);
        }
    }

    private JScrollPane addTable(JTable table, HealthTableModel healthTableModel, JPanel centerPanel, BitArrayLayout rt) {
        table.setAutoCreateRowSorter(true);
        table.addMouseListener(this);
        this.scrollPane = new JScrollPane(table, 22, 32);
        table.setFillsViewportHeight(true);
        table.setAutoResizeMode(0);
        centerPanel.add(this.scrollPane);
        return this.scrollPane;
    }

    protected JLabel addReset(JPanel topPanel2, String type) {
        JLabel lblResets = new JLabel(String.valueOf(type) + " " + RESETS);
        lblResets.setFont(new Font("SansSerif", 1, Config.displayModuleFontSize * 14 / 11));
        lblResets.setForeground(this.textLblColor);
        topPanel2.add(lblResets);
        JLabel lblResetsValue = new JLabel();
        lblResetsValue.setFont(new Font("SansSerif", 1, Config.displayModuleFontSize * 14 / 11));
        lblResetsValue.setForeground(this.textColor);
        topPanel2.add(lblResetsValue);
        return lblResetsValue;
    }

    protected JLabel addUptime(JPanel topPanel2, String type) {
        return this.addTopPanelValue(topPanel2, UPTIME);
    }

    protected JLabel addTopPanelValue(JPanel topPanel2, String name) {
        int fonth = Config.displayModuleFontSize * 14 / 11;
        JLabel lblUptime = new JLabel(name);
        lblUptime.setFont(new Font("SansSerif", 1, Config.displayModuleFontSize * 14 / 11));
        lblUptime.setForeground(this.textLblColor);
        topPanel2.add(lblUptime);
        JLabel lblUptimeValue = new JLabel();
        lblUptimeValue.setFont(new Font("SansSerif", 1, fonth));
        lblUptimeValue.setMinimumSize(new Dimension(1600, fonth));
        lblUptimeValue.setMaximumSize(new Dimension(1600, fonth));
        lblUptimeValue.setForeground(this.textColor);
        topPanel2.add(lblUptimeValue);
        return lblUptimeValue;
    }

    private void displayUptime(JLabel lblUptimeValue, long u) {
        lblUptimeValue.setText("" + u);
    }

    private void displayResets(JLabel lblResetsValue, int u) {
        lblResetsValue.setText("" + u);
    }

    protected void displayMode(int newMode) {
        String mode = Spacecraft.modeNames[1];
        if (this.fox.hasModeInHeader) {
            mode = Spacecraft.getModeString(newMode);
        } else {
            FramePart radPayload = Config.payloadStore.getLatestRad(this.foxId);
            mode = Spacecraft.determineModeString(this.fox, (PayloadRtValues)this.realTime, (PayloadMaxValues)this.maxPayload, (PayloadMinValues)this.minPayload, radPayload);
        }
        this.displayMode(mode);
    }

    protected void displayMode(String mode) {
        if (this.lblModeValue != null) {
            this.lblModeValue.setText(mode);
        }
    }

    private void displayId(int u) {
        String id = "??";
        id = String.valueOf(this.fox.toString()) + "(" + Spacecraft.models[this.fox.model] + ")";
        this.lblIdValue.setText(id);
    }

    protected void displayFramesDecoded(int u) {
        this.total = u;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                HealthTab.this.lblFramesDecodedValue.setText("" + HealthTab.this.total);
                HealthTab.this.lblFramesDecodedValue.invalidate();
                HealthTab.this.topPanel.validate();
            }
        });
    }

    private void displayCaptureDate(String u) {
        Date result = null;
        String reportDate = null;
        try {
            FramePart.fileDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            result = FramePart.fileDateFormat.parse(u);
            if (this.showUTCtime) {
                FramePart.reportDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            } else {
                FramePart.reportDateFormat.setTimeZone(TimeZone.getDefault());
            }
            reportDate = FramePart.reportDateFormat.format(result);
        }
        catch (ParseException e) {
            reportDate = "unknown";
        }
        catch (NumberFormatException e) {
            reportDate = "unknown";
        }
        catch (ArrayIndexOutOfBoundsException e) {
            reportDate = "unknown";
        }
        this.lblCaptureDate.setText(CAPTURE_DATE + reportDate);
    }

    public void updateTabRT(FramePart realTime2, boolean refreshTable) {
        DisplayModule mod;
        if (!Config.payloadStore.initialized()) {
            return;
        }
        this.realTime = realTime2;
        DisplayModule[] displayModuleArray = this.topModules;
        int n = this.topModules.length;
        int n2 = 0;
        while (n2 < n) {
            mod = displayModuleArray[n2];
            if (mod != null) {
                mod.updateRtValues(realTime2);
            }
            ++n2;
        }
        if (this.bottomModules != null) {
            displayModuleArray = this.bottomModules;
            n = this.bottomModules.length;
            n2 = 0;
            while (n2 < n) {
                mod = displayModuleArray[n2];
                if (mod != null) {
                    mod.updateRtValues(realTime2);
                }
                ++n2;
            }
        }
        this.displayId(realTime2.getFoxId());
        this.displayUptime(this.lblUptimeValue, realTime2.getUptime());
        this.displayResets(this.lblResetsValue, realTime2.getResets());
        this.displayCaptureDate(realTime2.getCaptureDate());
        if (refreshTable) {
            this.parseFrames();
        }
        this.showLiveOrHistorical();
        this.displayMode(realTime2.newMode);
    }

    protected void showLiveOrHistorical() {
        if (this.healthTableToDisplay == 0) {
            this.lblLive.setForeground(Color.BLACK);
            this.lblLive.setText(LIVE);
        } else {
            this.lblLive.setForeground(Config.AMSAT_RED);
            this.lblLive.setText(DISPLAY);
        }
    }

    protected void parseTelemetry(String[][] data) {
        long[][] tableData = new long[data.length][data[0].length];
        int i = 0;
        while (i < data.length) {
            tableData[data.length - i - 1][0] = Long.parseLong(data[i][0]);
            tableData[data.length - i - 1][1] = Long.parseLong(data[i][1]);
            int j = 2;
            while (j < data[0].length) {
                if (data[i][j] != null) {
                    tableData[data.length - i - 1][j] = Config.displayRawRadData ? Long.parseLong(data[i][j]) : Long.parseLong(data[i][j]);
                }
                ++j;
            }
            ++i;
        }
        if (data.length > 0) {
            if (this.healthTableToDisplay == 1) {
                this.rtTableModel.setData(tableData);
            } else if (this.healthTableToDisplay == 2) {
                this.maxTableModel.setData(tableData);
            } else {
                this.minTableModel.setData(tableData);
            }
        }
    }

    public void updateTabMax(FramePart maxPayload2) {
        DisplayModule mod;
        if (!Config.payloadStore.initialized()) {
            return;
        }
        this.maxPayload = maxPayload2;
        DisplayModule[] displayModuleArray = this.topModules;
        int n = this.topModules.length;
        int n2 = 0;
        while (n2 < n) {
            mod = displayModuleArray[n2];
            if (mod != null) {
                mod.updateMaxValues(maxPayload2);
            }
            ++n2;
        }
        if (this.bottomModules != null) {
            displayModuleArray = this.bottomModules;
            n = this.bottomModules.length;
            n2 = 0;
            while (n2 < n) {
                mod = displayModuleArray[n2];
                if (mod != null) {
                    mod.updateMaxValues(maxPayload2);
                }
                ++n2;
            }
        }
        this.displayId(maxPayload2.getFoxId());
        this.displayUptime(this.lblMaxUptimeValue, maxPayload2.getUptime());
        this.displayResets(this.lblMaxResetsValue, maxPayload2.getResets());
        this.displayCaptureDate(maxPayload2.getCaptureDate());
        this.displayMode(maxPayload2.newMode);
        this.displayFramesDecoded(Config.payloadStore.getNumberOfTelemFrames(this.foxId));
    }

    public void updateTabMin(FramePart minPayload2) {
        DisplayModule mod;
        if (!Config.payloadStore.initialized()) {
            return;
        }
        this.minPayload = minPayload2;
        DisplayModule[] displayModuleArray = this.topModules;
        int n = this.topModules.length;
        int n2 = 0;
        while (n2 < n) {
            mod = displayModuleArray[n2];
            if (mod != null) {
                mod.updateMinValues(minPayload2);
            }
            ++n2;
        }
        if (this.bottomModules != null) {
            displayModuleArray = this.bottomModules;
            n = this.bottomModules.length;
            n2 = 0;
            while (n2 < n) {
                mod = displayModuleArray[n2];
                if (mod != null) {
                    mod.updateMinValues(minPayload2);
                }
                ++n2;
            }
        }
        this.displayId(minPayload2.getFoxId());
        this.displayUptime(this.lblMinUptimeValue, minPayload2.getUptime());
        this.displayResets(this.lblMinResetsValue, minPayload2.getResets());
        this.displayCaptureDate(minPayload2.getCaptureDate());
        this.displayMode(minPayload2.newMode);
        this.displayFramesDecoded(Config.payloadStore.getNumberOfTelemFrames(this.foxId));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        ItemSelectable source = e.getItemSelectable();
        if (source == this.showRawValues) {
            Config.displayRawValues = e.getStateChange() != 2;
            Config.save();
            if (this.realTime != null) {
                this.updateTabRT(this.realTime, false);
            }
            if (this.maxPayload != null) {
                this.updateTabMax(this.maxPayload);
            }
            if (this.minPayload != null) {
                this.updateTabMin(this.minPayload);
            }
        }
        if (source == this.cbUTC) {
            if (this.realTime != null) {
                this.updateTabRT(this.realTime, false);
            }
            if (this.maxPayload != null) {
                this.updateTabMax(this.maxPayload);
            }
            if (this.minPayload != null) {
                this.updateTabMin(this.minPayload);
            }
        }
    }

    protected abstract void displayRow(JTable var1, int var2, int var3);

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int fromRow = -1;
        JTable table = this.healthTableToDisplay == 1 ? this.rtTable : (this.healthTableToDisplay == 2 ? this.maxTable : this.minTable);
        int row = table.rowAtPoint(e.getPoint());
        int col = table.columnAtPoint(e.getPoint());
        if (e.isShiftDown()) {
            fromRow = table.getSelectedRow();
            int n = table.getSelectedRowCount();
            if (row == fromRow) {
                fromRow = fromRow + n - 1;
            }
        }
        if (row >= 0 && col >= 0) {
            this.displayRow(table, fromRow, row);
        }
    }
}

