/*
 * Decompiled with CFR 0.152.
 */
package gui.tabs;

import common.Config;
import common.Log;
import common.Spacecraft;
import gui.MainWindow;
import gui.tabs.HealthTab;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import telemetry.LayoutLoadException;

public class HealthTabRt
extends HealthTab {
    private static final long serialVersionUID = 1L;

    public HealthTabRt(Spacecraft spacecraft) throws LayoutLoadException {
        super(spacecraft, 3);
        this.TAB_TYPE = "health";
        this.healthTableToDisplay = Config.loadGraphIntValue(this.fox.getIdString(), 99, 1, "HEALTHTAB", String.valueOf(this.TAB_TYPE) + "healthTableToDisplay");
        this.splitPaneHeight = Config.loadGraphIntValue(this.fox.getIdString(), 99, 1, "HEALTHTAB", String.valueOf(this.TAB_TYPE) + "splitPaneHeight");
        if (this.healthTableToDisplay == 0) {
            this.hideTables(true);
        } else if (this.splitPaneHeight != 0) {
            this.splitPane.setDividerLocation(this.splitPaneHeight);
        } else {
            this.splitPane.setDividerLocation(5000);
        }
        this.showLiveOrHistorical();
        this.lblMode = new JLabel("  Mode: ");
        this.lblMode.setFont(new Font("SansSerif", 1, Config.displayModuleFontSize * 14 / 11));
        this.lblMode.setForeground(this.textLblColor);
        this.topPanel1.add(this.lblMode);
        this.lblModeValue = new JLabel();
        this.lblModeValue.setFont(new Font("SansSerif", 1, Config.displayModuleFontSize * 14 / 11));
        this.lblModeValue.setForeground(this.textColor);
        this.topPanel1.add(this.lblModeValue);
        this.topPanel1.add(new Box.Filler(new Dimension(14, this.fonth), new Dimension(1600, this.fonth), new Dimension(1600, this.fonth)));
        this.lblFramesDecoded = new JLabel("Telemetry Payloads Decoded: ");
        this.lblFramesDecoded.setFont(new Font("SansSerif", 1, Config.displayModuleFontSize * 14 / 11));
        this.lblFramesDecoded.setBorder(new EmptyBorder(5, 2, 5, 5));
        this.lblFramesDecoded.setForeground(this.textLblColor);
        this.topPanel1.add(this.lblFramesDecoded);
        this.lblFramesDecodedValue = new JLabel();
        this.lblFramesDecodedValue.setFont(new Font("SansSerif", 1, Config.displayModuleFontSize * 14 / 11));
        this.lblFramesDecodedValue.setBorder(new EmptyBorder(5, 2, 5, 5));
        this.lblFramesDecodedValue.setForeground(this.textColor);
        this.topPanel1.add(this.lblFramesDecodedValue);
        this.lblResetsValue = this.addReset(this.topPanel2, "Realtime:");
        this.lblUptimeValue = this.addUptime(this.topPanel2, "");
        this.lblMaxResetsValue = this.addReset(this.topPanel2, "Max:");
        this.lblMaxUptimeValue = this.addUptime(this.topPanel2, "");
        this.lblMinResetsValue = this.addReset(this.topPanel2, "Min:");
        this.lblMinUptimeValue = this.addUptime(this.topPanel2, "");
    }

    @Override
    protected void addBottomFilter() {
        this.currentBut = new JRadioButton("Current");
        this.bottomPanel.add(this.currentBut);
        this.currentBut.addActionListener(this);
        this.rtBut = new JRadioButton("RT");
        this.bottomPanel.add(this.rtBut);
        this.rtBut.addActionListener(this);
        this.maxBut = new JRadioButton("MAX");
        this.bottomPanel.add(this.maxBut);
        this.maxBut.addActionListener(this);
        this.minBut = new JRadioButton("MIN");
        this.bottomPanel.add(this.minBut);
        this.minBut.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.currentBut);
        group.add(this.rtBut);
        group.add(this.maxBut);
        group.add(this.minBut);
        this.healthTableToDisplay = Config.loadGraphIntValue(this.fox.getIdString(), 99, 1, "HEALTHTAB", "healthhealthTableToDisplay");
        if (this.healthTableToDisplay == 0) {
            this.currentBut.setSelected(true);
        } else if (this.healthTableToDisplay == 1) {
            this.rtBut.setSelected(true);
        } else if (this.healthTableToDisplay == 2) {
            this.maxBut.setSelected(true);
        } else {
            this.minBut.setSelected(true);
        }
        super.addBottomFilter();
    }

    @Override
    protected void displayRow(JTable rtTable, int fromRow, int row) {
        long reset_l = (Long)rtTable.getValueAt(row, 0);
        long uptime = (Long)rtTable.getValueAt(row, 1);
        int reset = (int)reset_l;
        this.maxPayload = Config.payloadStore.getFramePart(this.foxId, reset, uptime, this.max.name, true);
        if (this.maxPayload != null) {
            this.updateTabMax(this.maxPayload);
        }
        this.minPayload = Config.payloadStore.getFramePart(this.foxId, reset, uptime, this.min.name, true);
        if (this.minPayload != null) {
            this.updateTabMin(this.minPayload);
        }
        this.realTime = Config.payloadStore.getFramePart(this.foxId, reset, uptime, this.rt.name, false);
        if (this.realTime != null) {
            this.updateTabRT(this.realTime, false);
        }
        if (fromRow == -1) {
            fromRow = row;
        }
        if (fromRow <= row) {
            rtTable.setRowSelectionInterval(fromRow, row);
        } else {
            rtTable.setRowSelectionInterval(row, fromRow);
        }
    }

    @Override
    public void parseFrames() {
        if (Config.payloadStore == null) {
            return;
        }
        String[][] data = null;
        if (this.healthTableToDisplay == 1) {
            data = Config.payloadStore.getTableData(this.SAMPLES, this.fox.foxId, this.START_RESET, this.START_UPTIME, true, this.reverse, this.rt.name);
        }
        if (this.healthTableToDisplay == 2) {
            data = Config.payloadStore.getTableData(this.SAMPLES, this.fox.foxId, this.START_RESET, this.START_UPTIME, true, this.reverse, this.max.name);
        }
        if (this.healthTableToDisplay == 3) {
            data = Config.payloadStore.getTableData(this.SAMPLES, this.fox.foxId, this.START_RESET, this.START_UPTIME, true, this.reverse, this.min.name);
        }
        this.displayTable();
        if (data != null && data.length > 0) {
            this.parseTelemetry(data);
            MainWindow.frame.repaint();
        }
    }

    @Override
    public void run() {
        int currentRtFrames = 0;
        int currentMaxFrames = 0;
        int currentMinFrames = 0;
        Thread.currentThread().setName("HealthTabRt:" + this.foxId);
        this.running = true;
        this.done = false;
        boolean justStarted = true;
        while (this.running) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: HealthTab thread interrupted");
                e.printStackTrace(Log.getWriter());
            }
            if (Config.displayRawValues != this.showRawValues.isSelected()) {
                this.showRawValues.setSelected(Config.displayRawValues);
            }
            if (this.foxId == 0 || !Config.payloadStore.initialized()) continue;
            int frames = Config.payloadStore.getNumberOfFrames(this.foxId, this.max.name);
            if (frames != currentMaxFrames) {
                currentMaxFrames = frames;
                this.maxPayload = Config.payloadStore.getLatestMax(this.foxId);
                if (this.maxPayload != null && (this.healthTableToDisplay == 0 || justStarted)) {
                    this.updateTabMax(this.maxPayload);
                }
                Config.payloadStore.setUpdated(this.foxId, this.max.name, false);
                this.displayFramesDecoded(Config.payloadStore.getNumberOfTelemFrames(this.foxId));
                MainWindow.setTotalDecodes();
            }
            if ((frames = Config.payloadStore.getNumberOfFrames(this.foxId, this.min.name)) != currentMinFrames) {
                currentMinFrames = frames;
                this.minPayload = Config.payloadStore.getLatestMin(this.foxId);
                if (this.minPayload != null && (this.healthTableToDisplay == 0 || justStarted)) {
                    this.updateTabMin(this.minPayload);
                }
                this.displayFramesDecoded(Config.payloadStore.getNumberOfTelemFrames(this.foxId));
                Config.payloadStore.setUpdated(this.foxId, this.min.name, false);
                MainWindow.setTotalDecodes();
            }
            if ((frames = Config.payloadStore.getNumberOfFrames(this.foxId, this.rt.name)) != currentRtFrames) {
                currentRtFrames = frames;
                this.realTime = Config.payloadStore.getLatestRt(this.foxId);
                if (this.realTime != null) {
                    if (this.healthTableToDisplay == 0) {
                        this.updateTabRT(this.realTime, true);
                    } else {
                        this.parseFrames();
                        if (justStarted) {
                            this.updateTabRT(this.realTime, true);
                        }
                    }
                    this.displayFramesDecoded(Config.payloadStore.getNumberOfTelemFrames(this.foxId));
                }
                Config.payloadStore.setUpdated(this.foxId, this.rt.name, false);
                MainWindow.setTotalDecodes();
                if (justStarted) {
                    this.openGraphs();
                    justStarted = false;
                }
                MainWindow.frame.repaint();
            }
            if (this.healthTableToDisplay != 0 || !this.fox.hasModeInHeader) continue;
            this.displayMode(this.fox.determineModeFromHeader());
        }
        this.done = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.rtBut) {
            this.healthTableToDisplay = 1;
            this.hideTables(false);
            Config.saveGraphIntParam(this.fox.getIdString(), 99, 1, "HEALTHTAB", "healthhealthTableToDisplay", this.healthTableToDisplay);
            this.parseFrames();
        }
        if (e.getSource() == this.maxBut) {
            this.healthTableToDisplay = 2;
            this.hideTables(false);
            Config.saveGraphIntParam(this.fox.getIdString(), 99, 1, "HEALTHTAB", "healthhealthTableToDisplay", this.healthTableToDisplay);
            this.parseFrames();
        }
        if (e.getSource() == this.minBut) {
            this.healthTableToDisplay = 3;
            this.hideTables(false);
            Config.saveGraphIntParam(this.fox.getIdString(), 99, 1, "HEALTHTAB", "healthhealthTableToDisplay", this.healthTableToDisplay);
            this.parseFrames();
        }
        if (e.getSource() == this.currentBut) {
            this.healthTableToDisplay = 0;
            this.hideTables(true);
            Config.saveGraphIntParam(this.fox.getIdString(), 99, 1, "HEALTHTAB", "healthhealthTableToDisplay", this.healthTableToDisplay);
            if (Config.payloadStore == null) {
                return;
            }
            this.realTime = Config.payloadStore.getLatestRt(this.foxId);
            this.minPayload = Config.payloadStore.getLatestMin(this.foxId);
            this.maxPayload = Config.payloadStore.getLatestMax(this.foxId);
            if (this.realTime != null) {
                this.updateTabRT(this.realTime, false);
            }
            if (this.maxPayload != null) {
                this.updateTabMax(this.maxPayload);
            }
            if (this.minPayload != null) {
                this.updateTabMin(this.minPayload);
            }
            this.parseFrames();
        }
        this.showLiveOrHistorical();
    }
}

