/*
 * Decompiled with CFR 0.152.
 */
package gui.tabs;

import common.Config;
import common.FoxTime;
import common.Log;
import common.Spacecraft;
import gui.tabs.DisplayModule;
import gui.tabs.FoxTelemTab;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import telemetry.BitArrayLayout;
import telemetry.LayoutLoadException;

public abstract class ModuleTab
extends FoxTelemTab
implements FocusListener,
ActionListener,
ItemListener {
    public static final int SHOW_LIVE = 0;
    public static final int SHOW_RANGE = 2;
    public static final int SHOW_NEXT = 1;
    public int showLatest = 0;
    public static final String LIVE_TEXT = "Last";
    public static final String RANGE_TEXT = "Range";
    public static final String NEXT_TEXT = "Next";
    public static String NOW = "now";
    public static String YESTERDAY = "yesterday";
    public static String LAUNCH = "launch";
    public String dateFormatsToolTip = "formats:YYYYMMDD HHMMSS, YYYY/MM/DD HH:MM:SS, dd MMM yy HH:mm:ss, now, yesterday, launch";
    public boolean reverse = true;
    public int MIN_SAMPLES = 1;
    public static int DEFAULT_SAMPLES = 180;
    public int SAMPLES = DEFAULT_SAMPLES;
    public static long DEFAULT_START_UPTIME = 0L;
    public static int DEFAULT_START_RESET = 0;
    public long START_UPTIME = DEFAULT_START_UPTIME;
    public int START_RESET = DEFAULT_START_RESET;
    public int END_RESET = DEFAULT_START_RESET;
    public long END_UPTIME = DEFAULT_START_UPTIME;
    public static String DEFAULT_START_UTC = NOW;
    public static String DEFAULT_END_UTC = NOW;
    public String START_UTC = DEFAULT_START_UTC;
    public String END_UTC = DEFAULT_END_UTC;
    public static final int MAX_SAMPLES = 99999;
    protected int fonth = 0;
    private JLabel lblFromUptime;
    private JTextField textFromUptime;
    JLabel lblSamplePeriod;
    protected JTextField txtSamplePeriod;
    private JLabel lblFromReset;
    private JTextField textFromReset;
    private JLabel lblToReset;
    private JLabel lblToUptime;
    private JTextField textToReset;
    private JTextField textToUptime;
    JLabel lblFromUTC;
    JLabel lblToUTC;
    public static final String FROM_RESET = "From Epoch";
    public static final String BEFORE_RESET = " before Epoch";
    public static final String FROM_UTC = "From UTC";
    public static final String BEFORE_UTC = " before UTC";
    private JTextField textFromUtc;
    private JTextField textToUtc;
    protected JCheckBox cbUTC;
    JPanel footerPanel2uptime = new JPanel();
    JPanel footerPanel2utc = new JPanel();
    public boolean showUTCtime = false;
    protected Spacecraft fox;
    protected int foxId = 0;
    protected DisplayModule[] topModules;
    protected DisplayModule[] bottomModules;
    protected JPanel topHalf;
    protected JPanel bottomHalf;
    JScrollPane scrollPane;
    protected JPanel bottomPanel;
    JButton btnLatest;
    protected JCheckBox showRawValues;
    String[] topModuleNames = new String[20];
    int[] topModuleLines = new int[20];
    int numOfTopModules = 1;
    public static final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.ENGLISH);
    public static final DateFormat dateFormat2 = new SimpleDateFormat("yyyyMMdd HHmmss", Locale.ENGLISH);
    public static final DateFormat dateFormat3 = new SimpleDateFormat("dd MMM yy HH:mm:ss", Locale.ENGLISH);

    protected void addBottomFilter() {
        JPanel footerPanel = new JPanel();
        this.bottomPanel.add(footerPanel);
        footerPanel.setLayout(new BorderLayout(0, 0));
        JPanel footerPanelRight = new JPanel();
        JPanel footerPanelLeft = new JPanel();
        JPanel footerPanel1 = new JPanel();
        JPanel footerPanel2 = new JPanel();
        JPanel footerPanel3 = new JPanel();
        footerPanel.add((Component)footerPanelRight, "East");
        footerPanelRight.setLayout(new BorderLayout(0, 0));
        footerPanelRight.add((Component)footerPanel1, "West");
        footerPanelRight.add((Component)footerPanel2, "Center");
        footerPanel2.setLayout(new BorderLayout(0, 0));
        footerPanel2.add((Component)this.footerPanel2uptime, "East");
        footerPanel2.add((Component)this.footerPanel2utc, "West");
        footerPanelRight.add((Component)footerPanel3, "East");
        footerPanel.add((Component)footerPanelLeft, "West");
        footerPanelLeft.setLayout(new BoxLayout(footerPanelLeft, 0));
        this.showRawValues = new JCheckBox("Display Raw Values", Config.displayRawValues);
        this.showRawValues.setMinimumSize(new Dimension(100, this.fonth));
        footerPanelLeft.add(this.showRawValues);
        this.showRawValues.addItemListener(this);
        this.cbUTC = new JCheckBox("Display UTC Time", Config.displayUTCtime);
        footerPanelLeft.add(this.cbUTC);
        this.cbUTC.addItemListener(this);
        footerPanelLeft.add(new Box.Filler(new Dimension(14, this.fonth), new Dimension(400, this.fonth), new Dimension(1600, this.fonth)));
        this.lblFromReset = new JLabel(FROM_RESET);
        this.footerPanel2uptime.add(this.lblFromReset);
        this.textFromReset = new JTextField();
        this.footerPanel2uptime.add(this.textFromReset);
        this.textFromReset.setText(Integer.toString(this.START_RESET));
        this.textFromReset.setColumns(8);
        this.textFromReset.addActionListener(this);
        this.textFromReset.addFocusListener(this);
        this.lblFromUptime = new JLabel(" and Uptime");
        this.footerPanel2uptime.add(this.lblFromUptime);
        this.textFromUptime = new JTextField();
        this.footerPanel2uptime.add(this.textFromUptime);
        this.textFromUptime.setText(Long.toString(this.START_UPTIME));
        this.textFromUptime.setColumns(8);
        this.textFromUptime.addActionListener(this);
        this.textFromUptime.addFocusListener(this);
        this.lblToReset = new JLabel("  to Epoch");
        this.footerPanel2uptime.add(this.lblToReset);
        this.textToReset = new JTextField();
        this.footerPanel2uptime.add(this.textToReset);
        this.textToReset.setText(Integer.toString(this.END_RESET));
        this.textToReset.setColumns(8);
        this.textToReset.addActionListener(this);
        this.textToReset.addFocusListener(this);
        this.lblToUptime = new JLabel(" and Uptime");
        this.footerPanel2uptime.add(this.lblToUptime);
        this.textToUptime = new JTextField();
        this.footerPanel2uptime.add(this.textToUptime);
        this.textToUptime.setText(Long.toString(this.END_UPTIME));
        this.textToUptime.setColumns(8);
        this.textToUptime.addActionListener(this);
        this.textToUptime.addFocusListener(this);
        this.lblFromUTC = new JLabel(FROM_UTC);
        this.lblFromUTC.setToolTipText(this.dateFormatsToolTip);
        this.footerPanel2utc.add(this.lblFromUTC);
        this.textFromUtc = new JTextField();
        this.footerPanel2utc.add(this.textFromUtc);
        this.textFromUtc.setText(this.START_UTC);
        this.textFromUtc.setToolTipText(this.dateFormatsToolTip);
        this.textFromUtc.setColumns(16);
        this.textFromUtc.addActionListener(this);
        this.textFromUtc.addFocusListener(this);
        this.lblToUTC = new JLabel(" to UTC");
        this.lblToUTC.setToolTipText(this.dateFormatsToolTip);
        this.footerPanel2utc.add(this.lblToUTC);
        this.textToUtc = new JTextField();
        this.footerPanel2utc.add(this.textToUtc);
        this.textToUtc.setText(this.END_UTC);
        this.textToUtc.setColumns(16);
        this.textToUtc.setToolTipText(this.dateFormatsToolTip);
        this.textToUtc.addActionListener(this);
        this.textToUtc.addFocusListener(this);
        this.btnLatest = new JButton(LIVE_TEXT);
        this.btnLatest.setMargin(new Insets(0, 0, 0, 0));
        this.btnLatest.setToolTipText("Toggle between showing the live samples, the next samples from a date/uptime or a range of samples");
        this.btnLatest.addActionListener(this);
        footerPanel3.add(this.btnLatest);
        this.txtSamplePeriod = new JTextField();
        this.txtSamplePeriod.addActionListener(this);
        this.txtSamplePeriod.addFocusListener(this);
        this.txtSamplePeriod.setToolTipText("The number of data samples to plot.  The latest samples are returned unless a from reset/uptime is specified");
        footerPanel3.add(this.txtSamplePeriod);
        this.lblSamplePeriod = new JLabel("samples");
        footerPanel3.add(this.lblSamplePeriod);
        this.txtSamplePeriod.setText(Integer.toString(this.SAMPLES));
        this.txtSamplePeriod.setColumns(6);
        this.showRangeSearch(0);
        this.showUTCtime = Config.displayUTCtime;
        this.showUptimeQuery(!this.showUTCtime);
    }

    protected void initDisplayHalves(JPanel centerPanel) {
        this.topHalf = new JPanel();
        this.topHalf.setBackground(Color.DARK_GRAY);
        if (Config.ignoreSpacecraftLoadErrors) {
            JScrollPane scrollPane = new JScrollPane(this.topHalf, 22, 32);
            centerPanel.add(scrollPane);
        } else {
            centerPanel.add(this.topHalf);
        }
    }

    protected void makeDisplayModules(BitArrayLayout[] layouts, int moduleType) throws LayoutLoadException {
        int topLength = layouts.length;
        int bottomLength = 0;
        String[] topModuleNames = new String[topLength];
        int[] topModuleLines = new int[topLength];
        String[] bottomModuleNames = new String[bottomLength];
        int[] bottomModuleLines = new int[bottomLength];
        int numOfTopModules = 0;
        int numOfBottomModules = 0;
        int moduleNum = 0;
        BitArrayLayout[] bitArrayLayoutArray = layouts;
        int n = layouts.length;
        int n2 = 0;
        while (n2 < n) {
            BitArrayLayout rt = bitArrayLayoutArray[n2];
            if (moduleNum < topLength) {
                topModuleNames[moduleNum] = rt.module[4];
                topModuleLines[moduleNum] = rt.NUMBER_OF_FIELDS - 4;
                if (rt.fieldName[rt.NUMBER_OF_FIELDS - 1].equalsIgnoreCase("JUNK")) {
                    topModuleLines[moduleNum] = topModuleLines[moduleNum] - 1;
                }
                ++numOfTopModules;
            } else {
                bottomModuleNames[moduleNum - topLength] = rt.module[4];
                bottomModuleLines[moduleNum - topLength] = rt.NUMBER_OF_FIELDS - 5;
                ++numOfBottomModules;
            }
            ++moduleNum;
            ++n2;
        }
        if (topLength > 0) {
            this.topModules = new DisplayModule[numOfTopModules];
        }
        if (bottomLength > 0) {
            this.bottomModules = new DisplayModule[numOfBottomModules];
        }
        if (topLength > 0) {
            int i = 0;
            while (i < numOfTopModules) {
                this.topModules[i] = new DisplayModule(this.fox, topModuleNames[i], topModuleLines[i] + 1, layouts[i], moduleType, Color.BLUE);
                this.addModuleLines(this.topModules[i], topModuleNames[i], topModuleLines[i], layouts[i]);
                this.topHalf.add(this.topModules[i]);
                ++i;
            }
        }
        if (bottomLength > 0) {
            int i = 0;
            while (i < numOfBottomModules) {
                this.bottomModules[i] = new DisplayModule(this.fox, bottomModuleNames[i], bottomModuleLines[i] + 1, null, moduleType, Color.BLUE);
                this.addModuleLines(this.bottomModules[i], bottomModuleNames[i], bottomModuleLines[i], layouts[i]);
                this.bottomHalf.add(this.bottomModules[i]);
                ++i;
            }
        }
    }

    protected void analyzeModules(BitArrayLayout rt, BitArrayLayout max, BitArrayLayout min, int moduleType) throws LayoutLoadException {
        this.processLayout(rt);
        if (moduleType != 16) {
            if (max != null) {
                this.processLayout(max);
            }
            if (min != null) {
                this.processLayout(min);
            }
        }
        this.topModules = new DisplayModule[this.numOfTopModules + 1];
        int i = 1;
        while (i <= this.numOfTopModules) {
            if (this.topModuleNames[i] != null || this.topModuleLines[i] != 0) {
                if (this.topModuleNames[i] == null) {
                    Log.errorDialog("ERROR", "For spacecraft: " + this.fox.user_display_name + "  layout: " + rt.name + "  panel number: " + i + " has no name defined");
                    return;
                }
                if (this.topModuleLines[i] == 0) {
                    Log.errorDialog("ERROR", "For spacecraft: " + this.fox.user_display_name + "  layout: " + rt.name + "  panel number: " + i + " has zero lines defined");
                    return;
                }
                this.topModules[i] = new DisplayModule(this.fox, this.topModuleNames[i], this.topModuleLines[i] + 1, rt, moduleType, rt.color);
                this.addModuleLines(this.topModules[i], this.topModuleNames[i], this.topModuleLines[i], rt);
                if (moduleType != 16) {
                    if (max != null) {
                        this.addModuleLines(this.topModules[i], this.topModuleNames[i], this.topModuleLines[i], max);
                    }
                    if (min != null) {
                        this.addModuleLines(this.topModules[i], this.topModuleNames[i], this.topModuleLines[i], min);
                    }
                }
                this.topHalf.add(this.topModules[i]);
            }
            ++i;
        }
    }

    private void processLayout(BitArrayLayout rt) {
        int i = 0;
        while (i < rt.NUMBER_OF_FIELDS) {
            if (!rt.module[i].equalsIgnoreCase("NONE") && rt.moduleNum[i] != 0) {
                if (!this.containedIn(this.topModuleNames, rt.module[i])) {
                    if (this.topModuleNames[rt.moduleNum[i]] != null && !this.topModuleNames[rt.moduleNum[i]].equalsIgnoreCase(rt.module[i])) {
                        Log.errorDialog("ERROR", "For spacecraft: " + this.fox.user_display_name + "  layout: " + rt.name + "  panel number: " + rt.moduleNum[i] + " has the name " + this.topModuleNames[rt.moduleNum[i]] + " and the name " + rt.module[i] + ".  It can not have two different names.");
                        return;
                    }
                    this.topModuleNames[rt.moduleNum[i]] = rt.module[i];
                    if (this.numOfTopModules < rt.moduleNum[i]) {
                        this.numOfTopModules = rt.moduleNum[i];
                    }
                }
                int n = rt.moduleNum[i];
                this.topModuleLines[n] = this.topModuleLines[n] + 1;
            }
            ++i;
        }
    }

    private void addModuleLines(DisplayModule displayModule, String topModuleName, int topModuleLine, BitArrayLayout rt) throws LayoutLoadException {
        int j = 0;
        while (j < rt.NUMBER_OF_FIELDS) {
            if (rt.module[j].equals(topModuleName)) {
                if (rt.moduleLinePosition[j] > topModuleLine) {
                    throw new LayoutLoadException("Found error in Layout File: " + rt.fileName + " field: " + j + ".\nModule: " + topModuleName + " has " + topModuleLine + " lines, so we can not add " + rt.shortName[j] + " on line " + rt.moduleLinePosition[j]);
                }
                try {
                    if (this.fox.hasFOXDB_V3) {
                        if (rt.name.equals(this.fox.getLayoutNameByType("WOD"))) {
                            rt.moduleDisplayType[j] = 16;
                        }
                    } else if (rt.name.equals("wodtelemetry")) {
                        rt.moduleDisplayType[j] = 16;
                    }
                    displayModule.addName(rt.moduleLinePosition[j], String.valueOf(rt.shortName[j]) + this.formatUnits(rt.fieldUnits[j]), rt.fieldName[j], rt.description[j], rt.moduleDisplayType[j]);
                }
                catch (NullPointerException e) {
                    throw new LayoutLoadException("Found NULL item error in Layout File: " + rt.fileName + ".\nModule: " + topModuleName + " has " + topModuleLine + " lines, but error adding " + rt.shortName[j] + " on line " + rt.moduleLinePosition[j]);
                }
            }
            ++j;
        }
    }

    private String formatUnits(String unit) {
        if (unit.equals("-") || unit.equalsIgnoreCase("NONE")) {
            return "";
        }
        unit = " (" + unit + ")";
        return unit;
    }

    private boolean containedIn(String[] array, String item) {
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null && s.equals(item)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void showGraphs() {
        DisplayModule mod;
        int n;
        int n2;
        DisplayModule[] displayModuleArray;
        if (this.topModules != null) {
            displayModuleArray = this.topModules;
            n2 = this.topModules.length;
            n = 0;
            while (n < n2) {
                mod = displayModuleArray[n];
                if (mod != null) {
                    mod.showGraphs();
                }
                ++n;
            }
        }
        if (this.bottomModules != null) {
            displayModuleArray = this.bottomModules;
            n2 = this.bottomModules.length;
            n = 0;
            while (n < n2) {
                mod = displayModuleArray[n];
                if (mod != null) {
                    mod.showGraphs();
                }
                ++n;
            }
        }
    }

    @Override
    public void stopProcessing() {
        this.closeGraphs();
        super.stopProcessing();
    }

    public void closeGraphs() {
        DisplayModule mod;
        int n;
        int n2;
        DisplayModule[] displayModuleArray;
        if (this.topModules != null) {
            displayModuleArray = this.topModules;
            n2 = this.topModules.length;
            n = 0;
            while (n < n2) {
                mod = displayModuleArray[n];
                if (mod != null) {
                    mod.closeGraphs();
                }
                ++n;
            }
        }
        if (this.bottomModules != null) {
            displayModuleArray = this.bottomModules;
            n2 = this.bottomModules.length;
            n = 0;
            while (n < n2) {
                mod = displayModuleArray[n];
                if (mod != null) {
                    mod.closeGraphs();
                }
                ++n;
            }
        }
    }

    public void openGraphs() {
        DisplayModule mod;
        int n;
        int n2;
        DisplayModule[] displayModuleArray;
        if (this.topModules != null) {
            displayModuleArray = this.topModules;
            n2 = this.topModules.length;
            n = 0;
            while (n < n2) {
                mod = displayModuleArray[n];
                if (mod != null && mod.rtPayload != null) {
                    mod.openGraphs(mod.rtPayload.getLayout().number);
                }
                ++n;
            }
        }
        if (this.bottomModules != null) {
            displayModuleArray = this.bottomModules;
            n2 = this.bottomModules.length;
            n = 0;
            while (n < n2) {
                mod = displayModuleArray[n];
                if (mod != null && mod.rtPayload != null) {
                    mod.openGraphs(mod.rtPayload.getLayout().number);
                }
                ++n;
            }
        }
    }

    private void showRangeSearch(int showLive) {
        boolean show = false;
        if (showLive == 2) {
            this.btnLatest.setText(RANGE_TEXT);
            this.lblFromUTC.setText(FROM_UTC);
            this.lblFromReset.setText(FROM_RESET);
            show = true;
            this.btnLatest.setForeground(Color.BLACK);
            this.lblFromReset.setVisible(show);
            this.textFromReset.setVisible(show);
            this.lblFromUptime.setVisible(show);
            this.textFromUptime.setVisible(show);
            this.textFromUtc.setVisible(show);
            this.lblFromUTC.setVisible(show);
            this.lblToUTC.setVisible(show);
            this.reverse = false;
        }
        if (showLive == 0) {
            this.lblFromUTC.setText(BEFORE_UTC);
            this.lblFromReset.setText(BEFORE_RESET);
            this.btnLatest.setText(LIVE_TEXT);
            this.lblFromReset.setVisible(show);
            this.textFromReset.setVisible(show);
            this.lblFromUptime.setVisible(show);
            this.textFromUptime.setVisible(show);
            this.textFromUtc.setVisible(show);
            this.lblFromUTC.setVisible(show);
            this.reverse = true;
        }
        if (showLive == 1) {
            this.btnLatest.setText(NEXT_TEXT);
            this.lblFromUTC.setText(FROM_UTC);
            this.lblFromReset.setText(FROM_RESET);
            this.btnLatest.setForeground(Color.BLACK);
            this.lblFromReset.setVisible(!show);
            this.textFromReset.setVisible(!show);
            this.lblFromUptime.setVisible(!show);
            this.textFromUptime.setVisible(!show);
            this.textFromUtc.setVisible(!show);
            this.lblFromUTC.setVisible(!show);
            this.reverse = false;
        }
        this.lblToReset.setVisible(show);
        this.textToReset.setVisible(show);
        this.lblToUptime.setVisible(show);
        this.textToUptime.setVisible(show);
        this.txtSamplePeriod.setEnabled(!show);
        this.lblToUTC.setVisible(show);
        this.textToUtc.setVisible(show);
    }

    protected void showUptimeQuery(boolean up) {
        if (up) {
            this.footerPanel2uptime.setVisible(true);
            this.footerPanel2utc.setVisible(false);
        } else {
            this.footerPanel2uptime.setVisible(false);
            this.footerPanel2utc.setVisible(true);
        }
    }

    private Date parseDate(String strDate) {
        Date date = null;
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        dateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            date = dateFormat.parse(strDate);
        }
        catch (ParseException e) {
            try {
                date = dateFormat2.parse(strDate);
            }
            catch (ParseException e2) {
                try {
                    date = dateFormat3.parse(strDate);
                }
                catch (ParseException e3) {
                    Log.errorDialog("Invalid Date", "Try a date in one of the following formats: \nYYYYMMDD HHMMSS\nYYYY/MM/DD HH:MM:SS\ndd MMM yy HH:mm:ss\nnow\nyesterday\nlaunch");
                    date = null;
                }
            }
        }
        return date;
    }

    private FoxTime parseUTCField(JTextField field, String strDate) {
        if (strDate.equalsIgnoreCase(NOW)) {
            Date currentDate = new Date();
            FoxTime foxTime = this.fox.getUptimeForUtcDate(currentDate);
            dateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
            String time = dateFormat2.format(currentDate);
            field.setText(time);
            return foxTime;
        }
        if (strDate.equalsIgnoreCase(YESTERDAY)) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, -1);
            Date currentDate = new Date(cal.getTimeInMillis());
            FoxTime foxTime = this.fox.getUptimeForUtcDate(currentDate);
            dateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
            String time = dateFormat2.format(currentDate);
            field.setText(time);
            return foxTime;
        }
        if (strDate.equalsIgnoreCase(LAUNCH)) {
            Date date = this.fox.getUtcForReset(0, 0L);
            if (date != null) {
                dateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
                String time = dateFormat2.format(date);
                field.setText(time);
            }
            return new FoxTime(0, 0L);
        }
        Date dateFrom = this.parseDate(strDate);
        if (dateFrom != null) {
            FoxTime foxTime = this.fox.getUptimeForUtcDate(dateFrom);
            return foxTime;
        }
        return null;
    }

    protected void parseUTCFields() {
        FoxTime foxTime2;
        String strDate = this.textFromUtc.getText();
        FoxTime foxTime = this.parseUTCField(this.textFromUtc, strDate);
        if (foxTime != null) {
            this.START_RESET = foxTime.getReset();
            this.START_UPTIME = foxTime.getUptime();
        }
        if ((foxTime2 = this.parseUTCField(this.textToUtc, strDate = this.textToUtc.getText())) != null) {
            this.END_RESET = foxTime2.getReset();
            this.END_UPTIME = foxTime2.getUptime();
        }
    }

    protected void parseTextFields() {
        block15: {
            String text;
            block14: {
                block13: {
                    block12: {
                        text = this.textFromReset.getText();
                        try {
                            this.START_RESET = Integer.parseInt(text);
                            if (this.START_RESET < 0) {
                                this.START_RESET = 0;
                            }
                        }
                        catch (NumberFormatException ex) {
                            if (!text.equals("")) break block12;
                            this.START_RESET = DEFAULT_START_RESET;
                        }
                    }
                    text = this.textFromUptime.getText();
                    try {
                        this.START_UPTIME = Integer.parseInt(text);
                        if (this.START_UPTIME < 0L) {
                            this.START_UPTIME = 0L;
                        }
                    }
                    catch (NumberFormatException ex) {
                        if (!text.equals("")) break block13;
                        this.START_UPTIME = DEFAULT_START_UPTIME;
                    }
                }
                text = this.textToReset.getText();
                try {
                    this.END_RESET = Integer.parseInt(text);
                    if (this.END_RESET < 0) {
                        this.END_RESET = 0;
                    }
                }
                catch (NumberFormatException ex) {
                    if (!text.equals("")) break block14;
                    this.END_RESET = DEFAULT_START_RESET;
                }
            }
            text = this.textToUptime.getText();
            try {
                this.END_UPTIME = Integer.parseInt(text);
                if (this.END_UPTIME < 0L) {
                    this.END_UPTIME = 0L;
                }
            }
            catch (NumberFormatException ex) {
                if (!text.equals("")) break block15;
                this.END_UPTIME = DEFAULT_START_UPTIME;
            }
        }
    }

    private void convertToUtc() {
        Date date2;
        this.parseTextFields();
        Date date = this.fox.getUtcForReset(this.START_RESET, this.START_UPTIME);
        if (date != null) {
            dateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
            String time = dateFormat2.format(date);
            this.textFromUtc.setText(time);
            this.START_UTC = time;
            this.textFromUtc.setText(time);
        }
        if ((date2 = this.fox.getUtcForReset(this.END_RESET, this.END_UPTIME)) != null) {
            dateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
            String time2 = dateFormat2.format(date2);
            this.textToUtc.setText(time2);
            this.END_UTC = time2;
            this.textToUtc.setText(time2);
        }
        if (this.showLatest == 2) {
            this.SAMPLES = this.fox.hasFOXDB_V3 ? Config.payloadStore.getNumberOfPayloadsBetweenTimestamps(this.fox.foxId, this.START_RESET, this.START_UPTIME, this.END_RESET, this.END_UPTIME, this.fox.getLayoutNameByType("RT")) : Config.payloadStore.getNumberOfPayloadsBetweenTimestamps(this.fox.foxId, this.START_RESET, this.START_UPTIME, this.END_RESET, this.END_UPTIME, "rttelemetry");
            this.txtSamplePeriod.setText(Integer.toString(this.SAMPLES));
        }
    }

    private void convertToUptime() {
        this.parseUTCFields();
        this.textFromReset.setText(Integer.toString(this.START_RESET));
        this.textFromUptime.setText(Long.toString(this.START_UPTIME));
        this.textToReset.setText(Integer.toString(this.END_RESET));
        this.textToUptime.setText(Long.toString(this.END_UPTIME));
        if (this.showLatest == 2) {
            this.SAMPLES = this.fox.hasFOXDB_V3 ? Config.payloadStore.getNumberOfPayloadsBetweenTimestamps(this.fox.foxId, this.START_RESET, this.START_UPTIME, this.END_RESET, this.END_UPTIME, this.fox.getLayoutNameByType("RT")) : Config.payloadStore.getNumberOfPayloadsBetweenTimestamps(this.fox.foxId, this.START_RESET, this.START_UPTIME, this.END_RESET, this.END_UPTIME, "rttelemetry");
            this.txtSamplePeriod.setText(Integer.toString(this.SAMPLES));
        }
    }

    private void parseFields() {
        String text = null;
        if (this.showUTCtime) {
            this.convertToUptime();
        } else {
            this.convertToUtc();
        }
        text = this.txtSamplePeriod.getText();
        try {
            this.SAMPLES = Integer.parseInt(text);
            if (this.SAMPLES > 99999) {
                this.SAMPLES = 99999;
                text = Integer.toString(99999);
                this.txtSamplePeriod.setText(text);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.parseFrames();
    }

    public abstract void parseFrames();

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.txtSamplePeriod) {
            this.parseFields();
        } else if (e.getSource() == this.textFromReset) {
            this.parseFields();
        } else if (e.getSource() == this.textFromUptime) {
            this.parseFields();
        } else if (e.getSource() == this.textToReset) {
            this.parseFields();
        } else if (e.getSource() == this.textToUptime) {
            this.parseFields();
        } else if (e.getSource() == this.textFromUtc) {
            this.parseFields();
        } else if (e.getSource() == this.textToUtc) {
            this.parseFields();
        } else if (e.getSource() == this.btnLatest) {
            ++this.showLatest;
            if (this.showLatest > 2) {
                this.showLatest = 0;
            }
            this.showRangeSearch(this.showLatest);
            this.parseFrames();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.cbUTC) {
            boolean bl = this.showUTCtime = !this.showUTCtime;
            if (this.showUTCtime) {
                this.parseTextFields();
                if (this.SAMPLES > 99999) {
                    this.SAMPLES = 99999;
                }
                this.txtSamplePeriod.setText(Integer.toString(this.SAMPLES));
            } else {
                this.parseUTCFields();
                if (this.SAMPLES > 99999) {
                    this.SAMPLES = 99999;
                }
                this.txtSamplePeriod.setText(Integer.toString(this.SAMPLES));
            }
            this.showUptimeQuery(!this.showUTCtime);
            Config.displayUTCtime = this.showUTCtime;
            Config.save();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() != this.txtSamplePeriod && e.getSource() != this.textFromReset) {
            e.getSource();
        }
    }
}

