/*
 * Decompiled with CFR 0.152.
 */
package gui.tabs;

import common.Config;
import common.Log;
import common.Spacecraft;
import gui.MainWindow;
import gui.tabs.HealthTab;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import predict.PositionCalcException;
import telemetry.LayoutLoadException;
import telemetry.payloads.PayloadWOD;
import uk.me.g4dpz.satellite.SatPos;

public class WodHealthTab
extends HealthTab {
    private static final long serialVersionUID = 1L;
    JLabel lblSatLatitudeValue;
    JLabel lblSatLongitudeValue;

    public WodHealthTab(Spacecraft spacecraft) throws LayoutLoadException {
        super(spacecraft, 16);
        this.TAB_TYPE = "wod";
        this.healthTableToDisplay = Config.loadGraphIntValue(this.fox.getIdString(), 99, 1, "HEALTHTAB", String.valueOf(this.TAB_TYPE) + "healthTableToDisplay");
        this.splitPaneHeight = Config.loadGraphIntValue(this.fox.getIdString(), 99, 1, "HEALTHTAB", String.valueOf(this.TAB_TYPE) + "splitPaneHeight");
        if (this.healthTableToDisplay == 0) {
            this.hideTables(true);
        } else if (this.splitPaneHeight != 0) {
            this.splitPane.setDividerLocation(this.splitPaneHeight);
        } else {
            this.splitPane.setDividerLocation(5000);
        }
        this.showLiveOrHistorical();
        this.topPanel1.add(new Box.Filler(new Dimension(14, this.fonth), new Dimension(1600, this.fonth), new Dimension(1600, this.fonth)));
        this.lblFramesDecoded = new JLabel("WOD Payloads Decoded:");
        this.lblFramesDecoded.setFont(new Font("SansSerif", 1, Config.displayModuleFontSize * 14 / 11));
        this.lblFramesDecoded.setBorder(new EmptyBorder(5, 2, 5, 5));
        this.lblFramesDecoded.setForeground(this.textLblColor);
        this.topPanel1.add(this.lblFramesDecoded);
        this.lblFramesDecodedValue = new JLabel();
        this.lblFramesDecodedValue.setFont(new Font("SansSerif", 1, Config.displayModuleFontSize * 14 / 11));
        this.lblFramesDecodedValue.setBorder(new EmptyBorder(5, 2, 5, 5));
        this.lblFramesDecodedValue.setForeground(this.textColor);
        this.topPanel1.add(this.lblFramesDecodedValue);
        this.lblResetsValue = this.addReset(this.topPanel2, "Last WOD:");
        this.lblUptimeValue = this.addUptime(this.topPanel2, "");
        this.lblSatLatitudeValue = this.addTopPanelValue(this.topPanel2, "Footprint   Latitude:");
        this.lblSatLongitudeValue = this.addTopPanelValue(this.topPanel2, "Longitude:");
    }

    @Override
    protected void addBottomFilter() {
        this.currentBut = new JRadioButton("Current");
        this.bottomPanel.add(this.currentBut);
        this.currentBut.addActionListener(this);
        this.rtBut = new JRadioButton("History");
        this.bottomPanel.add(this.rtBut);
        this.rtBut.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.currentBut);
        group.add(this.rtBut);
        this.healthTableToDisplay = Config.loadGraphIntValue(this.fox.getIdString(), 99, 1, "HEALTHTAB", "wodhealthTableToDisplay");
        if (this.healthTableToDisplay == 0) {
            this.currentBut.setSelected(true);
        } else if (this.healthTableToDisplay == 1) {
            this.rtBut.setSelected(true);
        }
        super.addBottomFilter();
    }

    private void displayLatLong() {
        block5: {
            PayloadWOD wod = (PayloadWOD)this.realTime;
            SatPos pos = null;
            try {
                pos = this.fox.getSatellitePosition(wod.getResets(), wod.getUptime());
                if (pos != null) {
                    wod.setSatPosition(pos);
                    this.lblSatLatitudeValue.setText(" " + wod.getSatLatitudeStr());
                    this.lblSatLongitudeValue.setText(" " + wod.getSatLongitudeStr());
                } else {
                    this.lblSatLatitudeValue.setText(" ERR");
                    this.lblSatLongitudeValue.setText(" ERR");
                }
            }
            catch (PositionCalcException e) {
                if (e.errorCode == -997.0) {
                    this.lblSatLatitudeValue.setText(" NO TLE");
                    this.lblSatLongitudeValue.setText(" NO TLE");
                }
                if (e.errorCode != -998.0) break block5;
                this.lblSatLatitudeValue.setText(" T0 NOT SET");
                this.lblSatLongitudeValue.setText(" T0 NOT SET");
            }
        }
    }

    @Override
    protected void displayRow(JTable rtTable, int fromRow, int row) {
        long reset_l = (Long)rtTable.getValueAt(row, 0);
        long uptime = (Long)rtTable.getValueAt(row, 1);
        int reset = (int)reset_l;
        this.realTime = Config.payloadStore.getFramePart(this.foxId, reset, uptime, this.rt.name, false);
        if (this.realTime != null) {
            this.updateTabRT(this.realTime, false);
        }
        if (fromRow == -1) {
            fromRow = row;
        }
        if (fromRow <= row) {
            rtTable.setRowSelectionInterval(fromRow, row);
        } else {
            rtTable.setRowSelectionInterval(row, fromRow);
        }
        this.displayLatLong();
    }

    @Override
    public void parseFrames() {
        String[][] data = Config.payloadStore.getTableData(this.SAMPLES, this.fox.foxId, this.START_RESET, this.START_UPTIME, true, this.reverse, this.rt.name);
        if (data != null && data.length > 0) {
            this.parseTelemetry(data);
            this.displayTable();
            MainWindow.frame.repaint();
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName("WodHealthTab");
        this.running = true;
        this.done = false;
        boolean justStarted = true;
        int currentFrames = 0;
        while (this.running) {
            int frames;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: WodHealthTab thread interrupted");
                e.printStackTrace(Log.getWriter());
            }
            if (Config.displayRawValues != this.showRawValues.isSelected()) {
                this.showRawValues.setSelected(Config.displayRawValues);
            }
            if (this.foxId == 0 || !Config.payloadStore.initialized() || (frames = Config.payloadStore.getNumberOfFrames(this.foxId, this.rt.name)) == currentFrames) continue;
            currentFrames = frames;
            this.realTime = Config.payloadStore.getLatest(this.foxId, this.rt.name);
            if (this.realTime != null) {
                if (this.healthTableToDisplay == 0) {
                    this.updateTabRT(this.realTime, true);
                    this.displayLatLong();
                } else {
                    this.parseFrames();
                }
                this.displayFramesDecoded(frames);
            }
            Config.payloadStore.setUpdated(this.foxId, this.rt.name, false);
            MainWindow.setTotalDecodes();
            if (justStarted) {
                this.openGraphs();
                justStarted = false;
            }
            MainWindow.frame.repaint();
        }
        this.done = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.rtBut) {
            this.healthTableToDisplay = 1;
            this.hideTables(false);
            Config.saveGraphIntParam(this.fox.getIdString(), 99, 1, "HEALTHTAB", "wodhealthTableToDisplay", this.healthTableToDisplay);
            this.parseFrames();
        }
        if (e.getSource() == this.currentBut) {
            this.healthTableToDisplay = 0;
            this.hideTables(true);
            Config.saveGraphIntParam(this.fox.getIdString(), 99, 1, "HEALTHTAB", "wodhealthTableToDisplay", this.healthTableToDisplay);
            this.realTime = this.fox.hasFOXDB_V3 ? Config.payloadStore.getLatest(this.foxId, this.fox.getLayoutNameByType("WOD")) : Config.payloadStore.getLatest(this.foxId, "wodtelemetry");
            if (this.realTime != null) {
                this.updateTabRT(this.realTime, true);
            }
            this.parseFrames();
        }
        this.showLiveOrHistorical();
    }
}

