/*
 * Decompiled with CFR 0.152.
 */
package measure;

import common.Config;
import common.Log;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import measure.Measurement;
import telemetry.FramePart;

public class RtMeasurement
extends Measurement {
    public static final String BIT_SNR = "BIT_SNR";
    public static final String RF_SNR = "RF_SNR";
    public static final String RF_POWER = "RF_POWER";
    public static final String CARRIER_FREQ = "CARRIER_FREQ";
    public static final String AZ = "AZ";
    public static final String EL = "EL";
    public static final String STATION_CONFIG = "STATION_CONFIG";
    public static final String ERRORS = "ERRORS";
    public static final String ERASURES = "ERASURES";

    public RtMeasurement(int foxid, String date, int reset, long uptime, int type, StringTokenizer st) {
        this.id = foxid;
        FramePart.fileDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.date = new Date();
        try {
            this.date = FramePart.fileDateFormat.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace(Log.getWriter());
        }
        this.reset = reset;
        this.uptime = uptime;
        this.type = type;
        this.layout = Config.satManager.getMeasurementLayout(foxid);
        this.fieldValue = new double[this.layout.NUMBER_OF_FIELDS];
        this.load(st);
    }

    public RtMeasurement(int foxid, int reset, long uptime, int type) {
        this.id = foxid;
        this.date = Calendar.getInstance().getTime();
        FramePart.fileDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.reset = reset;
        this.uptime = uptime;
        this.type = type;
        this.layout = Config.satManager.getMeasurementLayout(foxid);
        this.fieldValue = new double[this.layout.NUMBER_OF_FIELDS];
    }

    public boolean zeroIsNull(String name) {
        if (name.equalsIgnoreCase(CARRIER_FREQ)) {
            return true;
        }
        if (name.equalsIgnoreCase(BIT_SNR)) {
            return true;
        }
        if (name.equalsIgnoreCase(RF_SNR)) {
            return true;
        }
        return name.equalsIgnoreCase(RF_POWER);
    }

    public double getRawValue(String name) {
        int i = 0;
        while (i < this.layout.fieldName.length) {
            if (name.equalsIgnoreCase(this.layout.fieldName[i])) {
                return this.fieldValue[i];
            }
            ++i;
        }
        return -1.0;
    }

    public void setRawValue(String name, double value) {
        int i = 0;
        while (i < this.layout.fieldName.length) {
            if (name.equalsIgnoreCase(this.layout.fieldName[i])) {
                this.fieldValue[i] = value;
            }
            ++i;
        }
    }

    public void setBitSNR(double d) {
        this.setRawValue(BIT_SNR, d);
    }

    public void setRfSNR(double d) {
        this.setRawValue(RF_SNR, d);
    }

    public void setRfPower(double d) {
        this.setRawValue(RF_POWER, d);
    }

    public void setCarrierFrequency(long d) {
        this.setRawValue(CARRIER_FREQ, d);
    }

    public void setAzimuth(double d) {
        this.setRawValue(AZ, d);
    }

    public void setElevation(double d) {
        this.setRawValue(EL, d);
    }

    public void setErrors(int d) {
        this.setRawValue(ERRORS, d);
    }

    public void setErasures(int d) {
        this.setRawValue(ERASURES, d);
    }

    protected void load(StringTokenizer st) {
        try {
            int i = 0;
            while (i < this.layout.NUMBER_OF_FIELDS) {
                this.fieldValue[i] = Double.valueOf(st.nextToken());
                ++i;
            }
        }
        catch (NoSuchElementException i) {
        }
        catch (ArrayIndexOutOfBoundsException e) {
            String captureDate = FramePart.fileDateFormat.format(this.date);
            Log.println("ERROR: Too many fields:  Could not load measurement " + this.id + " " + captureDate + this.type);
        }
        catch (NumberFormatException n) {
            String captureDate = FramePart.fileDateFormat.format(this.date);
            Log.println("ERROR: Invalid number:  Could not load measurement " + this.id + " " + captureDate + this.type);
        }
    }

    public String toString() {
        return "FOX RT Measurement: Fox-Id: " + this.id;
    }
}

