/*
 * Decompiled with CFR 0.152.
 */
package measure;

import com.pretty_tools.dde.DDEException;
import com.pretty_tools.dde.DDEMLException;
import com.pretty_tools.dde.client.DDEClientConversation;
import common.Config;
import common.Log;

public class SatPc32DDE {
    public static final int CONNECT_FAIL_ERROR_CODE = 16394;
    public DDEClientConversation conversation = null;
    String satellite;
    double azimuth;
    double elevation;
    long downlinkFrequency;

    public SatPc32DDE() {
        this.connectConversation();
    }

    public String getSatellite() {
        this.connectConversation();
        return this.satellite;
    }

    public double getAzimuth() {
        this.connectConversation();
        return this.azimuth;
    }

    public double getElevation() {
        this.connectConversation();
        return this.elevation;
    }

    public long getDownlinkFrequency() {
        this.connectConversation();
        return this.downlinkFrequency;
    }

    public synchronized void connectConversation() {
        if (this.conversation == null) {
            this.conversation = new DDEClientConversation();
            this.conversation.setTimeout(1000);
            try {
                this.conversation.connect("SatPC32", "SatPcDdeConv");
            }
            catch (DDEException e) {
                this.conversation = null;
            }
        }
    }

    public synchronized void disconnect() {
        if (this.conversation != null) {
            try {
                this.conversation.disconnect();
            }
            catch (DDEException e) {
                Log.println("DDEException while disconnecting: " + e.getMessage());
            }
        }
        this.conversation = null;
    }

    public synchronized boolean request() {
        String ddeString;
        block15: {
            ddeString = null;
            this.connectConversation();
            if (this.conversation == null) {
                this.satellite = null;
                return false;
            }
            ddeString = this.conversation.request("SatPcDdeItem");
            if (ddeString.length() <= 0 || ddeString.startsWith("**")) break block15;
            String[] parts = ddeString.split(" ");
            this.satellite = parts[0].substring(2, parts[0].length());
            String az = parts[1].substring(2, parts[1].length());
            az = az.replaceAll(",", ".");
            this.azimuth = Double.parseDouble(az);
            String el = parts[2].substring(2, parts[2].length());
            el = el.replaceAll(",", ".");
            this.elevation = Double.parseDouble(el);
            this.downlinkFrequency = Long.parseLong(parts[5].substring(2, parts[5].length()));
            if (Config.debugDDE) {
                System.out.println("DDE Sat: " + this.satellite + " Az: " + this.azimuth + " El: " + this.elevation + " Freq: " + this.downlinkFrequency);
            }
            return true;
        }
        try {
            this.satellite = "NONE";
            return true;
        }
        catch (DDEMLException e) {
            if (e.getErrorCode() != 16394) {
                Log.println("DDEMLException: 0x" + Integer.toHexString(e.getErrorCode()) + " " + e.getMessage());
            }
            this.satellite = null;
            this.disconnect();
            return false;
        }
        catch (DDEException e) {
            Log.println("DDEException in request: " + e.getMessage());
            this.satellite = null;
            this.disconnect();
            return false;
        }
        catch (UnsatisfiedLinkError e) {
            Log.errorDialog("MISSING DDE DLLs", "FoxTelem could not find the JavaDDE.dll or JavaDDEx64.dll files.  They need to be in the same\nfolder as the jar file and should have been part of the installation.\nThe DDE connection to SatPC32 has been disabled.");
            Config.useDDEforAzEl = false;
            Config.useDDEforFreq = false;
            this.satellite = null;
            this.disconnect();
            return false;
        }
        catch (NoClassDefFoundError e) {
            Log.errorDialog("MISSING DDE DLLs", "FoxTelem could not find the JavaDDE.dll or JavaDDEx64.dll files.  They need to be in the same\nfolder as the jar file and should have been part of the installation.\nThe DDE connection to SatPC32 has been disabled.");
            Config.useDDEforAzEl = false;
            Config.useDDEforFreq = false;
            this.satellite = null;
            this.disconnect();
            return false;
        }
        catch (NumberFormatException e) {
            if (ddeString != null) {
                Log.println("Cannot parse the DDE message: " + ddeString + "\nNumber format error: " + e.getMessage());
            } else {
                Log.println("Cannot parse the DDE message.  \nNumber format error: " + e.getMessage());
            }
            this.satellite = null;
            this.disconnect();
            return false;
        }
        catch (StringIndexOutOfBoundsException e) {
            if (ddeString != null) {
                Log.println("Cannot parse the DDE message: " + ddeString + "\nIndex ouf of bounds error: " + e.getMessage());
            } else {
                Log.println("Cannot parse the DDE message.  \nIndex out of bounds error: " + e.getMessage());
            }
            this.satellite = null;
            this.disconnect();
            return false;
        }
    }
}

