/*
 * Decompiled with CFR 0.152.
 */
package predict;

import common.Log;
import gui.legacyTabs.ImagePanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import uk.me.g4dpz.satellite.SatPos;

public class MapPanel
extends ImagePanel
implements Runnable {
    boolean running = true;
    public static final int MAP_UPDATE_PERIOD = 1000;
    SatPos[] satPositions;
    public static final double MAX_LATITUDE = 81.0;
    public static final double MIN_LATITUDE = 85.0;

    public MapPanel(String filePath, SatPos[] positions) {
        super(filePath);
        this.satPositions = positions;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        double ratio = (double)this.getHeight() / (double)this.image.getHeight();
        if ((double)this.image.getWidth() * ratio > (double)this.getWidth()) {
            ratio = (double)this.getWidth() / (double)this.image.getWidth();
        }
        int mapHeight = (int)((double)this.image.getHeight() * ratio);
        int mapWidth = (int)((double)this.image.getWidth() * ratio);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        if (this.satPositions != null && this.satPositions.length > 0) {
            SatPos[] satPosArray = this.satPositions;
            int n = this.satPositions.length;
            int n2 = 0;
            while (n2 < n) {
                SatPos pos = satPosArray[n2];
                if (pos != null) {
                    g.setFont(new Font("SansSerif", 1, 12));
                    g2.setColor(Color.LIGHT_GRAY);
                    g2.drawLine(mapWidth / 2, 0, mapWidth / 2, mapHeight);
                    g2.drawLine(0, mapHeight / 2, mapWidth, mapHeight / 2);
                    double lat = pos.getLatitude() / (Math.PI * 2) * 360.0;
                    double lon = pos.getLongitude() / (Math.PI * 2) * 360.0;
                    Log.println("Sat lat/long: " + lat + "," + lon);
                    double[][] rangeCircle = pos.getRangeCircle();
                    g2.setColor(Color.YELLOW);
                    double la = -33.9249;
                    double lo = 18.4241;
                    this.drawCross(la, lo, mapWidth, mapHeight, g2);
                    la = 51.5074;
                    lo = -0.1278;
                    this.drawCross(la, lo, mapWidth, mapHeight, g2);
                    lo = -73.980599;
                    la = 40.703328;
                    this.drawCross(la, lo, mapWidth, mapHeight, g2);
                    g2.setColor(Color.RED);
                    this.drawCross(lat, lon, mapWidth, mapHeight, g2);
                    int x = 0;
                    int y = 0;
                    g2.setColor(Color.YELLOW);
                    int lastX = 99999;
                    int lastY = 99999;
                    double[][] dArray = rangeCircle;
                    int n3 = rangeCircle.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        double[] latLon = dArray[n4];
                        lat = latLon[0];
                        lon = latLon[1];
                        x = this.lonToX(lon, mapWidth);
                        y = this.latToY(lat, mapWidth, mapHeight);
                        if (lastX == 99999) {
                            lastX = x;
                            lastY = y;
                        }
                        g2.drawLine(lastX, lastY, x, y);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private void drawCross(double lat, double lon, int mapWidth, int mapHeight, Graphics2D g2) {
        int x = this.lonToX(lon, mapWidth);
        int y = this.latToY(lat, mapWidth, mapHeight);
        g2.drawLine(x - 10, y, x + 10, y);
        g2.drawLine(x, y - 10, x, y + 10);
        Log.println("Drawn at: " + x + "," + y);
    }

    int lonToX(double lon, int mapWidth) {
        int x = 0;
        lon = lon > 180.0 ? (lon -= 180.0) : (lon += 180.0);
        x = (int)(lon * (double)mapWidth / 360.0);
        return x;
    }

    int latToY(double lat, int mapWidth, int mapHeight) {
        lat = lat > 0.0 ? 81.0 * lat / 90.0 : 85.0 * lat / 90.0;
        double latRad = lat * (Math.PI / 180);
        double mercN = Math.log(Math.tan(0.7853981633974483 + latRad / 2.0));
        int y = (int)((double)mapWidth / (Math.PI * 2) * mercN);
        return mapHeight / 2 - y;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace(Log.getWriter());
            }
            this.repaint();
        }
    }
}

