/*
 * Decompiled with CFR 0.152.
 */
package spacecraftEditor;

import common.Config;
import common.Log;
import gui.MainWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import spacecraftEditor.SpacecraftEditorWindow;

public class EditorSettingsFrame
extends JDialog
implements ActionListener,
ItemListener,
FocusListener,
WindowListener {
    JPanel contentPane;
    JTextField txtLogFileDirectory;
    JTextField txtMasterFileDirectory;
    JButton btnSave;
    JButton btnCancel;
    JButton btnBrowse;
    JButton btnBrowseMaster;
    JCheckBox cbLogging;
    JTextField txtPython;
    JTextField txtPayloadHeaderGenScript;

    public EditorSettingsFrame(JFrame owner, boolean modal) {
        super((Frame)owner, modal);
        this.setTitle("Settings");
        this.addWindowListener(this);
        this.setDefaultCloseOperation(2);
        this.loadProperties();
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        JPanel southpanel = new JPanel();
        this.contentPane.add((Component)southpanel, "South");
        southpanel.setLayout(new FlowLayout(1, 5, 5));
        this.btnSave = new JButton("Save");
        this.btnSave.addActionListener(this);
        southpanel.add(this.btnSave);
        this.getRootPane().setDefaultButton(this.btnSave);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.addActionListener(this);
        southpanel.add(this.btnCancel);
        JPanel northpanel = new JPanel();
        this.contentPane.add((Component)northpanel, "North");
        northpanel.setLayout(new BorderLayout());
        JPanel northpanel1 = new JPanel();
        JPanel northpanel2 = new JPanel();
        JPanel northpanelA = new JPanel();
        JPanel northpanelB = new JPanel();
        northpanel.add((Component)northpanel1, "North");
        northpanel1.setLayout(new BorderLayout());
        northpanel1.add((Component)northpanelA, "North");
        northpanel1.add((Component)northpanelB, "South");
        northpanel.add((Component)northpanel2, "South");
        northpanel2.setLayout(new BorderLayout());
        northpanelA.setLayout(new BorderLayout());
        northpanelB.setLayout(new BorderLayout());
        JLabel lblHomeDir = new JLabel("Home directory     ");
        lblHomeDir.setToolTipText("This is the directory that contains the settings file");
        lblHomeDir.setBorder(new EmptyBorder(5, 2, 5, 5));
        northpanelA.add((Component)lblHomeDir, "West");
        JLabel lblHomeDir2 = new JLabel(Config.homeDirectory);
        northpanelA.add((Component)lblHomeDir2, "Center");
        JLabel lblServerUrl = new JLabel("MASTER files directory  ");
        lblServerUrl.setToolTipText("This contains the spacecraft folder with the MASTER files that will be edited");
        lblServerUrl.setBorder(new EmptyBorder(5, 2, 5, 5));
        northpanelB.add((Component)lblServerUrl, "West");
        this.txtMasterFileDirectory = new JTextField(Config.spacecraftDir);
        northpanelB.add((Component)this.txtMasterFileDirectory, "Center");
        this.txtMasterFileDirectory.setColumns(30);
        this.txtMasterFileDirectory.addActionListener(this);
        this.btnBrowseMaster = new JButton("Browse");
        this.btnBrowseMaster.addActionListener(this);
        northpanelB.add((Component)this.btnBrowseMaster, "East");
        JLabel lblLogFilesDir = new JLabel("Log files directory");
        lblLogFilesDir.setToolTipText("This sets the directory that the downloaded telemetry data is stored in");
        lblLogFilesDir.setBorder(new EmptyBorder(5, 2, 5, 5));
        northpanel2.add((Component)lblLogFilesDir, "West");
        this.txtLogFileDirectory = new JTextField(Config.logFileDirectory);
        northpanel2.add((Component)this.txtLogFileDirectory, "Center");
        this.txtLogFileDirectory.setColumns(30);
        this.txtLogFileDirectory.addActionListener(this);
        this.btnBrowse = new JButton("Browse");
        this.btnBrowse.addActionListener(this);
        northpanel2.add((Component)this.btnBrowse, "East");
        if (Config.logDirFromPassedParam) {
            this.txtLogFileDirectory.setEnabled(false);
            this.btnBrowse.setVisible(false);
            JLabel lblPassedParam = new JLabel("  (Fixed at Startup)");
            northpanel2.add((Component)lblPassedParam, "East");
        }
        TitledBorder eastTitle1 = this.title("Files and Directories");
        northpanel.setBorder(eastTitle1);
        JPanel centerpanel = new JPanel();
        this.contentPane.add((Component)centerpanel, "Center");
        TitledBorder centerTitle1 = this.title("Options");
        centerpanel.setBorder(centerTitle1);
        centerpanel.setLayout(new BoxLayout(centerpanel, 1));
        this.cbLogging = this.addCheckBoxRow("Enable Logging", "Log debug information to a file", Config.logging, centerpanel);
        this.txtPython = this.addSettingsRow(centerpanel, 20, "Path to Python", "python executable name with folder if it is not in the path", Config.python);
        this.txtPayloadHeaderGenScript = this.addSettingsRow(centerpanel, 20, "C header Script", "Name of the python script to generate the C headers", Config.payloadHeaderGenScript);
        centerpanel.add(new Box.Filler(new Dimension(0, 1000), new Dimension(100, 1000), new Dimension(1000, 1000)));
    }

    public void saveProperties() {
        Config.saveGraphIntParam("Global", 0, 0, "settingsWindow", "windowHeight", this.getHeight());
        Config.saveGraphIntParam("Global", 0, 0, "settingsWindow", "windowWidth", this.getWidth());
        Config.saveGraphIntParam("Global", 0, 0, "settingsWindow", "windowX", this.getX());
        Config.saveGraphIntParam("Global", 0, 0, "settingsWindow", "windowY", this.getY());
    }

    public void loadProperties() {
        int windowX = Config.loadGraphIntValue("Global", 0, 0, "settingsWindow", "windowX");
        int windowY = Config.loadGraphIntValue("Global", 0, 0, "settingsWindow", "windowY");
        int windowWidth = Config.loadGraphIntValue("Global", 0, 0, "settingsWindow", "windowWidth");
        int windowHeight = Config.loadGraphIntValue("Global", 0, 0, "settingsWindow", "windowHeight");
        if (windowX == 0 || windowY == 0 || windowWidth == 0 || windowHeight == 0) {
            this.setBounds(100, 100, 400, 700);
        } else {
            this.setBounds(windowX, windowY, windowWidth, windowHeight);
        }
    }

    private TitledBorder title(String s) {
        TitledBorder title = new TitledBorder(null, s, 4, 2, null, null);
        title.setTitleFont(new Font("SansSerif", 1, 14));
        return title;
    }

    private JCheckBox addCheckBoxRow(String name, String tip, boolean value, JPanel parent) {
        JCheckBox checkBox = new JCheckBox(name);
        checkBox.setEnabled(true);
        checkBox.addItemListener(this);
        checkBox.setToolTipText(tip);
        parent.add(checkBox);
        if (value) {
            checkBox.setSelected(true);
        } else {
            checkBox.setSelected(false);
        }
        return checkBox;
    }

    private JTextField addSettingsRow(JPanel column, int length, String name, String tip, String value) {
        JPanel panel = new JPanel();
        column.add(panel);
        panel.setLayout(new GridLayout(1, 2, 5, 5));
        JLabel lblDisplayModuleFont = new JLabel(name);
        lblDisplayModuleFont.setToolTipText(tip);
        panel.add(lblDisplayModuleFont);
        JTextField textField = new JTextField(value);
        panel.add(textField);
        textField.setColumns(length);
        textField.addActionListener(this);
        textField.addFocusListener(this);
        return textField;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnCancel) {
            this.dispose();
        }
        if (e.getSource() == this.btnSave) {
            boolean dispose = true;
            boolean refreshTabs = false;
            String testString = Config.spacecraftDir;
            if (!testString.equalsIgnoreCase(this.txtMasterFileDirectory.getText())) {
                File file = new File(this.txtMasterFileDirectory.getText());
                if (!file.isDirectory() || file == null || !file.exists()) {
                    Log.errorDialog("Invalid directory", "Can not find the specified MASTER file directory: " + this.txtMasterFileDirectory.getText());
                    dispose = false;
                } else {
                    Object[] options = new Object[]{"Yes", "No"};
                    int n = JOptionPane.showOptionDialog(MainWindow.frame, "Do you want to switch MASTER spacecraft directories? You must restart the program to reload the spacecraft.  Unsaved changes will be lost.", "Do you want to continue?", 0, 3, null, options, options[1]);
                    if (n == 0) {
                        String txt;
                        Config.editorSpacecraftDir = txt = this.txtMasterFileDirectory.getText();
                        Config.spacecraftDir = txt;
                        Log.println("Setting MASTER directory to: " + Config.spacecraftDir);
                        SpacecraftEditorWindow.displayDirs();
                        Config.initSatelliteManager();
                    }
                }
            }
            if (!Config.logFileDirectory.equalsIgnoreCase(this.txtLogFileDirectory.getText())) {
                boolean currentDir = false;
                if (this.txtLogFileDirectory.getText().equalsIgnoreCase("")) {
                    currentDir = true;
                }
                File file = new File(this.txtLogFileDirectory.getText());
                if (!(currentDir || file.isDirectory() && file != null && file.exists())) {
                    Log.errorDialog("Invalid directory", "Can not find the specified directory: " + this.txtLogFileDirectory.getText());
                    dispose = false;
                } else {
                    Object[] options = new Object[]{"Yes", "No"};
                    int n = JOptionPane.showOptionDialog(MainWindow.frame, "Do you want to switch log file directories? You must restart the program to reload the spacecraft.  Unsaved changes will be lost.", "Do you want to continue?", 0, 3, null, options, options[1]);
                    if (n == 0) {
                        Config.logFileDirectory = this.txtLogFileDirectory.getText();
                        Log.println("Setting log file directory to: " + Config.logFileDirectory);
                        Config.initSatelliteManager();
                        refreshTabs = true;
                    }
                }
            }
            Config.logging = this.cbLogging.isSelected();
            Config.python = this.txtPython.getText();
            if (!this.txtPayloadHeaderGenScript.getText().equalsIgnoreCase("")) {
                File script = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + this.txtPayloadHeaderGenScript.getText());
                if (script.exists()) {
                    Config.payloadHeaderGenScript = this.txtPayloadHeaderGenScript.getText();
                } else {
                    Log.errorDialog("ERROR", "Make sure the header generation script is in this folder:\n" + System.getProperty("user.dir"));
                }
            } else {
                Config.payloadHeaderGenScript = this.txtPayloadHeaderGenScript.getText();
            }
            if (dispose) {
                Config.save();
                this.dispose();
            }
        }
        if (e.getSource() == this.btnBrowse) {
            File initialdir = null;
            if (!Config.logFileDirectory.equalsIgnoreCase("")) {
                initialdir = new File(Config.logFileDirectory);
            }
            String dir = this.pickDir(initialdir);
            this.txtLogFileDirectory.setText(dir);
        }
        if (e.getSource() == this.btnBrowseMaster) {
            File initialdir = null;
            if (!Config.spacecraftDir.equalsIgnoreCase("")) {
                initialdir = new File(Config.spacecraftDir);
            }
            String dir = this.pickDir(initialdir);
            this.txtMasterFileDirectory.setText(dir);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String pickDir(File dir) {
        if (Config.isMacOs()) {
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            FileDialog fd = new FileDialog((Dialog)this, "Choose Directory", 0);
            if (dir != null) {
                fd.setDirectory(dir.getAbsolutePath());
            }
            fd.setVisible(true);
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
            String filename = fd.getFile();
            String dirname = fd.getDirectory();
            if (filename == null) {
                Log.println("You cancelled the choice");
                return "";
            }
            Log.println("File: " + filename);
            Log.println("DIR: " + dirname);
            File selectedFile = new File(String.valueOf(dirname) + filename);
            return selectedFile.getAbsolutePath();
        }
        JFileChooser fc = new JFileChooser();
        fc.setApproveButtonText("Choose");
        if (dir != null) {
            fc.setCurrentDirectory(dir);
        }
        fc.setDialogTitle("Choose Directory");
        fc.setFileSelectionMode(1);
        fc.setPreferredSize(new Dimension(Config.windowFcWidth, Config.windowFcHeight));
        int returnVal = fc.showOpenDialog(this);
        Config.windowFcHeight = fc.getHeight();
        Config.windowFcWidth = fc.getWidth();
        if (returnVal == 0) {
            return fc.getSelectedFile().getAbsolutePath();
        }
        System.out.println("No Selection ");
        return "";
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
        this.saveProperties();
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }
}

