/*
 * Decompiled with CFR 0.152.
 */
package spacecraftEditor;

import common.Config;
import common.Log;
import common.Spacecraft;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class InitalEditorSettings
extends JDialog
implements ActionListener,
WindowListener {
    private JPanel contentPane;
    private JPanel directories;
    private JTextField txtLogFileDirectory;
    private JTextField txtMasterFileDirectory;
    JLabel title;
    JLabel lab;
    JLabel lab2;
    JLabel lab3;
    JLabel lab4;
    JLabel lab5;
    JLabel lab6;
    JLabel lab7;
    JLabel lab8;
    JButton btnContinue;
    JButton btnCancel;
    JButton btnBrowse;
    JButton btnBrowseMaster;

    public InitalEditorSettings(JFrame owner, boolean modal) {
        super((Frame)owner, modal);
        this.setTitle("Welcome to the Amsat Spacecraft MASTER file editor");
        this.setDefaultCloseOperation(0);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        JPanel top = new JPanel();
        this.contentPane.add((Component)top, "North");
        JPanel center = new JPanel();
        this.contentPane.add((Component)center, "Center");
        JPanel bottom = new JPanel();
        this.contentPane.add((Component)bottom, "South");
        top.setLayout(new BorderLayout(0, 0));
        this.title = new JLabel();
        this.title.setFont(new Font("SansSerif", 1, 14));
        this.title.setText("AMSAT Editor");
        JPanel titlePanel = new JPanel();
        top.add((Component)titlePanel, "North");
        titlePanel.add(this.title);
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BoxLayout(textPanel, 1));
        top.add((Component)textPanel, "Center");
        this.addLabel("It looks like this is the first time you have run the editor. You must choose the directories where the files and data are stored", textPanel);
        this.addLabel(" ", textPanel);
        this.addLabel("The MASTER folder holds the spacecraft directory.  This is where the spacecraft MASTER files are stored.  ", textPanel);
        this.addLabel("This is usually the spacecraft directory where FoxTelem is installed, but you can edit spacecraft ", textPanel);
        this.addLabel("files in another directory if you wish.  But note that requires copying all the needed files to that folder.", textPanel);
        this.addLabel(" ", textPanel);
        this.addLabel("You must also choose a working directory to store runtime files and keep track of the loaded spacecraft. FoxTelem ", textPanel);
        this.addLabel("calls this the 'log files directory'.  Usually it is different to the directory where the MASTER spacecraft files are stored.", textPanel);
        this.addLabel(" ", textPanel);
        this.addLabel("Choose the directories below.  See the manual for details.", textPanel);
        this.addLabel(" ", textPanel);
        center.setLayout(new BoxLayout(center, 1));
        JPanel masterFiles = this.MasterFilesPanel();
        center.add(masterFiles);
        this.directories = this.FilesPanel();
        center.add(this.directories);
        this.addLabel("Configuration settings will be saved in:  " + Config.homeDirectory, center);
        bottom.setLayout(new FlowLayout(1, 5, 5));
        this.btnContinue = new JButton("Continue");
        this.btnContinue.addActionListener(this);
        bottom.add(this.btnContinue);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.addActionListener(this);
        bottom.add(this.btnCancel);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void addLabel(String text, JPanel panel) {
        JLabel lbl = new JLabel(text);
        panel.add(lbl);
    }

    private JPanel MasterFilesPanel() {
        JPanel northpanel = new JPanel();
        northpanel.setLayout(new BorderLayout());
        JLabel lblDisplayModuleFont = new JLabel("MASTER files directory");
        lblDisplayModuleFont.setBorder(new EmptyBorder(5, 2, 5, 5));
        northpanel.add((Component)lblDisplayModuleFont, "West");
        this.txtMasterFileDirectory = new JTextField(String.valueOf(System.getProperty("user.dir")) + File.separator + Spacecraft.SPACECRAFT_DIR);
        northpanel.add((Component)this.txtMasterFileDirectory, "Center");
        this.txtMasterFileDirectory.setColumns(30);
        this.txtMasterFileDirectory.addActionListener(this);
        this.btnBrowseMaster = new JButton("Browse");
        this.btnBrowseMaster.addActionListener(this);
        northpanel.add((Component)this.btnBrowseMaster, "East");
        return northpanel;
    }

    private JPanel FilesPanel() {
        JPanel northpanel = new JPanel();
        northpanel.setLayout(new BorderLayout());
        JLabel lblDisplayModuleFont = new JLabel("Log files directory");
        lblDisplayModuleFont.setBorder(new EmptyBorder(5, 2, 5, 5));
        northpanel.add((Component)lblDisplayModuleFont, "West");
        this.txtLogFileDirectory = new JTextField(Config.logFileDirectory);
        northpanel.add((Component)this.txtLogFileDirectory, "Center");
        this.txtLogFileDirectory.setColumns(30);
        this.txtLogFileDirectory.addActionListener(this);
        this.btnBrowse = new JButton("Browse");
        this.btnBrowse.addActionListener(this);
        northpanel.add((Component)this.btnBrowse, "East");
        return northpanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String dir;
        if (e.getSource() == this.btnCancel) {
            System.exit(1);
        }
        if (e.getSource() == this.btnContinue) {
            this.saveAndExit();
        }
        if (e.getSource() == this.btnBrowse) {
            dir = this.pickDir();
            this.txtLogFileDirectory.setText(dir);
        }
        if (e.getSource() == this.btnBrowseMaster) {
            dir = this.pickDir();
            this.txtMasterFileDirectory.setText(dir);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String pickDir() {
        File dir = null;
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            dir = new File(Config.logFileDirectory);
        }
        if (Config.isMacOs()) {
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            FileDialog fd = new FileDialog((Dialog)this, "Choose Directory", 0);
            if (dir != null) {
                fd.setDirectory(dir.getAbsolutePath());
            }
            fd.setVisible(true);
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
            String filename = fd.getFile();
            String dirname = fd.getDirectory();
            if (filename == null) {
                Log.println("You cancelled the choice");
                return "";
            }
            Log.println("File: " + filename);
            Log.println("DIR: " + dirname);
            File selectedFile = new File(String.valueOf(dirname) + filename);
            return selectedFile.getAbsolutePath();
        }
        JFileChooser fc = new JFileChooser();
        fc.setApproveButtonText("Choose");
        if (dir != null) {
            fc.setCurrentDirectory(dir);
        }
        fc.setDialogTitle("Choose Directory");
        fc.setFileSelectionMode(1);
        fc.setPreferredSize(new Dimension(Config.windowFcWidth, Config.windowFcHeight));
        int returnVal = fc.showOpenDialog(this);
        Config.windowFcHeight = fc.getHeight();
        Config.windowFcWidth = fc.getWidth();
        if (returnVal == 0) {
            return fc.getSelectedFile().getAbsolutePath();
        }
        System.out.println("No Selection ");
        return "";
    }

    void saveAndExit() {
        File file;
        Config.FIRST_RUN = false;
        Config.firstRun106 = false;
        if (!Config.logFileDirectory.equalsIgnoreCase(this.txtLogFileDirectory.getText())) {
            file = new File(this.txtLogFileDirectory.getText());
            if (!file.isDirectory() || file == null || !file.exists()) {
                Log.errorDialog("Invalid directory", "Can not find the specified directory: " + this.txtLogFileDirectory.getText());
            } else {
                Config.logFileDirectory = this.txtLogFileDirectory.getText();
                this.dispose();
            }
        }
        if (!Config.editorSpacecraftDir.equalsIgnoreCase(this.txtMasterFileDirectory.getText())) {
            file = new File(this.txtMasterFileDirectory.getText());
            if (!file.isDirectory() || file == null || !file.exists()) {
                Log.errorDialog("Invalid directory", "Can not find the specified directory: " + this.txtMasterFileDirectory.getText());
            } else {
                Config.editorSpacecraftDir = this.txtMasterFileDirectory.getText();
                this.dispose();
            }
        }
        this.dispose();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

