/*
 * Decompiled with CFR 0.152.
 */
package spacecraftEditor;

import common.Config;
import common.Log;
import common.Spacecraft;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import spacecraftEditor.SpacecraftEditPanel;
import spacecraftEditor.listEditors.curves.CurveCsvFileEditPanel;
import spacecraftEditor.listEditors.curves.CurvesTableModel;
import spacecraftEditor.listEditors.expressions.ExpressionsCsvFileEditPanel;
import spacecraftEditor.listEditors.expressions.ExpressionsTableModel;
import spacecraftEditor.listEditors.frames.FrameListEditPanel;
import spacecraftEditor.listEditors.lookupTables.LookupListTableModel;
import spacecraftEditor.listEditors.lookupTables.LookupTableListEditPanel;
import spacecraftEditor.listEditors.lookupTables.LookupTableModel;
import spacecraftEditor.listEditors.payload.PayloadListEditPanel;
import spacecraftEditor.listEditors.stringLookupTables.StringLookupTableListEditPanel;
import telemetry.SatPayloadStore;

public class SpacecraftEditTab
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String CURVES_TEMPLATE_FILENAME = "CURVES_template.csv";
    public static final String MATH_EXPRESSIONS_TEMPLATE_FILENAME = "MATH_EXPRESSIONS_template.csv";
    Spacecraft sat;
    JTabbedPane tabbedPane;
    SpacecraftEditPanel spacecraftEditPanel;

    public SpacecraftEditTab(Spacecraft s) {
        ExpressionsCsvFileEditPanel expressionsCsvFileEdit;
        CurveCsvFileEditPanel csvFileEdit;
        this.sat = s;
        this.setLayout(new BorderLayout(0, 0));
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setTabLayoutPolicy(1);
        this.add((Component)this.tabbedPane, "Center");
        this.spacecraftEditPanel = new SpacecraftEditPanel(this.sat);
        this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1><b>Parameters</b></body></html>", this.spacecraftEditPanel);
        PayloadListEditPanel payloadListEditPanel = new PayloadListEditPanel(this.sat, this.spacecraftEditPanel);
        this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1><b>Payloads</b></body></html>", payloadListEditPanel);
        FrameListEditPanel frameListEditPanel = new FrameListEditPanel(this.sat, this.spacecraftEditPanel);
        this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1><b>Frames</b></body></html>", frameListEditPanel);
        CurvesTableModel model = new CurvesTableModel();
        String f = this.sat.conversionCurvesFileName;
        if (f == null) {
            String targetFilename = "";
            File sourceFile = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + Spacecraft.SPACECRAFT_DIR + File.separator + "templates" + File.separator + CURVES_TEMPLATE_FILENAME);
            File targetFile = new File(String.valueOf(Config.spacecraftDir) + File.separator + CURVES_TEMPLATE_FILENAME);
            try {
                SatPayloadStore.copyFile(sourceFile, targetFile);
                targetFilename = targetFile.getName();
            }
            catch (IOException e) {
                Log.errorDialog("ERROR", "Could not load CURVES template" + e);
                e.printStackTrace(Log.getWriter());
            }
            csvFileEdit = new CurveCsvFileEditPanel(this.sat, model, "Curves", targetFilename);
            csvFileEdit.setFilenameText("");
        } else {
            csvFileEdit = new CurveCsvFileEditPanel(this.sat, model, "Curves", f);
        }
        this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1><b>Conversion Curves</b></body></html>", csvFileEdit);
        ExpressionsTableModel expressionsModel = new ExpressionsTableModel();
        String expFile = this.sat.conversionExpressionsFileName;
        if (expFile == null) {
            String targetFilename = "";
            File sourceFile = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + Spacecraft.SPACECRAFT_DIR + File.separator + "templates" + File.separator + MATH_EXPRESSIONS_TEMPLATE_FILENAME);
            File targetFile = new File(String.valueOf(Config.spacecraftDir) + File.separator + MATH_EXPRESSIONS_TEMPLATE_FILENAME);
            try {
                SatPayloadStore.copyFile(sourceFile, targetFile);
                targetFilename = targetFile.getName();
            }
            catch (IOException e) {
                Log.errorDialog("ERROR", "Could not load CURVES template" + e);
                e.printStackTrace(Log.getWriter());
            }
            expressionsCsvFileEdit = new ExpressionsCsvFileEditPanel(this.sat, expressionsModel, "Expressions", targetFilename);
            expressionsCsvFileEdit.setFilenameText("");
        } else {
            expressionsCsvFileEdit = new ExpressionsCsvFileEditPanel(this.sat, expressionsModel, "Expressions", expFile);
        }
        this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1><b>Math Expressions</b></body></html>", expressionsCsvFileEdit);
        LookupListTableModel lookupListTableModel = new LookupListTableModel();
        LookupTableModel lookupTableModel = new LookupTableModel();
        LookupTableListEditPanel lookupTableListEditPanel = new LookupTableListEditPanel(this.sat, "Lookup Tables", lookupListTableModel, lookupTableModel, this.spacecraftEditPanel);
        this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1><b>Lookup Tables</b></body></html>", lookupTableListEditPanel);
        LookupListTableModel stringLookupListTableModel = new LookupListTableModel();
        LookupTableModel stringLookupTableModel = new LookupTableModel();
        StringLookupTableListEditPanel stringLookupTableListEditPanel = new StringLookupTableListEditPanel(this.sat, "String Lookup Tables", stringLookupListTableModel, stringLookupTableModel, this.spacecraftEditPanel);
        this.tabbedPane.addTab("<html><body leftmargin=1 topmargin=1 marginwidth=1 marginheight=1><b>String Lookup Tables</b></body></html>", stringLookupTableListEditPanel);
    }
}

