/*
 * Decompiled with CFR 0.152.
 */
package spacecraftEditor;

import common.Config;
import common.Log;
import common.Spacecraft;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class TextEditorFrame
extends JFrame
implements ActionListener,
WindowListener {
    private static final long serialVersionUID = 1L;
    Spacecraft spacecraft;
    boolean editable;
    private JTextArea ta;
    private JMenuBar menuBar;
    private JMenu fileM;
    private JMenu editM;
    private JScrollPane scpane;
    private JMenuItem cancelI;
    private JMenuItem cutI;
    private JMenuItem copyI;
    private JMenuItem pasteI;
    private JMenuItem selectI;
    private JMenuItem saveI;
    private JMenuItem statusI;
    private String pad;
    private JToolBar toolBar;
    private String filename;
    JPanel textPane;
    JPanel centerpane;
    public static final String EDIT_WINDOW_X = "edit_window_x";
    public static final String EDIT_WINDOW_Y = "edit_window_y";
    public static final String EDIT_WINDOW_WIDTH = "edit_window_width";
    public static final String EDIT_WINDOW_HEIGHT = "edit_window_height";

    public TextEditorFrame(Spacecraft spacecraft, String filename) {
        super("Message Editor");
        this.spacecraft = spacecraft;
        this.filename = filename;
        this.editable = true;
        this.makeFrame(this.editable);
        this.addTextArea();
        if (filename != null) {
            this.setTitle(filename);
            try {
                byte[] encoded = Files.readAllBytes(Paths.get(filename, new String[0]));
                String text = new String(encoded, StandardCharsets.US_ASCII);
                this.ta.setText(text);
            }
            catch (IOException e) {
                Log.errorDialog("ERROR", "Could not open the file: " + filename);
            }
        }
    }

    private void makeFrame(boolean edit) {
        this.addWindowListener(this);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/pacsat.jpg")));
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.loadProperties();
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.pad = " ";
        this.menuBar = new JMenuBar();
        this.fileM = new JMenu("File");
        this.editM = new JMenu("Edit");
        this.cancelI = new JMenuItem("Exit");
        this.cutI = new JMenuItem("Cut");
        this.copyI = new JMenuItem("Copy");
        this.pasteI = new JMenuItem("Paste");
        this.selectI = new JMenuItem("Select All");
        this.saveI = new JMenuItem("Save");
        this.statusI = new JMenuItem("Status");
        this.toolBar = new JToolBar();
        this.setJMenuBar(this.menuBar);
        this.menuBar.add(this.fileM);
        this.menuBar.add(this.editM);
        this.fileM.add(this.saveI);
        this.fileM.add(this.cancelI);
        this.saveI.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.cancelI.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.editM.add(this.cutI);
        this.editM.add(this.copyI);
        this.editM.add(this.pasteI);
        this.editM.add(this.selectI);
        this.cutI.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.copyI.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.pasteI.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.selectI.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Cancel");
        this.getRootPane().getActionMap().put("Cancel", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TextEditorFrame.this.dispose();
            }
        });
        this.centerpane = new JPanel();
        pane.add((Component)this.centerpane, "Center");
        this.centerpane.setLayout(new BorderLayout());
        this.textPane = new JPanel();
        this.textPane.setLayout(new BorderLayout());
        this.centerpane.add((Component)this.textPane, "Center");
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        pane.add((Component)topPanel, "North");
        JPanel buttonBar = new JPanel();
        buttonBar.setLayout(new FlowLayout(0));
        topPanel.add((Component)buttonBar, "North");
        pane.add((Component)this.toolBar, "South");
        this.saveI.addActionListener(this);
        this.cancelI.addActionListener(this);
        this.cutI.addActionListener(this);
        this.copyI.addActionListener(this);
        this.pasteI.addActionListener(this);
        this.selectI.addActionListener(this);
        this.statusI.addActionListener(this);
        this.setVisible(true);
    }

    private void addTextArea() {
        this.ta = new JTextArea();
        this.scpane = new JScrollPane(this.ta);
        this.ta.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.ta.setLineWrap(true);
        this.ta.setWrapStyleWord(true);
        this.ta.setEditable(this.editable);
        this.ta.setVisible(true);
        this.textPane.add((Component)this.scpane, "Center");
    }

    public void saveProperties() {
        Config.saveGraphIntParam("Global", 0, 0, "spacecraftEditorFrame", "windowHeight", this.getHeight());
        Config.saveGraphIntParam("Global", 0, 0, "spacecraftEditorFrame", "windowWidth", this.getWidth());
        Config.saveGraphIntParam("Global", 0, 0, "spacecraftEditorFrame", "windowX", this.getX());
        Config.saveGraphIntParam("Global", 0, 0, "spacecraftEditorFrame", "windowY", this.getY());
    }

    public void loadProperties() {
        int windowX = Config.loadGraphIntValue("Global", 0, 0, "spacecraftEditorFrame", "windowX");
        int windowY = Config.loadGraphIntValue("Global", 0, 0, "spacecraftEditorFrame", "windowY");
        int windowWidth = Config.loadGraphIntValue("Global", 0, 0, "spacecraftEditorFrame", "windowWidth");
        int windowHeight = Config.loadGraphIntValue("Global", 0, 0, "spacecraftEditorFrame", "windowHeight");
        if (windowX == 0 || windowY == 0 || windowWidth == 0 || windowHeight == 0) {
            this.setBounds(100, 100, 600, 700);
        } else {
            this.setBounds(windowX, windowY, windowWidth, windowHeight);
        }
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
        this.saveProperties();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.saveI) {
            try {
                this.saveFile(this.filename);
            }
            catch (IOException e1) {
                Log.errorDialog("ERROR", "Could not save the file");
            }
        }
        if (e.getSource() == this.cancelI) {
            this.dispose();
        } else if (e.getSource() == this.cutI) {
            this.pad = this.ta.getSelectedText();
            this.ta.replaceRange("", this.ta.getSelectionStart(), this.ta.getSelectionEnd());
        } else if (e.getSource() == this.copyI) {
            this.pad = this.ta.getSelectedText();
        } else if (e.getSource() == this.pasteI) {
            this.ta.insert(this.pad, this.ta.getCaretPosition());
        } else if (e.getSource() == this.selectI) {
            this.ta.selectAll();
        } else {
            e.getSource();
        }
    }

    private void saveFile(String filename) throws FileNotFoundException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (PrintWriter out = new PrintWriter(filename);){
            out.print(this.ta.getText());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

