/*
 * Decompiled with CFR 0.152.
 */
package telemServer;

import common.Log;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public class ServerConfig {
    public static Properties properties;
    public static final String propertiesFileName = "FoxTelemServer.properties";
    public static ArrayList<String> trustedGroundStations;
    public static final String TRUSTED_GROUNDSTATION_FILENAME = "trusted_ground_stations.txt";
    public static boolean slowSpeedRsDecode;
    public static boolean highSpeedRsDecode;
    public static int socketReadTimeout;
    public static int newResetCheckThreshold;
    public static int newResetCheckUptimeMax;
    public static int groundStationClockThreshold;
    public static int realTimeReceptionThreshold;
    public static boolean debugResetCheck;

    static {
        slowSpeedRsDecode = true;
        highSpeedRsDecode = true;
        socketReadTimeout = 1000;
        newResetCheckThreshold = 30;
        newResetCheckUptimeMax = 15000;
        groundStationClockThreshold = 60;
        realTimeReceptionThreshold = 30;
        debugResetCheck = true;
    }

    public static void init() {
        properties = new Properties();
        try {
            ServerConfig.loadTrustedGroundStations();
        }
        catch (IOException e) {
            Log.alert("FATAL: Cannot load the trusted stations list: " + e);
        }
        ServerConfig.load();
    }

    public static boolean isTrustedGroundStation(String groundStation) {
        for (String station : trustedGroundStations) {
            if (!station.equalsIgnoreCase(groundStation)) continue;
            return true;
        }
        return false;
    }

    private static void loadTrustedGroundStations() throws IOException {
        trustedGroundStations = new ArrayList();
        BufferedReader bufReader = new BufferedReader(new FileReader(TRUSTED_GROUNDSTATION_FILENAME));
        String line = bufReader.readLine();
        while (line != null) {
            trustedGroundStations.add(line);
            line = bufReader.readLine();
        }
        bufReader.close();
    }

    public static void save() {
        properties.setProperty("slowSpeedRsDecode", Boolean.toString(slowSpeedRsDecode));
        properties.setProperty("highSpeedRsDecode", Boolean.toString(highSpeedRsDecode));
        properties.setProperty("socketReadTimeout", Integer.toString(socketReadTimeout));
        properties.setProperty("newResetCheckThreshold", Integer.toString(newResetCheckThreshold));
        properties.setProperty("newResetCheckUptimeMax", Integer.toString(newResetCheckUptimeMax));
        properties.setProperty("groundStationClockThreshold", Integer.toString(groundStationClockThreshold));
        properties.setProperty("debugResetCheck", Boolean.toString(debugResetCheck));
        properties.setProperty("realTimeReceptionThreshold", Integer.toString(realTimeReceptionThreshold));
        ServerConfig.store();
    }

    private static void store() {
        try {
            FileOutputStream fos = new FileOutputStream(propertiesFileName);
            properties.store(fos, "Fox 1 Telemetry Decoder Properties");
            fos.close();
        }
        catch (FileNotFoundException e1) {
            Log.errorDialog("ERROR", "Could not write properties file. Check permissions on directory or on the file\nFoxTelemServer.properties");
            e1.printStackTrace(Log.getWriter());
        }
        catch (IOException e1) {
            Log.errorDialog("ERROR", "Error writing properties file");
            e1.printStackTrace(Log.getWriter());
        }
    }

    private static String getProperty(String key) {
        String value = properties.getProperty(key);
        if (value == null) {
            throw new NullPointerException();
        }
        return value;
    }

    public static void load() {
        try {
            FileInputStream fis = new FileInputStream(propertiesFileName);
            properties.load(fis);
            fis.close();
        }
        catch (IOException e) {
            Log.println("Writing Default properties file");
            ServerConfig.save();
        }
        try {
            slowSpeedRsDecode = Boolean.parseBoolean(ServerConfig.getProperty("slowSpeedRsDecode"));
            highSpeedRsDecode = Boolean.parseBoolean(ServerConfig.getProperty("highSpeedRsDecode"));
            socketReadTimeout = Integer.parseInt(ServerConfig.getProperty("socketReadTimeout"));
            newResetCheckThreshold = Integer.parseInt(ServerConfig.getProperty("newResetCheckThreshold"));
            newResetCheckUptimeMax = Integer.parseInt(ServerConfig.getProperty("newResetCheckUptimeMax"));
            groundStationClockThreshold = Integer.parseInt(ServerConfig.getProperty("groundStationClockThreshold"));
            debugResetCheck = Boolean.parseBoolean(ServerConfig.getProperty("debugResetCheck"));
            realTimeReceptionThreshold = Integer.parseInt(ServerConfig.getProperty("realTimeReceptionThreshold"));
        }
        catch (NumberFormatException nf) {
            Log.println("FATAL: Could not load properties: " + nf.getMessage());
            System.exit(1);
        }
        catch (NullPointerException nf) {
            Log.println("FATAL: Could not load properties: " + nf.getMessage());
            System.exit(1);
        }
        Log.println("LOADED: FoxTelemServer.properties");
    }
}

