/*
 * Decompiled with CFR 0.152.
 */
package telemStream;

import common.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import telemetry.FramePart;
import telemetry.PayloadDbStore;
import telemetry.uw.PcanPacket;
import telemetry.uw.UwCanPacket;

@Deprecated
public class StreamProcess
implements Runnable {
    public static final int REFRESH_PERIOD = 1000;
    public static final int HEARTBEAT_PERIOD = 60;
    int heartBeatCount = 0;
    public static final String GUEST = "guest";
    public static final String GUEST_PASSWORD = "amsat";
    public static final int TIMEOUT_CONNECTION = 5000;
    static HashMap<String, Boolean> connectedUsers = new HashMap();
    byte[] heartBeatPacket;
    String u;
    String p;
    String db;
    private Socket socket = null;
    public static final DateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss", Locale.ENGLISH);

    public StreamProcess(String u, String p, String db, Socket socket) {
        this.socket = socket;
        this.u = u;
        this.p = p;
        this.db = db;
    }

    @Override
    public void run() {
        Log.println("Started Thread to handle connection from: " + this.socket.getInetAddress());
        Date now = new Date();
        byte[] data = new byte[8];
        PcanPacket heartBeat = new PcanPacket(now, 6, 0, 0L, 0, 0, 0, data);
        this.heartBeatPacket = heartBeat.getBytes();
        InputStream in = null;
        OutputStream out = null;
        try {
            this.socket.setSoTimeout(5000);
            in = this.socket.getInputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(in));
            String username = input.readLine();
            String password = input.readLine();
            String spacecraft_id = input.readLine();
            int id = 0;
            try {
                id = Integer.parseInt(spacecraft_id);
            }
            catch (NumberFormatException e) {
                Log.println("Rejected invalid FoxId: " + spacecraft_id);
                spacecraft_id = null;
            }
            if (id != 6) {
                Log.println("Invalid FoxId for streaming: Connection closed");
                return;
            }
            try {
                out = this.socket.getOutputStream();
                if (username != null && password != null && spacecraft_id != null) {
                    if (username.equalsIgnoreCase(GUEST)) {
                        try {
                            this.streamTelemetry(username, password, id, out, input);
                        }
                        catch (SQLException e) {
                            Log.println("ERROR: with SQL TRANS" + e.getMessage());
                            e.printStackTrace(Log.getWriter());
                        }
                    } else {
                        if (connectedUsers.containsKey(username)) {
                            Log.println(String.valueOf(username) + " already logged in: Connection being closed");
                            connectedUsers.put(username, false);
                        } else {
                            connectedUsers.put(username, true);
                        }
                        try {
                            while (connectedUsers.get(username) != null && !connectedUsers.get(username).booleanValue()) {
                            }
                            if (connectedUsers.get(username) == null) {
                                connectedUsers.put(username, true);
                            }
                            this.streamTelemetry(username, password, id, out, input);
                        }
                        catch (SQLException e) {
                            Log.println("ERROR: with SQL TRANS" + e.getMessage());
                            e.printStackTrace(Log.getWriter());
                        }
                    }
                }
                in.close();
                out.close();
                this.socket.close();
                if (username != null && !username.equalsIgnoreCase(GUEST)) {
                    if (!connectedUsers.get(username).booleanValue()) {
                        connectedUsers.put(username, true);
                    } else {
                        connectedUsers.remove(username);
                    }
                }
                Log.println("Connection closed to: " + username + " " + this.socket.getInetAddress());
            }
            catch (SocketException e) {
                Log.println("SOCKET EXCEPTION: " + e.getMessage());
            }
            catch (IOException e) {
                Log.println("IO ERROR:" + e.getMessage());
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
            try {
                this.socket.close();
            }
            catch (Exception exception) {}
        }
    }

    private void streamTelemetry(String user, String pass, int sat, OutputStream out, BufferedReader in) throws SQLException {
        boolean streaming = true;
        this.heartBeatCount = 0;
        PayloadDbStore payloadDbStore = null;
        try {
            payloadDbStore = new PayloadDbStore(this.u, this.p, this.db);
            if (!this.validLogin(payloadDbStore, user, pass)) {
                Log.println(String.valueOf(user) + ": Invalid Login for streaming: Connection closed");
                return;
            }
            Log.println(String.valueOf(user) + ":Logged in for streaming..");
            UwCanPacket lastCan = payloadDbStore.getLatestUwCanPacket(sat);
            int lastPktId = lastCan.getFoxId() == 0 ? 0 : (user.equalsIgnoreCase(GUEST) ? lastCan.pkt_id : payloadDbStore.getLastCanId(sat, user));
            Log.println(String.valueOf(user) + ":Last CAN ID: " + lastPktId);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            while (streaming) {
                String where = "where pkt_id > '" + lastPktId + "'";
                payloadDbStore.derby.setAutoCommit(false);
                ArrayList<FramePart> canPacketsList = payloadDbStore.selectCanPackets(sat, where);
                int prevPktId = lastPktId;
                int count = 0;
                if (canPacketsList.size() > 0) {
                    Log.println(String.valueOf(user) + ": ready to send: " + canPacketsList.size());
                }
                for (FramePart can : canPacketsList) {
                    block30: {
                        Date captureDate;
                        try {
                            captureDate = dateFormat.parse(can.getCaptureDate());
                        }
                        catch (ParseException e) {
                            Log.println(String.valueOf(user) + ":ERROR: Could not parse captureDate.  Setting to current time: " + can.id + " " + can.resets + ":" + can.uptime + " " + can.getType());
                            captureDate = Calendar.getInstance().getTime();
                        }
                        PcanPacket pc = ((UwCanPacket)can).getPCanPacket(captureDate);
                        byte[] bytes = pc.getBytes();
                        if (user.equalsIgnoreCase(GUEST) || connectedUsers.get(user) != null && connectedUsers.get(user).booleanValue()) {
                            try {
                                out.write(bytes);
                                out.flush();
                                break block30;
                            }
                            catch (IOException e) {
                                streaming = false;
                                if (count > 0) {
                                    --count;
                                }
                                lastPktId = prevPktId;
                                if (user.equalsIgnoreCase(GUEST)) break;
                                payloadDbStore.storeLastCanId(sat, user, lastPktId);
                                break;
                            }
                        }
                        streaming = false;
                    }
                    try {
                        String resp = in.readLine();
                        if (resp != null && resp.equalsIgnoreCase("ACK")) {
                            ++count;
                            this.heartBeatCount = 0;
                            lastCan = (UwCanPacket)can;
                            prevPktId = lastPktId;
                            lastPktId = lastCan.pkt_id;
                            if (user.equalsIgnoreCase(GUEST)) continue;
                            payloadDbStore.storeLastCanId(sat, user, lastPktId);
                            continue;
                        }
                        streaming = false;
                    }
                    catch (IOException e) {
                        streaming = false;
                    }
                    break;
                }
                if (count > 0) {
                    Log.println(String.valueOf(user) + ": Sent: " + count + " CAN packets to: " + this.socket.getInetAddress());
                }
                payloadDbStore.derby.commit();
                if (!(user.equalsIgnoreCase(GUEST) || connectedUsers.get(user) != null && connectedUsers.get(user).booleanValue())) {
                    streaming = false;
                    Log.println(String.valueOf(user) + ": kicked out..");
                }
                if (!streaming) continue;
                if (this.heartBeatCount >= 60) {
                    boolean alive = this.sendHeartBeat(user, out, in);
                    if (!alive) {
                        streaming = false;
                    }
                    this.heartBeatCount = 0;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (payloadDbStore != null) {
                    payloadDbStore.closeConnection();
                }
            }
            catch (Exception exception) {}
        }
    }

    private boolean sendHeartBeat(String user, OutputStream out, BufferedReader in) {
        block5: {
            Log.print(String.valueOf(user) + ": HEARTBEAT ..");
            try {
                out.write(this.heartBeatPacket);
                out.flush();
            }
            catch (IOException e) {
                Log.println(String.valueOf(user) + " DEAD");
                return false;
            }
            try {
                String resp = in.readLine();
                if (resp == null || !resp.equalsIgnoreCase("ACK")) break block5;
                Log.println(String.valueOf(user) + " ALIVE");
                return true;
            }
            catch (IOException e) {
                Log.println(String.valueOf(user) + " NO RESPONSE");
                return false;
            }
        }
        Log.println(String.valueOf(user) + " NO ACK..");
        return true;
    }

    private boolean validLogin(PayloadDbStore db, String user, String pass) {
        block32: {
            Statement stmt = null;
            String update = "  SELECT password, salt FROM users where username= '" + user + "'";
            ResultSet r = null;
            try {
                Connection derby = db.getConnection();
                stmt = derby.createStatement();
                r = stmt.executeQuery(update);
                if (r.next()) {
                    String password = r.getString("password");
                    String salt = r.getString("salt");
                    String checkPassword = StreamProcess.get_SHA_256_SecurePassword(pass, salt);
                    return checkPassword.equals(password);
                    {
                    }
                }
                Log.println(String.valueOf(user) + ":Invalid username");
            }
            catch (SQLException e) {
                PayloadDbStore.errorPrint("ERROR Check Password SQL:", e);
                try {
                    r.close();
                    stmt.close();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                break block32;
            }
            finally {
                try {
                    if (r != null) {
                        r.close();
                    }
                }
                catch (SQLException sQLException) {}
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            return false;
        }
        return false;
    }

    private static String get_SHA_256_SecurePassword(String password, String salt) {
        String generatedPassword = null;
        byte[] bytes = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            bytes = digest.digest((String.valueOf(password) + salt).getBytes("UTF-8"));
            int i = 0;
            while (i < 65536) {
                bytes = digest.digest((String.valueOf(StreamProcess.toByteString(bytes)) + salt).getBytes("UTF-8"));
                ++i;
            }
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            return null;
        }
        generatedPassword = StreamProcess.toByteString(bytes);
        return generatedPassword;
    }

    static String toByteString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < bytes.length) {
            sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
            ++i;
        }
        return sb.toString();
    }
}

