/*
 * Decompiled with CFR 0.152.
 */
package telemetry;

import common.Log;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import telemetry.LayoutLoadException;

public class BitArrayLayout {
    public static final String RT = "RT";
    public static final String MAX = "MAX";
    public static final String MIN = "MIN";
    public static final String WOD = "WOD";
    public static final String EXP = "EXP";
    public static final String WOD_EXP = "WOD_EXP";
    public static final String CAN_EXP = "CAN_EXP";
    public static final String CAN_WOD_EXP = "CAN_WOD_EXP";
    public static final String CAN_PKT = "CAN_PKT";
    public static final String WOD_CAN_PKT = "WOD_CAN_PKT";
    public static final String DBG = "DBG";
    public static final String[] types = new String[]{"RT", "MAX", "MIN", "WOD", "EXP", "WOD_EXP", "CAN_EXP", "CAN_WOD_EXP", "CAN_PKT", "WOD_CAN_PKT", "DBG"};
    public int NUMBER_OF_FIELDS = 0;
    public static int ERROR_POSITION = -1;
    public String fileName;
    public String tableName;
    public String name;
    public String parentLayout = null;
    public String secondaryLayout = null;
    public int number;
    public String typeStr = "";
    public String title;
    public String shortTitle;
    public Color color = Color.BLUE;
    public static final String NONE = "NONE";
    public String[] fieldName = null;
    public String[] conversion = null;
    public String[] fieldUnits = null;
    public int[] fieldBitLength = null;
    public String[] module = null;
    public int[] moduleNum = null;
    public int[] moduleLinePosition = null;
    public int[] moduleDisplayType = null;
    public String[] shortName = null;
    public String[] description = null;
    public boolean hasGPSTime = false;
    private int numberOfBits = 0;
    private int numberOfBytes = 0;
    public static final int CONVERT_NONE = 0;
    public static final int CONVERT_INTEGER = 1;
    public static final int CONVERT_V25_SENSOR = 2;
    public static final int CONVERT_V3_SENSOR = 3;
    public static final int CONVERT_BATTERY = 4;
    public static final int CONVERT_SOLAR_PANEL = 5;
    public static final int CONVERT_SOLAR_PANEL_TEMP = 6;
    public static final int CONVERT_TEMP = 7;
    public static final int CONVERT_BATTERY_TEMP = 8;
    public static final int CONVERT_BATTERY_CURRENT = 9;
    public static final int CONVERT_PA_CURRENT = 10;
    public static final int CONVERT_PSU_CURRENT = 11;
    public static final int CONVERT_SPIN = 12;
    public static final int CONVERT_MEMS_ROTATION = 13;
    public static final int CONVERT_RSSI = 14;
    public static final int CONVERT_IHU_TEMP = 15;
    public static final int CONVERT_ANTENNA = 16;
    public static final int CONVERT_STATUS_BIT = 17;
    public static final int CONVERT_IHU_DIAGNOSTIC = 18;
    public static final int CONVERT_HARD_ERROR = 19;
    public static final int CONVERT_SOFT_ERROR = 20;
    public static final int CONVERT_BOOLEAN = 21;
    public static final int CONVERT_MPPT_CURRENT = 22;
    public static final int CONVERT_MPPT_SOLAR_PANEL = 23;
    public static final int CONVERT_MPPT_SOLAR_PANEL_TEMP = 24;
    public static final int CONVERT_16_SEC_UPTIME = 25;
    public static final int CONVERT_FREQ = 26;
    public static final int CONVERT_VULCAN_STATUS = 27;
    public static final int CONVERT_HERCI_HEX = 28;
    public static final int CONVERT_HERCI_SOURCE = 29;
    public static final int CONVERT_HERCI_MICRO_PKT_TYP = 30;
    public static final int CONVERT_HERCI_MICRO_PKT_SOURCE = 31;
    public static final int CONVERT_HERCI_MICRO_PKT_HEX = 32;
    public static final int CONVERT_JAVA_DATE = 33;
    public static final int CONVERT_ICR_SW_COMMAND_COUNT = 34;
    public static final int CONVERT_ICR_DIAGNOSTIC = 35;
    public static final int CONVERT_WOD_STORED = 36;
    public static final int CONVERT_LT_TXRX_TEMP = 37;
    public static final int CONVERT_LT_PA_CURRENT = 38;
    public static final int CONVERT_SOFT_ERROR_84488 = 39;
    public static final int CONVERT_LT_TX_FWD_PWR = 40;
    public static final int CONVERT_LT_TX_REF_PWR = 41;
    public static final int CONVERT_LT_VGA = 42;
    public static final int CONVERT_ICR_VOLT_SENSOR = 43;
    public static final int CONVERT_STATUS_ENABLED = 44;
    public static final int CONVERT_COM1_ACCELEROMETER = 45;
    public static final int CONVERT_COM1_MAGNETOMETER = 46;
    public static final int CONVERT_COM1_SPIN = 47;
    public static final int CONVERT_COM1_GYRO_TEMP = 48;
    public static final int CONVERT_COM1_ISIS_ANT_TEMP = 49;
    public static final int CONVERT_COM1_ISIS_ANT_TIME = 50;
    public static final int CONVERT_COM1_ISIS_ANT_STATUS = 51;
    public static final int CONVERT_COM1_SOLAR_PANEL = 52;
    public static final int CONVERT_COM1_TX_FWD_PWR = 53;
    public static final int CONVERT_COM1_TX_REF_PWR = 54;
    public static final int CONVERT_HUSKY_UW_DIST_BOARD_STATUS = 55;
    public static final int CONVERT_COM1_RSSI = 56;
    public static final int CONVERT_COM1_ICR_2V5_SENSOR = 57;
    public static final int CONVERT_COM1_BUS_VOLTAGE = 58;
    public static final int CONVERT_ROOT_10 = 59;
    public static final int CONVERT_MEMS_SCALAR_ROTATION = 60;
    public static final int CONVERT_MEMS_X_ROTATION = 61;
    public static final int CONVERT_MEMS_Y_ROTATION = 62;
    public static final int CONVERT_MEMS_Z_ROTATION = 63;
    public static final int MAX_CONVERSION_NUMBER = 63;

    public BitArrayLayout() {
    }

    public BitArrayLayout(String f) throws FileNotFoundException, LayoutLoadException {
        this.load(f);
    }

    public int getMaxNumberOfBits() {
        return this.numberOfBits;
    }

    public int getMaxNumberOfBytes() {
        return this.numberOfBytes;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isRealTime() {
        return this.typeStr.equalsIgnoreCase(RT);
    }

    public boolean isWOD() {
        return this.typeStr.equalsIgnoreCase(WOD);
    }

    public boolean isMAX() {
        return this.typeStr.equalsIgnoreCase(MAX);
    }

    public boolean isMIN() {
        return this.typeStr.equalsIgnoreCase(MIN);
    }

    public boolean isExperiment() {
        return this.typeStr.equalsIgnoreCase(EXP);
    }

    public boolean isWODExperiment() {
        return this.typeStr.equalsIgnoreCase(WOD_EXP);
    }

    public boolean isCanExperiment() {
        return this.typeStr.equalsIgnoreCase(CAN_EXP);
    }

    public boolean isCanWodExperiment() {
        return this.typeStr.equalsIgnoreCase(CAN_WOD_EXP);
    }

    public boolean isCanPkt() {
        return this.typeStr.equalsIgnoreCase(CAN_PKT);
    }

    public boolean isCanWodPkt() {
        return this.typeStr.equalsIgnoreCase(WOD_CAN_PKT);
    }

    public static boolean isValidType(String typeStr) {
        int i = 0;
        while (i < types.length) {
            if (typeStr.equalsIgnoreCase(types[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getSecondaryPayloadName() {
        return this.secondaryLayout;
    }

    public boolean isSecondaryPayload() {
        return this.parentLayout != null;
    }

    public boolean hasFieldName(String name) {
        int i = 0;
        while (i < this.fieldName.length) {
            if (name.equalsIgnoreCase(this.fieldName[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getConversionNameByPos(int pos) {
        return this.conversion[pos];
    }

    public String getConversionNameByName(String name) {
        int pos = ERROR_POSITION;
        int i = 0;
        while (i < this.fieldName.length) {
            if (name.equalsIgnoreCase(this.fieldName[i])) {
                pos = i;
                break;
            }
            ++i;
        }
        if (pos == ERROR_POSITION) {
            return NONE;
        }
        return this.getConversionNameByPos(pos);
    }

    public int getIntConversionByPos(int pos) {
        int c = 0;
        try {
            c = Integer.parseInt(this.conversion[pos]);
        }
        catch (NumberFormatException e) {
            return 0;
        }
        return c;
    }

    public int getIntConversionByName(String name) {
        int pos = ERROR_POSITION;
        int i = 0;
        while (i < this.fieldName.length) {
            if (name.equalsIgnoreCase(this.fieldName[i])) {
                pos = i;
            }
            ++i;
        }
        if (pos == ERROR_POSITION) {
            return 0;
        }
        return this.getIntConversionByPos(pos);
    }

    public String getUnitsByName(String name) {
        int pos = ERROR_POSITION;
        int i = 0;
        while (i < this.fieldName.length) {
            if (name.equalsIgnoreCase(this.fieldName[i])) {
                pos = i;
            }
            ++i;
        }
        if (pos == ERROR_POSITION) {
            return "";
        }
        return this.fieldUnits[pos];
    }

    public int getPositionByName(String name) {
        int pos = ERROR_POSITION;
        int i = 0;
        while (i < this.fieldName.length) {
            if (name.equalsIgnoreCase(this.fieldName[i])) {
                pos = i;
            }
            ++i;
        }
        if (pos == ERROR_POSITION) {
            return ERROR_POSITION;
        }
        return pos;
    }

    public String getShortNameByName(String name) {
        int pos = ERROR_POSITION;
        int i = 0;
        while (i < this.fieldName.length) {
            if (name.equalsIgnoreCase(this.fieldName[i])) {
                pos = i;
            }
            ++i;
        }
        if (pos == ERROR_POSITION) {
            return "";
        }
        return this.shortName[pos];
    }

    public String getModuleByName(String name) {
        int pos = ERROR_POSITION;
        int i = 0;
        while (i < this.fieldName.length) {
            if (name.equalsIgnoreCase(this.fieldName[i])) {
                pos = i;
            }
            ++i;
        }
        if (pos == ERROR_POSITION) {
            return "";
        }
        return this.module[pos];
    }

    public String[][] getJTableData() {
        String[][] data = new String[this.fieldName.length][12];
        int i = 0;
        while (i < this.fieldName.length) {
            data[i][0] = "" + i;
            data[i][1] = this.typeStr;
            data[i][2] = this.fieldName[i];
            data[i][3] = "" + this.fieldBitLength[i];
            data[i][4] = this.fieldUnits[i];
            data[i][5] = this.conversion[i];
            data[i][6] = this.module[i];
            data[i][7] = "" + this.moduleNum[i];
            data[i][8] = "" + this.moduleLinePosition[i];
            data[i][9] = "" + this.moduleDisplayType[i];
            data[i][10] = this.shortName[i];
            data[i][11] = this.description[i];
            ++i;
        }
        return data;
    }

    protected void load(String fileName) throws FileNotFoundException, LayoutLoadException {
        Log.println("Loading layout: " + fileName);
        BufferedReader dis = new BufferedReader(new FileReader(fileName));
        int field = 0;
        int column = 0;
        try {
            String line = dis.readLine();
            StringTokenizer header = new StringTokenizer(line, ",");
            this.NUMBER_OF_FIELDS = Integer.valueOf(header.nextToken());
            this.fieldName = new String[this.NUMBER_OF_FIELDS];
            this.conversion = new String[this.NUMBER_OF_FIELDS];
            this.fieldBitLength = new int[this.NUMBER_OF_FIELDS];
            this.fieldUnits = new String[this.NUMBER_OF_FIELDS];
            this.module = new String[this.NUMBER_OF_FIELDS];
            this.moduleLinePosition = new int[this.NUMBER_OF_FIELDS];
            this.moduleNum = new int[this.NUMBER_OF_FIELDS];
            this.moduleDisplayType = new int[this.NUMBER_OF_FIELDS];
            this.shortName = new String[this.NUMBER_OF_FIELDS];
            this.description = new String[this.NUMBER_OF_FIELDS];
            while ((line = dis.readLine()) != null) {
                if (line == null) continue;
                StringTokenizer st = new StringTokenizer(line, ",");
                int fieldId = Integer.valueOf(st.nextToken());
                ++column;
                String type = st.nextToken();
                ++column;
                String tmpName = st.nextToken();
                ++column;
                if (this.hasFieldName(tmpName)) {
                    throw new LayoutLoadException("Error loading layout " + fileName + "\n Duplicate field: " + tmpName);
                }
                this.fieldName[field] = tmpName;
                this.fieldBitLength[field] = Integer.valueOf(st.nextToken());
                ++column;
                this.fieldUnits[field] = st.nextToken();
                ++column;
                this.conversion[field] = st.nextToken();
                ++column;
                this.module[field] = st.nextToken();
                ++column;
                this.moduleNum[field] = Integer.valueOf(st.nextToken());
                ++column;
                this.moduleLinePosition[field] = Integer.valueOf(st.nextToken());
                ++column;
                this.moduleDisplayType[field] = Integer.valueOf(st.nextToken());
                ++column;
                this.shortName[field] = st.nextToken();
                ++column;
                this.description[field] = st.nextToken();
                ++column;
                ++field;
                column = 0;
            }
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace(Log.getWriter());
        }
        catch (NumberFormatException n) {
            Log.errorDialog("NUMBER FORMAT EXCEPTION", "In layout: " + fileName + "\n" + " in row for field: " + this.fieldName[field] + " on row: " + field + " at col: " + column + "\n" + n.getMessage());
            n.printStackTrace(Log.getWriter());
        }
        catch (IndexOutOfBoundsException n) {
            Log.errorDialog("INDEX EXCEPTION", "Error loading Layout " + fileName + "\n" + " on row: " + field + " at col: " + column + "\n" + " Index is out of bounds: " + n.getMessage());
            n.printStackTrace(Log.getWriter());
        }
        catch (NoSuchElementException n) {
            Log.errorDialog("Missing Field in Layout File", "Halted loading of: " + fileName + "\n on row: " + field + " at col: " + column + "\n");
            n.printStackTrace(Log.getWriter());
        }
        if (this.NUMBER_OF_FIELDS != field) {
            throw new LayoutLoadException("Error loading fields from " + fileName + ". Expected " + this.NUMBER_OF_FIELDS + " fields , but loaded " + field);
        }
        if (this.fieldBitLength != null) {
            this.numberOfBits = 0;
            int i = 0;
            while (i < this.fieldBitLength.length) {
                this.numberOfBits += this.fieldBitLength[i];
                ++i;
            }
            this.numberOfBytes = (int)Math.ceil((double)this.numberOfBits / 8.0);
        }
    }

    public String getTableCreateStmt(boolean storeMode) {
        String s = new String();
        s = String.valueOf(s) + "(captureDate varchar(14), id int, resets int, uptime bigint, type int, ";
        if (storeMode) {
            s = String.valueOf(s) + "newMode int,";
        }
        int i = 0;
        while (i < this.fieldName.length) {
            s = String.valueOf(s) + this.fieldName[i] + " int,\n";
            ++i;
        }
        s = String.valueOf(s) + "PRIMARY KEY (id, resets, uptime, type))";
        return s;
    }

    public String toString() {
        String s = this.name;
        return s;
    }
}

