/*
 * Decompiled with CFR 0.152.
 */
package telemetry;

import common.Config;
import common.Log;
import common.Spacecraft;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import measure.Measurement;
import measure.PassMeasurement;
import measure.RtMeasurement;
import telemServer.StpFileProcessException;
import telemetry.FoxPayloadStore;
import telemetry.FramePart;
import telemetry.SatPayloadDbStore;
import telemetry.SortedFramePartArrayList;
import telemetry.SortedJpegList;
import telemetry.frames.Frame;
import telemetry.herci.HerciHighspeedHeader;
import telemetry.herci.PayloadHERCIhighSpeed;
import telemetry.legacyPayloads.PayloadCameraData;
import telemetry.legacyPayloads.PayloadRadExpData;
import telemetry.legacyPayloads.PictureScanLine;
import telemetry.legacyPayloads.RadiationTelemetry;
import telemetry.payloads.PayloadMaxValues;
import telemetry.payloads.PayloadMinValues;
import telemetry.payloads.PayloadRtValues;
import telemetry.uw.PayloadUwExperiment;
import telemetry.uw.UwCanPacket;

public class PayloadDbStore
extends FoxPayloadStore
implements Runnable {
    public static final int DATA_COL = 0;
    public static final int UPTIME_COL = 1;
    public static final int RESETS_COL = 2;
    private boolean running;
    private boolean done;
    public Connection derby;
    static String url = "jdbc:mysql://localhost:3306/";
    static String db = "FOXDB";
    static String user = "g0kla";
    static String password = "amsatfox";
    SatPayloadDbStore[] payloadStore;

    public PayloadDbStore(String u, String pw, String database) {
        File aFile;
        ArrayList<Spacecraft> sats;
        block22: {
            this.running = true;
            this.done = false;
            db = database;
            user = u;
            password = pw;
            sats = Config.satManager.getSpacecraftList();
            Statement st = null;
            ResultSet rs = null;
            try {
                try {
                    this.derby = this.getConnection();
                    st = this.derby.createStatement();
                    rs = st.executeQuery("SELECT VERSION()");
                    if (rs.next()) {
                        Log.println("Connectted to MYSQL FOXDB Version: " + rs.getString(1));
                    }
                    this.initStpHeaderTable();
                    this.initT0LogTable();
                }
                catch (SQLException ex) {
                    Log.println(ex.getMessage());
                    PayloadDbStore.SQLExceptionPrint("Login failed", ex);
                    System.err.print("FATAL: Could not connect to DB");
                    Log.alert("FATAL: Could not connect to DB");
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (st != null) {
                            st.close();
                        }
                        break block22;
                    }
                    catch (SQLException ex2) {
                        Log.println(ex2.getMessage());
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (st != null) {
                        st.close();
                    }
                }
                catch (SQLException ex) {
                    Log.println(ex.getMessage());
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException ex) {
                Log.println(ex.getMessage());
            }
        }
        String dir = "images";
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            dir = String.valueOf(Config.logFileDirectory) + File.separator + dir;
        }
        if (!(aFile = new File(dir)).isDirectory()) {
            aFile.mkdir();
            Log.println("Making directory: " + dir);
        }
        if (!aFile.isDirectory()) {
            Log.println("FATAL: can't create the images directory: " + aFile.getAbsolutePath());
            Log.alert("FATAL: can't create the images directory: " + aFile.getAbsolutePath());
        }
        this.payloadStore = new SatPayloadDbStore[sats.size()];
        int s = 0;
        while (s < sats.size()) {
            this.payloadStore[s] = new SatPayloadDbStore(this, sats.get(s));
            ++s;
        }
    }

    @Override
    public void initRad2() {
        ArrayList<Spacecraft> sats = Config.satManager.getSpacecraftList();
        int s = 0;
        while (s < sats.size()) {
            this.payloadStore[s] = new SatPayloadDbStore(this, sats.get(s));
            this.payloadStore[s].initRad2();
            ++s;
        }
    }

    @Override
    public void initHerciPackets() {
        ArrayList<Spacecraft> sats = Config.satManager.getSpacecraftList();
        int s = 0;
        while (s < sats.size()) {
            Spacecraft fox = sats.get(s);
            if (fox.hasHerci()) {
                this.payloadStore[s] = new SatPayloadDbStore(this, sats.get(s));
                this.payloadStore[s].initHerciPackets();
            }
            ++s;
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.derby == null || !this.derby.isValid(2)) {
            this.derby = DriverManager.getConnection(String.valueOf(url) + db + "?autoReconnect=true&serverTimezone=UTC", user, password);
        }
        return this.derby;
    }

    public void closeConnection() throws SQLException {
        if (this.derby != null) {
            this.derby.close();
        }
    }

    @Override
    public boolean hasQueuedFrames() {
        return false;
    }

    private SatPayloadDbStore getPayloadStoreById(int id) {
        SatPayloadDbStore[] satPayloadDbStoreArray = this.payloadStore;
        int n = this.payloadStore.length;
        int n2 = 0;
        while (n2 < n) {
            SatPayloadDbStore store = satPayloadDbStoreArray[n2];
            if (store != null && store.foxId == id) {
                return store;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void setUpdatedAll() {
        SatPayloadDbStore[] satPayloadDbStoreArray = this.payloadStore;
        int n = this.payloadStore.length;
        int n2 = 0;
        while (n2 < n) {
            SatPayloadDbStore store = satPayloadDbStoreArray[n2];
            if (store != null) {
                store.setUpdatedAll();
            }
            ++n2;
        }
    }

    @Override
    public void setUpdatedAll(int id) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            store.setUpdatedAll();
        }
    }

    public boolean getUpdatedRt(int id) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            return store.getUpdatedRt();
        }
        return false;
    }

    public void setUpdatedRt(int id, boolean u) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            store.setUpdatedRt(u);
        }
    }

    public boolean getUpdatedMax(int id) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            return store.getUpdatedMax();
        }
        return false;
    }

    public void setUpdatedMax(int id, boolean u) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            store.setUpdatedMax(u);
        }
    }

    public boolean getUpdatedMin(int id) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            return store.getUpdatedMin();
        }
        return false;
    }

    public void setUpdatedMin(int id, boolean u) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            store.setUpdatedMin(u);
        }
    }

    public boolean getUpdatedRad(int id) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            return store.getUpdatedRad();
        }
        return false;
    }

    public void setUpdatedRad(int id, boolean u) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            store.setUpdatedRad(u);
        }
    }

    @Override
    public boolean getUpdatedCamera(int id) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            return store.getUpdatedCamera();
        }
        return false;
    }

    @Override
    public void setUpdatedCamera(int id, boolean u) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            store.setUpdatedCamera(u);
        }
    }

    @Override
    public int getTotalNumberOfFrames() {
        int total = 0;
        SatPayloadDbStore[] satPayloadDbStoreArray = this.payloadStore;
        int n = this.payloadStore.length;
        int n2 = 0;
        while (n2 < n) {
            SatPayloadDbStore store = satPayloadDbStoreArray[n2];
            total += store.getNumberOfFrames();
            ++n2;
        }
        return total;
    }

    public int getTotalNumberOfTelemFrames() {
        int total = 0;
        SatPayloadDbStore[] satPayloadDbStoreArray = this.payloadStore;
        int n = this.payloadStore.length;
        int n2 = 0;
        while (n2 < n) {
            SatPayloadDbStore store = satPayloadDbStoreArray[n2];
            total += store.getNumberOfTelemFrames();
            ++n2;
        }
        return total;
    }

    public int getTotalNumberOfRadFrames() {
        int total = 0;
        SatPayloadDbStore[] satPayloadDbStoreArray = this.payloadStore;
        int n = this.payloadStore.length;
        int n2 = 0;
        while (n2 < n) {
            SatPayloadDbStore store = satPayloadDbStoreArray[n2];
            total += store.getNumberOfRadFrames();
            ++n2;
        }
        return total;
    }

    public int getNumberOfFrames(int id) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            return store.getNumberOfFrames();
        }
        return 0;
    }

    @Override
    public int getNumberOfTelemFrames(int id) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            return store.getNumberOfTelemFrames();
        }
        return 0;
    }

    public int getNumberOfRadFrames(int id) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            return store.getNumberOfRadFrames();
        }
        return 0;
    }

    @Override
    public int getNumberOfPictureCounters(int id) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            return store.getNumberOfPictureCounters();
        }
        return 0;
    }

    @Override
    public SortedJpegList getJpegIndex(int id, int period, int fromReset, long fromUptime) {
        return null;
    }

    @Override
    public boolean add(int id, long uptime, int resets, FramePart f) {
        if (Config.debugFieldValues) {
            Log.println(f.toString());
        }
        if (f instanceof PayloadCameraData) {
            if (this.addToDb(id, uptime, resets, (PayloadCameraData)f)) {
                return true;
            }
            Log.alert("ERROR: Could not add camera record to the database: " + id + " " + uptime + " " + resets + " " + f);
        } else {
            if (this.addToDb(id, uptime, resets, f)) {
                return true;
            }
            Log.alert("ERROR: Could not add record to the database: " + id + " " + uptime + " " + resets + " " + f);
        }
        return false;
    }

    public boolean addToDb(int id, long uptime, int resets, FramePart f) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.add(id, uptime, resets, f);
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
        return false;
    }

    @Override
    public boolean add(int id, long uptime, int resets, PayloadRadExpData[] f) {
        int i = 0;
        while (i < f.length) {
            if (f[i].hasData()) {
                f[i].captureHeaderInfo(id, uptime, resets);
                f[i].type = 400 + i;
                if (!this.addToDb(id, uptime, resets, f[i])) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean add(int id, long uptime, int resets, PayloadHERCIhighSpeed[] herci) {
        int i = 0;
        while (i < herci.length) {
            herci[i].captureHeaderInfo(id, uptime, resets);
            herci[i].type = 600 + i;
            if (!this.addToDb(id, uptime, resets, herci[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void initStpHeaderTable() {
        String table = "STP_HEADER";
        Statement stmt = null;
        ResultSet select = null;
        try {
            try {
                this.derby = this.getConnection();
                stmt = this.derby.createStatement();
                select = stmt.executeQuery("select 1 from " + table + " LIMIT 1");
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("42S02")) {
                    String createString = "CREATE TABLE " + table + " ";
                    createString = String.valueOf(createString) + Frame.getTableCreateStmt();
                    Log.println("Creating new DB table " + table);
                    try {
                        stmt.execute(createString);
                    }
                    catch (SQLException ex) {
                        PayloadDbStore.errorPrint("initStpHeaderTable", ex);
                        Log.alert("FATAL: Could not create STP HEADER table");
                    }
                } else {
                    PayloadDbStore.errorPrint("initStpHeaderTable", e);
                    Log.alert("FATAL: Could not access the STP HEADER table");
                }
                try {
                    if (select != null) {
                        select.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (select != null) {
                    select.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private void initT0LogTable() {
        String table = "T0_LOG";
        Statement stmt = null;
        ResultSet select = null;
        try {
            try {
                this.derby = this.getConnection();
                stmt = this.derby.createStatement();
                select = stmt.executeQuery("select 1 from " + table + " LIMIT 1");
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("42S02")) {
                    String createString = "CREATE TABLE " + table + " ";
                    createString = String.valueOf(createString) + "(id int, resets int, " + "T0_estimate_date_time timestamp NOT NULL,";
                    createString = String.valueOf(createString) + "PRIMARY KEY (id, resets))";
                    Log.println("Creating new DB table " + table);
                    try {
                        stmt.execute(createString);
                    }
                    catch (SQLException ex) {
                        PayloadDbStore.errorPrint("initT0LogTable", ex);
                        Log.alert("FATAL: Could not create T0_LOG table");
                    }
                } else {
                    PayloadDbStore.errorPrint("initT0LogTable", e);
                    Log.alert("FATAL: Could not access the T0_LOG table");
                }
                try {
                    if (select != null) {
                        select.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (select != null) {
                    select.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public boolean addStpHeader(Frame f) {
        Statement ps = null;
        try {
            try {
                this.derby = this.getConnection();
                ps = f.getPreparedInsertStmt(this.derby);
                int n = ps.executeUpdate();
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("23000")) {
                    Log.println("DUPLICATE RECORD, not stored");
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    return true;
                }
                PayloadDbStore.errorPrint("addStpHeader", e);
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return true;
    }

    @Override
    public boolean updateStpHeader(Frame f) throws StpFileProcessException {
        Statement stmt = null;
        String update = "update STP_HEADER ";
        update = String.valueOf(update) + "set rx_location='" + f.rx_location + "', ";
        update = String.valueOf(update) + "receiver_rf='" + f.receiver_rf + "' ";
        update = String.valueOf(update) + " where receiver='" + f.receiver + "' ";
        update = String.valueOf(update) + " and sequenceNumber=" + f.sequenceNumber;
        update = String.valueOf(update) + " and resets=" + f.header.resets;
        update = String.valueOf(update) + " and uptime=" + f.header.uptime;
        update = String.valueOf(update) + " and id=" + f.header.id;
        try {
            try {
                this.derby = this.getConnection();
                stmt = this.derby.createStatement();
                int r = stmt.executeUpdate(update);
                if (r > 1) {
                    throw new StpFileProcessException("FOXDB", "MULTIPLE ROWS UPDATED!");
                }
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("23000")) {
                    Log.println("DUPLICATE RECORD, not stored");
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    return true;
                }
                PayloadDbStore.errorPrint("updateStpHeader", e);
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return true;
    }

    public boolean addToDb(int id, long uptime, int resets, PayloadCameraData f) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            ArrayList<PictureScanLine> lines = f.pictureLines;
            for (PictureScanLine line : lines) {
                line.id = id;
                line.resets = resets;
                line.uptime = uptime;
                try {
                    if (store.add(line)) continue;
                    return false;
                }
                catch (IOException e) {
                    e.printStackTrace(Log.getWriter());
                    return false;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Log.println("ERROR: CORRUPT CAMERA DATA, line not written: " + id + " " + resets + " " + uptime);
                    e.printStackTrace(Log.getWriter());
                    return false;
                }
                catch (SQLException e) {
                    Log.println("SQL ERROR with CAMERA DATA, line not written: " + id + " " + resets + " " + uptime);
                    e.printStackTrace(Log.getWriter());
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public FramePart getLatest(int id, String layout) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getLatest(layout);
            }
            catch (SQLException e) {
                e.printStackTrace(Log.getWriter());
                return null;
            }
        }
        return null;
    }

    @Deprecated
    public ArrayList<FramePart> selectCanPackets(int id, String where) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            return store.selectCanPackets(where);
        }
        return null;
    }

    public int getLastCanId(int id, String user) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            return store.getLastCanId(user);
        }
        return 0;
    }

    public UwCanPacket getLatestUwCanPacket(int id) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getLatestUwCanPacket();
            }
            catch (SQLException e) {
                e.printStackTrace(Log.getWriter());
                return null;
            }
        }
        return null;
    }

    public boolean storeLastCanId(int id, String date, int pkt_id) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            return store.storeLastCanId(date, pkt_id);
        }
        return false;
    }

    @Override
    public PayloadRtValues getLatestRt(int id) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getLatestRt();
            }
            catch (SQLException e) {
                e.printStackTrace(Log.getWriter());
                return null;
            }
        }
        return null;
    }

    @Override
    public PayloadMaxValues getLatestMax(int id) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getLatestMax();
            }
            catch (SQLException e) {
                e.printStackTrace(Log.getWriter());
                return null;
            }
        }
        return null;
    }

    @Override
    public PayloadMinValues getLatestMin(int id) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getLatestMin();
            }
            catch (SQLException e) {
                e.printStackTrace(Log.getWriter());
                return null;
            }
        }
        return null;
    }

    @Override
    public PayloadRadExpData getLatestRad(int id) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getLatestRad();
            }
            catch (SQLException e) {
                PayloadDbStore.errorPrint("getLatestRad", e);
                e.printStackTrace(Log.getWriter());
                return null;
            }
        }
        return null;
    }

    public PayloadUwExperiment getLatestUwExp(int id) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getLatestUwExp();
            }
            catch (SQLException e) {
                PayloadDbStore.errorPrint("getLatestUwExp", e);
                e.printStackTrace(Log.getWriter());
                return null;
            }
        }
        return null;
    }

    public double[][] getGraphData(String name, int period, Spacecraft fox, int fromReset, long fromUptime, boolean plot, boolean reverse, String layout) {
        SatPayloadDbStore store = this.getPayloadStoreById(fox.foxId);
        if (store != null) {
            try {
                return store.getGraphData(name, period, fox, fromReset, fromUptime, layout);
            }
            catch (SQLException e) {
                e.printStackTrace(Log.getWriter());
                return null;
            }
        }
        return null;
    }

    @Override
    public double[][] getRtGraphData(String name, int period, Spacecraft fox, int fromReset, long fromUptime, boolean plot, boolean reverse) {
        SatPayloadDbStore store = this.getPayloadStoreById(fox.foxId);
        if (store != null) {
            try {
                return store.getRtGraphData(name, period, fox, fromReset, fromUptime);
            }
            catch (SQLException e) {
                Log.println("SQL ERROR!" + e.getMessage());
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    public double[][] getMaxGraphData(String name, int period, Spacecraft fox, int fromReset, long fromUptime, boolean plot, boolean reverse) {
        SatPayloadDbStore store = this.getPayloadStoreById(fox.foxId);
        if (store != null) {
            try {
                return store.getMaxGraphData(name, period, fox, fromReset, fromUptime);
            }
            catch (SQLException e) {
                PayloadDbStore.errorPrint("getMaxGraphData", e);
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    public double[][] getMinGraphData(String name, int period, Spacecraft fox, int fromReset, long fromUptime, boolean plot, boolean reverse) {
        SatPayloadDbStore store = this.getPayloadStoreById(fox.foxId);
        if (store != null) {
            try {
                return store.getMinGraphData(name, period, fox, fromReset, fromUptime);
            }
            catch (SQLException e) {
                PayloadDbStore.errorPrint("getMinGraphData", e);
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    public String[][] getRadData(int period, int id, int fromReset, long fromUptime, boolean reverse) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            try {
                return store.getRadData(period, id, fromReset, fromUptime);
            }
            catch (SQLException e) {
                Log.println("SQL ERROR!" + e.getMessage());
                e.printStackTrace(Log.getWriter());
            }
        }
        return null;
    }

    @Override
    public void deleteAll() {
        SatPayloadDbStore[] satPayloadDbStoreArray = this.payloadStore;
        int n = this.payloadStore.length;
        int n2 = 0;
        while (n2 < n) {
            SatPayloadDbStore store = satPayloadDbStoreArray[n2];
            if (store != null) {
                store.deleteAll();
            }
            ++n2;
        }
    }

    @Override
    public void delete(Spacecraft sat) {
        SatPayloadDbStore[] satPayloadDbStoreArray = this.payloadStore;
        int n = this.payloadStore.length;
        int n2 = 0;
        while (n2 < n) {
            SatPayloadDbStore store = satPayloadDbStoreArray[n2];
            if (store != null && sat.foxId == store.foxId && store != null) {
                store.deleteAll();
            }
            ++n2;
        }
    }

    public static void errorPrint(String cause, Throwable e) {
        if (e instanceof SQLException) {
            PayloadDbStore.SQLExceptionPrint(cause, (SQLException)e);
        } else {
            Log.println("ERROR: " + cause + " A NON SQLException error occured while accessing the DB");
            e.printStackTrace(Log.getWriter());
        }
    }

    static void SQLExceptionPrint(String cause, SQLException sqle) {
        while (sqle != null) {
            Log.println("\n---SQLException Caught--- Caused by: " + cause + "\n");
            Log.println("SQLState: " + sqle.getSQLState());
            Log.println("Severity: " + sqle.getErrorCode());
            Log.println("Message: " + sqle.getMessage());
            sqle.printStackTrace(Log.getWriter());
            Log.alert("SERIOUS SQL exception caused by " + cause + ".  Need to clear the ALERT and restart the server:\n");
            sqle = sqle.getNextException();
        }
    }

    @Override
    public void run() {
        this.running = true;
        this.done = false;
        Log.println("Database Payload store started. No background thread..");
        this.done = true;
    }

    @Override
    public boolean hasQueuedMeasurements() {
        return false;
    }

    @Override
    public boolean getUpdatedMeasurement(int id) {
        return false;
    }

    @Override
    public void setUpdatedMeasurement(int id, boolean u) {
    }

    @Override
    public boolean getUpdatedPassMeasurement(int id) {
        return false;
    }

    @Override
    public void setUpdatedPassMeasurement(int id, boolean u) {
    }

    @Override
    public boolean addToFile(int id, long uptime, int resets, FramePart f) {
        return false;
    }

    @Override
    public boolean addToFile(int id, long uptime, int resets, PayloadRadExpData[] f) throws IOException {
        return false;
    }

    @Override
    public boolean addToPictureFile(int id, long uptime, int resets, PayloadCameraData f) {
        return false;
    }

    @Override
    public boolean add(int id, RtMeasurement m) {
        return false;
    }

    @Override
    public boolean addToFile(int id, Measurement m) {
        return false;
    }

    @Override
    public RtMeasurement getLatestMeasurement(int id) {
        return null;
    }

    @Override
    public boolean add(int id, PassMeasurement m) {
        return false;
    }

    @Override
    public PassMeasurement getLatestPassMeasurement(int id) {
        return null;
    }

    @Override
    public RadiationTelemetry getLatestRadTelem(int id) {
        return null;
    }

    @Override
    public String[][] getRadTelemData(int period, int id, int fromReset, long fromUptime, boolean reverse) {
        return null;
    }

    @Override
    public double[][] getRadTelemGraphData(String name, int period, Spacecraft fox, int fromReset, long fromUptime, boolean plot, boolean reverse) {
        return null;
    }

    @Override
    public double[][] getMeasurementGraphData(String name, int period, Spacecraft fox, int fromReset, long fromUptime, boolean reverse) {
        return null;
    }

    @Override
    public String getRtUTCFromUptime(int id, int reset, long uptime) {
        return null;
    }

    @Override
    public double[][] getHerciScienceHeaderGraphData(String name, int period, Spacecraft fox, int fromReset, long fromUptime, boolean plot, boolean reverse) {
        return null;
    }

    @Override
    public PayloadHERCIhighSpeed getLatestHerci(int id) {
        return null;
    }

    @Override
    public HerciHighspeedHeader getLatestHerciHeader(int id) {
        return null;
    }

    @Override
    public String[][] getHerciPacketData(int period, int id, int fromReset, long fromUptime, boolean type, boolean reverse) {
        return null;
    }

    @Override
    public RadiationTelemetry getRadTelem(int id, int resets, long uptime) {
        return null;
    }

    @Override
    public boolean processNewImageLines() throws SQLException, IOException {
        SatPayloadDbStore[] satPayloadDbStoreArray = this.payloadStore;
        int n = this.payloadStore.length;
        int n2 = 0;
        while (n2 < n) {
            SatPayloadDbStore store = satPayloadDbStoreArray[n2];
            if (store != null) {
                store.processNewImageLines();
            }
            ++n2;
        }
        return true;
    }

    @Override
    public double[][] getPassMeasurementGraphData(String name, int period, Spacecraft fox, int fromReset, long fromUptime, boolean reverse) {
        return null;
    }

    @Override
    public boolean getUpdated(int id, String lay) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            return store.getUpdated(lay);
        }
        return false;
    }

    @Override
    public void setUpdated(int id, String lay, boolean u) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            store.setUpdated(lay, u);
        }
    }

    @Override
    public int getTotalNumberOfFrames(String lay) {
        return 0;
    }

    @Override
    public int getNumberOfFrames(int id, String lay) {
        return 0;
    }

    @Override
    public double[][] getGraphData(String name, int period, Spacecraft fox, int fromReset, long fromUptime, String layout, boolean plot, boolean reverse) {
        return null;
    }

    @Override
    public String[][] getWodRadTelemData(int sAMPLES, int foxId, int sTART_RESET, long sTART_UPTIME, boolean reverse) {
        return null;
    }

    @Override
    public String[][] getRtData(int sAMPLES, int foxId, int sTART_RESET, long sTART_UPTIME, boolean reverse) {
        return null;
    }

    @Override
    public String[][] getWODData(int sAMPLES, int foxId, int sTART_RESET, long sTART_UPTIME, boolean reverse) {
        return null;
    }

    @Override
    public int getNumberOfPayloadsBetweenTimestamps(int id, int reset, long uptime, int toReset, long toUptime, String payloadType) {
        return 0;
    }

    @Override
    public FramePart getFramePart(int id, int reset, long uptime, String layout, boolean prev) {
        return null;
    }

    @Override
    public String[][] getWODRadData(int sAMPLES, int foxId, int sTART_RESET, long sTART_UPTIME, boolean reverse) {
        return null;
    }

    @Override
    public String[][] getHerciHsData(int period, int id, int fromReset, long fromUptime, boolean reverse) {
        return null;
    }

    @Override
    public FramePart getFramePart(int id, int reset, long uptime, int type, String layout, boolean prev) {
        return null;
    }

    @Override
    public String[][] getTableData(int period, int id, int fromReset, long fromUptime, boolean reverse, String layout) {
        return null;
    }

    @Override
    public String[][] getTableData(int period, int id, int fromReset, long fromUptime, boolean returnType, boolean reverse, String layout) {
        return null;
    }

    @Override
    public int checkForNewReset(int id, long uptime, Date stpDate, int resetOnFrame, String groundStation) {
        SatPayloadDbStore store = this.getPayloadStoreById(id);
        if (store != null) {
            return store.checkForNewReset(id, uptime, stpDate, resetOnFrame, groundStation);
        }
        return -1;
    }

    @Override
    public int getQueuedFramesSize() {
        return 0;
    }

    @Override
    public SortedFramePartArrayList getFrameParts(int id, int fromReset, long fromUptime, int period, boolean reverse, String layout) throws IOException {
        return null;
    }

    @Override
    public int getNumberOfMeasurements(int id) {
        return 0;
    }

    @Override
    public int getNumberOfPassMeasurements(int id) {
        return 0;
    }
}

