/*
 * Decompiled with CFR 0.152.
 */
package telemetry;

import common.Config;
import common.Log;
import common.Spacecraft;
import common.TlmServer;
import gui.MainWindow;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JOptionPane;
import telemetry.Format.FormatFrame;
import telemetry.RawQueue;
import telemetry.SatPayloadStore;
import telemetry.SatPayloadTable;
import telemetry.frames.Frame;
import telemetry.frames.SlowSpeedFrame;

public class RawPayloadQueue
extends RawQueue {
    public static String RAW_SLOW_SPEED_FRAMES_FILE = "rawDUVpayloads.log";
    public static String RAW_HIGH_SPEED_FRAMES_FILE = "rawHSpayloads.log";
    public static String RAW_PSK_FRAMES_FILE = "rawPSKpayloads.log";
    TlmServer localServer;

    public RawPayloadQueue() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.localServer = new TlmServer(Config.primaryServer, Config.serverPort, false, false);
        this.rawSlowSpeedFrames = new ConcurrentLinkedQueue();
        this.rawHighSpeedFrames = new ConcurrentLinkedQueue();
        this.formatFrames = new ConcurrentLinkedQueue();
        try {
            RawPayloadQueue rawPayloadQueue = this;
            synchronized (rawPayloadQueue) {
                this.load(RAW_SLOW_SPEED_FRAMES_FILE, 0);
                this.load(RAW_HIGH_SPEED_FRAMES_FILE, 1);
                this.load(RAW_PSK_FRAMES_FILE, 2);
            }
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(MainWindow.frame, e.toString(), "ERROR Raw Frames Queue File not found", 0);
            e.printStackTrace(Log.getWriter());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(MainWindow.frame, e.toString(), "I/O ERROR Loading Stored Raw Frames Queue", 0);
            e.printStackTrace(Log.getWriter());
        }
        MainWindow.setLocalQueued(this.rawSlowSpeedFrames.size() + this.rawHighSpeedFrames.size() + this.formatFrames.size());
    }

    @Override
    public boolean add(Frame f) throws IOException {
        if (f instanceof SlowSpeedFrame) {
            this.updatedSlowQueue = true;
            this.save(f, RAW_SLOW_SPEED_FRAMES_FILE);
            MainWindow.setLocalQueued(this.rawSlowSpeedFrames.size() + this.rawHighSpeedFrames.size() + this.formatFrames.size());
            return this.rawSlowSpeedFrames.add(f);
        }
        if (f instanceof FormatFrame) {
            this.updatedPSKQueue = true;
            this.save(f, RAW_PSK_FRAMES_FILE);
            MainWindow.setLocalQueued(this.rawSlowSpeedFrames.size() + this.rawHighSpeedFrames.size() + this.formatFrames.size());
            return this.formatFrames.add(f);
        }
        this.updatedHSQueue = true;
        this.save(f, RAW_HIGH_SPEED_FRAMES_FILE);
        MainWindow.setLocalQueued(this.rawSlowSpeedFrames.size() + this.rawHighSpeedFrames.size() + this.formatFrames.size());
        return this.rawHighSpeedFrames.add(f);
    }

    @Override
    public void delete() {
        try {
            SatPayloadStore.remove(String.valueOf(SatPayloadTable.getDir()) + RAW_SLOW_SPEED_FRAMES_FILE);
            SatPayloadStore.remove(String.valueOf(SatPayloadTable.getDir()) + RAW_HIGH_SPEED_FRAMES_FILE);
            SatPayloadStore.remove(String.valueOf(SatPayloadTable.getDir()) + RAW_PSK_FRAMES_FILE);
            this.init();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(MainWindow.frame, ex.toString(), "Error Deleting Local Server Upload Queues, check permissions on files:\n" + RAW_SLOW_SPEED_FRAMES_FILE + "\n" + RAW_PSK_FRAMES_FILE + "\n" + RAW_HIGH_SPEED_FRAMES_FILE, 0);
        }
    }

    @Override
    public void run() {
        this.running = true;
        boolean success = true;
        while (this.running) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: server payload queue thread interrupted");
                e.printStackTrace(Log.getWriter());
            }
            while (this.rawSlowSpeedFrames.size() > 0) {
                success = this.sendFrame(this.rawSlowSpeedFrames, RAW_SLOW_SPEED_FRAMES_FILE);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Log.println("ERROR: local server DUV frame queue thread interrupted");
                    e.printStackTrace(Log.getWriter());
                }
            }
            while (this.rawHighSpeedFrames.size() > 0) {
                success = this.sendFrame(this.rawHighSpeedFrames, RAW_HIGH_SPEED_FRAMES_FILE);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Log.println("ERROR: local server HS frame queue thread interrupted");
                    e.printStackTrace(Log.getWriter());
                }
            }
            while (this.formatFrames.size() > 0) {
                success = this.sendFrame(this.formatFrames, RAW_PSK_FRAMES_FILE);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Log.println("ERROR: server PSK frame queue thread interrupted");
                    e.printStackTrace(Log.getWriter());
                }
            }
        }
        Log.println("Local Server Queue thread ended");
    }

    private boolean sendFrame(ConcurrentLinkedQueue<Frame> frames, String file) {
        boolean success = false;
        int protocol = 0;
        if (Config.satManager != null) {
            try {
                Spacecraft sat;
                if (frames.peek() != null && (sat = Config.satManager.getSpacecraft(frames.peek().foxId)).sendToLocalServer()) {
                    byte[][] buffer;
                    this.localServer.setHostName(sat.user_localServer);
                    this.localServer.setPort(sat.user_localServerPort);
                    Log.println("Trying Local Server: TCP://" + sat.user_localServer + ":" + sat.user_localServerPort);
                    byte[][] byArray = buffer = frames.peek().getPayloadBytes();
                    int n = buffer.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte[] b = byArray[n2];
                        this.localServer.sendToServer(b, protocol);
                        ++n2;
                    }
                    success = true;
                }
            }
            catch (UnknownHostException e) {
                Log.println("Could not connect to local server: " + e.getMessage());
                this.localServer.close();
            }
            catch (IOException e) {
                Log.println("IO Exception with local server: " + e.getMessage());
                this.localServer.close();
            }
        }
        if (success) {
            try {
                this.deleteAndSave(frames, file);
            }
            catch (IOException e) {
                Log.errorDialog("ERROR", "Could not remove raw frames from the local queue file:\n" + file + "\n" + " The frame will be sent again.  If this error repeats you may need to remove the queue file manually");
                e.printStackTrace(Log.getWriter());
            }
        }
        return success;
    }
}

