/*
 * Decompiled with CFR 0.152.
 */
package telemetry;

import common.Config;
import common.Log;
import common.Spacecraft;
import gui.MainWindow;
import java.io.File;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JOptionPane;
import telemServer.ServerConfig;
import telemetry.BitArrayLayout;
import telemetry.FramePart;
import telemetry.PayloadDbStore;
import telemetry.SortedArrayList;
import telemetry.herci.HerciHighSpeedPacket;
import telemetry.herci.HerciHighspeedHeader;
import telemetry.herci.PayloadHERCIhighSpeed;
import telemetry.legacyPayloads.CameraJpeg;
import telemetry.legacyPayloads.PayloadRadExpData;
import telemetry.legacyPayloads.PayloadWODRad;
import telemetry.legacyPayloads.PictureScanLine;
import telemetry.legacyPayloads.RadiationTelemetry;
import telemetry.legacyPayloads.WodRadiationTelemetry;
import telemetry.payloads.PayloadMaxValues;
import telemetry.payloads.PayloadMinValues;
import telemetry.payloads.PayloadRtValues;
import telemetry.payloads.PayloadWOD;
import telemetry.uw.PayloadUwExperiment;
import telemetry.uw.PayloadWODUwExperiment;
import telemetry.uw.UwCanPacket;

public class SatPayloadDbStore {
    public static final String ERR_TABLE_DOES_NOT_EXIST = "42S02";
    public static final String ERR_DUPLICATE = "23000";
    public static final String ERR_OPEN_RESULT_SET = "X0X95";
    public int foxId;
    public Spacecraft fox;
    @Deprecated
    public static String RT_LOG = "RTTELEMETRY";
    @Deprecated
    public static String MAX_LOG = "MAXTELEMETRY";
    @Deprecated
    public static String MIN_LOG = "MINTELEMETRY";
    @Deprecated
    public static String RAD_LOG = "RADTELEMETRY";
    @Deprecated
    public static String RAD_TELEM_LOG = "RAD2TELEMETRY";
    @Deprecated
    public static String HERCI_HS_LOG = "HERCI_HS";
    @Deprecated
    public static String HERCI_HS_HEADER_LOG = "HERCI_HS_HEADER";
    @Deprecated
    public static String HERCI_HS_PACKET_LOG = "HERCI_HS_PACKET";
    @Deprecated
    public static String JPG_IDX = "JPG_IDX";
    @Deprecated
    public static String PICTURE_LINES = "PICTURE_LINES_IDX";
    @Deprecated
    public static String WOD_LOG = "WODTELEMETRY";
    @Deprecated
    public static String WOD_RAD_LOG = "WODRADTELEMETRY";
    @Deprecated
    public static String WOD_RAD_TELEM_LOG = "WODRAD2TELEMETRY";
    @Deprecated
    public static String UW_CAN_PACKET_LOG = "UW_CAN_PACKET";
    @Deprecated
    public static String UW_CAN_PACKET_TIMESTAMP = "UW_CAN_PACKET_TIMESTAMP";
    @Deprecated
    public static String CAN_LOG = "CANTELEMETRY";
    @Deprecated
    public static String WOD_CAN_LOG = "WODCANTELEMETRY";
    @Deprecated
    public String rtTableName;
    @Deprecated
    public String maxTableName;
    @Deprecated
    public String minTableName;
    @Deprecated
    public String radTableName;
    @Deprecated
    public String radTelemTableName;
    @Deprecated
    public String herciHSTableName;
    @Deprecated
    public String herciHSHeaderTableName;
    @Deprecated
    public String herciHSPacketTableName;
    @Deprecated
    public String jpgIdxTableName;
    @Deprecated
    public String pictureLinesTableName;
    @Deprecated
    public String wodTableName;
    @Deprecated
    public String wodRadTableName;
    @Deprecated
    public String wodRadTelemTableName;
    @Deprecated
    public String uwCanPacketTableName;
    @Deprecated
    public String uwCanPacketTimestampTableName;
    boolean[] updated;
    @Deprecated
    boolean updatedRt = true;
    @Deprecated
    boolean updatedMax = true;
    @Deprecated
    boolean updatedMin = true;
    @Deprecated
    boolean updatedRad = true;
    @Deprecated
    boolean updatedRadTelem = true;
    @Deprecated
    boolean updatedHerciHS = true;
    @Deprecated
    boolean updatedHerciHeader = true;
    @Deprecated
    boolean updatedHerciPacket = true;
    @Deprecated
    boolean updatedCamera = true;
    @Deprecated
    boolean updatedWod = true;
    @Deprecated
    boolean updatedWodRad = true;
    @Deprecated
    boolean updatedWodRadTelem = true;
    @Deprecated
    boolean updatedUwCanPacket = true;
    PayloadDbStore payloadDbStore;

    public SatPayloadDbStore(PayloadDbStore store, Spacecraft fox) {
        this.fox = fox;
        this.payloadDbStore = store;
        this.foxId = fox.foxId;
        if (fox.hasFOXDB_V3) {
            this.setupTables();
            this.updated = new boolean[fox.numberOfDbLayouts];
        } else {
            this.setupLegacyTables();
        }
    }

    private void setupTables() {
        int i = 0;
        while (i < this.fox.numberOfDbLayouts) {
            this.initPayloadTable(this.fox.layout[i].name, this.fox.hasModeInHeader);
            ++i;
        }
    }

    @Deprecated
    private void setupLegacyTables() {
        this.rtTableName = "Fox" + this.foxId + RT_LOG;
        this.maxTableName = "Fox" + this.foxId + MAX_LOG;
        this.minTableName = "Fox" + this.foxId + MIN_LOG;
        this.radTableName = "Fox" + this.foxId + RAD_LOG;
        this.radTelemTableName = "Fox" + this.foxId + RAD_TELEM_LOG;
        this.herciHSTableName = "Fox" + this.foxId + HERCI_HS_LOG;
        this.herciHSHeaderTableName = "Fox" + this.foxId + HERCI_HS_HEADER_LOG;
        this.herciHSPacketTableName = "Fox" + this.foxId + HERCI_HS_PACKET_LOG;
        this.jpgIdxTableName = "Fox" + this.foxId + JPG_IDX;
        this.pictureLinesTableName = "Fox" + this.foxId + PICTURE_LINES;
        this.wodTableName = "Fox" + this.foxId + WOD_LOG;
        this.wodRadTableName = "Fox" + this.foxId + WOD_RAD_LOG;
        this.wodRadTelemTableName = "Fox" + this.foxId + WOD_RAD_TELEM_LOG;
        this.uwCanPacketTableName = "Fox" + this.foxId + UW_CAN_PACKET_LOG;
        this.uwCanPacketTimestampTableName = "Fox" + this.foxId + UW_CAN_PACKET_TIMESTAMP;
        this.initPayloadFiles();
    }

    private String makeTableName(String layoutName) {
        String s = String.valueOf(this.fox.series) + this.foxId;
        String LAY = layoutName.toUpperCase();
        s = String.valueOf(s) + LAY;
        return s;
    }

    @Deprecated
    private void initPayloadFiles() {
        boolean storeMode = false;
        if (this.fox.hasModeInHeader) {
            storeMode = true;
        }
        this.initPayloadTable(this.rtTableName, this.fox.getLayoutByName("rttelemetry"), storeMode);
        this.initPayloadTable(this.maxTableName, this.fox.getLayoutByName("maxtelemetry"), storeMode);
        this.initPayloadTable(this.minTableName, this.fox.getLayoutByName("mintelemetry"), storeMode);
        if (this.fox.getLayoutIdxByName("cantelemetry") != -1) {
            this.radTableName = "Fox" + this.foxId + CAN_LOG;
            this.initPayloadTable(this.radTableName, this.fox.getLayoutByName("cantelemetry"), storeMode);
            this.initCanPacketTable(storeMode);
            this.initCanTimestampTable();
        } else {
            this.initPayloadTable(this.radTableName, this.fox.getLayoutByName("radtelemetry"), storeMode);
            this.initPayloadTable(this.radTelemTableName, this.fox.getLayoutByName("radtelemetry2"), storeMode);
        }
        if (this.fox.hasHerci()) {
            this.initHerciTables(storeMode);
        }
        if (this.fox.hasCamera()) {
            this.initCameraTables();
        }
        if (this.fox.getLayoutIdxByName("wodtelemetry") != -1) {
            this.initPayloadTable(this.wodTableName, this.fox.getLayoutByName("wodtelemetry"), storeMode);
        }
        if (this.fox.getLayoutIdxByName("wodradtelemetry") != -1) {
            this.initPayloadTable(this.wodRadTableName, this.fox.getLayoutByName("wodradtelemetry"), storeMode);
            this.initPayloadTable(this.wodRadTelemTableName, this.fox.getLayoutByName("wodradtelemetry2"), storeMode);
        }
        if (this.fox.getLayoutIdxByName("wodcantelemetry") != -1) {
            this.wodRadTableName = "Fox" + this.foxId + WOD_CAN_LOG;
            this.initPayloadTable(this.wodRadTableName, this.fox.getLayoutByName("wodcantelemetry"), storeMode);
        }
    }

    private void initPayloadTable(String layoutName, boolean storeMode) {
        this.initPayloadTable(this.makeTableName(layoutName), this.fox.getLayoutByName(layoutName), storeMode);
    }

    private void initPayloadTable(String table, BitArrayLayout layout, boolean storeMode) {
        if (layout == null) {
            return;
        }
        String createStmt = layout.getTableCreateStmt(storeMode);
        layout.tableName = table;
        this.createTable(table, createStmt);
    }

    @Deprecated
    private void initHerciTables(boolean storeMode) {
        this.initPayloadTable(this.herciHSTableName, this.fox.getLayoutByName("herciHSdata"), storeMode);
        this.initPayloadTable(this.herciHSHeaderTableName, this.fox.getLayoutByName("herciHSheader"), storeMode);
        String table = this.herciHSPacketTableName;
        String createStmt = HerciHighSpeedPacket.getTableCreateStmt();
        this.createTable(table, createStmt);
    }

    @Deprecated
    private void initCameraTables() {
        String table = this.jpgIdxTableName;
        String createStmt = CameraJpeg.getTableCreateStmt();
        this.createTable(table, createStmt);
        table = this.pictureLinesTableName;
        createStmt = PictureScanLine.getTableCreateStmt();
        this.createTable(table, createStmt);
    }

    @Deprecated
    private void initCanPacketTable(boolean storeMode) {
        String table = this.uwCanPacketTableName;
        BitArrayLayout lay = this.fox.getLayoutByName("canpacket");
        String s = new String();
        s = String.valueOf(s) + "(captureDate varchar(14), id int, resets int, uptime bigint, type int, ";
        if (storeMode) {
            s = String.valueOf(s) + "newMode int,";
        }
        int i = 0;
        while (i < lay.fieldName.length) {
            s = String.valueOf(s) + lay.fieldName[i] + " int,\n";
            ++i;
        }
        s = String.valueOf(s) + "pkt_id int(11) NOT NULL AUTO_INCREMENT,";
        s = String.valueOf(s) + "PRIMARY KEY (pkt_id),";
        s = String.valueOf(s) + "UNIQUE KEY (id, resets, uptime, type)" + ")";
        this.createTable(table, s);
    }

    @Deprecated
    private void initCanTimestampTable() {
        String table = this.uwCanPacketTimestampTableName;
        String s = new String();
        s = String.valueOf(s) + "(username varchar(255) not null," + "last_pkt_id int(11) NOT NULL,";
        s = String.valueOf(s) + "PRIMARY KEY (username))";
        this.createTable(table, s);
    }

    private void createTable(String table, String createStmt) {
        Statement stmt = null;
        ResultSet select = null;
        try {
            try {
                this.payloadDbStore.getConnection();
                stmt = this.payloadDbStore.derby.createStatement();
                select = stmt.executeQuery("select 1 from " + table + " LIMIT 1");
            }
            catch (SQLException e) {
                if (e.getSQLState().equals(ERR_TABLE_DOES_NOT_EXIST)) {
                    String createString = "CREATE TABLE " + table + " ";
                    createString = String.valueOf(createString) + createStmt;
                    Log.println("Creating new DB table " + table);
                    Log.println("***************************************\n" + createString + "***************************************\n");
                    try {
                        stmt.execute(createString);
                    }
                    catch (SQLException ex) {
                        PayloadDbStore.errorPrint("createTable:" + table, ex);
                    }
                } else {
                    PayloadDbStore.errorPrint("createTable:" + table, e);
                }
                try {
                    if (select != null) {
                        select.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (select != null) {
                    select.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public void setUpdatedAll() {
        if (this.fox.hasFOXDB_V3) {
            int i = 0;
            while (i < this.fox.numberOfDbLayouts) {
                this.updated[i] = true;
                ++i;
            }
        } else {
            this.updatedRt = true;
            this.updatedMax = true;
            this.updatedMin = true;
            this.updatedRad = true;
            this.updatedRadTelem = true;
        }
    }

    public boolean getUpdated(String layout) {
        int i = this.fox.getLayoutIdxByName(layout);
        if (i != -1) {
            return this.updated[i];
        }
        return false;
    }

    public void setUpdated(String layout, boolean u) {
        int i = this.fox.getLayoutIdxByName(layout);
        if (i != -1) {
            this.updated[i] = u;
        }
    }

    @Deprecated
    public boolean getUpdatedRt() {
        return this.updatedRt;
    }

    @Deprecated
    public void setUpdatedRt(boolean u) {
        this.updatedRt = u;
    }

    @Deprecated
    public boolean getUpdatedMax() {
        return this.updatedMax;
    }

    @Deprecated
    public void setUpdatedMax(boolean u) {
        this.updatedMax = u;
    }

    @Deprecated
    public boolean getUpdatedMin() {
        return this.updatedMin;
    }

    @Deprecated
    public void setUpdatedMin(boolean u) {
        this.updatedMin = u;
    }

    @Deprecated
    public boolean getUpdatedRad() {
        return this.updatedRad;
    }

    @Deprecated
    public void setUpdatedRad(boolean u) {
        this.updatedRad = u;
    }

    @Deprecated
    public boolean getUpdatedRadTelem() {
        return this.updatedRadTelem;
    }

    @Deprecated
    public void setUpdatedRadTelem(boolean u) {
        this.updatedRadTelem = u;
    }

    @Deprecated
    public boolean getUpdatedCamera() {
        return this.updatedCamera;
    }

    @Deprecated
    public void setUpdatedCamera(boolean u) {
        this.updatedCamera = u;
    }

    private int count(String table) {
        int count = 0;
        Statement stmt = null;
        ResultSet rs = null;
        String update = "select count(*) from " + table;
        try {
            try {
                Connection derby = this.payloadDbStore.getConnection();
                stmt = derby.createStatement();
                rs = stmt.executeQuery(update);
                if (rs.isClosed() || rs.next()) {
                    // empty if block
                }
                count = rs.getInt(1);
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals(ERR_TABLE_DOES_NOT_EXIST)) {
                    PayloadDbStore.errorPrint("count:" + table, e);
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return 0;
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return count;
    }

    public int getNumberOfFrames(String layout) {
        BitArrayLayout lay = this.fox.getLayoutByName(layout);
        if (lay != null) {
            return this.count(lay.tableName);
        }
        return 0;
    }

    public int getNumberOfFrames() {
        if (this.fox.hasFOXDB_V3) {
            int total = 0;
            int i = 0;
            while (i < this.fox.numberOfLayouts) {
                if (!this.fox.layout[i].isSecondaryPayload()) {
                    total += this.count(this.fox.layout[i].tableName);
                }
                ++i;
            }
            return total;
        }
        return this.count(this.rtTableName) + this.count(this.maxTableName) + this.count(this.minTableName) + this.count(this.radTableName);
    }

    public int getNumberOfTelemFrames() {
        return this.count(this.rtTableName) + this.count(this.maxTableName) + this.count(this.minTableName);
    }

    public int getNumberOfRadFrames() {
        return this.count(this.radTableName);
    }

    public int getNumberOfPictureCounters() {
        return this.count(this.jpgIdxTableName);
    }

    public boolean add(int id, long uptime, int resets, FramePart f) throws IOException {
        f.captureHeaderInfo(id, uptime, resets);
        return this.add(f);
    }

    private boolean addRadRecord(PayloadRadExpData f) {
        if (this.insert(this.radTableName, f)) {
            if (this.fox.hasHerci() || f.isTelemetry()) {
                RadiationTelemetry radiationTelemetry = f.calculateTelemetryPalyoad();
                radiationTelemetry.captureHeaderInfo(f.id, f.uptime, f.resets);
                if (f.type >= 400) {
                    radiationTelemetry.type = f.type + 300;
                }
                return this.add(radiationTelemetry);
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean addWodRadRecord(PayloadWODRad f) {
        if (this.insert(this.wodRadTableName, f)) {
            WodRadiationTelemetry radiationTelemetry = f.calculateTelemetryPalyoad();
            radiationTelemetry.captureHeaderInfo(f.id, f.uptime, f.resets);
            return this.add(radiationTelemetry);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean addHerciRecord(PayloadHERCIhighSpeed f) {
        if (!this.insert(this.herciHSTableName, f)) return false;
        HerciHighspeedHeader radiationTelemetry = f.calculateTelemetryPalyoad();
        radiationTelemetry.captureHeaderInfo(f.id, f.uptime, f.resets);
        if (f.type >= 600) {
            radiationTelemetry.type = f.type + 200;
        }
        if (!this.add(radiationTelemetry)) return false;
        this.updatedHerciHeader = true;
        ArrayList<HerciHighSpeedPacket> pkts = f.calculateTelemetryPackets();
        int i = 0;
        while (i < pkts.size()) {
            HerciHighSpeedPacket pk = pkts.get(i);
            pk.captureHeaderInfo(f.id, f.uptime, f.resets);
            if (f.type >= 600) {
                pk.type = f.type * 1000 + 900 + i;
            }
            this.add(pk);
            this.updatedHerciPacket = true;
            ++i;
        }
        return true;
    }

    public boolean add(int id, long uptime, int resets, PayloadRadExpData[] f) {
        int i = 0;
        while (i < f.length) {
            if (f[i].hasData()) {
                f[i].captureHeaderInfo(id, uptime, resets);
                f[i].type = i + 400;
                this.addRadRecord(f[i]);
            }
            ++i;
        }
        return true;
    }

    private boolean insert(String table, FramePart f) {
        String insertStmt = f.getInsertStmt();
        return this.insertData(table, insertStmt);
    }

    private boolean insert(String table, CameraJpeg f) {
        String insertStmt = f.getInsertStmt();
        return this.insertData(table, insertStmt);
    }

    private boolean insert(String table, PictureScanLine f) {
        String insertStmt = f.getInsertStmt();
        return this.insertData(table, insertStmt);
    }

    private boolean insertData(String table, String insertStmt) {
        Statement stmt = null;
        String update = "insert into " + table;
        update = String.valueOf(update) + insertStmt;
        try {
            try {
                Connection derby = this.payloadDbStore.getConnection();
                stmt = derby.createStatement();
                int n = stmt.executeUpdate(update);
            }
            catch (SQLException e) {
                if (e.getSQLState().equals(ERR_DUPLICATE)) {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    return true;
                }
                PayloadDbStore.errorPrint("insertData:" + table, e);
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return true;
    }

    private boolean insertImageLine(String table, PictureScanLine f) throws SQLException {
        String insertStmt = f.getInsertStmt();
        boolean inserted = this.insertData(table, insertStmt);
        Statement ps = null;
        if (!inserted) {
            return false;
        }
        try {
            try {
                Connection derby = this.payloadDbStore.getConnection();
                ps = derby.prepareStatement("UPDATE " + table + " set imageBytes = ?" + " where id = " + f.id + " and resets = " + f.resets + " and uptime = " + f.uptime + " and pictureCounter = " + f.pictureCounter + " and scanLineNumber = " + f.scanLineNumber);
                ps.setBytes(1, f.getBytes());
                int n = ps.executeUpdate();
            }
            catch (SQLException e) {
                if (e.getSQLState().equals(ERR_DUPLICATE)) {
                    Log.println("ERROR, image bytes not stored");
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    return false;
                }
                throw e;
            }
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return true;
    }

    private boolean add(FramePart f) {
        if (this.fox.hasFOXDB_V3) {
            this.setUpdated(f.getLayout().name, true);
            boolean ret = this.insert(f.getLayout().tableName, f);
            if (ret) {
                if (f.getLayout().getSecondaryPayloadName() != null) {
                    String sec = f.getLayout().getSecondaryPayloadName();
                    BitArrayLayout secLayout = this.fox.getLayoutByName(sec);
                    FramePart secPayload = f.getSecondaryPayload();
                    return this.insert(secLayout.tableName, secPayload);
                }
                return true;
            }
            return false;
        }
        return this.addLegacyPayload(f);
    }

    private boolean addLegacyPayload(FramePart f) {
        if (f instanceof PayloadWOD) {
            return this.insert(this.wodTableName, (PayloadWOD)f);
        }
        if (f instanceof PayloadRtValues) {
            this.setUpdatedRt(true);
            return this.insert(this.rtTableName, f);
        }
        if (f instanceof PayloadMaxValues) {
            this.setUpdatedMax(true);
            return this.insert(this.maxTableName, f);
        }
        if (f instanceof PayloadMinValues) {
            this.setUpdatedMin(true);
            return this.insert(this.minTableName, f);
        }
        if (f instanceof PayloadWODRad) {
            return this.addWodRadRecord((PayloadWODRad)f);
        }
        if (f instanceof PayloadRadExpData) {
            this.setUpdatedRad(true);
            return this.addRadRecord((PayloadRadExpData)f);
        }
        if (f instanceof WodRadiationTelemetry) {
            return this.insert(this.wodRadTelemTableName, f);
        }
        if (f instanceof RadiationTelemetry) {
            this.setUpdatedRadTelem(true);
            return this.insert(this.radTelemTableName, f);
        }
        if (f instanceof PayloadHERCIhighSpeed) {
            return this.addHerciRecord((PayloadHERCIhighSpeed)f);
        }
        if (f instanceof HerciHighspeedHeader) {
            return this.insert(this.herciHSHeaderTableName, f);
        }
        if (f instanceof HerciHighSpeedPacket) {
            return this.insert(this.herciHSPacketTableName, (HerciHighSpeedPacket)f);
        }
        if (f instanceof PayloadWODUwExperiment) {
            this.updatedWodRad = true;
            return this.insert(this.wodRadTableName, (PayloadWODUwExperiment)f);
        }
        if (f instanceof PayloadUwExperiment) {
            this.updatedRad = true;
            return this.insert(this.radTableName, (PayloadUwExperiment)f);
        }
        if (f instanceof UwCanPacket) {
            return this.insert(this.uwCanPacketTableName, (UwCanPacket)f);
        }
        return false;
    }

    public boolean processNewImageLines() throws SQLException, IOException {
        if (!this.fox.hasCamera()) {
            return false;
        }
        String lineswhere = " where id = " + this.foxId + " and processed = 0";
        SortedArrayList<PictureScanLine> psl = this.selectImageLines(this.pictureLinesTableName, lineswhere);
        if (psl == null) {
            return false;
        }
        for (PictureScanLine p : psl) {
            Log.println("Processing new image line " + p.scanLineNumber + " for FoxId: " + this.foxId + " r:" + p.resets + " u:" + p.uptime + " pc:" + p.pictureCounter);
            String where = " where id = " + this.foxId + " and resets = " + p.resets + " and uptime = " + p.uptime + " and pictureCounter = " + p.pictureCounter;
            CameraJpeg jpg = this.selectExistingJpeg(this.jpgIdxTableName, this.foxId, p.resets, p.uptime, p.pictureCounter);
            if (jpg == null) {
                SortedArrayList<PictureScanLine> jpgPsl = this.selectImageLines(this.pictureLinesTableName, where);
                if (jpgPsl == null) {
                    return false;
                }
                jpg = new CameraJpeg(this.foxId, p.resets, (long)p.uptime, (long)p.uptime, p.pictureCounter, jpgPsl);
                this.insert(this.jpgIdxTableName, jpg);
            }
            jpg.writeAllLines();
            this.updatedCamera = true;
            try (Statement ps = null;){
                Connection derby = this.payloadDbStore.getConnection();
                ps = derby.prepareStatement("UPDATE " + this.pictureLinesTableName + " set processed = ? " + " where id = " + this.foxId + " and resets = " + p.resets + " and uptime = " + p.uptime + " and pictureCounter = " + p.pictureCounter + " and scanLineNumber = " + p.scanLineNumber);
                ps.setLong(1, 1L);
                int n = ps.executeUpdate();
            }
        }
        return true;
    }

    public boolean add(PictureScanLine line) throws IOException, SQLException {
        return this.insertImageLine(this.pictureLinesTableName, line);
    }

    /*
     * Exception decompiling
     */
    private CameraJpeg selectExistingJpeg(String table, int id, int resets, long uptime, int pictureCounter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.TryRewriter.extendTryBlock(TryRewriter.java:34)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.TryRewriter.extendTryBlocks(TryRewriter.java:147)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.extendTryBlocks(Op03Rewriters.java:48)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:557)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    ArrayList<FramePart> selectCanPackets(String where) {
        Statement stmt = null;
        String update = "  SELECT * FROM ";
        update = String.valueOf(update) + this.uwCanPacketTableName + " " + where + " ORDER BY pkt_id limit 1000";
        ResultSet r = null;
        ArrayList<FramePart> frameParts = new ArrayList<FramePart>(60);
        try {
            Connection derby = this.payloadDbStore.getConnection();
            stmt = derby.createStatement();
            r = stmt.executeQuery(update);
            if (r != null) {
                while (r.next()) {
                    UwCanPacket payload = new UwCanPacket(Config.satManager.getLayoutByName(this.foxId, "canpacket"));
                    payload.id = r.getInt("id");
                    payload.resets = r.getInt("resets");
                    payload.uptime = r.getLong("uptime");
                    payload.type = r.getInt("type");
                    payload.reportDate = r.getString("captureDate");
                    payload.pkt_id = r.getInt("pkt_id");
                    payload.init();
                    payload.rawBits = null;
                    int i = 0;
                    while (i < payload.fieldValue.length) {
                        payload.fieldValue[i] = r.getInt(payload.layout.fieldName[i]);
                        ++i;
                    }
                    frameParts.add(payload);
                }
            } else {
                frameParts = null;
            }
            ArrayList<FramePart> arrayList = frameParts;
            return arrayList;
        }
        catch (SQLException e) {
            PayloadDbStore.errorPrint("selectLatest:" + this.uwCanPacketTableName, e);
            try {
                r.close();
                stmt.close();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return null;
    }

    private SortedArrayList<PictureScanLine> selectImageLines(String table, String where) {
        block27: {
            SortedArrayList<PictureScanLine> sortedArrayList;
            Statement stmt = null;
            String update = "";
            SortedArrayList<PictureScanLine> pictureLines = new SortedArrayList<PictureScanLine>(60);
            update = " SELECT id, resets, uptime, date_time, pictureCounter, scanLineNumber, scanLineLength, imageBytes FROM ";
            update = String.valueOf(update) + table + where + " order by scanLineNumber";
            ResultSet r = null;
            try {
                Connection derby = this.payloadDbStore.getConnection();
                stmt = derby.createStatement(1004, 1007);
                r = stmt.executeQuery(update);
                if (r != null) {
                    while (r.next()) {
                        int lineId = r.getInt("id");
                        int lineResets = r.getInt("resets");
                        int lineUptime = r.getInt("uptime");
                        int linePc = r.getInt("pictureCounter");
                        int lineNum = r.getInt("scanLineNumber");
                        int lineLineLen = r.getInt("scanLineLength");
                        Blob blob = r.getBlob("imageBytes");
                        if (blob == null) {
                            Log.println("ERROR: Tried to create JPEG but no data bytes available");
                            return null;
                        }
                        int len = (int)blob.length();
                        byte[] blobAsBytes = blob.getBytes(1L, len);
                        PictureScanLine psl = new PictureScanLine(lineId, lineResets, (long)lineUptime, "", linePc, lineNum, lineLineLen, blobAsBytes);
                        pictureLines.add(psl);
                        blob.free();
                    }
                }
                sortedArrayList = pictureLines;
            }
            catch (SQLException e) {
                PayloadDbStore.errorPrint("selectImageLines:" + table, e);
                break block27;
            }
            finally {
                try {
                    if (r != null) {
                        r.close();
                    }
                }
                catch (SQLException sQLException) {}
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            return sortedArrayList;
        }
        return null;
    }

    private void selectLatest(String table, FramePart payload) {
        block38: {
            ResultSet r;
            Statement stmt;
            block36: {
                if (table == null) {
                    return;
                }
                if (payload == null) {
                    return;
                }
                stmt = null;
                String update = "  SELECT * FROM " + table + " ORDER BY";
                update = payload instanceof UwCanPacket ? String.valueOf(update) + " pkt_id DESC LIMIT 1" : String.valueOf(update) + " resets DESC, uptime DESC, type DESC LIMIT 1";
                r = null;
                Connection derby = this.payloadDbStore.getConnection();
                stmt = derby.createStatement();
                r = stmt.executeQuery(update);
                if (!r.next()) break block36;
                payload.id = r.getInt("id");
                payload.resets = r.getInt("resets");
                payload.uptime = r.getLong("uptime");
                payload.type = r.getInt("type");
                if (this.fox.hasModeInHeader) {
                    payload.newMode = r.getInt("newMode");
                }
                payload.reportDate = r.getString("captureDate");
                if (payload instanceof UwCanPacket) {
                    ((UwCanPacket)payload).pkt_id = r.getInt("pkt_id");
                }
                payload.init();
                payload.rawBits = null;
                int i = 0;
                while (i < payload.fieldValue.length) {
                    payload.fieldValue[i] = r.getInt(payload.layout.fieldName[i]);
                    ++i;
                }
                try {
                    if (r != null) {
                        r.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return;
            }
            try {
                try {
                    payload = null;
                }
                catch (SQLException e) {
                    PayloadDbStore.errorPrint("selectLatest:" + table, e);
                    try {
                        r.close();
                        stmt.close();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                    try {
                        if (r != null) {
                            r.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        break block38;
                    }
                    catch (SQLException sQLException) {}
                    break block38;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        r.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        payload = null;
    }

    public FramePart getLatest(String layout) throws SQLException {
        BitArrayLayout lay = this.fox.getLayoutByName(layout);
        String tableName = lay.getTableName();
        FramePart payload = null;
        payload = this.fox.hasFOXDB_V3 ? FramePart.makePayload(this.fox.foxId, 0, 0L, layout) : FramePart.makeLegacyPayload(this.fox.foxId, 0, 0L, layout);
        this.selectLatest(tableName, payload);
        return payload;
    }

    @Deprecated
    public UwCanPacket getLatestUwCanPacket() throws SQLException {
        UwCanPacket payload = new UwCanPacket(this.fox.getLayoutByName("canpacket"));
        this.selectLatest(this.uwCanPacketTableName, payload);
        return payload;
    }

    public PayloadWOD getLatestWod() throws SQLException {
        PayloadWOD payload = null;
        payload = new PayloadWOD(this.fox.getLayoutByName("wodtelemetry"));
        this.selectLatest(this.wodTableName, payload);
        return payload;
    }

    public PayloadRtValues getLatestRt() throws SQLException {
        PayloadRtValues payload = null;
        if (this.fox.hasFOXDB_V3) {
            payload = new PayloadRtValues(this.fox.getLayoutByType("RT"));
            this.selectLatest(this.makeTableName(payload.layout.name), payload);
        } else {
            payload = new PayloadRtValues(this.fox.getLayoutByName("rttelemetry"));
            this.selectLatest(this.rtTableName, payload);
        }
        return payload;
    }

    public PayloadMaxValues getLatestMax() throws SQLException {
        PayloadMaxValues max = null;
        if (this.fox.hasFOXDB_V3) {
            max = new PayloadMaxValues(this.fox.getLayoutByType("MAX"));
            this.selectLatest(this.makeTableName(max.layout.name), max);
        } else {
            max = new PayloadMaxValues(this.fox.getLayoutByName("maxtelemetry"));
            this.selectLatest(this.maxTableName, max);
        }
        return max;
    }

    public PayloadMinValues getLatestMin() throws SQLException {
        PayloadMinValues min = null;
        if (this.fox.hasFOXDB_V3) {
            min = new PayloadMinValues(this.fox.getLayoutByType("MIN"));
            this.selectLatest(this.makeTableName(min.layout.name), min);
        } else {
            min = new PayloadMinValues(this.fox.getLayoutByName("mintelemetry"));
            this.selectLatest(this.minTableName, min);
        }
        return min;
    }

    @Deprecated
    public PayloadRadExpData getLatestRad() throws SQLException {
        PayloadRadExpData rad = null;
        rad = new PayloadRadExpData(this.fox.getLayoutByName("radtelemetry"));
        this.selectLatest(this.radTableName, rad);
        return rad;
    }

    @Deprecated
    public PayloadUwExperiment getLatestUwExp() throws SQLException {
        PayloadUwExperiment rad = new PayloadUwExperiment(this.fox.getLayoutByName("cantelemetry"), 0, 0L, 0);
        this.selectLatest(this.radTableName, rad);
        return rad;
    }

    public double[][] getRtGraphData(String name, int period, Spacecraft fox2, int fromReset, long fromUptime) throws SQLException {
        String tableName = this.rtTableName;
        if (this.fox.hasFOXDB_V3) {
            BitArrayLayout lay = this.fox.getLayoutByType("RT");
            tableName = this.makeTableName(lay.name);
        }
        return this.getGraphData(tableName, name, period, fox2, fromReset, fromUptime);
    }

    public double[][] getMaxGraphData(String name, int period, Spacecraft id, int fromReset, long fromUptime) throws SQLException {
        String tableName = this.maxTableName;
        if (this.fox.hasFOXDB_V3) {
            BitArrayLayout lay = this.fox.getLayoutByType("MAX");
            tableName = this.makeTableName(lay.name);
        }
        return this.getGraphData(tableName, name, period, id, fromReset, fromUptime);
    }

    public double[][] getMinGraphData(String name, int period, Spacecraft id, int fromReset, long fromUptime) throws SQLException {
        String tableName = this.minTableName;
        if (this.fox.hasFOXDB_V3) {
            BitArrayLayout lay = this.fox.getLayoutByType("MIN");
            tableName = this.makeTableName(lay.name);
        }
        return this.getGraphData(tableName, name, period, id, fromReset, fromUptime);
    }

    public void initRad2() {
        ResultSet rs = null;
        String where = "select * from " + this.radTableName;
        Statement stmt = null;
        try {
            try {
                Connection derby = this.payloadDbStore.getConnection();
                stmt = derby.createStatement(1004, 1007);
                rs = stmt.executeQuery(where);
                while (rs.next()) {
                    PayloadRadExpData f = new PayloadRadExpData(rs, this.fox.getLayoutByName("radtelemetry"));
                    if (!this.fox.hasHerci() && !f.isTelemetry()) continue;
                    RadiationTelemetry radiationTelemetry = f.calculateTelemetryPalyoad();
                    radiationTelemetry.captureHeaderInfo(f.id, f.uptime, f.resets);
                    this.add(radiationTelemetry);
                }
            }
            catch (SQLException e) {
                PayloadDbStore.errorPrint("initRad2", e);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public void initHerciPackets() {
        int k = 0;
        int p = 0;
        ResultSet rs = null;
        String where = "select * from " + this.herciHSTableName;
        Statement stmt = null;
        try {
            try {
                Connection derby = this.payloadDbStore.getConnection();
                stmt = derby.createStatement(1004, 1007);
                rs = stmt.executeQuery(where);
                while (rs.next()) {
                    PayloadHERCIhighSpeed f = new PayloadHERCIhighSpeed(rs, this.fox.getLayoutByName("herciHSdata"));
                    int type = rs.getInt(5);
                    ++k;
                    ArrayList<HerciHighSpeedPacket> pkts = f.calculateTelemetryPackets();
                    int i = 0;
                    while (i < pkts.size()) {
                        HerciHighSpeedPacket pk = pkts.get(i);
                        pk.captureHeaderInfo(f.id, f.uptime, f.resets);
                        pk.type = type * 1000 + 900 + i;
                        this.add(pk);
                        ++p;
                        this.updatedHerciPacket = true;
                        ++i;
                    }
                }
                Log.println("Processed " + k + " HERCI HS FRAMES generating " + p + " mini packets");
            }
            catch (SQLException e) {
                PayloadDbStore.errorPrint("initRad2", e);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean storeLastCanId(String user, int pkt_id) {
        Statement ps = null;
        Statement ps2 = null;
        try {
            Connection derby = this.payloadDbStore.getConnection();
            ps = derby.prepareStatement("UPDATE " + this.uwCanPacketTimestampTableName + " SET last_pkt_id = ? where username = ?");
            ps.setInt(1, pkt_id);
            ps.setString(2, user);
            int rows = ps.executeUpdate();
            if (rows > 0) {
                return true;
            }
            Log.println("Could not update the CAN pkt id for " + user + " trying INSERT");
            ps2 = derby.prepareStatement("INSERT INTO " + this.uwCanPacketTimestampTableName + " (username, last_pkt_id) VALUES (?, ?)");
            ps2.setString(1, user);
            ps2.setInt(2, pkt_id);
            rows = ps2.executeUpdate();
            if (rows > 0) {
                return true;
            }
            Log.println("ERROR: Could not insert the CAN pkt id " + pkt_id + " for " + user);
            return false;
        }
        catch (SQLException e) {
            PayloadDbStore.errorPrint("ERROR Check Password SQL:", e);
            return false;
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public int getLastCanId(String user) {
        Statement ps = null;
        ResultSet rs = null;
        int pktId = 0;
        try {
            Connection derby = this.payloadDbStore.getConnection();
            ps = derby.prepareStatement("SELECT last_pkt_id from " + this.uwCanPacketTimestampTableName + " where username = ?");
            ps.setString(1, user);
            rs = ps.executeQuery();
            while (rs.next()) {
                pktId = rs.getInt("last_pkt_id");
            }
            int n = pktId;
            return n;
        }
        catch (SQLException e) {
            PayloadDbStore.errorPrint("ERROR Check Password SQL:", e);
            try {
                rs.close();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            try {
                ps.close();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int checkForNewReset(int id, long uptime, Date stpDate, int resetOnFrame, String groundStation) {
        PreparedStatement ps = null;
        Statement ps1 = null;
        Statement ps2 = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        Timestamp T0 = null;
        int currentReset = 0;
        long stpSeconds = 0L;
        if (stpDate != null) {
            stpSeconds = stpDate.getTime() / 1000L;
        }
        Date now = new Date();
        long nowSeconds = now.getTime() / 1000L;
        long T0Seconds = 0L;
        Connection conn = null;
        try {
            conn = this.payloadDbStore.getConnection();
            conn.setAutoCommit(false);
            ps = conn.prepareStatement("SELECT max(resets) as reset from T0_LOG where id = ?");
            ps.setInt(1, id);
            rs = ps.executeQuery();
            while (rs.next()) {
                currentReset = rs.getInt("reset");
            }
            ps1 = conn.prepareStatement("SELECT T0_estimate_date_time from T0_LOG where id = ? and resets = ?");
            ps1.setInt(1, id);
            ps1.setInt(2, currentReset);
            rs1 = ps1.executeQuery();
            while (rs1.next()) {
                T0 = rs1.getTimestamp("T0_estimate_date_time");
            }
            if (T0 != null) {
                T0Seconds = T0.getTime() / 1000L;
            }
            long stpDiff2Now = Math.abs(nowSeconds - stpSeconds);
            long stpDiff2T0 = Math.abs(stpSeconds - (T0Seconds + uptime));
            if (ServerConfig.isTrustedGroundStation(groundStation)) {
                if (stpDiff2Now > (long)ServerConfig.realTimeReceptionThreshold) {
                    if (ServerConfig.debugResetCheck) {
                        Log.println("### NON RT Frame REJECTED from trusted: " + groundStation + ": " + stpDate + ": " + stpDiff2T0 + " from T0 + uptime and " + stpDiff2Now + " from current time");
                    }
                    conn.commit();
                    return -1;
                }
                if (T0Seconds == 0L || uptime < (long)ServerConfig.newResetCheckUptimeMax) {
                    if (ServerConfig.debugResetCheck) {
                        Log.println("*** Trusted station: " + groundStation + ": " + stpDate + ": " + stpDiff2T0 + " from T0 + uptime and " + stpDiff2Now + " from current time");
                    }
                    if (stpDiff2T0 > (long)ServerConfig.newResetCheckThreshold) {
                        Log.println("*** HUSKY NON MRAM LOGGED RESET DETECTED ...." + groundStation + ": ");
                        Log.println("*** stpDate: " + groundStation + ": " + stpDate + " " + stpSeconds);
                        Log.println("*** TO: " + groundStation + ": " + T0 + " " + T0Seconds);
                        Log.println("*** uptime: " + groundStation + ": " + uptime);
                        Log.println("*** DIFF: " + groundStation + ": " + stpDiff2T0);
                        if (T0Seconds != 0L) {
                            ++currentReset;
                        }
                        ps2 = conn.prepareStatement("INSERT INTO T0_LOG (id, resets, T0_estimate_date_time) VALUES (?, ?, ?)");
                        ps2.setInt(1, id);
                        ps2.setInt(2, currentReset);
                        Timestamp newT0estimate = new Timestamp((stpSeconds - uptime) * 1000L);
                        ps2.setTimestamp(3, newT0estimate);
                        int rows = ps2.executeUpdate();
                        if (rows > 0) {
                            conn.commit();
                            int n = currentReset;
                            return n;
                        }
                        Log.println("ERROR: Could not insert the new reset number" + currentReset + " from " + groundStation);
                        conn.rollback();
                        return -1;
                    }
                }
                conn.commit();
                int n = currentReset;
                return n;
            }
            int gsct = ServerConfig.groundStationClockThreshold;
            if (uptime > (long)ServerConfig.newResetCheckUptimeMax) {
                gsct *= 3;
            }
            if (stpDiff2T0 < (long)gsct) {
                conn.commit();
                int n = currentReset;
                return n;
            }
            if (ServerConfig.debugResetCheck) {
                Log.println("### DELAYED Frame REJECTED: " + groundStation + ": uptime: " + uptime + " stp: " + stpDate + ": " + stpDiff2T0 + " from T0 + uptime and " + stpDiff2Now + " from current time");
            }
            conn.commit();
            return -1;
        }
        catch (SQLException e) {
            PayloadDbStore.errorPrint("ERROR Check SQL:", e);
            try {
                conn.rollback();
                rs.close();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            try {
                if (rs1 != null) {
                    rs1.close();
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            try {
                if (ps1 != null) {
                    ps1.close();
                }
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            try {
                if (ps2 == null) return -1;
                ps2.close();
                return -1;
            }
            catch (SQLException e1) {
                e1.printStackTrace();
                return -1;
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (rs1 != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (ps1 != null) {
                    ps1.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (conn != null) {
                    conn.setAutoCommit(true);
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public String[][] getRadData(int period, int id, int fromReset, long fromUptime) throws SQLException {
        String where = "";
        where = (double)fromReset == 0.0 && (double)fromUptime == 0.0 ? " ORDER BY resets DESC, uptime DESC " : " where uptime >= " + fromUptime + " and resets >= " + fromReset + " ORDER BY resets DESC, uptime DESC ";
        Statement stmt = null;
        String update = " SELECT * FROM ";
        update = String.valueOf(update) + this.radTableName + where + " LIMIT " + period;
        ResultSet rs = null;
        String[][] resultSet = null;
        try {
            try {
                Connection derby = this.payloadDbStore.getConnection();
                stmt = derby.createStatement(1004, 1007);
                rs = stmt.executeQuery(update);
                int size = 0;
                if (rs != null) {
                    rs.beforeFirst();
                    rs.last();
                    size = rs.getRow();
                }
                resultSet = new String[size][61];
                int i = 0;
                if (size > 0) {
                    resultSet[i][0] = "" + rs.getInt("resets");
                    resultSet[i][1] = "" + rs.getLong("uptime");
                    int j = 0;
                    while (j < 58) {
                        resultSet[i][j + 2] = "" + rs.getInt(j + 6);
                        ++j;
                    }
                    ++i;
                    while (rs.previous()) {
                        resultSet[i][0] = "" + rs.getInt("resets");
                        resultSet[i][1] = "" + rs.getLong("uptime");
                        j = 0;
                        while (j < 58) {
                            resultSet[i][j + 2] = "" + rs.getInt(j + 6);
                            ++j;
                        }
                        ++i;
                    }
                }
            }
            catch (SQLException e) {
                PayloadDbStore.errorPrint("selectRows:" + this.radTableName, e);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return resultSet;
    }

    public double[][] getGraphData(String name, int period, Spacecraft fox2, int fromReset, long fromUptime, String layout) throws SQLException {
        BitArrayLayout lay = this.fox.getLayoutByName(layout);
        String tableName = lay.getTableName();
        return this.getGraphData(tableName, name, period, fox2, fromReset, fromUptime);
    }

    private double[][] getGraphData(String table, String name, int period, Spacecraft id, int fromReset, long fromUptime) throws SQLException {
        ResultSet rs = null;
        String where = "";
        where = (double)fromReset == 0.0 && (double)fromUptime == 0.0 ? " ORDER BY resets DESC, uptime DESC " : " where uptime >= " + fromUptime + " and resets >= " + fromReset + " ORDER BY resets, uptime ";
        Statement stmt = null;
        String update = " SELECT resets, uptime, " + name + " FROM ";
        update = String.valueOf(update) + table + where + " LIMIT " + period;
        double[] results = null;
        double[] upTime = null;
        double[] resets = null;
        double[][] resultSet = null;
        int size = 0;
        try {
            try {
                Connection derby = this.payloadDbStore.getConnection();
                stmt = derby.createStatement(1004, 1007);
                rs = stmt.executeQuery(update);
                if (rs != null) {
                    rs.beforeFirst();
                    rs.last();
                    size = rs.getRow();
                }
                results = new double[size];
                upTime = new double[size];
                resets = new double[size];
                int i = 0;
                if (size > 0) {
                    resets[i] = rs.getInt("resets");
                    upTime[i] = rs.getLong("uptime");
                    int rawValue = rs.getInt(name);
                    PayloadRtValues rt = this.fox.hasFOXDB_V3 ? new PayloadRtValues(id.getLayoutByType("RT")) : new PayloadRtValues(id.getLayoutByName("rttelemetry"));
                    results[i++] = rt.convertRawValue(name, rawValue, id);
                    while (rs.previous()) {
                        resets[i] = rs.getInt("resets");
                        upTime[i] = rs.getLong("uptime");
                        rawValue = rs.getInt(name);
                        results[i++] = rt.convertRawValue(name, rawValue, id);
                    }
                } else {
                    results = new double[1];
                    upTime = new double[1];
                    resets = new double[1];
                }
                resultSet = new double[3][size];
                resultSet[0] = results;
                resultSet[1] = upTime;
                resultSet[2] = resets;
            }
            catch (SQLException e) {
                PayloadDbStore.errorPrint("selectRows:" + table, e);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return resultSet;
    }

    public void deleteAll() {
        this.drop(this.rtTableName);
        this.drop(this.maxTableName);
        this.drop(this.minTableName);
        this.drop(this.radTableName);
        this.initPayloadFiles();
        this.setUpdatedAll();
    }

    private void drop(String table) {
        Statement stmt = null;
        try {
            try {
                Connection derby = this.payloadDbStore.getConnection();
                stmt = derby.createStatement();
                boolean res = stmt.execute("drop table " + table);
                stmt.close();
            }
            catch (SQLException e) {
                if (e.getSQLState().equals(ERR_OPEN_RESULT_SET)) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException res) {
                        // empty catch block
                    }
                    try {
                        Log.println("RETRYING.....");
                        boolean res = stmt.execute("drop table " + table);
                    }
                    catch (SQLException e1) {
                        Log.println("RETRY FAILED");
                        PayloadDbStore.errorPrint("drop:" + table, e);
                    }
                }
                if (!e.getSQLState().equals(ERR_TABLE_DOES_NOT_EXIST)) {
                    PayloadDbStore.errorPrint("drop:" + table, e);
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public static void remove(String f) throws IOException {
        block3: {
            try {
                File file = new File(f);
                if (!file.exists()) break block3;
                if (file.delete()) {
                    Log.println(String.valueOf(file.getName()) + " is deleted!");
                    break block3;
                }
                Log.println("Delete operation failed for: " + file.getName());
                throw new IOException("Could not delete file " + file.getName() + " Check the file system and remove it manually.");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(MainWindow.frame, ex.toString(), "Error Deleting File", 0);
            }
        }
    }
}

