/*
 * Decompiled with CFR 0.152.
 */
package telemetry;

import common.Config;
import common.Log;
import common.Spacecraft;
import gui.MainWindow;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import telemetry.SatPayloadStore;
import telemetry.SortedJpegList;
import telemetry.legacyPayloads.CameraJpeg;
import telemetry.legacyPayloads.PictureScanLine;

public class SatPictureStore {
    private static final int INIT_SIZE = 100;
    private Spacecraft fox;
    public int foxId;
    public static String JPG_INDEX_NAME = "jpg_index.dat";
    private String fileName = JPG_INDEX_NAME;
    boolean updatedCamera = false;
    SortedJpegList jpegIndex;

    public SatPictureStore(int id) {
        this.foxId = id;
        this.fox = Config.satManager.getSpacecraft(id);
        this.initPayloadFiles();
    }

    private void initPayloadFiles() {
        File aFile;
        String dir = "images";
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            dir = String.valueOf(Config.logFileDirectory) + File.separator + dir;
        }
        if (!(aFile = new File(dir)).isDirectory()) {
            aFile.mkdir();
            Log.println("Making directory: " + dir);
        }
        if (!aFile.isDirectory()) {
            Log.errorDialog("ERROR", "ERROR can't create the directory: " + aFile.getAbsolutePath() + "\nAny decoded pictures will not be saved to disk. Downloaded picture lines\n" + "can still be decoded and uploaded to the server.");
        }
        this.jpegIndex = new SortedJpegList(100);
        this.fileName = "images" + File.separator + "Fox" + this.foxId + JPG_INDEX_NAME;
        try {
            this.load(this.fileName);
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(MainWindow.frame, e.toString(), "ERROR Loading Stored Jpeg Index data", 0);
            e.printStackTrace(Log.getWriter());
        }
        String header = CameraJpeg.JPG_HEADER;
        File hFile = new File(header);
        if (!hFile.exists()) {
            Log.errorDialog("ERROR", "ERROR can't find the file: " + hFile.getAbsolutePath() + "\nWithout the JPEG header information downloaded picture lines can not be converted into a viewable image.\n" + "They can still be decoded and uploaded to the server.");
        }
    }

    public void setUpdatedAll() {
        this.updatedCamera = true;
    }

    public boolean getUpdatedCamera() {
        return this.updatedCamera;
    }

    public void setUpdatedCamera(boolean u) {
        this.updatedCamera = u;
    }

    public int getNumberOfPictureCounters() {
        return this.jpegIndex.size();
    }

    public boolean add(int id, int resets, long uptime, PictureScanLine line) throws IOException {
        CameraJpeg jpg2;
        for (CameraJpeg jpg2 : this.jpegIndex) {
            if (!jpg2.isSameFile(id, resets, uptime, line.pictureCounter)) continue;
            jpg2.addLine(line);
            this.updatedCamera = true;
            return true;
        }
        jpg2 = new CameraJpeg(id, resets, uptime, uptime, line.pictureCounter, line);
        this.jpegIndex.add(jpg2);
        this.updatedCamera = true;
        this.save(jpg2, this.fileName, true);
        return true;
    }

    public SortedJpegList getJpegIndex(int id, int period, int fromReset, long fromUptime) {
        int start = 0;
        int end = 0;
        if (fromReset == 0 && fromUptime == 0L) {
            start = this.jpegIndex.size() - period;
            end = this.jpegIndex.size();
        } else {
            start = this.jpegIndex.getNearestFrameIndex(this.fox.foxId, fromUptime, fromReset);
            if (start == -1) {
                return null;
            }
            end = start + period;
        }
        if (end > this.jpegIndex.size()) {
            end = this.jpegIndex.size();
        }
        if (end < start) {
            end = start;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > this.jpegIndex.size()) {
            start = this.jpegIndex.size();
        }
        SortedJpegList results = new SortedJpegList(end - start);
        int i = end - 1;
        while (i >= start) {
            results.add((CameraJpeg)this.jpegIndex.get(i));
            --i;
        }
        return results;
    }

    public void load(String log) throws FileNotFoundException {
        File aFile;
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            log = String.valueOf(Config.logFileDirectory) + File.separator + log;
            Log.println("Loading: " + log);
        }
        if (!(aFile = new File(log)).exists()) {
            try {
                aFile.createNewFile();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(MainWindow.frame, e.toString(), "ERROR creating jpeg index file " + log, 0);
                e.printStackTrace(Log.getWriter());
            }
        }
        boolean deleted = false;
        BufferedReader dis = new BufferedReader(new FileReader(log));
        try {
            String line;
            while ((line = dis.readLine()) != null) {
                CameraJpeg jpg;
                if (line == null) continue;
                StringTokenizer st = new StringTokenizer(line, ",");
                String date = st.nextToken();
                int id = Integer.valueOf(st.nextToken());
                int resets = Integer.valueOf(st.nextToken());
                long fromUptime = Long.valueOf(st.nextToken());
                long toUptime = Long.valueOf(st.nextToken());
                int pictureCounter = Integer.valueOf(st.nextToken());
                String name = st.nextToken();
                if (Config.satManager.getSpacecraft(id) == null) {
                    Log.errorDialog("FATAL", "Attempting to Load payloads from the Camera Line store for satellite with Fox Id: " + id + "\n when no sattellite with that FoxId is configured.  Add this spacecraft to the satellite directory and restart FoxTelem." + "\nProgram will now exit");
                    System.exit(1);
                }
                if ((jpg = new CameraJpeg(id, resets, fromUptime, toUptime, pictureCounter, date, name)).fileExists()) {
                    this.jpegIndex.add(jpg);
                    this.updatedCamera = true;
                    continue;
                }
                deleted = true;
            }
            dis.close();
            if (deleted && this.jpegIndex.size() > 0) {
                this.save((CameraJpeg)this.jpegIndex.get(0), log, false);
                int i = 1;
                while (i < this.jpegIndex.size()) {
                    this.save((CameraJpeg)this.jpegIndex.get(i), log, true);
                    ++i;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace(Log.getWriter());
        }
        catch (NumberFormatException n) {
            n.printStackTrace(Log.getWriter());
        }
        catch (NoSuchElementException n) {
            Log.println("ERROR loading record from camera picture line store");
            n.printStackTrace(Log.getWriter());
        }
    }

    public void save(CameraJpeg frame, String log, boolean append) throws IOException {
        File aFile;
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            log = String.valueOf(Config.logFileDirectory) + File.separator + log;
        }
        if (!(aFile = new File(log)).exists()) {
            aFile.createNewFile();
        }
        BufferedWriter output = new BufferedWriter(new FileWriter(aFile, append));
        try {
            output.write(String.valueOf(frame.toString()) + "\n");
            ((Writer)output).flush();
        }
        finally {
            ((Writer)output).flush();
            ((Writer)output).close();
        }
    }

    public void deleteAll() {
        String log = this.fileName;
        if (!Config.logFileDirectory.equalsIgnoreCase("")) {
            log = String.valueOf(Config.logFileDirectory) + File.separator + log;
        }
        try {
            int i = 0;
            while (i < this.jpegIndex.size()) {
                if (((CameraJpeg)this.jpegIndex.get(i)).fileExists()) {
                    SatPayloadStore.remove(((CameraJpeg)this.jpegIndex.get(i)).getFileName());
                    SatPayloadStore.remove(String.valueOf(((CameraJpeg)this.jpegIndex.get(i)).getFileName()) + ".tn");
                }
                ++i;
            }
            SatPayloadStore.remove(log);
            this.initPayloadFiles();
            this.setUpdatedAll();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(MainWindow.frame, ex.toString(), "Error Deleting JPeg Index Files for FoxId:" + this.foxId + ", check permissions on file: \n" + log, 0);
        }
    }
}

