/*
 * Decompiled with CFR 0.152.
 */
package telemetry;

import common.Config;

public class TableSeg
implements Comparable<TableSeg> {
    int fromReset = 0;
    long fromUptime = 0L;
    int records = 0;
    private boolean loaded = false;
    String fileName;
    long lastAccess;

    public TableSeg(int r, long u, String f) {
        this.fromReset = r;
        this.fromUptime = u;
        this.records = 0;
        this.fileName = String.valueOf(f) + "_" + r + "_" + u + ".log";
        this.accessed();
    }

    TableSeg(int r, long u, String f, int rec) {
        this.fromReset = r;
        this.fromUptime = u;
        this.records = rec;
        this.fileName = f;
        this.accessed();
    }

    public void accessed() {
        this.lastAccess = System.nanoTime() / 1000000L;
    }

    public boolean isLoaded() {
        this.accessed();
        return this.loaded;
    }

    public boolean isStale() {
        long now;
        long elapsed;
        return this.loaded && (elapsed = (now = System.nanoTime() / 1000000L) - this.lastAccess) > (long)Config.timeUntilTableSegOffloaded;
    }

    public void setLoaded(boolean t) {
        this.accessed();
        this.loaded = t;
    }

    public String toFile() {
        String s = "";
        s = String.valueOf(s) + this.fromReset + ",";
        s = String.valueOf(s) + this.fromUptime + ",";
        s = String.valueOf(s) + this.records + ",";
        s = String.valueOf(s) + this.fileName + ",";
        return s;
    }

    @Override
    public int compareTo(TableSeg p) {
        if (this.fromReset == p.fromReset && this.fromUptime == p.fromUptime) {
            return 0;
        }
        if (this.fromReset < p.fromReset) {
            return -1;
        }
        if (this.fromReset > p.fromReset) {
            return 1;
        }
        if (this.fromReset == p.fromReset && this.fromUptime < p.fromUptime) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        return String.valueOf(this.fileName) + ": " + this.fromReset + "," + this.fromUptime + "," + this.records;
    }
}

