/*
 * Decompiled with CFR 0.152.
 */
package telemetry.conversion;

import common.Spacecraft;
import telemetry.FramePart;
import telemetry.conversion.Conversion;

public class ConversionFormat
extends Conversion {
    public String type;
    int modifier = 0;

    public ConversionFormat(String name, Spacecraft fox) {
        super(name, fox);
        name.trim();
        this.type = name;
        String stem3 = "";
        if (name.length() >= 3) {
            stem3 = name.substring(0, 3);
            if (stem3.equalsIgnoreCase("HEX")) {
                this.type = "HEX";
                this.modifier = this.getIndex(name, 3);
            } else if (stem3.equalsIgnoreCase("BIN")) {
                this.type = "BIN";
                this.modifier = this.getIndex(name, 3);
            } else if (name.length() >= 5 && name.substring(0, 5).equalsIgnoreCase("FLOAT")) {
                this.type = name;
            }
        }
    }

    private int getIndex(String name, int offset) {
        int modifier = 0;
        String index3 = name.substring(offset);
        try {
            modifier = Integer.parseInt(index3);
        }
        catch (NumberFormatException e) {
            modifier = 1;
        }
        return modifier;
    }

    @Override
    public double calculate(double x) {
        return x;
    }

    @Override
    public String calculateString(double x) {
        String s = "";
        switch (this.type) {
            case "INT": {
                s = Long.toString((long)x);
                return s;
            }
            case "FLOAT": 
            case "FLOAT1": {
                s = String.format("%2.1f", x);
                return s;
            }
            case "FLOAT2": {
                s = String.format("%1.2f", x);
                return s;
            }
            case "FLOAT3": {
                s = String.format("%1.3f", x);
                return s;
            }
            case "FLOAT4": {
                s = String.format("%1.4f", x);
                return s;
            }
            case "FLOAT5": {
                s = String.format("%1.5f", x);
                return s;
            }
            case "FLOAT6": {
                s = String.format("%1.6f", x);
                return s;
            }
            case "HEX": {
                s = FramePart.toHexString((long)x, this.modifier);
                return s;
            }
            case "BIN": {
                s = FramePart.intToBin((int)x, this.modifier);
                return s;
            }
        }
        return null;
    }
}

