/*
 * Decompiled with CFR 0.152.
 */
package telemetry.conversion;

import common.Config;
import common.Log;
import common.Spacecraft;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import telemetry.LayoutLoadException;
import telemetry.conversion.Conversion;

public class ConversionStringLookUpTable
extends Conversion {
    public static final String ERROR = "UNK";
    protected Map<Integer, String> table = new LinkedHashMap<Integer, String>();

    public ConversionStringLookUpTable(String name, Spacecraft fox) {
        super(name, fox);
    }

    public ConversionStringLookUpTable(String name, String fileName, Spacecraft fox) throws FileNotFoundException, LayoutLoadException {
        super(name, fox);
        this.load(fileName);
    }

    @Override
    public String calculateString(double x) {
        int key = (int)Math.round(x);
        String value = this.table.get(key);
        if (value == null) {
            String s = String.format("%2.1f", x);
            return s;
        }
        return value;
    }

    @Override
    public double calculate(double x) {
        return x;
    }

    public int getMaxKey() {
        int max = -9999;
        Map.Entry<Integer, String> pairs2 = null;
        for (Map.Entry<Integer, String> pairs2 : this.table.entrySet()) {
            int key = pairs2.getKey();
            if (key <= max) continue;
            max = key;
        }
        return max;
    }

    public int getMinKey() {
        int min = 9999;
        Map.Entry<Integer, String> pairs2 = null;
        for (Map.Entry<Integer, String> pairs2 : this.table.entrySet()) {
            int key = pairs2.getKey();
            if (key >= min) continue;
            min = key;
        }
        return min;
    }

    protected void load(String fileName) throws FileNotFoundException, LayoutLoadException {
        fileName = String.valueOf(Config.spacecraftDir) + File.separator + fileName;
        Log.println("Loading lookup table: " + fileName);
        BufferedReader dis = new BufferedReader(new FileReader(fileName));
        try {
            String line;
            while ((line = dis.readLine()) != null) {
                if (line == null) continue;
                StringTokenizer st = new StringTokenizer(line, ",");
                int key = Integer.valueOf(st.nextToken());
                this.table.put(key, st.nextToken().trim());
            }
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace(Log.getWriter());
        }
        catch (NumberFormatException n) {
            Log.errorDialog("NUMBER FORMAT EXCEPTION", "Loading Lookup table " + fileName + " " + n.getMessage());
            n.printStackTrace(Log.getWriter());
        }
        catch (NoSuchElementException n) {
            Log.errorDialog("Missing Field in Lookup table File", "Halted loading " + fileName);
            n.printStackTrace(Log.getWriter());
        }
    }

    public String toString() {
        String s = "";
        s = String.valueOf(s) + "Lookup Table: " + this.name;
        return s;
    }
}

