/*
 * Decompiled with CFR 0.152.
 */
package telemetry.frames;

import common.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import telemetry.BitArrayLayout;
import telemetry.LayoutLoadException;

public class FrameLayout {
    public Properties properties = new Properties();
    public File propertiesFile;
    String fileName;
    public String name;
    HashMap<Integer, String> payloadNames;
    int foxId;

    public FrameLayout(int foxId, String fileName) throws LayoutLoadException {
        this.fileName = String.valueOf(Config.spacecraftDir) + File.separator + fileName;
        this.foxId = foxId;
        this.propertiesFile = new File(this.fileName);
        this.payloadNames = new HashMap();
        this.load();
    }

    protected void load() throws LayoutLoadException {
        FileInputStream f = null;
        try {
            f = new FileInputStream(this.propertiesFile);
            this.properties.load(f);
            f.close();
            Enumeration<?> enums = this.properties.propertyNames();
            while (enums.hasMoreElements()) {
                try {
                    String key = (String)enums.nextElement();
                    String[] keyparts = key.split("\\.");
                    String part = keyparts[0].substring(0, 7);
                    String index = keyparts[0].substring(7);
                    int idx = Integer.parseInt(index);
                    if (!part.equalsIgnoreCase("payload") || !keyparts[1].equalsIgnoreCase("name")) continue;
                    String value = this.properties.getProperty(key);
                    this.payloadNames.put(idx, value);
                }
                catch (NumberFormatException key) {
                    // empty catch block
                }
            }
            if (this.payloadNames.size() == 0) {
                throw new LayoutLoadException("Empty Frame Definition File.  No Payloads were defined in the Frame definition file.  It will not be loaded.");
            }
            int i = 0;
            while (i < this.payloadNames.size()) {
                String payloadName = this.payloadNames.get(i);
                if (payloadName == null) {
                    throw new LayoutLoadException("Frame Definition File: " + this.propertiesFile.getAbsolutePath() + "\n missing payload number " + i + ".  Was that defined in the file? It will not be loaded.");
                }
                ++i;
            }
        }
        catch (IOException e) {
            if (f != null) {
                try {
                    f.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new LayoutLoadException("Could not load FrameLayout file: " + this.propertiesFile.getAbsolutePath());
        }
    }

    public String getPayloadName(int i) {
        return this.payloadNames.get(i);
    }

    public BitArrayLayout getPayload(int i) {
        String name = this.payloadNames.get(i);
        BitArrayLayout lay = Config.satManager.getLayoutByName(this.foxId, name);
        return lay;
    }

    public int getPayloadLength(int i) {
        String name = this.payloadNames.get(i);
        BitArrayLayout lay = Config.satManager.getLayoutByName(this.foxId, name);
        if (lay == null) {
            return 0;
        }
        return lay.getMaxNumberOfBytes();
    }

    public int getNumberOfPayloads() {
        return this.payloadNames.size();
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public int getInt(String key) {
        return Integer.parseInt(this.properties.getProperty(key));
    }

    public boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.properties.getProperty(key));
    }

    public String toString() {
        String s = this.name;
        return s;
    }
}

