/*
 * Decompiled with CFR 0.152.
 */
package telemetry.frames;

import common.Config;
import decoder.FoxDecoder;
import telemetry.BitArrayLayout;
import telemetry.frames.Header;

public class SlowSpeedHeader
extends Header {
    int extFoxId;
    int safeMode;
    int healthMode;
    int scienceMode;

    @Deprecated
    public SlowSpeedHeader() {
        super(98, new BitArrayLayout());
        this.MAX_BYTES = 7;
        this.rawBits = new boolean[this.MAX_BYTES * 8];
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void copyBitsToFields() {
        super.copyBitsToFields();
        this.type = this.nextbits(4);
        if (this.id == 0) {
            this.extFoxId = this.nextbits(5);
            this.id = 8 + this.extFoxId;
            this.safeMode = this.nextbits(1);
            this.healthMode = this.nextbits(1);
            this.scienceMode = this.nextbits(1);
        }
    }

    @Override
    public boolean isValid() {
        this.copyBitsToFields();
        return Config.satManager.validFoxId(this.id);
    }

    @Override
    public String toString() {
        this.copyBitsToFields();
        String s = new String();
        s = String.valueOf(s) + "ID: " + FoxDecoder.dec(this.id) + " RESET COUNT: " + FoxDecoder.dec(this.resets) + " UPTIME: " + FoxDecoder.dec(this.uptime) + " TYPE: " + FoxDecoder.dec(this.type);
        return s;
    }
}

