/*
 * Decompiled with CFR 0.152.
 */
package telemetry.legacyPayloads;

import common.Config;
import common.Spacecraft;
import decoder.FoxBitStream;
import decoder.FoxDecoder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import telemetry.BitArrayLayout;
import telemetry.FramePart;
import telemetry.legacyPayloads.RadiationTelemetry;

@Deprecated
public class PayloadRadExpData
extends FramePart {
    public static final int MAX_PAYLOAD_RAD_SIZE = 58;
    public static final String EXP1_BOARD_NUM = "exp1BoardNum";
    public static final String WOD_RESETS = "WODTimestampReset";
    public static final String WOD_UPTIME = "WODTimestampUptime";
    public static final String WOD_CRC_ERROR = "WodCRCError";
    public static final int ACTIVE = 3;
    public static final String STATE2 = "State2";
    public static final String STATE3 = "State3";
    public static final String STATE4 = "State4";

    public PayloadRadExpData(BitArrayLayout lay) {
        super(4, lay);
    }

    public PayloadRadExpData(int id, int resets, long uptime, String date, StringTokenizer st, BitArrayLayout lay) {
        super(id, resets, uptime, 4, date, st, lay);
    }

    public PayloadRadExpData(ResultSet r, BitArrayLayout lay) throws SQLException {
        super(r, 4, lay);
    }

    @Override
    protected void init() {
    }

    public boolean isTelemetry() {
        if (this.id == 1 || this.id == 3) {
            int i = 21;
            while (i < 25) {
                if (this.fieldValue[i] != 0) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected void calcFox1ETelemetry(RadiationTelemetry radTelem) {
        int k = 0;
        while (k < 10) {
            radTelem.addNext8Bits(this.fieldValue[k]);
            ++k;
        }
        radTelem.copyBitsToFields();
        int offset = 0;
        int length = 0;
        if (radTelem.getRawValue(STATE2) == 3) {
            offset = 0;
            length = 16;
        } else if (radTelem.getRawValue(STATE3) == 3) {
            offset = 16;
            length = 10;
        } else if (radTelem.getRawValue(STATE4) == 3) {
            offset = 26;
            length = 16;
        }
        int k2 = 0;
        while (k2 < offset) {
            radTelem.addNext8Bits(0);
            ++k2;
        }
        k2 = 10 + offset;
        while (k2 < 10 + offset + length) {
            radTelem.addNext8Bits(this.fieldValue[k2 - offset]);
            ++k2;
        }
        radTelem.copyBitsToFields();
        radTelem.blockCopyBits = true;
        this.copyFieldValue(EXP1_BOARD_NUM, radTelem);
        this.copyFieldValue(WOD_RESETS, radTelem);
        this.copyFieldValue(WOD_UPTIME, radTelem);
        this.copyFieldValue(WOD_CRC_ERROR, radTelem);
    }

    private void copyFieldValue(String field, RadiationTelemetry radTelem) {
        int pos = radTelem.layout.getPositionByName(field);
        int val = this.getRawValue(field);
        if (pos != BitArrayLayout.ERROR_POSITION && val != BitArrayLayout.ERROR_POSITION) {
            radTelem.fieldValue[pos] = val;
        }
    }

    public RadiationTelemetry calculateTelemetryPalyoad() {
        Spacecraft fox = Config.satManager.getSpacecraft(this.id);
        if (fox.hasExperiment(7) && fox.hasExperiment(8)) {
            RadiationTelemetry radTelem = new RadiationTelemetry(this.resets, this.uptime, Config.satManager.getLayoutByName(this.id, "radtelemetry2"));
            this.calcFox1ETelemetry(radTelem);
            return radTelem;
        }
        RadiationTelemetry radTelem = new RadiationTelemetry(this.resets, this.uptime, Config.satManager.getLayoutByName(this.id, "radtelemetry2"));
        int k = 0;
        while (k < radTelem.getMaxBytes()) {
            radTelem.addNext8Bits(this.fieldValue[k]);
            ++k;
        }
        return radTelem;
    }

    public void DATAaddNext8Bits(byte b) {
        int i = 0;
        while (i < 8) {
            this.rawBits[7 - i + this.numberBytesAdded * 8] = (b >> i & 1) == 1;
            ++i;
        }
        ++this.numberBytesAdded;
    }

    protected int DATAnextbits(int n) {
        int field = 0;
        boolean[] b = new boolean[n];
        int i = 0;
        while (i < n) {
            b[i] = this.rawBits[this.bitPosition + i];
            ++i;
        }
        this.bitPosition += n;
        field = FoxBitStream.binToInt(b);
        return field;
    }

    public boolean hasData() {
        this.copyBitsToFields();
        int i = 0;
        while (i < 58) {
            if (this.fieldValue[i] != 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String toString() {
        this.copyBitsToFields();
        String s = new String();
        s = String.valueOf(s) + "RADIATION EXPERIMENT DATA:\n";
        int i = 0;
        while (i < 58) {
            s = String.valueOf(s) + FoxDecoder.hex(this.fieldValue[i]) + " ";
            if ((i + 1) % 8 == 0) {
                s = String.valueOf(s) + "\n";
            }
            ++i;
        }
        return s;
    }

    public String toStringField() {
        this.copyBitsToFields();
        String s = new String();
        s = String.valueOf(s) + "RADIATION EXPERIMENT DATA:\n";
        int i = 0;
        while (i < this.layout.fieldName.length) {
            s = String.valueOf(s) + this.layout.fieldName[i] + ": " + this.fieldValue[i] + "\n";
            ++i;
        }
        return s;
    }

    public String toFile() {
        this.copyBitsToFields();
        String s = new String();
        s = String.valueOf(s) + this.reportDate + "," + this.id + "," + this.resets + "," + this.uptime + "," + this.type + ",";
        int i = 0;
        while (i < this.fieldValue.length - 1) {
            s = String.valueOf(s) + FoxDecoder.dec(this.fieldValue[i]) + ",";
            ++i;
        }
        s = String.valueOf(s) + FoxDecoder.dec(this.fieldValue[this.fieldValue.length - 1]);
        return s;
    }

    @Override
    public boolean isValid() {
        return false;
    }
}

