/*
 * Decompiled with CFR 0.152.
 */
package telemetry.legacyPayloads;

import common.Spacecraft;
import decoder.FoxBitStream;
import telemetry.BitArray;
import telemetry.BitArrayLayout;
import telemetry.Cobs;
import telemetry.CobsDecodeException;

public class RadiationPacket
extends BitArray {
    public int MAX_PACKET_BYTES;
    public int NUMBER_OF_FIELDS;
    public int reset;
    public long uptime;
    int[] rawBytes;
    int numberOfRawBytes;
    public static final String FILLER = "FILLER";
    public static final String[] radPacketState = new String[]{"OFF", "STANDBY", "DIAGNOSTIC", "ACTIVE", "DISABLED", "HALT"};
    public static final String[] radPacketStateShort = new String[]{"OFF", "STDBY", "DIAG", "ACT", "DIS", "GALT"};
    public static final String[] packetType = new String[]{"0-ASCII", "1-TIME", "2-REBOOT", "3-TELEM", "4-STATE", "5-EXPERIMENT"};
    public static final int ASCII = 0;
    public static final int TIME = 1;
    public static final int REBOOT = 2;
    public static final int TELEM = 3;
    public static final int STATE = 4;
    public static final int EXPERIMENT = 5;
    public static final int TYPE_FIELD = 0;
    public static final int SEQUENCE_FIELD = 1;
    public static final String[] LepPacketType = new String[]{"0-UNKNOWN", "1-UNKNOWN", "2-UNKNOWN", "3-START OF EXPOSURE", "4-SINGLE EVENT UPSET", "5-END OF EXPOSURE"};
    public static final int LEP_START = 3;
    public static final int LEP_SINGLE_EVENT = 4;
    public static final int LEP_END = 5;
    public static final int LEP_TYPE_FIELD = 2;
    public static final int LEP_SEQUENCED_FIELD = 3;

    public RadiationPacket(int r, long u) {
        super(new BitArrayLayout());
        this.NUMBER_OF_FIELDS = this.MAX_PACKET_BYTES = 256;
        this.rawBytes = new int[this.MAX_PACKET_BYTES];
        this.numberOfRawBytes = 0;
        this.reset = r;
        this.uptime = u;
        this.rawBits = new boolean[this.MAX_PACKET_BYTES * 8];
        this.layout = new BitArrayLayout();
        this.layout.fieldName = new String[this.NUMBER_OF_FIELDS];
        this.layout.fieldName[0] = "TYPE";
        this.layout.fieldName[1] = "SEQUENCE";
        this.fieldValue = new int[this.layout.fieldName.length];
        this.layout.fieldBitLength = new int[this.NUMBER_OF_FIELDS];
        this.layout.fieldBitLength[0] = 4;
        this.layout.fieldBitLength[1] = 12;
    }

    public int getType() {
        return this.fieldValue[0];
    }

    public int getSequence() {
        return this.fieldValue[1];
    }

    public String getTypeString() {
        if (this.fieldValue[0] >= packetType.length) {
            return "UNKNOWN";
        }
        return packetType[this.fieldValue[0]];
    }

    public int getLepType() {
        return this.fieldValue[2];
    }

    public void addRawByte(int b) {
        this.rawBytes[this.numberOfRawBytes++] = b;
    }

    public void parseRawBytes() throws CobsDecodeException {
        this.numberBytesAdded = 0;
        int[] in = new int[this.numberOfRawBytes];
        int i = 0;
        while (i < this.numberOfRawBytes) {
            in[i] = this.rawBytes[i];
            ++i;
        }
        int[] parsed = null;
        try {
            parsed = Cobs.unStuffData(in, this.MAX_PACKET_BYTES);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new CobsDecodeException("ERROR: Packet in reset: " + this.reset + " uptime: " + this.uptime + " overflowed. Array out of bounds");
        }
        if (parsed == null) {
            throw new CobsDecodeException("ERROR: Packet in reset: " + this.reset + " uptime: " + this.uptime + " - COBS unStuffData returned null");
        }
        int i2 = 0;
        while (i2 < parsed.length) {
            this.addNext8Bits(parsed[i2]);
            ++i2;
        }
        this.initType();
        this.copyBitsToFields();
    }

    public void initType() {
        this.copyBitsToFields();
        if (this.getType() == 3) {
            this.setTypeTELEM();
        } else if (this.getType() == 2) {
            this.setTypeRESTART();
        } else if (this.getType() == 1) {
            this.setTypeTIME();
        } else if (this.getType() == 4) {
            this.setTypeSTATE();
        } else if (this.getType() == 5) {
            this.setTypeEXPERIMENT();
        } else {
            this.setTypeASCII();
        }
    }

    public void setTypeASCII() {
        this.NUMBER_OF_FIELDS = this.numberOfRawBytes - 2;
        int i = 2;
        while (i < this.NUMBER_OF_FIELDS) {
            this.layout.fieldName[i] = "";
            this.layout.fieldBitLength[i] = 8;
            ++i;
        }
    }

    public void setTypeRESTART() {
        this.NUMBER_OF_FIELDS = 4;
        this.layout.fieldName[2] = "LOCAL RESTART COUNT";
        this.layout.fieldName[3] = "RCON";
        this.layout.fieldBitLength[2] = 16;
        this.layout.fieldBitLength[3] = 8;
    }

    public void setTypeTIME() {
        this.NUMBER_OF_FIELDS = 6;
        this.layout.fieldName[2] = "REF RESTART COUNT";
        this.layout.fieldName[3] = "REF CLOCK";
        this.layout.fieldName[4] = "LOCAL RESTART COUNT";
        this.layout.fieldName[5] = "LOCAL CLOCK";
        this.layout.fieldBitLength[2] = 16;
        this.layout.fieldBitLength[3] = 32;
        this.layout.fieldBitLength[4] = 16;
        this.layout.fieldBitLength[5] = 32;
    }

    public void setTypeTELEM() {
        this.NUMBER_OF_FIELDS = 26;
        this.layout.fieldName[2] = "VUC UPTIME";
        this.layout.fieldName[3] = "VUC LIVETIME";
        this.layout.fieldName[4] = FILLER;
        this.layout.fieldName[5] = FILLER;
        this.layout.fieldName[6] = "HARD RESETS";
        this.layout.fieldName[7] = "SOFT RESETS";
        this.layout.fieldName[8] = "VUC RUN STATE";
        this.layout.fieldName[9] = FILLER;
        this.layout.fieldName[10] = "EXP1 DRIFT";
        this.layout.fieldName[11] = "EXP2 DRIFT";
        this.layout.fieldName[12] = "EXP3 DRIFT";
        this.layout.fieldName[13] = "EXP4 DRIFT";
        this.layout.fieldName[14] = "EXP1 POWER";
        this.layout.fieldName[15] = "EXP2 POWER";
        this.layout.fieldName[16] = "EXP3 POWER";
        this.layout.fieldName[17] = "EXP4 POWER";
        this.layout.fieldName[18] = "EXP1 STATE";
        this.layout.fieldName[19] = "EXP2 STATE";
        this.layout.fieldName[20] = "EXP3 STATE";
        this.layout.fieldName[21] = "EXP4 STATE";
        this.layout.fieldName[22] = "LEP RESTARTS";
        this.layout.fieldName[23] = "LEP UPTIME";
        this.layout.fieldName[24] = "LEP LIVETIME";
        this.layout.fieldName[25] = "LEP TOTAL MEMORY UPSETS";
        this.layout.fieldBitLength[2] = 32;
        this.layout.fieldBitLength[3] = 32;
        this.layout.fieldBitLength[4] = 32;
        this.layout.fieldBitLength[5] = 32;
        this.layout.fieldBitLength[6] = 16;
        this.layout.fieldBitLength[7] = 16;
        this.layout.fieldBitLength[8] = 16;
        this.layout.fieldBitLength[9] = 16;
        this.layout.fieldBitLength[10] = 16;
        this.layout.fieldBitLength[11] = 16;
        this.layout.fieldBitLength[12] = 16;
        this.layout.fieldBitLength[13] = 16;
        this.layout.fieldBitLength[14] = 16;
        this.layout.fieldBitLength[15] = 16;
        this.layout.fieldBitLength[16] = 16;
        this.layout.fieldBitLength[17] = 16;
        this.layout.fieldBitLength[18] = 16;
        this.layout.fieldBitLength[19] = 16;
        this.layout.fieldBitLength[20] = 16;
        this.layout.fieldBitLength[21] = 16;
        this.layout.fieldBitLength[22] = 8;
        this.layout.fieldBitLength[23] = 24;
        this.layout.fieldBitLength[24] = 32;
        this.layout.fieldBitLength[25] = 32;
    }

    public void setTypeSTATE() {
        this.NUMBER_OF_FIELDS = 5;
        this.layout.fieldName[2] = "LOCAL CLOCK";
        this.layout.fieldName[3] = "EXPERIMENT";
        this.layout.fieldName[4] = "STATE";
        this.layout.fieldBitLength[2] = 32;
        this.layout.fieldBitLength[3] = 8;
        this.layout.fieldBitLength[4] = 8;
    }

    public void setTypeEXPERIMENT() {
        this.NUMBER_OF_FIELDS = 4;
        this.layout.fieldName[2] = "LEP TYPE";
        this.layout.fieldName[3] = "SEQUENCE";
        this.layout.fieldBitLength[2] = 4;
        this.layout.fieldBitLength[3] = 12;
        this.initLepType();
        this.copyBitsToFields();
    }

    public void initLepType() {
        this.copyBitsToFields();
        if (this.getLepType() == 3) {
            this.setTypeLEP_START();
        } else if (this.getLepType() == 4) {
            this.setTypeLEP_SINGLE_EVENT();
        } else if (this.getLepType() == 5) {
            this.setTypeLEP_END();
        } else {
            this.setTypeUNKNOWNLep();
        }
    }

    public void setTypeUNKNOWNLep() {
        this.NUMBER_OF_FIELDS = this.numberOfRawBytes;
        int i = 4;
        while (i < this.NUMBER_OF_FIELDS) {
            this.layout.fieldName[i] = "";
            this.layout.fieldBitLength[i] = 8;
            ++i;
        }
    }

    public void setTypeLEP_START() {
        this.NUMBER_OF_FIELDS = 5;
        this.layout.fieldName[4] = "LOCAL CLOCK START";
        this.layout.fieldBitLength[4] = 32;
    }

    public void setTypeLEP_SINGLE_EVENT() {
        this.NUMBER_OF_FIELDS = 6;
        this.layout.fieldName[4] = "ADDRESS";
        this.layout.fieldName[5] = "DATA";
        this.layout.fieldBitLength[4] = 32;
        this.layout.fieldBitLength[5] = 16;
    }

    public void setTypeLEP_END() {
        this.NUMBER_OF_FIELDS = 8;
        this.layout.fieldName[4] = "LOCAL CLOCK END";
        this.layout.fieldName[5] = "CURRENT";
        this.layout.fieldName[6] = "S0";
        this.layout.fieldName[7] = "UPSETS";
        this.layout.fieldBitLength[4] = 32;
        this.layout.fieldBitLength[5] = 8;
        this.layout.fieldBitLength[6] = 8;
        this.layout.fieldBitLength[7] = 16;
    }

    public void addNext8Bits(int b) {
        int i = 0;
        while (i < 8) {
            this.rawBits[7 - i + this.numberBytesAdded * 8] = (b >> i & 1) == 1;
            ++i;
        }
        ++this.numberBytesAdded;
    }

    @Override
    protected int nextbits(int n) {
        int field = 0;
        boolean[] b = new boolean[n];
        int i = 0;
        while (i < n) {
            b[i] = this.rawBits[this.bitPosition + i];
            ++i;
        }
        this.bitPosition += n;
        field = FoxBitStream.binToInt(b);
        return field;
    }

    public String getStringValue(String name) {
        int value;
        int pos = -1;
        int i = 0;
        while (i < this.layout.fieldName.length) {
            if (name.equalsIgnoreCase(this.layout.fieldName[i])) {
                pos = i;
            }
            ++i;
        }
        String s = "-----";
        if (pos == -1) {
            // empty if block
        }
        if ((value = this.getRawValue(name)) != 0) {
            s = "" + value;
        }
        if (name == "EXPERIMENT") {
            s = value == 0 ? "VUC" : "LEP";
        }
        if (name == "STATE") {
            s = value < radPacketState.length ? radPacketState[value] : "???";
        }
        if (s.length() < 5) {
            int k = 0;
            while (k < 5 - s.length()) {
                s = " " + s;
                ++k;
            }
        }
        return s;
    }

    public String toString() {
        String bytes = new String();
        bytes = String.valueOf(bytes) + this.layout.fieldName[0] + ": " + this.getTypeString() + " ";
        bytes = String.valueOf(bytes) + this.layout.fieldName[1] + ": " + this.fieldValue[1] + " ";
        bytes = String.valueOf(bytes) + " " + this.getDataString();
        return bytes;
    }

    public String getDataString() {
        String bytes = new String();
        int max = this.NUMBER_OF_FIELDS;
        int b = 2;
        while (b < max) {
            if (this.layout.fieldName[b] != FILLER) {
                bytes = String.valueOf(bytes) + this.layout.fieldName[b] + ": " + this.fieldValue[b] + " ";
            }
            if (b % 8 == 0) {
                bytes = String.valueOf(bytes) + "\n";
            }
            ++b;
        }
        return bytes;
    }

    public double convertRawValue(String name, int rawValue, int conversion, Spacecraft fox) {
        return 0.0;
    }

    @Override
    public String getStringValue(String name, Spacecraft fox) {
        return null;
    }
}

