/*
 * Decompiled with CFR 0.152.
 */
package telemetry.legacyPayloads;

import common.Spacecraft;
import decoder.FoxBitStream;
import decoder.FoxDecoder;
import java.util.StringTokenizer;
import telemetry.BitArrayLayout;
import telemetry.FramePart;
import telemetry.legacyPayloads.RadiationPacket;

public class RadiationTelemetry
extends FramePart {
    public static final int TELEM_BYTES = 20;
    public static final int MAX_HERCI_HK_DATA_LENGTH = 46;
    public static final int MAX_RAD_TELEM_BYTES = 58;
    boolean blockCopyBits = false;
    public static final String[] herciSource = new String[]{"PANIC", "HRS", "LRS", "HSK"};
    public static final String[] herciMicroPktTyp = new String[]{"??", "VERSION", "POST"};
    public static final String[] herciMicroPktSource = new String[]{"??", "CLOCK?", "??", "??", "??", "??", "??", "??", "??", "??", "??", "??", "IEB", "??", "COMMAND", "HOUSEKEEPING"};

    public RadiationTelemetry(int r, long u, BitArrayLayout l) {
        super(7, l);
        this.resets = r;
        this.uptime = u;
    }

    public RadiationTelemetry(int id, int resets, long uptime, String date, StringTokenizer st, BitArrayLayout lay) {
        super(id, resets, uptime, 7, date, st, lay);
    }

    @Override
    protected void init() {
        this.type = 7;
    }

    @Override
    public String getStringValue(String name, Spacecraft fox) {
        int pos = -1;
        int i = 0;
        while (i < this.layout.fieldName.length) {
            if (name.equalsIgnoreCase(this.layout.fieldName[i])) {
                pos = i;
            }
            ++i;
        }
        String s = "-----";
        int conv = this.layout.getIntConversionByPos(pos);
        if (pos != -1) {
            if (conv == 27) {
                int value = this.getRawValue(name);
                try {
                    s = RadiationPacket.radPacketState[value];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    s = "???";
                }
            } else if (conv == 25) {
                int value = this.getRawValue(name);
                s = Integer.toString(value * 16);
            } else if (conv == 29) {
                int value = this.getRawValue(name);
                try {
                    s = herciSource[value];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    s = "???";
                }
            } else if (conv == 28) {
                int value = this.getRawValue(name);
                s = "";
                int i2 = 0;
                while (i2 < 2) {
                    s = String.valueOf(FoxDecoder.plainhex(value & 0xFF)) + " " + s;
                    value >>= 8;
                    ++i2;
                }
            } else if (conv == 32) {
                int value = this.getRawValue(name);
                s = FoxDecoder.plainhex(value & 0xFF);
                int i3 = 2;
                while (i3 <= 12) {
                    value = this.getRawValue(String.valueOf(name) + i3);
                    s = String.valueOf(s) + " " + FoxDecoder.plainhex(value & 0xFF);
                    value >>= 8;
                    ++i3;
                }
                s = String.valueOf(s) + " \"";
                value = this.getRawValue(name);
                s = String.valueOf(s) + (char)(value & 0xFF);
                i3 = 2;
                while (i3 <= 12) {
                    value = this.getRawValue(String.valueOf(name) + i3);
                    s = String.valueOf(s) + (char)(value & 0xFF);
                    value >>= 8;
                    ++i3;
                }
                s = String.valueOf(s) + "\"";
            } else if (conv == 30) {
                int value = this.getRawValue(name);
                try {
                    s = herciMicroPktTyp[value];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    s = "???";
                }
            } else if (conv == 31) {
                int value = this.getRawValue(name);
                try {
                    s = herciMicroPktSource[value];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    s = "???";
                }
            } else {
                s = super.getStringValue(name, fox);
            }
        }
        return s;
    }

    public void addNext8Bits(int b) {
        int i = 0;
        while (i < 8) {
            this.rawBits[7 - i + this.numberBytesAdded * 8] = (b >> i & 1) == 1;
            ++i;
        }
        ++this.numberBytesAdded;
    }

    @Override
    protected int nextbits(int n) {
        int field = 0;
        boolean[] b = new boolean[n];
        int i = 0;
        while (i < n) {
            b[i] = this.rawBits[this.bitPosition + i];
            ++i;
        }
        this.bitPosition += n;
        field = FoxBitStream.binToInt(b);
        return field;
    }

    public String toDataString(Spacecraft fox) {
        this.copyBitsToFields();
        String s = new String();
        int i = 0;
        while (i < this.layout.fieldName.length) {
            s = String.valueOf(s) + this.getStringValue(this.layout.fieldName[i], fox) + " ";
            ++i;
        }
        return s;
    }

    @Override
    public String toString() {
        this.copyBitsToFields();
        String s = new String();
        s = String.valueOf(s) + "RADIATION TELEMETRY:\n";
        int i = 0;
        while (i < this.layout.fieldName.length) {
            s = String.valueOf(s) + this.layout.fieldName[i] + ": " + this.fieldValue[i] + "\n";
            ++i;
        }
        return s;
    }

    @Override
    public void copyBitsToFields() {
        if (this.blockCopyBits) {
            return;
        }
        super.copyBitsToFields();
    }

    @Override
    public boolean isValid() {
        return false;
    }
}

