/*
 * Decompiled with CFR 0.152.
 */
package telemetry.payloads;

import common.Config;
import common.Log;
import decoder.FoxBitStream;
import decoder.FoxDecoder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import telemetry.BitArrayLayout;
import telemetry.FramePart;

public class CanPacket
extends FramePart
implements Comparable<FramePart> {
    public static final int MAX_PACKET_BYTES = 12;
    public static final int ID_FIELD0 = 0;
    public static final int ID_FIELD1 = 1;
    public static final int HEADER_ID_BYTES = 2;
    public int pkt_id = 0;
    public int canId;
    int length = 0;
    byte[] bytes;

    public CanPacket(BitArrayLayout lay) {
        super(15, lay);
    }

    public CanPacket(BitArrayLayout lay, int id, long uptime, int resets) {
        super(15, lay);
        this.captureHeaderInfo(id, uptime, resets);
    }

    public CanPacket(int id, int resets, long uptime, String date, byte[] data, BitArrayLayout lay) {
        super(id, resets, uptime, 15, date, data, lay);
    }

    public CanPacket(int id, int resets, long uptime, String date, StringTokenizer st, BitArrayLayout lay) {
        super(id, resets, uptime, 15, date, st, lay);
    }

    public CanPacket(ResultSet r, BitArrayLayout lay) throws SQLException {
        super(r, 15, lay);
    }

    @Override
    public void init() {
        this.bytes = new byte[this.getMaxBytes()];
    }

    public void initBytes() {
    }

    public void setType(int t) {
        this.type = t;
    }

    public int getLength() {
        this.copyBitsToFields();
        return this.length;
    }

    public int getID() {
        this.copyBitsToFields();
        return this.canId;
    }

    public byte[] getBytes() {
        if (this.isValid()) {
            byte[] data = new byte[this.getLength() + 2];
            if (this.bytes.length < this.getLength() + 2) {
                return null;
            }
            int i = 0;
            while (i < this.getLength() + 2) {
                data[i] = this.bytes[i];
                ++i;
            }
            return data;
        }
        return null;
    }

    @Override
    public boolean isValid() {
        if (this.rawBits == null) {
            return true;
        }
        if (this.numberBytesAdded < 2) {
            return false;
        }
        this.copyBitsToFields();
        return this.canId != 0 && this.numberBytesAdded == this.getLength() + 2;
    }

    public boolean hasEndOfCanPacketsId() {
        if (this.numberBytesAdded >= this.getMaxBytes() && !this.isValid()) {
            return true;
        }
        return this.numberBytesAdded >= 2 && this.canId == 0;
    }

    @Override
    public void addNext8Bits(byte b) {
        try {
            int i = 0;
            while (i < 8) {
                this.rawBits[7 - i + this.numberBytesAdded * 8] = (b >> i & 1) == 1;
                ++i;
            }
            this.bytes[this.numberBytesAdded] = b;
            ++this.numberBytesAdded;
            if (this.numberBytesAdded == 2) {
                this.copyBitsToFields();
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (Config.debugFrames) {
                Log.errorDialog("ERROR", "Error adding data to Can Packet:\n" + this.layout.name + " layout length is: " + (this.layout.getMaxNumberOfBytes() - 4) + " data len from packet is: " + this.getLength() + "\n Error at byte: " + this.numberBytesAdded + "\nTurn off Debug Frames to prevent this message in future.");
            }
            Log.println("ERROR: adding data to Can Packet:\n" + this.layout.name + " layout length is: " + (this.layout.getMaxNumberOfBytes() - 4) + " data len from packet is: " + this.getLength() + "\n Error at byte: " + this.numberBytesAdded);
            this.length = 0;
            this.fieldValue[0] = 0;
            this.fieldValue[1] = 0;
            this.canId = 0;
            return;
        }
    }

    @Override
    protected int nextbits(int n) {
        int field = 0;
        boolean[] b = new boolean[n];
        int i = 0;
        while (i < n) {
            b[i] = this.rawBits[this.bitPosition + i];
            ++i;
        }
        this.bitPosition += n;
        field = FoxBitStream.binToInt(b);
        return field;
    }

    public static int getRawIdFromRawBytes(int a, int b) {
        int id = a + 256 * b;
        return id;
    }

    public static int getIdfromRawID(int canPacketId) {
        int id = canPacketId >> 4 & 0xFFF;
        return id;
    }

    public static int getLengthfromRawID(int canPacketId) {
        int length = canPacketId & 0xF;
        return length;
    }

    @Override
    public void copyBitsToFields() {
        this.resetBitPosition();
        super.copyBitsToFields();
        int rawId = CanPacket.getRawIdFromRawBytes(this.fieldValue[0], this.fieldValue[1]);
        this.canId = CanPacket.getIdfromRawID(rawId);
        this.length = CanPacket.getLengthfromRawID(rawId);
    }

    @Override
    public String toString() {
        this.copyBitsToFields();
        String s = "";
        s = String.valueOf(s) + this.resets + ":" + this.uptime;
        s = String.valueOf(s) + "CAN ID:";
        s = String.valueOf(s) + FoxDecoder.hex(this.canId);
        s = String.valueOf(s) + " " + this.canId;
        s = String.valueOf(s) + " Len:" + this.getLength();
        s = String.valueOf(s) + " Type:" + this.type;
        int i = 1;
        while (i < this.fieldValue.length) {
            s = String.valueOf(s) + " " + FoxDecoder.hex(this.fieldValue[i]);
            ++i;
        }
        return s;
    }

    public String getTableCreateStmt(boolean storeMode) {
        String s = new String();
        s = String.valueOf(s) + "(captureDate varchar(14), id int, resets int, uptime bigint, type int, ";
        if (storeMode) {
            s = String.valueOf(s) + "newMode int,";
        }
        int i = 0;
        while (i < this.layout.fieldName.length) {
            s = String.valueOf(s) + this.layout.fieldName[i] + " int,\n";
            ++i;
        }
        s = String.valueOf(s) + "date_time timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,";
        s = String.valueOf(s) + "PRIMARY KEY (id, resets, uptime, type))";
        return s;
    }
}

