/*
 * Decompiled with CFR 0.152.
 */
package telemetry.payloads;

import common.Config;
import common.Log;
import common.Spacecraft;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import telemetry.BitArrayLayout;
import telemetry.FoxPayloadStore;
import telemetry.FramePart;
import telemetry.payloads.CanPacket;
import telemetry.payloads.PayloadCanWODExperiment;

public class PayloadCanExperiment
extends FramePart {
    public ArrayList<CanPacket> canPackets = new ArrayList();
    protected CanPacket rawCanPacket;
    boolean addingCanPackets = true;
    int debugCount = 0;

    public PayloadCanExperiment(BitArrayLayout lay, int id, long uptime, int resets) {
        super(13, lay);
        this.captureHeaderInfo(id, uptime, resets);
    }

    public PayloadCanExperiment(int id, int resets, long uptime, String date, StringTokenizer st, BitArrayLayout lay) {
        super(id, resets, uptime, 13, date, st, lay);
    }

    @Override
    protected void init() {
    }

    protected boolean addToCanPackets(byte b) {
        BitArrayLayout canLayout;
        String canPktLayout = "canpacket";
        String canPktType = "CAN_PKT";
        if (this instanceof PayloadCanWODExperiment) {
            canPktLayout = "wodcanpacket";
            canPktType = "WOD_CAN_PKT";
        }
        Spacecraft fox = Config.satManager.getSpacecraft(this.id);
        if (this.rawCanPacket == null) {
            canLayout = fox.hasFOXDB_V3 ? fox.getLayoutByType(canPktType) : Config.satManager.getLayoutByName(this.id, canPktLayout);
            if (canLayout == null) {
                Log.println("ERROR: Payload Layout is missing for: " + canPktLayout + "\nCheck the MASTER file to confirm this is defined correctly.");
            }
            this.rawCanPacket = new CanPacket(canLayout);
            this.rawCanPacket.captureHeaderInfo(this.id, this.uptime, this.resets);
        }
        if (this.rawCanPacket.hasEndOfCanPacketsId()) {
            return false;
        }
        this.rawCanPacket.addNext8Bits(b);
        if (this.rawCanPacket.isValid()) {
            this.canPackets.add(this.rawCanPacket);
            canLayout = fox.hasFOXDB_V3 ? fox.getLayoutByType(canPktType) : Config.satManager.getLayoutByName(this.id, canPktLayout);
            this.rawCanPacket = new CanPacket(canLayout);
            this.rawCanPacket.captureHeaderInfo(this.id, this.uptime, this.resets);
        }
        return true;
    }

    @Override
    public void addNext8Bits(byte b) {
        super.addNext8Bits(b);
        if (this.addingCanPackets) {
            this.addingCanPackets = this.addToCanPackets(b);
        }
    }

    @Override
    public String toString() {
        this.copyBitsToFields();
        String s = "CAN EXPERIMENT PAYLOAD - " + this.canPackets.size() + " CAN PACKETS\n";
        s = String.valueOf(s) + "RESET: " + this.resets;
        s = String.valueOf(s) + "  UPTIME: " + this.uptime;
        s = String.valueOf(s) + "  TYPE: " + this.type;
        s = String.valueOf(s) + "  OVERFLOW FLAG: (not printed)" + "\n";
        int p = 0;
        while (p < this.canPackets.size()) {
            s = String.valueOf(s) + this.canPackets.get(p).toString() + "    ";
            if ((p + 1) % 3 == 0) {
                s = String.valueOf(s) + "\n";
            }
            ++p;
        }
        s = String.valueOf(s) + "\n";
        return s;
    }

    @Override
    public boolean isValid() {
        return false;
    }

    public boolean savePayloads(FoxPayloadStore payloadStore, int serial, boolean storeMode) {
        if (!(this instanceof PayloadCanWODExperiment)) {
            this.type = this.type * 100 + serial;
        }
        this.copyBitsToFields();
        if (!payloadStore.add(this.getFoxId(), this.getUptime(), this.getResets(), this)) {
            return false;
        }
        int j = 0;
        for (CanPacket p : this.canPackets) {
            Spacecraft sat;
            int p_type = p.getType();
            p_type = this instanceof PayloadCanWODExperiment ? p_type * 100 + j++ : p_type * 100 + serial + j++;
            p.setType(p_type);
            if (storeMode) {
                p.newMode = this.newMode;
            }
            if (payloadStore.add(this.getFoxId(), this.getUptime(), this.getResets(), p) && (sat = Config.satManager.getSpacecraft(this.id)).hasMesatCamera() && payloadStore.mesatImageStore != null) {
                try {
                    payloadStore.mesatImageStore.add(this.getFoxId(), this.getResets(), this.getUptime(), p, this.getCaptureDate());
                }
                catch (IOException e) {
                    Log.println("ERROR: Could not add the MESAT packet to the image");
                    e.printStackTrace(Log.getWriter());
                }
            }
            p.rawBits = null;
        }
        return true;
    }

    public byte[][] getCANPacketBytes(Date createDate) {
        return PayloadCanExperiment.getCANPacketBytes(this.canPackets, createDate);
    }

    public static byte[][] getCANPacketBytes(ArrayList<CanPacket> canPackets, Date createDate) {
        byte[][] buffers = new byte[canPackets.size()][];
        int i = 0;
        for (CanPacket p : canPackets) {
            buffers[i++] = p.getBytes();
        }
        return buffers;
    }

    static byte[] concatenateByteArrays(byte[] a, byte[] b) {
        byte[] result = new byte[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }
}

