/*
 * Decompiled with CFR 0.152.
 */
package telemetry.test;

import common.Config;
import common.Log;
import common.Spacecraft;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import telemetry.BitArrayLayout;
import telemetry.FramePart;
import telemetry.conversion.MathExpression;
import telemetry.payloads.PayloadRtValues;

public class MathExpressionTest {
    BitArrayLayout lay;
    FramePart rt;
    Spacecraft fox1;

    @Before
    public void setUp() throws Exception {
        String logFileDir;
        Config.homeDirectory = logFileDir = "C:\\Users\\chris\\Desktop\\Test\\JUNIT_TEST";
        Log.init("JUnitTest");
        Config.currentDir = System.getProperty("user.dir");
        Config.minInit(logFileDir);
        Config.initSatelliteManager();
        Log.println("LogFileDir is:" + Config.logFileDirectory);
        this.fox1 = Config.satManager.getSpacecraft(1);
        this.lay = Config.satManager.getLayoutByName(this.fox1.foxId, "rttelemetry");
        this.rt = new PayloadRtValues(this.lay);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testMathExpression() {
        MathExpression math = new MathExpression("1 + 2", 5.0);
        double y = math.parse(this.rt, this.fox1);
        Assert.assertEquals(3.0, y, 0.0);
    }

    @Test
    public void testComplexMathExpression() {
        MathExpression math = new MathExpression(" ((4  \t- 2^3+1) * -sqrt (3*3+4 *4)) / 2", 0.0);
        double y = math.parse(this.rt, this.fox1);
        Assert.assertEquals(7.5, y, 0.0);
    }

    @Test
    public void testRawValue() {
        MathExpression math = new MathExpression("1 + x", 5.0);
        double y = math.parse(this.rt, this.fox1);
        Assert.assertEquals(6.0, y, 0.0);
        math = new MathExpression("10^(10/x)", 5.0);
        y = math.parse(this.rt, this.fox1);
        Assert.assertEquals(100.0, y, 0.0);
        math = new MathExpression("10^x", 2.0);
        y = math.parse(this.rt, this.fox1);
        Assert.assertEquals(100.0, y, 0.0);
    }

    @Test
    public void testComplexRawValue() {
        MathExpression math = new MathExpression("((4  \t- 2^x+1) * -sqrt (x*x+4 *4)) / 2", 3.0);
        double y = math.parse(this.rt, this.fox1);
        Assert.assertEquals(7.5, y, 0.0);
        math = new MathExpression("((X  \t- 2^3+1) * -sqrt (3*3+x *x)) / 2", 4.0);
        y = math.parse(this.rt, this.fox1);
        Assert.assertEquals(7.5, y, 0.0);
        math = new MathExpression("x^2", 2.0);
        y = math.parse(this.rt, this.fox1);
        Assert.assertEquals(4.0, y, 0.0);
        math = new MathExpression("2^X", 2.0);
        y = math.parse(this.rt, this.fox1);
        Assert.assertEquals(4.0, y, 0.0);
        math = new MathExpression("((4 - x^3+1) * -sqrt (3*3+4 *4)) / x", 2.0);
        y = math.parse(this.rt, this.fox1);
        Assert.assertEquals(7.5, y, 0.0);
    }

    @Test
    public void testFunctions() {
        MathExpression math = new MathExpression("cos(3.1415926)", 0.0);
        double y = math.parse(this.rt, this.fox1);
        Assert.assertEquals(-1.0, y, 1.0E-4);
        math = new MathExpression("sin(3.1415926)", 0.0);
        y = math.parse(this.rt, this.fox1);
        Assert.assertEquals(0.0, y, 1.0E-4);
        math = new MathExpression("sin(x)", 3.1415926);
        y = math.parse(this.rt, this.fox1);
        Assert.assertEquals(0.0, y, 1.0E-4);
        math = new MathExpression("tan(3.1415926)", 0.0);
        y = math.parse(this.rt, this.fox1);
        Assert.assertEquals(-5.358E-8, y, 1.0E-4);
        math = new MathExpression("acos(1)", 0.0);
        y = math.parse(this.rt, this.fox1);
        Assert.assertEquals(0.0, y, 1.0E-4);
        math = new MathExpression("asin(1)", 0.0);
        y = math.parse(this.rt, this.fox1);
        Assert.assertEquals(1.5707, y, 1.0E-4);
        math = new MathExpression("atan(1)", 0.0);
        y = math.parse(this.rt, this.fox1);
        Assert.assertEquals(0.78539, y, 1.0E-4);
        math = new MathExpression("abs(1)", 0.0);
        y = math.parse(this.rt, this.fox1);
        Assert.assertEquals(1.0, y, 1.0E-4);
        math = new MathExpression("abs(-1)", 0.0);
        y = math.parse(this.rt, this.fox1);
        Assert.assertEquals(1.0, y, 1.0E-4);
        math = new MathExpression("10^4", 0.0);
        y = math.parse(this.rt, this.fox1);
        Assert.assertEquals(10000.0, y, 1.0E-4);
    }

    @Test
    public void testFields() {
        this.rt.fieldValue[0] = 1000;
        this.rt.fieldValue[1] = 1000;
        double expected_result = 1.4134457236842106;
        MathExpression math = new MathExpression("BATT_A_V + BATT_B_V", 0.0);
        double y = math.parse(this.rt, this.fox1);
        Assert.assertEquals(expected_result, y, 1.0E-4);
    }
}

