/*
 * Decompiled with CFR 0.152.
 */
package telemetry.uw;

import decoder.Decoder;
import java.util.Date;

public class PcanPacket {
    private final short length = (short)36;
    private final short messageType = (short)128;
    private static final byte CHANNEL = 0;
    private byte dataLengthCount;
    private static final short FLAGS = 0;
    private int canId;
    private byte[] canData = new byte[8];
    private int resets;
    private long uptime;
    private int type;
    private int foxId;
    private Date createDate;

    public PcanPacket(Date createDate, int foxid, int resets, long uptime, int type, int id, byte len, byte[] data) {
        this.canId = id;
        this.foxId = foxid;
        this.resets = resets;
        this.uptime = uptime;
        this.type = type;
        this.createDate = createDate;
        this.dataLengthCount = len;
        int i = 0;
        while (i < data.length) {
            this.canData[i] = data[i];
            ++i;
        }
    }

    public byte[] getBytes() {
        byte[] buffer = new byte[36];
        buffer[0] = 0;
        buffer[1] = 36;
        buffer[2] = 0;
        buffer[3] = -128;
        buffer[4] = (byte)(this.resets >> 8 & 0xFF);
        buffer[5] = (byte)(this.resets & 0xFF);
        byte[] uptimeBytes = Decoder.bigEndian4(this.uptime);
        int j = 0;
        while (j < 4) {
            buffer[6 + j] = uptimeBytes[j];
            ++j;
        }
        buffer[10] = (byte)(this.type >> 8 & 0xFF);
        buffer[11] = (byte)(this.type & 0xFF);
        long date_long = this.createDate.getTime();
        byte[] timeBytes = Decoder.bigEndian8(date_long);
        int j2 = 0;
        while (j2 < 8) {
            buffer[12 + j2] = timeBytes[j2];
            ++j2;
        }
        buffer[20] = 0;
        buffer[21] = this.dataLengthCount;
        buffer[22] = 0;
        buffer[23] = 0;
        byte[] id = Decoder.bigEndian4(this.canId);
        int k = 0;
        while (k < 4) {
            buffer[24 + k] = id[k];
            ++k;
        }
        k = 0;
        while (k < this.canData.length) {
            buffer[28 + k] = this.canData[k];
            ++k;
        }
        return buffer;
    }

    public String toString() {
        byte[] buffer;
        String s = "";
        byte[] byArray = buffer = this.getBytes();
        int n = buffer.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            s = String.valueOf(s) + String.format("%02x", b) + " ";
            ++n2;
        }
        return s;
    }
}

