/*
 * Decompiled with CFR 0.152.
 */
package uk.me.g4dpz.satellite;

import org.junit.Assert;
import org.junit.Test;
import uk.me.g4dpz.satellite.AbstractSatelliteTestBase;
import uk.me.g4dpz.satellite.DeepSpaceSatellite;
import uk.me.g4dpz.satellite.LEOSatellite;
import uk.me.g4dpz.satellite.Satellite;
import uk.me.g4dpz.satellite.SatelliteFactory;
import uk.me.g4dpz.satellite.TLE;

public class SatelliteFactoryTest
extends AbstractSatelliteTestBase {
    private static final String SHOULD_HAVE_THROWN_ILLEGAL_ARGUMENT_EXCEPTION = "Should have thrown IllegalArgument Exception";

    @Test
    public void testCreateLEOSatellite() {
        TLE tle = new TLE(LEO_TLE);
        Satellite satellite = SatelliteFactory.createSatellite(tle);
        Assert.assertTrue(satellite instanceof LEOSatellite);
    }

    @Test
    public void testCreateDeepSpaceSatellite() {
        TLE tle = new TLE(DEEP_SPACE_TLE);
        Satellite satellite = SatelliteFactory.createSatellite(tle);
        Assert.assertTrue(satellite instanceof DeepSpaceSatellite);
    }

    @Test
    public void testNullTLE() {
        try {
            SatelliteFactory.createSatellite(null);
            Assert.fail(SHOULD_HAVE_THROWN_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTLEWithWrongNumberOfRows() {
        try {
            String[] theTLE = new String[]{};
            TLE tle = new TLE(theTLE);
            SatelliteFactory.createSatellite(tle);
            Assert.fail(SHOULD_HAVE_THROWN_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

