/*
 * Decompiled with CFR 0.152.
 */
package uk.me.g4dpz.satellite;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TLE
implements Serializable {
    private static final long serialVersionUID = 716922882884628016L;
    private static final int THREELINES = 3;
    private static final double DEG2RAD = 0.0174532925199433;
    private static final double TWO_PI = Math.PI * 2;
    private static final double MINS_PERDAY = 1440.0;
    private static final double XKE = 0.0743669161;
    private static final double TWO_THIRDS = 0.6666666666666666;
    private static final double CK2 = 5.413079E-4;
    private int catnum;
    private String name;
    private int setnum;
    private int year;
    private double refepoch;
    private double incl;
    private double raan;
    private double eccn;
    private double argper;
    private double meanan;
    private double meanmo;
    private double drag;
    private double nddot6;
    private double bstar;
    private int orbitnum;
    private double epoch;
    private double xndt2o;
    private double xincl;
    private double xnodeo;
    private double eo;
    private double omegao;
    private double xmo;
    private double xno;
    private boolean deepspace;
    private Date createddate;

    public TLE(TLE tle) {
        this.catnum = tle.catnum;
        this.name = tle.name;
        this.setnum = tle.setnum;
        this.year = tle.year;
        this.refepoch = tle.refepoch;
        this.incl = tle.incl;
        this.raan = tle.raan;
        this.eccn = tle.eccn;
        this.argper = tle.argper;
        this.meanan = tle.meanan;
        this.meanmo = tle.meanmo;
        this.drag = tle.drag;
        this.nddot6 = tle.nddot6;
        this.bstar = tle.bstar;
        this.orbitnum = tle.orbitnum;
        this.epoch = tle.epoch;
        this.xndt2o = tle.xndt2o;
        this.xincl = tle.xincl;
        this.xnodeo = tle.xnodeo;
        this.eo = tle.eo;
        this.omegao = tle.omegao;
        this.xmo = tle.xmo;
        this.xno = tle.xno;
        this.deepspace = tle.deepspace;
        this.createddate = tle.createddate;
    }

    public TLE(String[] tle) throws IllegalArgumentException {
        this(tle, false);
    }

    public TLE(String[] tle, boolean nilStart) throws IllegalArgumentException {
        if (nilStart) {
            tle[0] = tle[0].substring(2);
        }
        if (tle == null) {
            throw new IllegalArgumentException("TLE was null");
        }
        if (tle.length != 3) {
            throw new IllegalArgumentException("TLE had " + tle.length + " elements");
        }
        int lineCount = 0;
        String[] stringArray = tle;
        int n = tle.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            this.testArguments(lineCount, line);
            ++lineCount;
            ++n2;
        }
        this.catnum = Integer.parseInt(StringUtils.strip(tle[1].substring(2, 7)));
        this.name = tle[0].trim();
        this.setnum = Integer.parseInt(StringUtils.strip(tle[1].substring(64, 68)));
        this.year = Integer.parseInt(StringUtils.strip(tle[1].substring(18, 20)));
        this.refepoch = this.parseDouble(tle[1].substring(20, 32));
        this.incl = this.parseDouble(tle[2].substring(8, 16));
        this.raan = this.parseDouble(tle[2].substring(17, 25));
        this.eccn = 1.0E-7 * this.parseDouble(tle[2].substring(26, 33));
        this.argper = this.parseDouble(tle[2].substring(34, 42));
        this.meanan = this.parseDouble(tle[2].substring(43, 51));
        this.meanmo = this.parseDouble(tle[2].substring(52, 63));
        this.drag = this.parseDouble(tle[1].substring(33, 43));
        double tempnum = 1.0E-5 * this.parseDouble(tle[1].substring(44, 50));
        this.nddot6 = tempnum / Math.pow(10.0, this.parseDouble(tle[1].substring(51, 52)));
        tempnum = 1.0E-5 * this.parseDouble(tle[1].substring(53, 59));
        this.bstar = tempnum / Math.pow(10.0, this.parseDouble(tle[1].substring(60, 61)));
        this.orbitnum = Integer.parseInt(StringUtils.strip(tle[2].substring(63, 68)));
        this.epoch = 1000.0 * (double)this.getYear() + this.getRefepoch();
        this.xndt2o = this.drag;
        double temp = this.incl;
        this.xincl = temp *= 0.0174532925199433;
        temp = this.raan;
        this.xnodeo = temp *= 0.0174532925199433;
        this.eo = this.eccn;
        temp = this.argper;
        this.omegao = temp *= 0.0174532925199433;
        temp = this.meanan;
        this.xmo = temp *= 0.0174532925199433;
        this.xno = this.meanmo;
        this.preProcessTLESet();
    }

    private double parseDouble(String s) {
        double d = 0.0;
        try {
            d = Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
        return d;
    }

    private synchronized void preProcessTLESet() {
        double del1;
        double ao;
        double temp = 3.0300855069346E-6;
        this.xno = this.xno * temp * 1440.0;
        this.xndt2o *= temp;
        double dd1 = 0.0743669161 / this.xno;
        double a1 = Math.pow(dd1, 0.6666666666666666);
        double r1 = Math.cos(this.xincl);
        temp = 8.1196185E-4 * (r1 * r1 * 3.0 - 1.0) / Math.pow(dd1 = 1.0 - this.eo * this.eo, 1.5);
        double delo = temp / ((ao = a1 * (1.0 - (del1 = temp / (a1 * a1)) * (0.3333333333333333 + del1 * (del1 * 1.654320987654321 + 1.0)))) * ao);
        double xnodp = this.xno / (delo + 1.0);
        this.deepspace = Math.PI * 2 / xnodp / 1440.0 >= 0.15625;
    }

    private void testArguments(int lineCount, String line) throws IllegalArgumentException {
        if (line == null) {
            throw new IllegalArgumentException(this.createIllegalArgumentMessage(lineCount, "was null"));
        }
        if (line.length() == 0) {
            throw new IllegalArgumentException(this.createIllegalArgumentMessage(lineCount, "was zero length"));
        }
    }

    private TLE() {
    }

    public int getCatnum() {
        return this.catnum;
    }

    public String getName() {
        return this.name;
    }

    public int getSetnum() {
        return this.setnum;
    }

    public int getYear() {
        return this.year;
    }

    public double getRefepoch() {
        return this.refepoch;
    }

    public double getIncl() {
        return this.incl;
    }

    public double getRaan() {
        return this.raan;
    }

    public double getEccn() {
        return this.eccn;
    }

    public double getArgper() {
        return this.argper;
    }

    public double getMeanan() {
        return this.meanan;
    }

    public double getMeanmo() {
        return this.meanmo;
    }

    public double getDrag() {
        return this.drag;
    }

    public double getNddot6() {
        return this.nddot6;
    }

    public double getBstar() {
        return this.bstar;
    }

    public int getOrbitnum() {
        return this.orbitnum;
    }

    public boolean isDeepspace() {
        return this.deepspace;
    }

    public double getEo() {
        return this.eo;
    }

    public double getEpoch() {
        return this.epoch;
    }

    public double getOmegao() {
        return this.omegao;
    }

    public double getXincl() {
        return this.xincl;
    }

    public double getXmo() {
        return this.xmo;
    }

    public synchronized double getXndt2o() {
        return this.xndt2o;
    }

    public synchronized double getXno() {
        return this.xno;
    }

    public double getXnodeo() {
        return this.xnodeo;
    }

    public Date getCreateddate() {
        return new Date(this.createddate.getTime());
    }

    public void setCreateddate(Date createddate) {
        this.createddate = new Date(createddate.getTime());
    }

    private String createIllegalArgumentMessage(int lineCount, String problem) {
        return "TLE line[" + lineCount + "] " + problem;
    }

    public static List<TLE> importSat(InputStream fileIS) throws IOException {
        String readString;
        ArrayList<TLE> importedSats = new ArrayList<TLE>();
        BufferedReader buf = new BufferedReader(new InputStreamReader(fileIS));
        int j = 0;
        String[] lines = new String[3];
        while ((readString = buf.readLine()) != null) {
            switch (j) {
                case 0: 
                case 1: {
                    lines[j] = readString;
                    ++j;
                    break;
                }
                case 2: {
                    lines[j] = readString;
                    j = 0;
                    importedSats.add(new TLE(lines));
                    break;
                }
            }
        }
        return importedSats;
    }

    public String toString() {
        return this.name;
    }
}

