/*
 * Decompiled with CFR 0.152.
 */
package uk.me.g4dpz.satellite;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import uk.me.g4dpz.satellite.AbstractSatelliteTestBase;
import uk.me.g4dpz.satellite.TLE;

public final class TLETest
extends AbstractSatelliteTestBase {
    private static final String VALUE_0_0000 = "0.0000";
    private static final String VALUE_0_0084159 = "0.0084159";
    private static final String FORMAT_6_4F = "%6.4f";
    private static final String ILLEGALARGUMENTEXCEPTION_SHOULDHAVEBEEN_THROWN = "IllegalArgumentException should have been thrown";
    private static final String TLELINE_3 = "2 28375  98.0821 101.6821 0084935  88.2048 272.8868 14.40599338194363";
    private static final String FORMAT_9_7F = "%9.7f";
    private static final String FORMAT_10_7F = "%10.7f";
    private static final String FORMAT_11_7F = "%11.7f";
    private static final String AO_51_NAME = "AO-51 [+]";

    @Test
    public void testTLEReadLEO() {
        TLE tle = new TLE(LEO_TLE);
        this.checkData(tle);
    }

    @Test
    public void testCopyConstructor() {
        TLE tle = new TLE(LEO_TLE);
        TLE tleCopy = new TLE(tle);
        this.checkData(tleCopy);
    }

    @Test
    public void testLaunchTLE() {
        TLE tle = new TLE(LAUNCH_TLE, true);
        this.checkLaunchData(tle);
    }

    @Test
    public void testNilStartTLE() {
        TLE tle = new TLE(NIL_START_TLE, true);
        this.checkData(tle);
    }

    @Test
    public void testTLEReadDeepSpace() {
        String[] theTLE = new String[]{"AO-40", "1 26609U 00072B   00326.22269097 -.00000581  00000-0  00000+0 0    29", "2 26609   6.4279 245.5626 7344055 179.5891 182.1915  2.03421959   104"};
        TLE tle = new TLE(theTLE);
        Assert.assertTrue("Satellite should have been DeepSpace", tle.isDeepspace());
    }

    @Test
    public void testForNullDataInTLE() {
        try {
            String[] stringArray = new String[3];
            stringArray[0] = AO_51_NAME;
            stringArray[2] = TLELINE_3;
            String[] theTLE = stringArray;
            new TLE(theTLE);
            Assert.fail(ILLEGALARGUMENTEXCEPTION_SHOULDHAVEBEEN_THROWN);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testForBlankDataInTLE() {
        try {
            String[] theTLE = new String[]{AO_51_NAME, "", TLELINE_3};
            new TLE(theTLE);
            Assert.fail(ILLEGALARGUMENTEXCEPTION_SHOULDHAVEBEEN_THROWN);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testForNoDataInTLE() {
        try {
            String[] theTLE = new String[]{};
            new TLE(theTLE);
            Assert.fail(ILLEGALARGUMENTEXCEPTION_SHOULDHAVEBEEN_THROWN);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLoadFromFile() {
        try {
            FileInputStream fileIS = new FileInputStream("src/test/resources/LEO.txt");
            List<TLE> tles = TLE.importSat(fileIS);
            Assert.assertTrue(1 == tles.size());
            this.checkData(tles.get(0));
        }
        catch (IOException e) {
            Assert.fail(e.getMessage());
        }
    }

    private void checkData(TLE tle) {
        Assert.assertEquals(AO_51_NAME, tle.getName());
        Assert.assertEquals(AO_51_NAME, tle.toString());
        Assert.assertEquals(28375L, tle.getCatnum());
        Assert.assertEquals(364L, tle.getSetnum());
        Assert.assertEquals(9L, tle.getYear());
        Assert.assertEquals("105.6639197", String.format(FORMAT_11_7F, tle.getRefepoch()));
        Assert.assertEquals("98.0551000", String.format(FORMAT_10_7F, tle.getIncl()));
        Assert.assertEquals("118.9086000", String.format(FORMAT_11_7F, tle.getRaan()));
        Assert.assertEquals(VALUE_0_0084159, String.format(FORMAT_9_7F, tle.getEccn()));
        Assert.assertEquals("315.8041000", String.format(FORMAT_10_7F, tle.getArgper()));
        Assert.assertEquals(" 43.6444000", String.format(FORMAT_11_7F, tle.getMeanan()));
        Assert.assertEquals("14.4063845", String.format(FORMAT_10_7F, tle.getMeanmo()));
        Assert.assertEquals(VALUE_0_0000, String.format(FORMAT_6_4F, tle.getDrag()));
        Assert.assertEquals(VALUE_0_0000, String.format(FORMAT_6_4F, tle.getNddot6()));
        Assert.assertEquals("0.0000138", String.format(FORMAT_9_7F, tle.getBstar()));
        Assert.assertEquals(25195L, tle.getOrbitnum());
        Assert.assertEquals("9105.6639197", String.format("%12.7f", tle.getEpoch()));
        Assert.assertEquals("0.0000000", String.format(FORMAT_9_7F, tle.getXndt2o()));
        Assert.assertEquals("1.7113843", String.format(FORMAT_9_7F, tle.getXincl()));
        Assert.assertEquals("2.0753466", String.format(FORMAT_9_7F, tle.getXnodeo()));
        Assert.assertEquals(VALUE_0_0084159, String.format(FORMAT_9_7F, tle.getEo()));
        Assert.assertEquals("5.5118213", String.format(FORMAT_9_7F, tle.getOmegao()));
        Assert.assertEquals("0.7617385", String.format(FORMAT_9_7F, tle.getXmo()));
        Assert.assertEquals("0.062860", String.format("%8.6f", tle.getXno()));
        Assert.assertFalse(tle.isDeepspace());
    }

    private void checkLaunchData(TLE tle) {
        Assert.assertEquals(AO_51_NAME, tle.getName());
        Assert.assertEquals(AO_51_NAME, tle.toString());
        Assert.assertEquals(28375L, tle.getCatnum());
        Assert.assertEquals(364L, tle.getSetnum());
        Assert.assertEquals(9L, tle.getYear());
        Assert.assertEquals("105.6639197", String.format(FORMAT_11_7F, tle.getRefepoch()));
        Assert.assertEquals("98.0551000", String.format(FORMAT_10_7F, tle.getIncl()));
        Assert.assertEquals("118.9086000", String.format(FORMAT_11_7F, tle.getRaan()));
        Assert.assertEquals(VALUE_0_0084159, String.format(FORMAT_9_7F, tle.getEccn()));
        Assert.assertEquals("315.8041000", String.format(FORMAT_10_7F, tle.getArgper()));
        Assert.assertEquals(" 43.6444000", String.format(FORMAT_11_7F, tle.getMeanan()));
        Assert.assertEquals("14.4063845", String.format(FORMAT_10_7F, tle.getMeanmo()));
        Assert.assertEquals(VALUE_0_0000, String.format(FORMAT_6_4F, tle.getDrag()));
        Assert.assertEquals(VALUE_0_0000, String.format(FORMAT_6_4F, tle.getNddot6()));
        Assert.assertEquals(25195L, tle.getOrbitnum());
        Assert.assertEquals("9105.6639197", String.format("%12.7f", tle.getEpoch()));
        Assert.assertEquals("0.0000000", String.format(FORMAT_9_7F, tle.getXndt2o()));
        Assert.assertEquals("1.7113843", String.format(FORMAT_9_7F, tle.getXincl()));
        Assert.assertEquals("2.0753466", String.format(FORMAT_9_7F, tle.getXnodeo()));
        Assert.assertEquals(VALUE_0_0084159, String.format(FORMAT_9_7F, tle.getEo()));
        Assert.assertEquals("5.5118213", String.format(FORMAT_9_7F, tle.getOmegao()));
        Assert.assertEquals("0.7617385", String.format(FORMAT_9_7F, tle.getXmo()));
        Assert.assertEquals("0.062860", String.format("%8.6f", tle.getXno()));
        Assert.assertFalse(tle.isDeepspace());
    }
}

