/*
 * Decompiled with CFR 0.152.
 */
import common.Config;
import common.Log;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.UIManager;
import spacecraftEditor.InitalEditorSettings;
import spacecraftEditor.SpacecraftEditorWindow;

public class AmsatSpacecraftEditor {
    static String logFileDir = null;

    public static void main(String[] args) {
        int arg = 0;
        while (arg < args.length) {
            if (args[arg].startsWith("-")) {
                if (args[arg].equalsIgnoreCase("-v") || args[arg].equalsIgnoreCase("-version")) {
                    System.out.println("AMSAT Spacecraft Editor. Version 1.02c - 24 Jan 2025");
                    System.exit(0);
                }
            } else {
                Log.println("Command Line Param LogFileDir: " + args[arg]);
                logFileDir = args[arg];
            }
            ++arg;
        }
        Config.ignoreSpacecraftLoadErrors = true;
        Config.homeDirectory = logFileDir == null ? String.valueOf(System.getProperty("user.home")) + File.separator + ".FoxTelem" : logFileDir;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        AmsatSpacecraftEditor m = new AmsatSpacecraftEditor();
        if (Config.setup("AmsatEditor.properties")) {
            Config.setHome();
            if (logFileDir == null) {
                m.initialRun();
            }
        }
        Log.init("AmsatEditor");
        Config.minInit(logFileDir);
        Config.currentDir = System.getProperty("user.dir");
        Config.spacecraftDir = Config.editorSpacecraftDir;
        Config.initSatelliteManager();
        SpacecraftEditorWindow editor = new SpacecraftEditorWindow();
        editor.setVisible(true);
    }

    public void initialRun() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JFrame window = new JFrame();
            window.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("images/fox.jpg")));
            InitalEditorSettings f = new InitalEditorSettings(window, true);
            f.setVisible(true);
        }
        catch (Exception e) {
            Log.println("SERIOUS ERROR - Uncaught and thrown from Initial Setup");
            e.printStackTrace();
            e.printStackTrace(Log.getWriter());
            Log.errorDialog("SERIOUS ERROR - Uncaught and thrown from Initial Setup", e.getMessage());
        }
    }
}

